include $(INCLUDE_DIR)/hardware.mk

define Device/teltonika_tsw1xx_common
	HARDWARE/Ethernet/Port := 5 $(HW_ETH_ETH_PORTS)
	HARDWARE/Ethernet/Speed := $(HW_ETH_SPEED_100)
	HARDWARE/Ethernet/Standard := $(HW_ETH_STANDARD)
	TECHNICAL/Physical_Interfaces/Ethernet := 5 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_100)
	TECHNICAL/Physical_Specification/Casing_Material := $(HW_PHYSICAL_HOUSING_AND_PANELS_AL)
	TECHNICAL/Operating_Environment/Operating_Temperature := $(HW_OPERATING_TEMP)
	TECHNICAL/Operating_Environment/Operating_Humidity := $(HW_OPERATING_HUMIDITY)
	TECHNICAL/Operating_Environment/Ingress_Protection_Rating := $(HW_OPERATING_PROTECTION_IP30)
endef

define Device/template_tsw1xx
	$(Device/teltonika_tsw1xx)

	DEVICE_FEATURES :=
endef

define Device/TEMPLATE_teltonika_tsf010
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSF010

	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 10 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_3PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := Integrated DIN rail bracket
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_3PIN)
	TECHNICAL/Power/Input_Voltage_Range := 7 – 57 VDC, overvoltage protection: 60 Vmax, reverse polarity protection: 80 Vmax, \
		surge protection: min 64.4V/max 71.2V breakdown voltage, \
		93.6V maximum reverse voltage @4.3A maximum reverse surge current
	TECHNICAL/Power/Power_Consumption := Idle: 1 W / Max: 1.5 W
	TECHNICAL/Physical_Specification/Dimensions := 113 x 28 x 50 mm
	TECHNICAL/Physical_Specification/Weight := 142 g
endef

define Device/TEMPLATE_teltonika_tsw010
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSW010

	TECHNICAL/Power/Input_Voltage_Range := 9 – 30 VDC
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Power/PoE_Standards := $(HW_POWER_POE_PASSIVE_30V)
	TECHNICAL/Power/Power_Consumption :=  Idle: 0.3 W / Max: 0.9 W
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 10 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT_INTEGRATED_DIN)
	TECHNICAL/Physical_Specification/Casing_Material := $(HW_PHYSICAL_HOUSING_AL)
	TECHNICAL/Physical_Specification/Dimensions := 113.1 x 27.4 x 80.5 mm
	TECHNICAL/Physical_Specification/Weight := 146.5 g
	REGULATORY/EMC_Emissions_&_Immunity/Standards := $(HW_EI_STANDARDS_EN_55032); $(HW_EI_STANDARDS_EN_55035)
	REGULATORY/EMC_Emissions_&_Immunity/ESD := $(HW_IMUNITY_EMISION_ESD)
	REGULATORY/EMC_Emissions_&_Immunity/Radiated_Immunity := $(HW_IMUNITY_EMISION_RI)
	REGULATORY/EMC_Emissions_&_Immunity/EFT := $(HW_IMUNITY_EMISION_EFT)
	REGULATORY/EMC_Emissions_&_Immunity/Surge_Immunity_(AC_Mains_Power_Port) := $(HW_IMUNITY_EMISION_SURGE)
	REGULATORY/EMC_Emissions_&_Immunity/CS := $(HW_IMUNITY_EMISION_CS)
	REGULATORY/Safety/Standards := CE: $(HW_SAFETY_EN_IEC_62368-1); RCM: $(HW_SAFETY_AS/NZS_62368); CB: $(HW_SAFETY_IEC_62368-1)
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, EAC, FCC, IC, CB, RCM, CITC, ANRT, SDPPI (POSTEL), Kenya, REACH, RoHS, WEEE, UL Safety
endef

define Device/TEMPLATE_teltonika_tsw030
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSW030

	HARDWARE/Ethernet/Port := 8 $(HW_ETH_ETH_PORTS)
	TECHNICAL/Power/Input_Voltage_Range := 7 – 57 VDC, overvoltage protection: 60Vmax, reverse polarity protection: 80Vmax, surge protection: min 64.4V/max 71.2V breakdown voltage,\
		 93.6V maximum reverse voltage @4.3A maximum reverse surge current, 1- Vin, 2-PGND
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Power/Power_Consumption := Idle: 0.5 W / Max: 1.5 W
	TECHNICAL/Physical_Interfaces/Ethernet := 8 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_100)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 16 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT_INTEGRATED_DIN)
	TECHNICAL/Physical_Specification/Dimensions := 113.1 x 41.2 x 74.6 mm
	TECHNICAL/Physical_Specification/Weight := 256 g
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := UL Safety
endef

define Device/TEMPLATE_teltonika_tsw040
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSW040

	HARDWARE/Ethernet/Port := 8 $(HW_ETH_ETH_PORTS)
	TECHNICAL/Power/PoE\-out_Input_Voltage_Range := 44 – 57 VDC
	TECHNICAL/PoE_Out/PoE_Ports := Port 1 - 8
	TECHNICAL/PoE_Out/PoE_Standards := 802.3af and 802.3at compliant PSE ports, over spare pairs - Mode B
	TECHNICAL/PoE_Out/PoE_Max_Power_per_Port_(at_PSE) := 30 W
	TECHNICAL/PoE_Out/Total_PoE_Power_Budget_(at_PSE) := 240 W
	TECHNICAL/Power/Input_Voltage_Range := 7 – 57 VDC, overvoltage protection: 60Vmax, reverse polarity protection: 80Vmax, surge protection: min 64.4V/max 71.2V breakdown voltage,\
	 93.6V maximum reverse voltage @4.3A maximum reverse surge current, 1- Vin, 2-PGND
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Power/Power_Consumption := Idle: 1 W / Max: 2 W / PoE Max: 246 W
	TECHNICAL/Physical_Interfaces/Ethernet := 8 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_100)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 16 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT_INTEGRATED_DIN)
	TECHNICAL/Physical_Specification/Dimensions := 113.1 x 41.2 x 74.6 mm
	TECHNICAL/Physical_Specification/Weight := 280 g
endef

define Device/TEMPLATE_teltonika_tsw100
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSW100

	HARDWARE/Ethernet/Speed := $(HW_ETH_SPEED_1000)
	TECHNICAL/Power/PoE\-out_Input_Voltage_Range := 44 – 57 VDC
	TECHNICAL/PoE_Out/PoE_Ports := Port 1 - 4
	TECHNICAL/PoE_Out/PoE_Standards := 802.3af and 802.3at Alternative A (Order code: TSW100 *1****); \
		802.3af and 802.3at Alternative B (Order code: TSW100 *0****)
	TECHNICAL/PoE_Out/PoE_Max_Power_per_Port_(at_PSE) := 30 W
	TECHNICAL/PoE_Out/Total_PoE_Power_Budget_(at_PSE) := 120 W
	TECHNICAL/Power/Input_Voltage_Range := 7 – 57 VDC
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_4PIN)
	TECHNICAL/Power/Power_Consumption := Idle: 2 W / Max (no PoE): 9 W / PoE Max: 129 W
	TECHNICAL/Physical_Interfaces/Ethernet := 5 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_1000)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 10 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_4PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT)
	TECHNICAL/Physical_Specification/Dimensions := 115 x 32.2 x 101.2 mm
	TECHNICAL/Physical_Specification/Weight := 350 g
	TECHNICAL/Physical_Specification/Casing_Material := $(HW_PHYSICAL_HOUSING_AL)
	REGULATORY/EMC_Emissions_&_Immunity/Standards := $(HW_EI_STANDARDS_EN_55032); $(HW_EI_STANDARDS_EN_55035); \
		$(HW_EI_STANDARDS_EN_301_489-1_V2.2.3:)
	REGULATORY/EMC_Emissions_&_Immunity/ESD := $(HW_IMUNITY_EMISION_ESD)
	REGULATORY/EMC_Emissions_&_Immunity/Radiated_Immunity := $(HW_IMUNITY_EMISION_RI)
	REGULATORY/EMC_Emissions_&_Immunity/EFT := $(HW_IMUNITY_EMISION_EFT)
	REGULATORY/EMC_Emissions_&_Immunity/Surge_Immunity_(AC_Mains_Power_Port) := $(HW_IMUNITY_EMISION_SURGE)
	REGULATORY/EMC_Emissions_&_Immunity/CS := $(HW_IMUNITY_EMISION_CS)
	REGULATORY/EMC_Emissions_&_Immunity/DIP := $(HW_IMUNITY_EMISION_DIP)
	REGULATORY/Safety/Standards := $(HW_SAFETY_IEC_62368-1) $(HW_SAFETY_EN_IEC_62368-1)
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, EAC, UCRF, CITC, ANRT, FCC, IC, NOM, Anatel, CB, E-mark
endef

define Device/TEMPLATE_teltonika_tsw101
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSW101

	HARDWARE/Ethernet/Speed := $(HW_ETH_SPEED_1000)
	TECHNICAL/Power/PoE\-out_Input_Voltage_Range := 9 – 30 VDC
	TECHNICAL/PoE_Out/PoE_Ports := Port 1 - 4
	TECHNICAL/PoE_Out/PoE_Standards := 802.3af and 802.3at Alternative A
	TECHNICAL/PoE_Out/PoE_Max_Power_per_Port_(at_PSE) := 30 W
	TECHNICAL/PoE_Out/Total_PoE_Power_Budget_(at_PSE) := 60 W
	TECHNICAL/PoE_Out/Maximum_Ethernet_cable_length := 100 m
	TECHNICAL/Power/Input_Voltage_Range := 9 – 30 VDC
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Power/Power_Consumption := Idle: 0.64 W / Max: 2.31 W / PoE Max: 62.3 W
	TECHNICAL/Physical_Interfaces/Ethernet := 5 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_1000)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 10 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT)
	TECHNICAL/Physical_Specification/Dimensions := 115 x 32 x 95 mm
	TECHNICAL/Physical_Specification/Weight := 384 g
	TECHNICAL/Physical_Specification/Casing_Material := $(HW_PHYSICAL_HOUSING_AL)
	REGULATORY/EMC_Emissions_&_Immunity/Standards := $(HW_EI_STANDARDS_EN_55032); $(HW_EI_STANDARDS_EN_55035)
	REGULATORY/EMC_Emissions_&_Immunity/ESD := $(HW_IMUNITY_EMISION_ESD)
	REGULATORY/EMC_Emissions_&_Immunity/Radiated_Immunity := $(HW_IMUNITY_EMISION_RI)
	REGULATORY/EMC_Emissions_&_Immunity/EFT := $(HW_IMUNITY_EMISION_EFT)
	REGULATORY/EMC_Emissions_&_Immunity/Surge_Immunity_(AC_Mains_Power_Port) := $(HW_IMUNITY_EMISION_SURGE)
	REGULATORY/EMC_Emissions_&_Immunity/CS := $(HW_IMUNITY_EMISION_CS)
	REGULATORY/Safety/Standards := CE: $(HW_SAFETY_EN_IEC_62368-1), $(HW_SAFETY_EN_IEC_62311), $(HW_SAFETY_EN_5066); RCM: $(HW_SAFETY_AS/NZS_62368); CB: $(HW_SAFETY_IEC_62368-1)
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, REACH, RoHS, WEEE, TSW101 CE, TSW101 UKCA, TSW101 FCC, TSW101 IC, TSW101 CB, TSW101 RCM, E-Mark
endef

define Device/TEMPLATE_teltonika_tsw110
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSW110

	HARDWARE/Ethernet/Speed := $(HW_ETH_SPEED_1000)
	TECHNICAL/Power/Input_Voltage_Range := 9 – 30 VDC
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_4PIN)
	TECHNICAL/Power/PoE_Standards := $(HW_POWER_POE_PASSIVE_30V)
	TECHNICAL/Power/Power_Consumption := < 0.4 W/ < 1.8 W
	TECHNICAL/Physical_Interfaces/Ethernet := 5 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_1000)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 10 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_4PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT)
	TECHNICAL/Physical_Specification/Dimensions := 100 x 30 x 85 mm
	TECHNICAL/Physical_Specification/Weight := 227 g
	TECHNICAL/Physical_Specification/Casing_Material := $(HW_PHYSICAL_HOUSING_AL)
	REGULATORY/EMC_Emissions_&_Immunity/Standards := $(HW_EI_STANDARDS_EN_55032); $(HW_EI_STANDARDS_EN_55035); \
		$(HW_EI_STANDARDS_EN_IEC_61000-3-2); $(HW_EI_STANDARDS_EN_61000-3-3)
	REGULATORY/EMC_Emissions_&_Immunity/ESD := $(HW_IMUNITY_EMISION_ESD)
	REGULATORY/EMC_Emissions_&_Immunity/Radiated_Immunity := $(HW_IMUNITY_EMISION_RI)
	REGULATORY/EMC_Emissions_&_Immunity/EFT := $(HW_IMUNITY_EMISION_EFT)
	REGULATORY/EMC_Emissions_&_Immunity/Surge_Immunity_(AC_Mains_Power_Port) := $(HW_IMUNITY_EMISION_SURGE)
	REGULATORY/EMC_Emissions_&_Immunity/CS := $(HW_IMUNITY_EMISION_CS)
	REGULATORY/EMC_Emissions_&_Immunity/DIP := $(HW_IMUNITY_EMISION_DIP)
	REGULATORY/Safety/Standards := $(HW_SAFETY_IEC_62368-1) $(HW_SAFETY_EN_IEC_62368-1)
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, EAC, UCRF, ANRT, CITC, Kenya, FCC, IC, NOM, RCM, BSMI, CB
endef

define Device/TEMPLATE_teltonika_tsw114
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSW114

	HARDWARE/Ethernet/Speed := $(HW_ETH_SPEED_1000)
	TECHNICAL/Power/Input_Voltage_Range := 9 – 30 VDC
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Power/PoE_Standards := $(HW_POWER_POE_PASSIVE_30V)
	TECHNICAL/Power/Power_Consumption := Idle: 0.3 W / Max: 2.3 W
	TECHNICAL/Physical_Interfaces/Ethernet := 5 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_1000)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 10 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT_INTEGRATED_DIN)
	TECHNICAL/Physical_Specification/Dimensions := 113.1 x 27.4 x 80.5 mm
	TECHNICAL/Physical_Specification/Weight := 174 g
	REGULATORY/EMC_Emissions_&_Immunity/Standards := $(HW_EI_STANDARDS_EN_55032); $(HW_EI_STANDARDS_EN_55035)
	REGULATORY/EMC_Emissions_&_Immunity/ESD := $(HW_IMUNITY_EMISION_ESD)
	REGULATORY/EMC_Emissions_&_Immunity/Radiated_Immunity := $(HW_IMUNITY_EMISION_RI)
	REGULATORY/EMC_Emissions_&_Immunity/EFT := $(HW_IMUNITY_EMISION_EFT)
	REGULATORY/EMC_Emissions_&_Immunity/Surge_Immunity_(AC_Mains_Power_Port) := $(HW_IMUNITY_EMISION_SURGE)
	REGULATORY/EMC_Emissions_&_Immunity/CS := $(HW_IMUNITY_EMISION_CS)
	REGULATORY/Safety/Standards := CE: $(HW_SAFETY_EN_IEC_62368-1); RCM: $(HW_SAFETY_AS/NZS_62368); CB: $(HW_SAFETY_IEC_62368-1)
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, FCC, IC, CB, RCM, CITC, REACH, RoHS, WEEE
endef

define Device/TEMPLATE_teltonika_tsw304
	$(Device/teltonika_tsw1xx_common)
	$(Device/teltonika_tsw1xx)
	DEVICE_MODEL := TSW304

	HARDWARE/Ethernet/Port := 4 $(HW_ETH_ETH_PORTS)
	HARDWARE/Ethernet/Speed := $(HW_ETH_SPEED_1000)
	TECHNICAL/Power/Input_Voltage_Range := 7 - 57 VDC; 9 - 40 VAC
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Power/PoE_Standards := $(HW_POWER_POE_PASSIVE_30V)
	TECHNICAL/Power/Power_Consumption :=  Idle: 0.26 W / Max: 1.44 W
	TECHNICAL/Physical_Interfaces/Ethernet := 4 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_1000)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 8 x ETH status LEDs
	TECHNICAL/Physical_Interfaces/Power := 1 x $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT_INTEGRATED_DIN )
	TECHNICAL/Physical_Specification/Dimensions := 102 x 25 x 81.5 mm
	TECHNICAL/Physical_Specification/Weight := 210 g
	TECHNICAL/Physical_Specification/Casing_Material := $(HW_PHYSICAL_HOUSING_AL)
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, REACH, RoHS, WEEE, UKCA, FCC, IC, CB, RCM
	REGULATORY/Safety/Standards := $(HW_SAFETY_EN_IEC_62368-1); $(HW_SAFETY_IEC_60068-2-6); $(HW_SAFETY_IEC_60068-2-27); $(HW_SAFETY_IEC_60068-2-31);
endef
