#include "utils_api.h"

enum mrp_in_recovery_type in_recv_int(char *arg)
{
	if (strcmp(arg, "500") == 0)
		return MRP_IN_RECOVERY_500;
	if (strcmp(arg, "200") == 0)
		return MRP_IN_RECOVERY_200;
	return MRP_IN_RECOVERY_500;
}

char* in_recv_str(enum mrp_in_recovery_type in_recv)
{
	switch (in_recv) {
	case MRP_IN_RECOVERY_500: return "500";
	case MRP_IN_RECOVERY_200: return "200";
	default:
		return "Unknown interconnect recovery";
	}
}

char *mrm_state_str(int mrm_state)
{
	switch (mrm_state) {
	case MRP_MRM_STATE_AC_STAT1: return "AC_STAT1";
	case MRP_MRM_STATE_PRM_UP: return "PRM_UP";
	case MRP_MRM_STATE_CHK_RO: return "CHK_RO";
	case MRP_MRM_STATE_CHK_RC: return "CHK_RC";
	default:
		return "Unknown mrm_state";
	}
}

char *mrc_state_str(int mrc_state)
{
	switch (mrc_state) {
	case MRP_MRC_STATE_AC_STAT1: return "AC_STAT1";
	case MRP_MRC_STATE_DE_IDLE: return "DE_IDLE";
	case MRP_MRC_STATE_PT: return "PT";
	case MRP_MRC_STATE_DE: return "DE";
	case MRP_MRC_STATE_PT_IDLE: return "PT_IDLE";
	default:
		return "Unknwon mrc_state";
	}
}

char *mim_state_str(int mim_state)
{
	switch (mim_state) {
	case MRP_MIM_STATE_AC_STAT1: return "AC_STAT1";
	case MRP_MIM_STATE_CHK_IO: return "CHK_IO";
	case MRP_MIM_STATE_CHK_IC: return "CHK_IC";
	default:
		return "Unknown mim_state";
	}
}

char *mic_state_str(int mic_state)
{
	switch (mic_state) {
	case MRP_MIC_STATE_AC_STAT1: return "AC_STAT1";
	case MRP_MIC_STATE_PT: return "PT";
	case MRP_MIC_STATE_IP_IDLE: return "IP_IDLE";
	default:
		return "Unknwon mic_state";
	}
}

char *ring_role_str(int ring_role)
{
	switch (ring_role) {
	case BR_MRP_RING_ROLE_DISABLED: return "disabled";
	case BR_MRP_RING_ROLE_MRC: return "mrc";
	case BR_MRP_RING_ROLE_MRM: return "mrm";
	case BR_MRP_RING_ROLE_MRA: return "mra";
	default:
		return "mrc";
	}
}

int int_ring_recv(int ring_recv)
{
	switch (ring_recv) {
	case 500:
		return MRP_RING_RECOVERY_500;
	case 200:
		return MRP_RING_RECOVERY_200;
	case 30:
		return MRP_RING_RECOVERY_30;
	case 10:
		return MRP_RING_RECOVERY_10;
	default:
		return MRP_RING_RECOVERY_500;
	}
}

int ring_recv_int(enum mrp_ring_recovery_type ring_recv)
{
	switch (ring_recv) {
	case MRP_RING_RECOVERY_500:
		return 500;
	case MRP_RING_RECOVERY_200:
		return 200;
	case MRP_RING_RECOVERY_30:
		return 30;
	case MRP_RING_RECOVERY_10:
		return 10;
	default:
		return 500;
	}
}

char* ring_recv_str(enum mrp_ring_recovery_type ring_recv)
{
	switch (ring_recv) {
	case MRP_RING_RECOVERY_500: return "500";
	case MRP_RING_RECOVERY_200: return "200";
	case MRP_RING_RECOVERY_30: return "30";
	case MRP_RING_RECOVERY_10: return "10";
	default:
		return "Unknown ring recovery";
	}
}

char *in_mode_str(int in_mode)
{
	switch (in_mode) {
	case MRP_IN_MODE_RC: return "RC";
	case MRP_IN_MODE_LC: return "LC";
	default:
		return "Unknown in mode";
	}
}

char *in_role_str(int in_role)
{
	switch (in_role) {
	case BR_MRP_IN_ROLE_DISABLED: return "disabled";
	case BR_MRP_IN_ROLE_MIC: return "mic";
	case BR_MRP_IN_ROLE_MIM: return "mim";
	default:
		return "mic";
	}
}

enum br_mrp_ring_role_type ring_role_int(char *arg)
{
	if (strcmp(arg, "disabled") == 0)
		return BR_MRP_RING_ROLE_DISABLED;
	if (strcmp(arg, "mrc") == 0)
		return BR_MRP_RING_ROLE_MRC;
	if (strcmp(arg, "mrm") == 0)
		return BR_MRP_RING_ROLE_MRM;
	if (strcmp(arg, "mra") == 0)
		return BR_MRP_RING_ROLE_MRA;
	return BR_MRP_RING_ROLE_DISABLED;
}

char *port_state_to_str(enum br_mrp_port_state_type port_state)
{
	switch (port_state) {
	case BR_MRP_PORT_STATE_DISABLED:
		return "disabled";
	case BR_MRP_PORT_STATE_BLOCKED:
		return "blocked";
	case BR_MRP_PORT_STATE_FORWARDING:
		return "forwarding";
	case BR_MRP_PORT_STATE_NOT_CONNECTED:
		return "not_connected";
	default:
		return "unknown";
	}
}
