
--Available global variabes:
--	event_juggler.section - name of the config section
--	event_juggler.version - LUA plugin version

-- The script must define a function handle_condition_request(env).
-- This function will be invoked by the event_juggler whenever an event occurs.
-- The parameter env is a table that contains all the relevant data generated by the event.
-- The contents of env will vary depending on the specific type of event, 
-- so the script must be designed to handle various data structures appropriately.
-- The function handle_condition_request(env) must return true to indicate that the 
-- condition was successfully met, or false to indicate that the condition was not met.
function handle_condition_request(env)

    -- E.g the io event provides the io.value, io.fvalue, io.type and io.state fields
    -- depending on the specific pin configured in the event.
    if (env["io.state"] == "High") then
        return false;
    end

    return true;
end
