/*
 * Copyright (C) 2009-2016 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision$
 * $Date$
 *
 * Purpose : Setup MAC Serdes parameters
 *
 * Feature : Setup MAC Serdes parameters functions
 *
 */
#include <rtk/default.h>

#include <dal/dal_construct.h>
#include <dal/longan/dal_longan_construct.h>
#include <hal/phy/phy_construct.h>
#include <hal/chipdef/longan/rtk_longan_table_struct.h>
#include <hal/chipdef/longan/rtk_longan_reg_struct.h>
#include <private/drv/swcore/swcore.h>
#include <private/drv/swcore/chip_probe.h>
#include <hwp/hwp_util.h>
#include <hal/mac/serdes.h>
#include <dal/longan/dal_longan_sds.h>
#include <dal/longan/dal_longan_port.h>

#include <rtk/customer/param/conf_rtl9300_sds_cust.c>
/*
 * Symbol Definition
 */
typedef struct dal_longan_sds_am_marker_s
{
    uint8 marker0_m0;
    uint8 marker0_m1;
    uint8 marker0_m2;

    uint8 marker1_m0;
    uint8 marker1_m1;
    uint8 marker1_m2;

    uint8 marker2_m0;
    uint8 marker2_m1;
    uint8 marker2_m2;

    uint8 marker3_m0;
    uint8 marker3_m1;
    uint8 marker3_m2;
} dal_longan_sds_am_marker_t;

typedef struct dal_longan_sds_usxgmii_cfg_s
{
    rtk_enable_t nway_enable;             /* qhsgmii_nway */
    uint32 opcode;                        /* usxgmii_qhsgmii_nway_opcode */
    uint32 am_period;                     /* am_period */
    dal_longan_sds_am_marker_t am_marker;
    uint32 an_table;                      /* usxgmii_an_table */
    uint32 sync_bit;                      /* usxgmii_sync_header */
} dal_longan_sds_usxgmii_cfg_t;

/*
 * Data Declaration
 */
extern uint32   rtk_init_status;

#define HWP_SDS_5G(sdsID)      ((sdsID) < 2)
#define HWP_SDS_ODD(sdsID)   ((sdsID) % 2)
#define DAL_LONGAN_MAX_SDS_PER_UNIT      12
#define HWP_LONGAN_SDS_TRAVS(unit, sdsID)              for (sdsID = 0; sdsID < DAL_LONGAN_MAX_SDS_PER_UNIT; sdsID++)

sds_config rtl9300_bT_sds_xsgmii[] =
{
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},{0x2E, 0x00, 0x0748},
    {0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x09, 0xF000},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1179},{0x2E, 0x16, 0x00CB},{0x2E, 0x17, 0xA100},{0x2E, 0x18, 0xBE48},
    {0x2E, 0x1E, 0x07FF},{0x2A, 0x12, 0x2034},{0x2F, 0x02, 0x1007},{0x2F, 0x05, 0x787C},
    {0x2F, 0x07, 0x8100},{0x2F, 0x0A, 0x7C7F},{0x2F, 0x0F, 0x0121},{0x2F, 0x11, 0x8840},
    {0x2F, 0x13, 0x0050},{0x2F, 0x16, 0x4000},{0x2F, 0x17, 0x4108},{0x2F, 0x18, 0xAE83},
    {0x2F, 0x1A, 0xA12B},{0x2F, 0x1C, 0x6109},
};

sds_config rtl9300_bT_sds_10gr_1000Bx[] =
{
    /*1G*/
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},
    {0x24, 0x00, 0x0748},{0x24, 0x01, 0x2088},{0x24, 0x02, 0xD020},{0x24, 0x09, 0xF000},
    {0x24, 0x12, 0x2304},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1179},{0x24, 0x16, 0x00C9},
    {0x24, 0x17, 0xA100},{0x24, 0x18, 0xBE48},{0x24, 0x1E, 0x07FF},
    {0x25, 0x02, 0x1007},{0x25, 0x05, 0x787C},{0x25, 0x07, 0x8100},{0x25, 0x0A, 0x7C7F},
    {0x25, 0x0F, 0x0121},{0x25, 0x11, 0x8840},{0x25, 0x13, 0x0050},{0x25, 0x16, 0x4000},
    {0x25, 0x18, 0xAE83},{0x25, 0x19, 0x4902},{0x25, 0x1A, 0xA02B},

    /*10G*/
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},{0x2E, 0x00, 0x0748},
    {0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x09, 0xF000},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1179},{0x2E, 0x16, 0x00CB},{0x2E, 0x17, 0xA100},{0x2E, 0x18, 0xBE48},
    {0x2E, 0x1E, 0x07FF},{0x2A, 0x12, 0x2034},{0x2F, 0x02, 0x1007},{0x2F, 0x05, 0x787C},
    {0x2F, 0x07, 0x8100},{0x2F, 0x0A, 0x7C7F},{0x2F, 0x0F, 0x0121},{0x2F, 0x11, 0x8840},
    {0x2F, 0x13, 0x0050},{0x2F, 0x16, 0x4000},{0x2F, 0x17, 0x4108},{0x2F, 0x18, 0xAE83},
};

sds_config rtl9300_bT_sds_qsgmii[] =
{
    {0x21, 0x00, 0x3C91},{0x21, 0x07, 0xFA66},{0x21, 0x0A, 0xDE40},{0x2A, 0x02, 0x35AD},
    {0x2A, 0x03, 0x6960},
};

sds_config rtl9300_bT_sds_rxaui_lane0[] =
{
    {0x0A, 0x01, 0x0300},{0x20, 0x12, 0x0050},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},
    {0x2C, 0x00, 0x0748},{0x2C, 0x01, 0x2088},{0x2C, 0x02, 0xD020},{0x2C, 0x09, 0xF000},
    {0x2C, 0x12, 0x2064},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1179},{0x2C, 0x16, 0x00C9},
    {0x2C, 0x17, 0xA100},{0x2C, 0x18, 0xBE48},{0x2C, 0x1E, 0x07FF},
    {0x2D, 0x02, 0x1007},{0x2D, 0x05, 0x787C},{0x2D, 0x07, 0x8100},{0x2D, 0x0A, 0x7C7F},
    {0x2D, 0x0F, 0x0121},{0x2D, 0x11, 0x8840},{0x2D, 0x13, 0x0050},
    {0x2D, 0x16, 0x4000},{0x2D, 0x18, 0xAE83},{0x2D, 0x19, 0x4902},{0x2D, 0x1A, 0xA02B},
};

sds_config rtl9300_bT_sds_rxaui_lane1[] =
{
    {0x0A, 0x01, 0x0300},{0x20, 0x12, 0x0050},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},
    {0x2C, 0x00, 0x0748},{0x2C, 0x01, 0x2088},{0x2C, 0x02, 0xD020},{0x2C, 0x09, 0xF000},
    {0x2C, 0x12, 0x2064},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1179},{0x2C, 0x16, 0x00C9},
    {0x2C, 0x17, 0xA100},{0x2C, 0x18, 0xBE48},{0x2C, 0x1E, 0x07FF},
    {0x2D, 0x02, 0x1007},{0x2D, 0x05, 0x787C},{0x2D, 0x07, 0x8100},{0x2D, 0x0A, 0x7C7F},
    {0x2D, 0x0F, 0x0121},{0x2D, 0x11, 0x8840},{0x2D, 0x13, 0x3E87},{0x2D, 0x14, 0x0F0B},
    {0x2D, 0x16, 0x4000},{0x2D, 0x18, 0xAE83},{0x2D, 0x19, 0x4902},{0x2D, 0x1A, 0xA02B},
};

sds_config rtl9300_cT_sds_xsgmii[] =
{
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},
    {0x2E, 0x00, 0x8648},{0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x09, 0xF000},
    {0x2E, 0x13, 0x027F},{0x2E, 0x14, 0x1279},{0x2E, 0x16, 0x00CB},{0x2E, 0x17, 0xA100},
    {0x2E, 0x18, 0x3E48},{0x2E, 0x1E, 0x07FF},{0x2E, 0x12, 0x2044},
    {0x2F, 0x02, 0x1007},{0x2F, 0x05, 0x787C},{0x2F, 0x07, 0x8100},{0x2F, 0x0A, 0x7C7F},
    {0x2F, 0x0F, 0x01A1},{0x2F, 0x11, 0x8840},{0x2F, 0x13, 0x0050},{0x2F, 0x16, 0x4000},
    {0x2F, 0x17, 0x4108},{0x2F, 0x18, 0xAE83},{0x2F, 0x19, 0x4906},{0x2F, 0x1A, 0xA12B},
    {0x2F, 0x1C, 0x6109},{0x2F, 0x1F, 0x3500},
};

sds_config rtl9300_cT_sds_10gr_1000Bx[] =
{
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},
    /*1G*/
    {0x24, 0x00, 0x0748},{0x24, 0x01, 0x2088},{0x24, 0x02, 0xD020},{0x24, 0x09, 0xF000},
    {0x24, 0x12, 0x2304},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1479},{0x24, 0x16, 0x00C9},
    {0x24, 0x17, 0xA100},{0x24, 0x18, 0x3E48},{0x24, 0x1E, 0x07FF},
    {0x25, 0x02, 0x1007},{0x25, 0x05, 0x787C},{0x25, 0x07, 0x8100},{0x25, 0x0A, 0x7C7F},
    {0x25, 0x0F, 0x0121},{0x25, 0x11, 0x8840},{0x25, 0x13, 0x0050},{0x25, 0x16, 0x4000},
    {0x25, 0x18, 0xAE83},{0x25, 0x19, 0x4902},{0x25, 0x1A, 0xA02B},
    /*10G*/
    {0x2E, 0x00, 0x8648},{0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x09, 0xF000},
    {0x2E, 0x13, 0x027F},{0x2E, 0x14, 0x1279},{0x2E, 0x16, 0x00CB},{0x2E, 0x17, 0xA100},
    {0x2E, 0x18, 0x3E48},{0x2E, 0x1E, 0x07FF},{0x2E, 0x12, 0x2044},
    {0x2F, 0x02, 0x1007},{0x2F, 0x05, 0x787C},{0x2F, 0x07, 0x8100},{0x2F, 0x0A, 0x7C7F},
    {0x2F, 0x0F, 0x01A1},{0x2F, 0x11, 0x8840},{0x2F, 0x13, 0x0050},{0x2F, 0x16, 0x4000},
    {0x2F, 0x17, 0x4108},{0x2F, 0x18, 0xAE83},{0x2F, 0x19, 0x4906},{0x2F, 0x1A, 0xA12B},
    {0x2F, 0x1C, 0x6109},{0x2F, 0x1F, 0x3500},
};

sds_config rtl9300_cT_sds_qsgmii[] =
{
    {0x21, 0x00, 0x3C91},{0x21, 0x02, 0xB602},{0x21, 0x07, 0xFA66},{0x21, 0x0A, 0xDE40},
    {0x2A, 0x02, 0x35A1},{0x2A, 0x03, 0x6960},

};

sds_config rtl9300_cT_sds_qsgmii_8218b[] =
{
    {0x21, 0x00, 0x3C91},{0x21, 0x07, 0xFA66},{0x21, 0x0A, 0xDE40},{0x2A, 0x02, 0xDDA3},
    {0x2A, 0x03, 0x6960},
};

sds_config rtl9300_cT_sds_rxaui_lane0[] =
{
    {0x0A, 0x01, 0x0300},{0x20, 0x12, 0x0050},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},
    {0x2C, 0x00, 0x0748},{0x2C, 0x01, 0x2088},{0x2C, 0x02, 0xD020},{0x2C, 0x09, 0xF000},
    {0x2C, 0x12, 0x2044},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1379},{0x2C, 0x16, 0x00C9},
    {0x2C, 0x17, 0xA100},{0x2C, 0x18, 0xBE48},{0x2C, 0x1E, 0x07FF},
    {0x2D, 0x02, 0x1007},{0x2D, 0x05, 0x787C},{0x2D, 0x07, 0x8100},{0x2D, 0x0A, 0x7C7F},
    {0x2D, 0x0F, 0x0121},{0x2D, 0x11, 0x8840},{0x2D, 0x13, 0x0050},
    {0x2D, 0x16, 0x4000},{0x2D, 0x17, 0x4105},{0x2D, 0x18, 0xAE83},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1A, 0xA02B},{0x2D, 0x1B, 0x0003},{0x2D, 0x1C, 0x6109},{0x2D, 0x1D, 0x2501},
    {0x2D, 0x1E, 0x5030},{0x2D, 0x1F, 0x2624},
};

sds_config rtl9300_cT_sds_rxaui_lane1[] =
{
    {0x0A, 0x01, 0x0300},{0x20, 0x12, 0x0050},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},
    {0x2C, 0x00, 0x0748},{0x2C, 0x01, 0x2088},{0x2C, 0x02, 0xD020},{0x2C, 0x09, 0xF000},
    {0x2C, 0x12, 0x2044},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1379},{0x2C, 0x16, 0x00C9},
    {0x2C, 0x17, 0xA100},{0x2C, 0x18, 0xBE48},{0x2C, 0x1E, 0x07FF},
    {0x2D, 0x02, 0x1007},{0x2D, 0x05, 0x787C},{0x2D, 0x07, 0x8100},{0x2D, 0x0A, 0x7C7F},
    {0x2D, 0x0F, 0x0121},{0x2D, 0x11, 0x8840},{0x2D, 0x13, 0x1E87},
    {0x2D, 0x14, 0x0F0B},{0x2D, 0x16, 0x4000},{0x2D, 0x17, 0x4105},{0x2D, 0x18, 0xAE83},
    {0x2D, 0x19, 0x4902},{0x2D, 0x1A, 0xA02B},{0x2D, 0x1B, 0x0003},{0x2D, 0x1C, 0x6109},
    {0x2D, 0x1D, 0x2501},{0x2D, 0x1E, 0x5030},{0x2D, 0x1F, 0x2624},
};

sds_config rtl9300_dT_sds_5g_qsgmii[] =
{
    {0x21, 0x00, 0x3C91},{0x21, 0x02, 0xB602},{0x21, 0x07, 0xFA66},{0x21, 0x0A, 0xDF40},
    {0x2A, 0x02, 0x35A1},{0x2A, 0x03, 0x6960},
};

sds_config rtl9300_dT_sds_5g_qsgmii_8218b[] =
{
    {0x21, 0x00, 0x3C91},{0x21, 0x07, 0xFA66},{0x21, 0x0A, 0xDE40},{0x2A, 0x02, 0xDDA3},
    {0x2A, 0x03, 0x6960},
};

sds_config rtl9300_dT_sds_10g_qsgmii_lane0[] =
{
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},{0x21, 0x09, 0xF09F},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x2A, 0x00, 0x0668},{0x2A, 0x01, 0x2088},
    {0x2A, 0x02, 0xD020},{0x2A, 0x09, 0xF000},{0x2A, 0x0F, 0xFFDF},{0x2A, 0x12, 0x0104},
    {0x2A, 0x13, 0x027F},{0x2A, 0x14, 0x1311},{0x2A, 0x16, 0x00C9},{0x2A, 0x17, 0xA100},
    {0x2A, 0x18, 0xBE48},{0x2A, 0x1E, 0x07F8},{0x2B, 0x02, 0x1017},{0x2B, 0x05, 0x7F7C},
    {0x2B, 0x07, 0x8100},{0x2B, 0x08, 0x0001},{0x2B, 0x0A, 0x7C2F},{0x2B, 0x0F, 0x0121},
    {0x2B, 0x11, 0x8840},{0x2B, 0x13, 0x0050},{0x2B, 0x16, 0x4000},{0x2B, 0x18, 0x8E88},
    {0x2B, 0x19, 0x4902},{0x2B, 0x1A, 0xA02B},{0x2B, 0x1C, 0x7109},
};

sds_config rtl9300_dT_sds_10g_qsgmii_lane1[] =
{
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x08, 0x0000},{0x21, 0x09, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x2A, 0x00, 0x0668},{0x2A, 0x01, 0x2088},{0x2A, 0x02, 0xD020},{0x2A, 0x09, 0xF000},
    {0x2A, 0x0F, 0xFFDF},{0x2A, 0x12, 0x0104},{0x2A, 0x13, 0x027F},{0x2A, 0x14, 0x1311},
    {0x2A, 0x16, 0x00C9},{0x2A, 0x17, 0xA100},{0x2A, 0x18, 0xBE48},{0x2A, 0x1E, 0x07F8},
    {0x2B, 0x02, 0x1017},{0x2B, 0x05, 0x7F7C},{0x2B, 0x07, 0x8100},{0x2B, 0x08, 0x0001},
    {0x2B, 0x0A, 0x7C2F},{0x2B, 0x0F, 0x0121},{0x2B, 0x11, 0x8840},{0x2B, 0x16, 0x4000},
    {0x2B, 0x17, 0x4105},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1A, 0xA02B},
    {0x2B, 0x1B, 0x0003},{0x2B, 0x1C, 0x7109},{0x2B, 0x1D, 0x2501},{0x2B, 0x1E, 0x5030},
    {0x2B, 0x1F, 0x2624},
};

sds_config rtl9300_dT_sds_10g_1000Bx_lane0[] =
{
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x24, 0x00, 0x0668},{0x24, 0x01, 0x2088},
    {0x24, 0x02, 0xD020},{0x24, 0x09, 0xF000},{0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},
    {0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},{0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},
    {0x24, 0x18, 0xBE48},{0x24, 0x1E, 0x07F8},{0x25, 0x02, 0x1017},{0x25, 0x05, 0x7F7C},
    {0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x0A, 0x7C2F},{0x25, 0x0F, 0x0121},
    {0x25, 0x11, 0x8840},{0x25, 0x13, 0x0050},{0x25, 0x16, 0x4000},{0x25, 0x18, 0x8E88},
    {0x25, 0x19, 0x4902},{0x25, 0x1A, 0xA02B},{0x25, 0x1C, 0x7109},
};

sds_config rtl9300_dT_sds_10g_1000Bx_lane1[] =
{
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x01, 0x2088},{0x24, 0x02, 0xD020},{0x24, 0x09, 0xF000},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x18, 0xBE48},{0x24, 0x1E, 0x07F8},
    {0x25, 0x02, 0x1017},{0x25, 0x05, 0x7F7C},{0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},
    {0x25, 0x0A, 0x7C2F},{0x25, 0x0F, 0x0121},{0x25, 0x11, 0x8840},{0x25, 0x16, 0x4000},
    {0x25, 0x17, 0x4105},{0x25, 0x18, 0x8E88},{0x25, 0x19, 0x4902},{0x25, 0x1A, 0xA02B},
    {0x25, 0x1B, 0x0003},{0x25, 0x1C, 0x7109},{0x25, 0x1D, 0x2501},{0x25, 0x1E, 0x5030},
    {0x25, 0x1F, 0x2624},
};

sds_config rtl9300_dT_sds_10g_2500Bx_lane0[] =
{
    {0x01, 0x14, 0x0100},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x28, 0x00, 0x0668},{0x28, 0x01, 0x2088},
    {0x28, 0x02, 0xD020},{0x28, 0x09, 0xF000},{0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x03C4},
    {0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},{0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},
    {0x28, 0x18, 0xBE48},{0x28, 0x1E, 0x07F8},{0x29, 0x02, 0x1017},{0x29, 0x05, 0x7F7C},
    {0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x0A, 0x7C2F},{0x29, 0x0F, 0x0121},
    {0x29, 0x11, 0x8840},{0x29, 0x13, 0x0050},{0x29, 0x16, 0x4000},{0x29, 0x18, 0x8E88},
    {0x29, 0x19, 0x4902},{0x29, 0x1A, 0xA02B},{0x29, 0x1B, 0x0003},{0x29, 0x1C, 0x7109},
    {0x29, 0x1D, 0x2641},
};

sds_config rtl9300_dT_sds_10g_2500Bx_lane1[] =
{
    {0x01, 0x14, 0x0100},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x28, 0x00, 0x0668},{0x28, 0x01, 0x2088},{0x28, 0x02, 0xD020},{0x28, 0x09, 0xF000},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x03C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x18, 0xBE48},{0x28, 0x1E, 0x07F8},
    {0x29, 0x02, 0x1017},{0x29, 0x05, 0x7F7C},{0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},
    {0x29, 0x0A, 0x7C2F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    {0x29, 0x16, 0x4000},{0x29, 0x17, 0x4105},{0x29, 0x18, 0x8E88},{0x29, 0x19, 0x4902},
    {0x29, 0x1A, 0xA02B},{0x29, 0x1B, 0x0003},{0x29, 0x1C, 0x7109},{0x29, 0x1D, 0x2641},
    {0x29, 0x1E, 0x6430},{0x29, 0x1F, 0x3024},
};

sds_config rtl9300_dT_sds_10g_rsgmii_lane0[] =
{
    {0x01, 0x14, 0x0100},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x26, 0x00, 0x0668},{0x26, 0x01, 0x2088},
    {0x26, 0x02, 0xD020},{0x26, 0x09, 0xF000},{0x26, 0x0F, 0xFFDF},{0x26, 0x12, 0x03C4},
    {0x26, 0x13, 0x027F},{0x26, 0x14, 0x1311},{0x26, 0x16, 0x00C9},{0x26, 0x17, 0xA100},
    {0x26, 0x18, 0xBE48},{0x26, 0x1E, 0x07F8},{0x27, 0x02, 0x1017},{0x27, 0x05, 0x7F7C},
    {0x27, 0x07, 0x8100},{0x27, 0x08, 0x0001},{0x27, 0x0A, 0x7C2F},{0x27, 0x0F, 0x0121},
    {0x27, 0x11, 0x8840},{0x27, 0x13, 0x0050},{0x27, 0x16, 0x4000},{0x27, 0x18, 0x8E88},
    {0x27, 0x19, 0x4902},{0x27, 0x1A, 0xA02B},{0x27, 0x1B, 0x0003},{0x27, 0x1C, 0x7109},
};

sds_config rtl9300_dT_sds_10g_rsgmii_lane1[] =
{
    {0x01, 0x14, 0x0100},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x26, 0x00, 0x0668},{0x26, 0x01, 0x2088},{0x26, 0x02, 0xD020},{0x26, 0x09, 0xF000},
    {0x26, 0x0F, 0xFFDF},{0x26, 0x12, 0x03C4},{0x26, 0x13, 0x027F},{0x26, 0x14, 0x1311},
    {0x26, 0x16, 0x00C9},{0x26, 0x17, 0xA100},{0x26, 0x18, 0xBE48},{0x26, 0x1E, 0x07F8},
    {0x27, 0x02, 0x1017},{0x27, 0x05, 0x7F7C},{0x27, 0x07, 0x8100},{0x27, 0x08, 0x0001},
    {0x27, 0x0A, 0x7C2F},{0x27, 0x0F, 0x0121},{0x27, 0x10, 0x0020},{0x27, 0x11, 0x8840},
    {0x27, 0x16, 0x4000},{0x27, 0x17, 0x4105},{0x27, 0x18, 0x8E88},{0x27, 0x19, 0x4902},
    {0x27, 0x1A, 0xA02B},{0x27, 0x1B, 0x0003},{0x27, 0x1C, 0x7109},{0x27, 0x1D, 0x2501},
    {0x27, 0x1E, 0x5030},{0x27, 0x1F, 0x2624},
};

sds_config rtl9300_dT_sds_10g_rxaui_lite_lane0[] =
{
    {0x0A, 0x01, 0x4300},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x2C, 0x00, 0x0668},{0x2C, 0x01, 0x2088},
    {0x2C, 0x02, 0xD020},{0x2C, 0x09, 0xF000},{0x2C, 0x0F, 0xFFDF},{0x2C, 0x12, 0x0104},
    {0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1311},{0x2C, 0x16, 0x00C9},{0x2C, 0x17, 0xA100},
    {0x2C, 0x18, 0xBE48},{0x2C, 0x1E, 0x07F8},{0x2D, 0x02, 0x1017},{0x2D, 0x05, 0x7F7C},
    {0x2D, 0x07, 0x8100},{0x2D, 0x08, 0x0001},{0x2D, 0x0A, 0x7C2F},{0x2D, 0x0F, 0x0121},
    {0x2D, 0x11, 0x8840},{0x2D, 0x13, 0x0050},{0x2D, 0x16, 0x4000},{0x2D, 0x18, 0x8E88},
    {0x2D, 0x19, 0x4902},{0x2D, 0x1A, 0xA02B},{0x2D, 0x1B, 0x0003},{0x2D, 0x1C, 0x7109},
    {0x2D, 0x1D, 0x2641},
};

sds_config rtl9300_dT_sds_10g_rxaui_lite_lane1[] =
{
    {0x0A, 0x01, 0x4300},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x2C, 0x00, 0x0668},{0x2C, 0x01, 0x2088},{0x2C, 0x02, 0xD020},{0x2C, 0x09, 0xF000},
    {0x2C, 0x0F, 0xFFDF},{0x2C, 0x12, 0x0104},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1311},
    {0x2C, 0x16, 0x00C9},{0x2C, 0x17, 0xA100},{0x2C, 0x18, 0xBE48},{0x2C, 0x1E, 0x07F8},
    {0x2D, 0x02, 0x1017},{0x2D, 0x05, 0x7F7C},{0x2D, 0x07, 0x8100},{0x2D, 0x08, 0x0001},
    {0x2D, 0x0A, 0x7C2F},{0x2D, 0x0F, 0x0121},{0x2D, 0x10, 0x0020},{0x2D, 0x11, 0x8840},
    {0x2D, 0x16, 0x4000},{0x2D, 0x17, 0x4105},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1A, 0xA02B},{0x2D, 0x1B, 0x0003},{0x2D, 0x1C, 0x7109},{0x2D, 0x1D, 0x2641},
    {0x2D, 0x1E, 0x6430},{0x2D, 0x1F, 0x3024},
};

sds_config rtl9300_dT_sds_xsgmii[] =
{
    {0x06, 0x0D, 0x0F00},{0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},
    {0x21, 0x08, 0x0000},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x2E, 0x00, 0x8668},
    {0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x09, 0xF000},{0x2E, 0x0F, 0xFFDF},
    {0x2E, 0x12, 0x2084},{0x2E, 0x13, 0x027F},{0x2E, 0x14, 0x1311},{0x2E, 0x16, 0x00CF},
    {0x2E, 0x17, 0xA100},{0x2E, 0x18, 0xBE48},{0x2E, 0x1E, 0x07FA},{0x2F, 0x02, 0x1017},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8100},{0x2F, 0x08, 0x0001},{0x2F, 0x0A, 0x7C2F},
    {0x2F, 0x0F, 0x0121},{0x2F, 0x11, 0x8840},{0x2F, 0x13, 0x0050},{0x2F, 0x16, 0x4000},
    {0x2F, 0x17, 0x4108},{0x2F, 0x18, 0x4E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1A, 0xA12B},
    {0x2F, 0x1C, 0x7109},
};

sds_config rtl9300_dT_sds_10gr_lane0[] =
{
    /*1G*/
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x24, 0x00, 0x0668},{0x24, 0x01, 0x2088},
    {0x24, 0x02, 0xD020},{0x24, 0x09, 0xF000},{0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},
    {0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},{0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},
    {0x24, 0x18, 0xBE48},{0x24, 0x1E, 0x07F8},{0x25, 0x02, 0x1017},{0x25, 0x05, 0x7F7C},
    {0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x0A, 0x7C2F},{0x25, 0x0F, 0x0121},
    {0x25, 0x11, 0x8840},{0x25, 0x13, 0x0050},{0x25, 0x16, 0x4000},{0x25, 0x18, 0x8E88},
    {0x25, 0x19, 0x4902},{0x25, 0x1A, 0xA02B},{0x25, 0x1C, 0x7109},
    /*10G*/
    {0x06, 0x0D, 0x0F00},{0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},
    {0x21, 0x08, 0x0000},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x2E, 0x00, 0x8668},
    {0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x09, 0xF000},{0x2E, 0x0F, 0xFFDF},
    {0x2E, 0x12, 0x2034},{0x2E, 0x13, 0x027F},{0x2E, 0x14, 0x1311},{0x2E, 0x16, 0x00CF},
    {0x2E, 0x17, 0xA100},{0x2E, 0x18, 0xBE48},{0x2E, 0x1E, 0x07FA},{0x2F, 0x02, 0x1017},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8100},{0x2F, 0x08, 0x0001},{0x2F, 0x0A, 0x7C2F},
    {0x2F, 0x0F, 0x0121},{0x2F, 0x11, 0x8840},{0x2F, 0x13, 0x0050},{0x2F, 0x16, 0x4000},
    {0x2F, 0x17, 0x4108},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1A, 0xA12B},
    {0x2F, 0x1C, 0x7109},
};

sds_config rtl9300_dT_sds_10gr_lane1[] =
{
    /*1G*/
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x01, 0x2088},{0x24, 0x02, 0xD020},{0x24, 0x09, 0xF000},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x18, 0xBE48},{0x24, 0x1E, 0x07F8},
    {0x25, 0x02, 0x1017},{0x25, 0x05, 0x7F7C},{0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},
    {0x25, 0x0A, 0x7C2F},{0x25, 0x0F, 0x0121},{0x25, 0x11, 0x8840},{0x25, 0x16, 0x4000},
    {0x25, 0x17, 0x4105},{0x25, 0x18, 0x8E88},{0x25, 0x19, 0x4902},{0x25, 0x1A, 0xA02B},
    {0x25, 0x1B, 0x0003},{0x25, 0x1C, 0x7109},{0x25, 0x1D, 0x2501},{0x25, 0x1E, 0x5030},
    {0x25, 0x1F, 0x2624},
    /*10G*/
    {0x06, 0x0D, 0x0F00},{0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},
    {0x21, 0x08, 0x0000},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x2E, 0x00, 0x8668},
    {0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x09, 0xF000},{0x2E, 0x0F, 0xFFDF},
    {0x2E, 0x12, 0x2034},{0x2E, 0x13, 0x027F},{0x2E, 0x14, 0x1311},{0x2E, 0x16, 0x00CF},
    {0x2E, 0x17, 0xA100},{0x2E, 0x18, 0xBE48},{0x2E, 0x1E, 0x07FA},{0x2F, 0x02, 0x1017},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8100},{0x2F, 0x08, 0x0001},{0x2F, 0x0A, 0x7C2F},
    {0x2F, 0x0F, 0x0121},{0x2F, 0x11, 0x8840},{0x2F, 0x13, 0x0050},{0x2F, 0x16, 0x4000},
    {0x2F, 0x17, 0x4108},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1A, 0xA12B},
    {0x2F, 0x1C, 0x7109},
};

sds_config rtl9300_dT_sds_rxaui_lane0[] =
{
    {0x0A, 0x01, 0x0300},{0x20, 0x12, 0x0050},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},{0x2C, 0x00, 0x0668},{0x2C, 0x01, 0x2088},
    {0x2C, 0x02, 0xD020},{0x2C, 0x09, 0xF000},{0x2C, 0x0F, 0xFFDF},{0x2C, 0x12, 0x0084},
    {0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1311},{0x2C, 0x16, 0x00C9},{0x2C, 0x17, 0xA100},
    {0x2C, 0x18, 0xBE48},{0x2C, 0x1E, 0x07F8},{0x2D, 0x02, 0x1017},{0x2D, 0x05, 0x7F7C},
    {0x2D, 0x07, 0x8100},{0x2D, 0x08, 0x0001},{0x2D, 0x0A, 0x7C2F},{0x2D, 0x0F, 0x0121},
    {0x2D, 0x11, 0x8840},{0x2D, 0x13, 0x0050},{0x2D, 0x14, 0x2008},{0x2D, 0x16, 0x4000},
    {0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1A, 0xA02B},{0x2D, 0x1C, 0x7109},
    {0x2D, 0x1D, 0x2501},{0x2D, 0x1E, 0x5030},{0x2D, 0x1F, 0x2624},
};

sds_config rtl9300_dT_sds_rxaui_lane1[] =
{
    {0x0A, 0x01, 0x0300},{0x20, 0x12, 0x0050},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x2C, 0x00, 0x0668},{0x2C, 0x01, 0x2088},{0x2C, 0x02, 0xD020},{0x2C, 0x09, 0xF000},
    {0x2C, 0x0F, 0xFFDF},{0x2C, 0x12, 0x0084},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1311},
    {0x2C, 0x16, 0x00C9},{0x2C, 0x17, 0xA100},{0x2C, 0x18, 0xBE48},{0x2C, 0x1E, 0x07F8},
    {0x2D, 0x02, 0x1017},{0x2D, 0x05, 0x7F7C},{0x2D, 0x07, 0x8100},{0x2D, 0x08, 0x0001},
    {0x2D, 0x0A, 0x7C2F},{0x2D, 0x0F, 0x0121},{0x2D, 0x11, 0x8840},{0x2D, 0x14, 0x0F0B},
    {0x2D, 0x16, 0x4000},{0x2D, 0x17, 0x4105},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1A, 0xA02B},{0x2D, 0x1B, 0x0003},{0x2D, 0x1C, 0x7109},{0x2D, 0x1D, 0x2641},
    {0x2D, 0x1E, 0x6430},{0x2D, 0x1F, 0x3024},
};

sds_config rtl9300_dT_sds_usxgmii_sx[] =
{
    {0x06, 0x0D, 0x0F00},{0x07, 0x11, 0x0540},{0x20, 0x12, 0x05F3},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x2A, 0x00, 0x8668},{0x2A, 0x01, 0x2088},{0x2A, 0x02, 0xD020},{0x2A, 0x09, 0xF000},
    {0x2A, 0x0F, 0xFFDF},{0x2A, 0x12, 0x2084},{0x2A, 0x13, 0x027F},{0x2A, 0x14, 0x1311},
    {0x2A, 0x16, 0x00CB},{0x2A, 0x17, 0xA100},{0x2A, 0x18, 0x3E48},{0x2A, 0x1E, 0x07FA},
    {0x2B, 0x02, 0x1017},{0x2B, 0x05, 0x7F7C},{0x2B, 0x07, 0x8100},{0x2B, 0x08, 0x0001},
    {0x2B, 0x0A, 0x7C2F},{0x2B, 0x0F, 0x0121},{0x2B, 0x11, 0x8840},{0x2B, 0x13, 0x0050},
    {0x2B, 0x16, 0x4000},{0x2F, 0x17, 0x4108},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},
    {0x2B, 0x1A, 0xA12B},{0x2B, 0x1C, 0x7109},
};

sds_config rtl9300_dT_sds_usxgmii_qx[] =
{
    {0x06, 0x0D, 0x0F00},{0x07, 0x11, 0x0540},{0x20, 0x12, 0x05F3},
    {0x21, 0x02, 0x03C0},{0x21, 0x05, 0x40B0},{0x21, 0x07, 0xF09F},{0x21, 0x08, 0x0000},
    {0x21, 0x0D, 0x0009},{0x21, 0x0F, 0x0008},
    {0x2A, 0x00, 0x8668},{0x2A, 0x01, 0x2088},{0x2A, 0x02, 0xD020},{0x2A, 0x09, 0xF000},
    {0x2A, 0x0F, 0xFFDF},{0x2A, 0x12, 0x2084},{0x2A, 0x13, 0x027F},{0x2A, 0x14, 0x1311},
    {0x2A, 0x16, 0x00CB},{0x2A, 0x17, 0xA100},{0x2A, 0x18, 0x3E48},{0x2A, 0x1E, 0x07FA},
    {0x2B, 0x02, 0x1017},{0x2B, 0x05, 0x7F7C},{0x2B, 0x07, 0x8100},{0x2B, 0x08, 0x0001},
    {0x2B, 0x0A, 0x7C2F},{0x2B, 0x0F, 0x0121},{0x2B, 0x11, 0x8840},{0x2B, 0x13, 0x0050},
    {0x2B, 0x16, 0x4000},{0x2F, 0x17, 0x4108},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},
    {0x2B, 0x1A, 0xA12B},{0x2B, 0x1C, 0x7109},
};

sds_config rtl9300_a_sds_5g_qsgmii[] =
{
    {0x00, 0x0E, 0x3053},{0x21, 0x00, 0x3C91},{0x21, 0x02, 0xB602},{0x21, 0x07, 0xFA66},
    {0x21, 0x0A, 0xDF40},{0x2A, 0x02, 0x35A1},{0x2A, 0x03, 0x6960},
};

sds_config rtl9300_a_sds_5g_qsgmii_8218b[] =
{
    {0x21, 0x00, 0x3C91},{0x21, 0x07, 0xFA66},{0x21, 0x0A, 0xDE40},{0x2A, 0x02, 0xDDA3},
    {0x2A, 0x03, 0x6960},
};

sds_config rtl9300_a_sds_10g_qsgmii_lane0[] =
{
    {0x00, 0x0E, 0x3053},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2A, 0x00, 0x0668},{0x2A, 0x02, 0xD020},{0x2A, 0x06, 0xC000},{0x2A, 0x0B, 0x1892},
    {0x2A, 0x0F, 0xFFDF},{0x2A, 0x11, 0x8280},{0x2A, 0x12, 0x0104},{0x2A, 0x13, 0x027F},
    {0x2A, 0x14, 0x1311},{0x2A, 0x16, 0x00C9},{0x2A, 0x17, 0xA100},{0x2A, 0x1A, 0x0001},
    {0x2A, 0x1C, 0x0400},{0x2B, 0x01, 0x0300},{0x2B, 0x02, 0x1017},{0x2B, 0x03, 0xFFDF},
    {0x2B, 0x05, 0x7F7C},{0x2B, 0x07, 0x8100},{0x2B, 0x08, 0x0001},{0x2B, 0x09, 0xFFD4},
    {0x2B, 0x0A, 0x7C2F},{0x2B, 0x0E, 0x003F},{0x2B, 0x0F, 0x0121},{0x2B, 0x10, 0x0020},
    {0x2B, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_10g_qsgmii_lane1[] =
{
    {0x00, 0x0E, 0x3053},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2A, 0x00, 0x0668},{0x2A, 0x02, 0xD020},{0x2A, 0x06, 0xC000},{0x2A, 0x0B, 0x1892},
    {0x2A, 0x0F, 0xFFDF},{0x2A, 0x11, 0x8280},{0x2A, 0x12, 0x0104},{0x2A, 0x13, 0x027F},
    {0x2A, 0x14, 0x1311},{0x2A, 0x16, 0x00C9},{0x2A, 0x17, 0xA100},{0x2A, 0x1A, 0x0001},
    {0x2A, 0x1C, 0x0400},{0x2B, 0x00, 0x820F},{0x2B, 0x01, 0x0300},{0x2B, 0x02, 0x1017},
    {0x2B, 0x03, 0xFFDF},{0x2B, 0x05, 0x7F7C},{0x2B, 0x07, 0x8100},{0x2B, 0x08, 0x0001},
    {0x2B, 0x09, 0xFFD4},{0x2B, 0x0A, 0x7C2F},{0x2B, 0x0E, 0x003F},{0x2B, 0x0F, 0x0121},
    {0x2B, 0x10, 0x0020},{0x2B, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_10g_sgmii_lane0[] =
{
    {0x00, 0x0E, 0x3053},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},{0x25, 0x05, 0x7F7C},
    {0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},{0x25, 0x0A, 0x7C2F},
    {0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},{0x25, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x17, 0x4109},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1C, 0x1109},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_10g_sgmii_lane1[] =
{
    {0x00, 0x0E, 0x3053},
    {0x21, 0x03, 0x8206},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},{0x21, 0x0A, 0x0003},
    {0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},
    {0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x00, 0x820F},{0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},
    {0x25, 0x05, 0x7F7C},{0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},
    {0x25, 0x0A, 0x7C2F},{0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},
    {0x25, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};


sds_config rtl9300_a_sds_10g_1000Bx_lane0[] =
{
    {0x00, 0x0E, 0x3053},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},{0x25, 0x05, 0x7F7C},
    {0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},{0x25, 0x0A, 0x7C2F},
    {0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},{0x25, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x17, 0x4109},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1C, 0x1109},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_10g_1000Bx_lane1[] =
{
    {0x00, 0x0E, 0x3053},
    {0x21, 0x03, 0x8206},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},{0x21, 0x0A, 0x0003},
    {0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},
    {0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x00, 0x820F},{0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},
    {0x25, 0x05, 0x7F7C},{0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},
    {0x25, 0x0A, 0x7C2F},{0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},
    {0x25, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_10g_hisgmii_lane0[] =
{
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},{0x25, 0x05, 0x7F7C},
    {0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},{0x25, 0x0A, 0x7C2F},
    {0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},{0x25, 0x11, 0x8840},
    {0x28, 0x00, 0x0668},{0x28, 0x02, 0xD020},{0x28, 0x06, 0xC000},{0x28, 0x0B, 0x1892},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x03C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x1A, 0x0001},{0x28, 0x1C, 0x0400},
    {0x29, 0x01, 0x0300},{0x29, 0x02, 0x1017},{0x29, 0x03, 0xFFDF},{0x29, 0x05, 0x7F7C},
    {0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x09, 0xFFD4},{0x29, 0x0A, 0x7C2F},
    {0x29, 0x0E, 0x003F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x17, 0x4109},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1C, 0x1109},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_10g_hisgmii_lane1[] =
{
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},{0x21, 0x0A, 0x0003},
    {0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},
    {0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x00, 0x820F},{0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},
    {0x25, 0x05, 0x7F7C},{0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},
    {0x25, 0x0A, 0x7C2F},{0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},
    {0x25, 0x11, 0x8840},
    {0x28, 0x00, 0x0668},{0x28, 0x02, 0xD020},{0x28, 0x06, 0xC000},{0x28, 0x0B, 0x1892},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x03C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x1A, 0x0001},{0x28, 0x1C, 0x0400},
    {0x29, 0x00, 0x820F},{0x29, 0x01, 0x0300},{0x29, 0x02, 0x1017},{0x29, 0x03, 0xFFDF},
    {0x29, 0x05, 0x7F7C},{0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x0A, 0x7C2F},
    {0x29, 0x0E, 0x003F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_10g_2500Bx_lane0[] =
{
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},{0x25, 0x05, 0x7F7C},
    {0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},{0x25, 0x0A, 0x7C2F},
    {0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},{0x25, 0x11, 0x8840},
    {0x28, 0x00, 0x0668},{0x28, 0x02, 0xD020},{0x28, 0x06, 0xC000},{0x28, 0x0B, 0x1892},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x01C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x1A, 0x0001},{0x28, 0x1C, 0x0400},
    {0x29, 0x01, 0x0300},{0x29, 0x02, 0x1017},{0x29, 0x03, 0xFFDF},{0x29, 0x05, 0x7F7C},
    {0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x09, 0xFFD4},{0x29, 0x0A, 0x7C2F},
    {0x29, 0x0E, 0x003F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x17, 0x4109},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1C, 0x1109},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_10g_2500Bx_lane1[] =
{
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},{0x21, 0x0A, 0x0003},
    {0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},
    {0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x00, 0x820F},{0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},
    {0x25, 0x05, 0x7F7C},{0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},
    {0x25, 0x0A, 0x7C2F},{0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},
    {0x25, 0x11, 0x8840},
    {0x28, 0x00, 0x0668},{0x28, 0x02, 0xD020},{0x28, 0x06, 0xC000},{0x28, 0x0B, 0x1892},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x01C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x1A, 0x0001},{0x28, 0x1C, 0x0400},
    {0x29, 0x00, 0x820F},{0x29, 0x01, 0x0300},{0x29, 0x02, 0x1017},{0x29, 0x03, 0xFFDF},
    {0x29, 0x05, 0x7F7C},{0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x0A, 0x7C2F},
    {0x29, 0x0E, 0x003F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_10g_rsgmii_lane0[] =
{
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x26, 0x00, 0x0668},{0x26, 0x02, 0xD020},{0x26, 0x06, 0xC000},{0x26, 0x0B, 0x1892},
    {0x26, 0x0F, 0xFFDF},{0x26, 0x12, 0x03C4},{0x26, 0x13, 0x027F},{0x26, 0x14, 0x1311},
    {0x26, 0x16, 0x00C9},{0x26, 0x17, 0xA100},{0x26, 0x1A, 0x0001},{0x26, 0x1C, 0x0400},
    {0x27, 0x01, 0x0300},{0x27, 0x02, 0x1017},{0x27, 0x03, 0xFFDF},{0x27, 0x05, 0x7F7C},
    {0x27, 0x07, 0x8100},{0x27, 0x08, 0x0001},{0x27, 0x09, 0xFFD4},{0x27, 0x0A, 0x7C2F},
    {0x27, 0x0E, 0x003F},{0x27, 0x0F, 0x0121},{0x27, 0x10, 0x0020},{0x27, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_10g_rsgmii_lane1[] =
{
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x26, 0x00, 0x0668},{0x26, 0x02, 0xD020},{0x26, 0x06, 0xC000},{0x26, 0x0B, 0x1892},
    {0x26, 0x0F, 0xFFDF},{0x26, 0x12, 0x03C4},{0x26, 0x13, 0x027F},{0x26, 0x14, 0x1311},
    {0x26, 0x16, 0x00C9},{0x26, 0x17, 0xA100},{0x26, 0x1A, 0x0001},{0x26, 0x1C, 0x0400},
    {0x27, 0x00, 0x820F},{0x27, 0x01, 0x0300},{0x27, 0x02, 0x1017},{0x27, 0x03, 0xFFDF},
    {0x27, 0x05, 0x7F7C},{0x27, 0x07, 0x8100},{0x27, 0x08, 0x0001},{0x27, 0x09, 0xFFD4},
    {0x27, 0x0A, 0x7C2F},{0x27, 0x0E, 0x003F},{0x27, 0x0F, 0x0121},{0x27, 0x10, 0x0020},
    {0x27, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_10g_rxaui_lite_lane0[] =
{
    {0x0A, 0x01, 0x4300},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2C, 0x00, 0x0668},{0x2C, 0x02, 0xD020},{0x2C, 0x06, 0xC000},{0x2C, 0x0B, 0x1892},
    {0x2C, 0x0F, 0xFFDF},{0x2C, 0x12, 0x0104},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1311},
    {0x2C, 0x16, 0x00C9},{0x2C, 0x17, 0xA100},{0x2C, 0x1A, 0x0001},{0x2C, 0x1C, 0x0400},
    {0x2D, 0x01, 0x0300},{0x2D, 0x02, 0x1017},{0x2D, 0x03, 0xFFDF},{0x2D, 0x05, 0x7F7C},
    {0x2D, 0x07, 0x8100},{0x2D, 0x08, 0x0001},{0x2D, 0x09, 0xFFD4},{0x2D, 0x0A, 0x7C2F},
    {0x2D, 0x0E, 0x003F},{0x2D, 0x0F, 0x0121},{0x2D, 0x10, 0x0020},{0x2D, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_10g_rxaui_lite_lane1[] =
{
    {0x0A, 0x01, 0x4300},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2C, 0x00, 0x0668},{0x2C, 0x02, 0xD020},{0x2C, 0x06, 0xC000},{0x2C, 0x0B, 0x1892},
    {0x2C, 0x0F, 0xFFDF},{0x2C, 0x12, 0x0104},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1311},
    {0x2C, 0x16, 0x00C9},{0x2C, 0x17, 0xA100},{0x2C, 0x1A, 0x0001},{0x2C, 0x1C, 0x0400},
    {0x2D, 0x00, 0x820F},{0x2D, 0x01, 0x0300},{0x2D, 0x02, 0x1017},{0x2D, 0x03, 0xFFDF},
    {0x2D, 0x05, 0x7F7C},{0x2D, 0x07, 0x8100},{0x2D, 0x08, 0x0001},{0x2D, 0x09, 0xFFD4},
    {0x2D, 0x0A, 0x7C2F},{0x2D, 0x0E, 0x003F},{0x2D, 0x0F, 0x0121},{0x2D, 0x10, 0x0020},
    {0x2D, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_xsgmii_lane0[] =
{
    {0x00, 0x0E, 0x3053},{0x00, 0x02, 0x70d0},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},{0x2F, 0x05, 0x7F7C},
    {0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},{0x2F, 0x0A, 0x7C2F},
    {0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},{0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};
sds_config rtl9300_a_sds_xsgmii_lane0_18d[] =
{
    {0x00, 0x0E, 0x3053},{0x00, 0x02, 0x71d0},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},{0x2F, 0x05, 0x7F7C},
    {0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},{0x2F, 0x0A, 0x7C2F},
    {0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},{0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};
sds_config rtl9300_a_sds_xsgmii_lane0_18e[] =
{
    {0x00, 0x0E, 0x3053},{0x00, 0x02, 0x71d0},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},{0x2F, 0x05, 0x7F7C},
    {0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},{0x2F, 0x0A, 0x7C2F},
    {0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},{0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};
sds_config rtl9300_a_sds_xsgmii_lane1[] =
{
    {0x00, 0x0E, 0x3053},{0x00, 0x02, 0x70d0},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x00, 0x820F},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};
sds_config rtl9300_a_sds_xsgmii_lane1_18d[] =
{
    {0x00, 0x0E, 0x3053},{0x00, 0x02, 0x71d0},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x00, 0x820F},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};
sds_config rtl9300_a_sds_xsgmii_lane1_18e[] =
{
    {0x00, 0x0E, 0x3053},{0x00, 0x02, 0x71d0},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x00, 0x820F},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_10gr_lane0_95r[] =
{
    /*1G*/
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},{0x25, 0x05, 0x7F7C},
    {0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},{0x25, 0x0A, 0x7C2F},
    {0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},{0x25, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
    /*3.125G*/
    {0x28, 0x00, 0x0668},{0x28, 0x02, 0xD020},{0x28, 0x06, 0xC000},{0x28, 0x0B, 0x1892},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x01C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x1A, 0x0001},{0x28, 0x1C, 0x0400},
    {0x29, 0x01, 0x0300},{0x29, 0x02, 0x1017},{0x29, 0x03, 0xFFDF},{0x29, 0x05, 0x7F7C},
    {0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x09, 0xFFD4},{0x29, 0x0A, 0x7C2F},
    {0x29, 0x0E, 0x003F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    /*10G*/
    {0x06, 0x0D, 0x0F00},{0x06, 0x00, 0x0000},{0x06, 0x01, 0xC800},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8240},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},{0x2F, 0x05, 0x7F7C},
    {0x2F, 0x07, 0x80C4},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD6},{0x2F, 0x0A, 0x7C2F},
    {0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},{0x2F, 0x11, 0x8840},
    {0x2F, 0x14, 0xE008},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x17, 0x4109},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1C, 0x1109},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x76E1},
};

sds_config rtl9300_a_sds_10gr_lane1_95r[] =
{
    /*1G*/
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},{0x21, 0x0A, 0x0003},
    {0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},
    {0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x00, 0x820F},{0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},
    {0x25, 0x05, 0x7F7C},{0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},
    {0x25, 0x0A, 0x7C2F},{0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},
    {0x25, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
    /*3.125G*/
    {0x28, 0x00, 0x0668},{0x28, 0x02, 0xD020},{0x28, 0x06, 0xC000},{0x28, 0x0B, 0x1892},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x01C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x1A, 0x0001},{0x28, 0x1C, 0x0400},
    {0x29, 0x00, 0x820F},{0x29, 0x01, 0x0300},{0x29, 0x02, 0x1017},{0x29, 0x03, 0xFFDF},
    {0x29, 0x05, 0x7F7C},{0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x0A, 0x7C2F},
    {0x29, 0x0E, 0x003F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    /*10G*/
    {0x06, 0x0D, 0x0F00},{0x06, 0x00, 0x0000},{0x06, 0x01, 0xC800},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8240},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x00, 0x820F},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x80C4},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD6},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_10gr_lane0[] =
{
    /*1G*/
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},{0x25, 0x05, 0x7F7C},
    {0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},{0x25, 0x0A, 0x7C2F},
    {0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},{0x25, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
    /*3.125G*/
    {0x28, 0x00, 0x0668},{0x28, 0x02, 0xD020},{0x28, 0x06, 0xC000},{0x28, 0x0B, 0x1892},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x01C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x1A, 0x0001},{0x28, 0x1C, 0x0400},
    {0x29, 0x01, 0x0300},{0x29, 0x02, 0x1017},{0x29, 0x03, 0xFFDF},{0x29, 0x05, 0x7F7C},
    {0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x09, 0xFFD4},{0x29, 0x0A, 0x7C2F},
    {0x29, 0x0E, 0x003F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    /*10G*/
    {0x06, 0x0D, 0x0F00},{0x06, 0x00, 0x0000},{0x06, 0x01, 0xC800},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0044},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1217},{0x2F, 0x03, 0xFFDF},{0x2F, 0x05, 0x7F7C},
    {0x2F, 0x07, 0x80C4},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},{0x2F, 0x0A, 0x7C2F},
    {0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},{0x2F, 0x11, 0x8840},
    {0x2F, 0x14, 0xE008},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x17, 0x4109},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1C, 0x1109},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x76E1},
};

sds_config rtl9300_a_sds_10gr_lane1[] =
{
    /*1G*/
    {0x00, 0x0E, 0x3053},{0x01, 0x14, 0x0100},
    {0x21, 0x03, 0x8206},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},{0x21, 0x0A, 0x0003},
    {0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},
    {0x21, 0x0F, 0x0008},
    {0x24, 0x00, 0x0668},{0x24, 0x02, 0xD020},{0x24, 0x06, 0xC000},{0x24, 0x0B, 0x1892},
    {0x24, 0x0F, 0xFFDF},{0x24, 0x12, 0x03C4},{0x24, 0x13, 0x027F},{0x24, 0x14, 0x1311},
    {0x24, 0x16, 0x00C9},{0x24, 0x17, 0xA100},{0x24, 0x1A, 0x0001},{0x24, 0x1C, 0x0400},
    {0x25, 0x00, 0x820F},{0x25, 0x01, 0x0300},{0x25, 0x02, 0x1017},{0x25, 0x03, 0xFFDF},
    {0x25, 0x05, 0x7F7C},{0x25, 0x07, 0x8100},{0x25, 0x08, 0x0001},{0x25, 0x09, 0xFFD4},
    {0x25, 0x0A, 0x7C2F},{0x25, 0x0E, 0x003F},{0x25, 0x0F, 0x0121},{0x25, 0x10, 0x0020},
    {0x25, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
    /*3.125G*/
    {0x28, 0x00, 0x0668},{0x28, 0x02, 0xD020},{0x28, 0x06, 0xC000},{0x28, 0x0B, 0x1892},
    {0x28, 0x0F, 0xFFDF},{0x28, 0x12, 0x01C4},{0x28, 0x13, 0x027F},{0x28, 0x14, 0x1311},
    {0x28, 0x16, 0x00C9},{0x28, 0x17, 0xA100},{0x28, 0x1A, 0x0001},{0x28, 0x1C, 0x0400},
    {0x29, 0x00, 0x820F},{0x29, 0x01, 0x0300},{0x29, 0x02, 0x1017},{0x29, 0x03, 0xFFDF},
    {0x29, 0x05, 0x7F7C},{0x29, 0x07, 0x8100},{0x29, 0x08, 0x0001},{0x29, 0x0A, 0x7C2F},
    {0x29, 0x0E, 0x003F},{0x29, 0x0F, 0x0121},{0x29, 0x10, 0x0020},{0x29, 0x11, 0x8840},
    /*10G*/
    {0x06, 0x0D, 0x0F00},{0x06, 0x00, 0x0000},{0x06, 0x01, 0xC800},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0044},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x00, 0x820F},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1217},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x80C4},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

sds_config rtl9300_a_sds_rxaui_lane0[] =
{
    {0x0A, 0x01, 0x0300},{0x20, 0x12, 0x0050},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x0009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2C, 0x00, 0x0668},{0x2C, 0x02, 0xD020},{0x2C, 0x06, 0xC000},{0x2C, 0x0B, 0x1892},
    {0x2C, 0x0F, 0xFFDF},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1311},{0x2C, 0x16, 0x00C9},
    {0x2C, 0x17, 0xA100},{0x2C, 0x1A, 0x0001},{0x2C, 0x1C, 0x0400},{0x2D, 0x01, 0x0300},
    {0x2D, 0x02, 0x1017},{0x2D, 0x03, 0xFFDF},{0x2D, 0x05, 0x7F7C},{0x2D, 0x07, 0x8100},
    {0x2D, 0x08, 0x0001},{0x2D, 0x09, 0xFFD4},{0x2D, 0x0A, 0x7C2F},{0x2D, 0x0E, 0x003F},
    {0x2D, 0x0F, 0x0121},{0x2D, 0x10, 0x0020},{0x2D, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_rxaui_lane1[] =
{
    {0x0A, 0x01, 0x0300},{0x20, 0x12, 0x0050},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x0009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2C, 0x00, 0x0668},{0x2C, 0x02, 0xD020},{0x2C, 0x06, 0xC000},{0x2C, 0x0B, 0x1892},
    {0x2C, 0x0F, 0xFFDF},{0x2C, 0x13, 0x027F},{0x2C, 0x14, 0x1311},{0x2C, 0x16, 0x00C9},
    {0x2C, 0x17, 0xA100},{0x2C, 0x1A, 0x0001},{0x2C, 0x1C, 0x0400},{0x2D, 0x00, 0x820F},
    {0x2D, 0x01, 0x0300},{0x2D, 0x02, 0x1017},{0x2D, 0x03, 0xFFDF},{0x2D, 0x05, 0x7F7C},
    {0x2D, 0x07, 0x8100},{0x2D, 0x08, 0x0001},{0x2D, 0x09, 0xFFD4},{0x2D, 0x0A, 0x7C2F},
    {0x2D, 0x0E, 0x003F},{0x2D, 0x0F, 0x0121},{0x2D, 0x10, 0x0020},{0x2D, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3D87},{0x2D, 0x14, 0x2708},
};

sds_config rtl9300_a_sds_usxgmii_sx_lane0[] =
{
    {0x06, 0x00, 0x0000},{0x06, 0x0D, 0x0F00},{0x06, 0x0E, 0x055A},{0x07, 0x10, 0x6003},
    {0x06, 0x1D, 0x0600},{0x06, 0x13, 0x68C1},{0x06, 0x14, 0xF021},{0x07, 0x06, 0x1401},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},
    {0x2E, 0x0B, 0x1892},{0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},
    {0x2E, 0x13, 0x027F},{0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},
    {0x2E, 0x1C, 0x0400},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
    /*enable eee*/
    {0x06, 0x03, 0xc45c},
};

sds_config rtl9300_a_sds_usxgmii_sx_lane1[] =
{
    {0x06, 0x00, 0x0000},{0x06, 0x0D, 0x0F00},{0x06, 0x0E, 0x055A},{0x07, 0x10, 0x6003},
    {0x06, 0x1D, 0x0600},{0x06, 0x13, 0x68C1},{0x06, 0x14, 0xF021},{0x07, 0x06, 0x1401},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x00, 0x820F},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
    /*enable eee*/
    {0x06, 0x03, 0xc45c},
};

sds_config rtl9300_a_sds_usxgmii_qx_lane0[] =
{
    {0x06, 0x00, 0x0000},{0x06, 0x0D, 0x0F00},{0x06, 0x0E, 0x055A},{0x06, 0x1D, 0x0600},
    {0x07, 0x10, 0x6003},{0x06, 0x13, 0x68C1},{0x06, 0x14, 0xF021},{0x07, 0x06, 0x1401},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},{0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x01, 0x2088},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},
    {0x2E, 0x0B, 0x1892},{0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},
    {0x2E, 0x13, 0x027F},{0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},
    {0x2E, 0x1C, 0x0400},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
    /*enable eee*/
    {0x06, 0x03, 0xc45c},
};

sds_config rtl9300_a_sds_usxgmii_qx_lane1[] =
{
    {0x06, 0x00, 0x0000},{0x06, 0x0D, 0x0F00},{0x06, 0x0E, 0x055A},{0x06, 0x1D, 0x0600},
    {0x07, 0x10, 0x6003},{0x06, 0x13, 0x68C1},{0x06, 0x14, 0xF021},{0x07, 0x06, 0x1401},
    {0x21, 0x03, 0x8206},{0x21, 0x05, 0x40B0},{0x21, 0x06, 0x0010},{0x21, 0x07, 0xF09F},
    {0x21, 0x0A, 0x0003},{0x21, 0x0B, 0x0005},{0x21, 0x0C, 0x0007},{0x21, 0x0D, 0x6009},
    {0x21, 0x0E, 0x0000},{0x21, 0x0F, 0x0008},
    {0x2E, 0x00, 0xA668},{0x2E, 0x02, 0xD020},{0x2E, 0x06, 0xC000},{0x2E, 0x0B, 0x1892},
    {0x2E, 0x0F, 0xFFDF},{0x2E, 0x11, 0x8280},{0x2E, 0x12, 0x0484},{0x2E, 0x13, 0x027F},
    {0x2E, 0x14, 0x1311},{0x2E, 0x17, 0xA100},{0x2E, 0x1A, 0x0001},{0x2E, 0x1C, 0x0400},
    {0x2F, 0x00, 0x820F},{0x2F, 0x01, 0x0300},{0x2F, 0x02, 0x1017},{0x2F, 0x03, 0xFFDF},
    {0x2F, 0x05, 0x7F7C},{0x2F, 0x07, 0x8104},{0x2F, 0x08, 0x0001},{0x2F, 0x09, 0xFFD4},
    {0x2F, 0x0A, 0x7C2F},{0x2F, 0x0E, 0x003F},{0x2F, 0x0F, 0x0121},{0x2F, 0x10, 0x0020},
    {0x2F, 0x11, 0x8840},
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},
    {0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
    /*enable eee*/
    {0x06, 0x03, 0xc45c},
};

sds_config rtl9300_a_sds_off_lane0[] =
{
    {0x2B, 0x13, 0x0050},{0x2B, 0x18, 0x8E88},{0x2B, 0x19, 0x4902},{0x2B, 0x1D, 0x2501},
    {0x2D, 0x13, 0x0050},{0x2D, 0x17, 0x4109},{0x2D, 0x18, 0x8E88},{0x2D, 0x19, 0x4902},
    {0x2D, 0x1C, 0x1109},{0x2D, 0x1D, 0x2641},
    {0x2F, 0x13, 0x0050},{0x2F, 0x18, 0x8E88},{0x2F, 0x19, 0x4902},{0x2F, 0x1D, 0x66E1},
};

sds_config rtl9300_a_sds_off_lane1[] =
{
    {0x2B, 0x13, 0x3D87},{0x2B, 0x14, 0x3108},{0x2D, 0x13, 0x3C87},{0x2D, 0x14, 0x1808},
};

patch_t  serdes_patch_List_bT[] =
{
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_NONE,          rtl9300_bT_sds_qsgmii,              sizeof(rtl9300_bT_sds_qsgmii)/sizeof(sds_config)},
    {RTK_MII_10GR,            0,    RTK_PHYTYPE_NONE,          rtl9300_bT_sds_10gr_1000Bx,   sizeof(rtl9300_bT_sds_10gr_1000Bx)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_NONE,          rtl9300_bT_sds_xsgmii,              sizeof(rtl9300_bT_sds_xsgmii)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  0,    RTK_PHYTYPE_NONE,          rtl9300_bT_sds_rxaui_lane0,     sizeof(rtl9300_bT_sds_rxaui_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  1,   RTK_PHYTYPE_NONE,           rtl9300_bT_sds_rxaui_lane1,     sizeof(rtl9300_bT_sds_rxaui_lane1)/sizeof(sds_config)},
};

patch_t  serdes_patch_List_cT[] =
{
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_RTL8218B,   rtl9300_cT_sds_qsgmii_8218b,   sizeof(rtl9300_cT_sds_qsgmii_8218b)/sizeof(sds_config)},
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_NONE,         rtl9300_cT_sds_qsgmii,              sizeof(rtl9300_cT_sds_qsgmii)/sizeof(sds_config)},
    {RTK_MII_10GR,            0,    RTK_PHYTYPE_NONE,         rtl9300_cT_sds_10gr_1000Bx,   sizeof(rtl9300_cT_sds_10gr_1000Bx)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_NONE,        rtl9300_cT_sds_xsgmii,              sizeof(rtl9300_cT_sds_xsgmii)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  0,    RTK_PHYTYPE_NONE,       rtl9300_cT_sds_rxaui_lane0,     sizeof(rtl9300_cT_sds_rxaui_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  1,   RTK_PHYTYPE_NONE,        rtl9300_cT_sds_rxaui_lane1,     sizeof(rtl9300_cT_sds_rxaui_lane1)/sizeof(sds_config)},
};

patch_t  serdes_patch_List_5g_dT[] =
{
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_RTL8218B,   rtl9300_dT_sds_5g_qsgmii_8218b,   sizeof(rtl9300_dT_sds_5g_qsgmii_8218b)/sizeof(sds_config)},
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_5g_qsgmii,              sizeof(rtl9300_dT_sds_5g_qsgmii)/sizeof(sds_config)},
};

patch_t  serdes_patch_List_10g_odd_dT[] =
{
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_qsgmii_lane1,     sizeof(rtl9300_dT_sds_10g_qsgmii_lane1)/sizeof(sds_config)},
    {RTK_MII_100BX_FIBER, 0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_1000Bx_lane1,   sizeof(rtl9300_dT_sds_10g_1000Bx_lane1)/sizeof(sds_config)},
    {RTK_MII_2500Base_X,   0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_2500Bx_lane1,   sizeof(rtl9300_dT_sds_10g_2500Bx_lane1)/sizeof(sds_config)},
    {RTK_MII_RSGMII,          0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_rsgmii_lane1,   sizeof(rtl9300_dT_sds_10g_rsgmii_lane1)/sizeof(sds_config)},
    {RTK_MII_RXAUI_LITE,    0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_rxaui_lite_lane1,   sizeof(rtl9300_dT_sds_10g_rxaui_lite_lane1)/sizeof(sds_config)},
    {RTK_MII_10GR,             0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10gr_lane1,   sizeof(rtl9300_dT_sds_10gr_lane1)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_NONE,        rtl9300_dT_sds_xsgmii,              sizeof(rtl9300_dT_sds_xsgmii)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  0,    RTK_PHYTYPE_NONE,       rtl9300_dT_sds_rxaui_lane0,     sizeof(rtl9300_dT_sds_rxaui_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  1,   RTK_PHYTYPE_NONE,        rtl9300_dT_sds_rxaui_lane1,     sizeof(rtl9300_dT_sds_rxaui_lane1)/sizeof(sds_config)},
    {RTK_MII_USXGMII_10GSXGMII,       0,   RTK_PHYTYPE_NONE,         rtl9300_dT_sds_usxgmii_sx,       sizeof(rtl9300_dT_sds_usxgmii_sx)/sizeof(sds_config)},
    {RTK_MII_USXGMII_10GQXGMII,       0,   RTK_PHYTYPE_NONE,         rtl9300_dT_sds_usxgmii_qx,      sizeof(rtl9300_dT_sds_usxgmii_qx)/sizeof(sds_config)},
};

patch_t  serdes_patch_List_10g_even_dT[] =
{
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_qsgmii_lane0,     sizeof(rtl9300_dT_sds_10g_qsgmii_lane0)/sizeof(sds_config)},
    {RTK_MII_100BX_FIBER, 0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_1000Bx_lane0,   sizeof(rtl9300_dT_sds_10g_1000Bx_lane0)/sizeof(sds_config)},
    {RTK_MII_2500Base_X,   0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_2500Bx_lane0,   sizeof(rtl9300_dT_sds_10g_2500Bx_lane0)/sizeof(sds_config)},
    {RTK_MII_RSGMII,          0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_rsgmii_lane0,   sizeof(rtl9300_dT_sds_10g_rsgmii_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_LITE,    0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10g_rxaui_lite_lane0,   sizeof(rtl9300_dT_sds_10g_rxaui_lite_lane0)/sizeof(sds_config)},
    {RTK_MII_10GR,             0,    RTK_PHYTYPE_NONE,         rtl9300_dT_sds_10gr_lane0,   sizeof(rtl9300_dT_sds_10gr_lane0)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_NONE,        rtl9300_dT_sds_xsgmii,              sizeof(rtl9300_dT_sds_xsgmii)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  0,    RTK_PHYTYPE_NONE,       rtl9300_dT_sds_rxaui_lane0,     sizeof(rtl9300_dT_sds_rxaui_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  1,   RTK_PHYTYPE_NONE,        rtl9300_dT_sds_rxaui_lane1,     sizeof(rtl9300_dT_sds_rxaui_lane1)/sizeof(sds_config)},
    {RTK_MII_USXGMII_10GSXGMII,       0,   RTK_PHYTYPE_NONE,         rtl9300_dT_sds_usxgmii_sx,       sizeof(rtl9300_dT_sds_usxgmii_sx)/sizeof(sds_config)},
    {RTK_MII_USXGMII_10GQXGMII,       0,   RTK_PHYTYPE_NONE,         rtl9300_dT_sds_usxgmii_qx,      sizeof(rtl9300_dT_sds_usxgmii_qx)/sizeof(sds_config)},
};

patch_t  serdes_patch_List_5g_a[] =
{
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_RTL8218B,   rtl9300_a_sds_5g_qsgmii_8218b,   sizeof(rtl9300_a_sds_5g_qsgmii_8218b)/sizeof(sds_config)},
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_5g_qsgmii,              sizeof(rtl9300_a_sds_5g_qsgmii)/sizeof(sds_config)},
};

patch_t  serdes_patch_List_10g_odd_a[] =
{
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_qsgmii_lane1,     sizeof(rtl9300_a_sds_10g_qsgmii_lane1)/sizeof(sds_config)},
    {RTK_MII_SGMII,            0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_sgmii_lane1,   sizeof(rtl9300_a_sds_10g_sgmii_lane1)/sizeof(sds_config)},
    {RTK_MII_1000BX_FIBER, 0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_1000Bx_lane1,   sizeof(rtl9300_a_sds_10g_1000Bx_lane1)/sizeof(sds_config)},
    {RTK_MII_HISGMII,        0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_hisgmii_lane1,   sizeof(rtl9300_a_sds_10g_hisgmii_lane1)/sizeof(sds_config)},
    {RTK_MII_2500Base_X,   0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_2500Bx_lane1,   sizeof(rtl9300_a_sds_10g_2500Bx_lane1)/sizeof(sds_config)},
    {RTK_MII_RSGMII,          0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_rsgmii_lane1,   sizeof(rtl9300_a_sds_10g_rsgmii_lane1)/sizeof(sds_config)},
    {RTK_MII_RXAUI_LITE,    0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_rxaui_lite_lane1,   sizeof(rtl9300_a_sds_10g_rxaui_lite_lane1)/sizeof(sds_config)},
    {RTK_MII_10GR,             0,    RTK_PHYTYPE_RTL8295R,   rtl9300_a_sds_10gr_lane1_95r,   sizeof(rtl9300_a_sds_10gr_lane1_95r)/sizeof(sds_config)},
    {RTK_MII_10GR,             0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10gr_lane1,   sizeof(rtl9300_a_sds_10gr_lane1)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_RTL8218D,        rtl9300_a_sds_xsgmii_lane1_18d,              sizeof(rtl9300_a_sds_xsgmii_lane1_18d)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_RTL8218E,        rtl9300_a_sds_xsgmii_lane1_18e,              sizeof(rtl9300_a_sds_xsgmii_lane1_18e)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_NONE,        rtl9300_a_sds_xsgmii_lane1,              sizeof(rtl9300_a_sds_xsgmii_lane1)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  0,    RTK_PHYTYPE_NONE,       rtl9300_a_sds_rxaui_lane0,     sizeof(rtl9300_a_sds_rxaui_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  1,   RTK_PHYTYPE_NONE,        rtl9300_a_sds_rxaui_lane1,     sizeof(rtl9300_a_sds_rxaui_lane1)/sizeof(sds_config)},
    {RTK_MII_USXGMII_10GSXGMII,       0,   RTK_PHYTYPE_NONE,         rtl9300_a_sds_usxgmii_sx_lane1,       sizeof(rtl9300_a_sds_usxgmii_sx_lane1)/sizeof(sds_config)},
    {RTK_MII_USXGMII_10GQXGMII,       0,   RTK_PHYTYPE_NONE,         rtl9300_a_sds_usxgmii_qx_lane1,      sizeof(rtl9300_a_sds_usxgmii_qx_lane1)/sizeof(sds_config)},
    {RTK_MII_NONE,             0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_off_lane1,     sizeof(rtl9300_a_sds_off_lane1)/sizeof(sds_config)},
};

patch_t  serdes_patch_List_10g_even_a[] =
{
    {RTK_MII_QSGMII,         0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_qsgmii_lane0,     sizeof(rtl9300_a_sds_10g_qsgmii_lane0)/sizeof(sds_config)},
    {RTK_MII_SGMII,            0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_sgmii_lane0,   sizeof(rtl9300_a_sds_10g_sgmii_lane0)/sizeof(sds_config)},
    {RTK_MII_1000BX_FIBER, 0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_1000Bx_lane0,   sizeof(rtl9300_a_sds_10g_1000Bx_lane0)/sizeof(sds_config)},
    {RTK_MII_HISGMII,        0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_hisgmii_lane0,   sizeof(rtl9300_a_sds_10g_hisgmii_lane0)/sizeof(sds_config)},
    {RTK_MII_2500Base_X,   0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_2500Bx_lane0,   sizeof(rtl9300_a_sds_10g_2500Bx_lane0)/sizeof(sds_config)},
    {RTK_MII_RSGMII,          0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_rsgmii_lane0,   sizeof(rtl9300_a_sds_10g_rsgmii_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_LITE,    0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10g_rxaui_lite_lane0,   sizeof(rtl9300_a_sds_10g_rxaui_lite_lane0)/sizeof(sds_config)},
    {RTK_MII_10GR,             0,    RTK_PHYTYPE_RTL8295R,   rtl9300_a_sds_10gr_lane0_95r,   sizeof(rtl9300_a_sds_10gr_lane0_95r)/sizeof(sds_config)},
    {RTK_MII_10GR,             0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_10gr_lane0,   sizeof(rtl9300_a_sds_10gr_lane0)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_RTL8218D,        rtl9300_a_sds_xsgmii_lane0_18d,              sizeof(rtl9300_a_sds_xsgmii_lane0_18d)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_RTL8218E,        rtl9300_a_sds_xsgmii_lane0_18e,              sizeof(rtl9300_a_sds_xsgmii_lane0_18e)/sizeof(sds_config)},
    {RTK_MII_XSGMII,         0,    RTK_PHYTYPE_NONE,        rtl9300_a_sds_xsgmii_lane0,              sizeof(rtl9300_a_sds_xsgmii_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  0,    RTK_PHYTYPE_NONE,       rtl9300_a_sds_rxaui_lane0,     sizeof(rtl9300_a_sds_rxaui_lane0)/sizeof(sds_config)},
    {RTK_MII_RXAUI_PLUS,  1,   RTK_PHYTYPE_NONE,        rtl9300_a_sds_rxaui_lane1,     sizeof(rtl9300_a_sds_rxaui_lane1)/sizeof(sds_config)},
    {RTK_MII_USXGMII_10GSXGMII,       0,   RTK_PHYTYPE_NONE,         rtl9300_a_sds_usxgmii_sx_lane0,       sizeof(rtl9300_a_sds_usxgmii_sx_lane0)/sizeof(sds_config)},
    {RTK_MII_USXGMII_10GQXGMII,       0,   RTK_PHYTYPE_NONE,         rtl9300_a_sds_usxgmii_qx_lane0,      sizeof(rtl9300_a_sds_usxgmii_qx_lane0)/sizeof(sds_config)},
    {RTK_MII_NONE,             0,    RTK_PHYTYPE_NONE,         rtl9300_a_sds_off_lane0,     sizeof(rtl9300_a_sds_off_lane0)/sizeof(sds_config)},
};

patch_list_t serdes_patch_list_dT =
{
    serdes_patch_List_5g_dT,
    sizeof(serdes_patch_List_5g_dT)/sizeof(patch_t),
    serdes_patch_List_10g_odd_dT,
    sizeof(serdes_patch_List_10g_odd_dT)/sizeof(patch_t),
    serdes_patch_List_10g_even_dT,
    sizeof(serdes_patch_List_10g_even_dT)/sizeof(patch_t),
};

patch_list_t serdes_patch_list_a =
{
    serdes_patch_List_5g_a,
    sizeof(serdes_patch_List_5g_a)/sizeof(patch_t),
    serdes_patch_List_10g_odd_a,
    sizeof(serdes_patch_List_10g_odd_a)/sizeof(patch_t),
    serdes_patch_List_10g_even_a,
    sizeof(serdes_patch_List_10g_even_a)/sizeof(patch_t),
};

reg_field_t sds_mode_sel[] =
{
    {LONGAN_SDS_MODE_SEL_0r, LONGAN_SDS0_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_0r, LONGAN_SDS1_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_0r, LONGAN_SDS2_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_0r, LONGAN_SDS3_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_1r, LONGAN_SDS4_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_1r, LONGAN_SDS5_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_1r, LONGAN_SDS6_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_1r, LONGAN_SDS7_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_2r, LONGAN_SDS8_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_2r, LONGAN_SDS9_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_3r, LONGAN_SDS10_MODE_SELf},
    {LONGAN_SDS_MODE_SEL_3r, LONGAN_SDS11_MODE_SELf},
};

reg_field_t sds_sub_mode_sel[] =
{
    /*sds0/1 donot have submode*/
    {LONGAN_REG_LIST_END, LONGAN_REGFIELD_LIST_END},
    {LONGAN_REG_LIST_END, LONGAN_REGFIELD_LIST_END},

    {LONGAN_SDS_SUBMODE_CTRL0r, LONGAN_S2_USXGMII_SUBMODEf},
    {LONGAN_SDS_SUBMODE_CTRL0r, LONGAN_S3_USXGMII_SUBMODEf},
    {LONGAN_SDS_SUBMODE_CTRL1r, LONGAN_S4_USXGMII_SUBMODEf},
    {LONGAN_SDS_SUBMODE_CTRL1r, LONGAN_S5_USXGMII_SUBMODEf},
    {LONGAN_SDS_SUBMODE_CTRL1r, LONGAN_S6_USXGMII_SUBMODEf},
    {LONGAN_SDS_SUBMODE_CTRL1r, LONGAN_S7_USXGMII_SUBMODEf},
    {LONGAN_SDS_SUBMODE_CTRL1r, LONGAN_S8_USXGMII_SUBMODEf},
    {LONGAN_SDS_SUBMODE_CTRL1r, LONGAN_S9_USXGMII_SUBMODEf},
    /*sds10/11 donot have submode*/
    {LONGAN_REG_LIST_END, LONGAN_REGFIELD_LIST_END},
    {LONGAN_REG_LIST_END, LONGAN_REGFIELD_LIST_END},
};

/* usxgmii config
 *
 * nway_enable
 * opcode
 * am_period
 * am_marker
 * an_table
 * sync_bit
 */
static dal_longan_sds_usxgmii_cfg_t sds_usxgmii_cfg_rtl8224 =
{
    .nway_enable = ENABLED,
    .opcode = 0xaa,
    .am_period = 0x5078,
    .am_marker = {0},
    .an_table = 1,
    .sync_bit = 0x1,
};

static dal_longan_sds_usxgmii_cfg_t sds_usxgmii_cfg_rtl8224qf =
{
    .nway_enable = ENABLED,
    .opcode = 0xaa,
    .am_period = 0x606,
    .am_marker = {0},
    .an_table = 1,
    .sync_bit = 0x2,
};

static dal_longan_sds_usxgmii_cfg_t sds_usxgmii_cfg_rtk_default =
{
    .nway_enable = ENABLED,
    .opcode = 0xaa,
    .am_period = 0x5078,
    .am_marker = {0},
    .an_table = 1,
    .sync_bit = 0x1,
};


/*
 * Function Declaration
 */
static void _rtl9300_serdes_index_to_physical(uint32 unit, uint8 page, uint32 logicIdx, uint32 *phyIdx0, uint32 *phyIdx1);
static void _rtl9300_serdes_reg_write(uint32 unit, uint8 index, uint8 page, uint8 reg, uint16 data);
static void _rtl9300_mac_serdes_patch_set(uint32 unit, uint32 sdsId, sds_config *cfg, uint32 size);

static void _rtl9300_serdes_index_to_physical(uint32 unit, uint8 page, uint32 logicIdx, uint32 *phyIdx0,uint32 *phyIdx1)
{
    if((page >= 0x4) || ((2 != logicIdx) && (3 != logicIdx)))
    {
        *phyIdx0 = logicIdx;
        *phyIdx1 = logicIdx;
    }
    else if(2 == logicIdx)
    {
        if((HWP_SDS_MODE(unit, logicIdx) == RTK_MII_XSGMII) ||
            (HWP_SDS_MODE(unit, logicIdx) == RTK_MII_RSGMII))
        {
            *phyIdx0 = 2;
            *phyIdx1 = 3;
        }
        else
        {
            *phyIdx0 = 2;
            *phyIdx1 = 2;
        }
    }
    else /*logic sdsid is 3*/
    {
        if((HWP_SDS_MODE(unit, logicIdx) == RTK_MII_XSGMII) ||
            (HWP_SDS_MODE(unit, logicIdx) == RTK_MII_RSGMII))
        {
            *phyIdx0 = 10;
            *phyIdx1 = 11;
        }
        else
        {
            *phyIdx0 = 10;
            *phyIdx1 = 10;
        }
    }

    return;
}

static void _rtl9300_serdes_reg_write(uint32 unit, uint8 index, uint8 page, uint8 reg, uint16 data)
{
    uint32 cmddata = 0;
    uint32 flag = 0;
    uint32 i = 0;
    uint32 value = 0;
    int32  ret = RT_ERR_OK;

    value = 0;
    value = data;

    RT_ERR_VOID_CHK(reg_field_write(unit, LONGAN_SDS_INDACS_DATAr, LONGAN_SDS_DATAf, &value), ret);

    cmddata = 0;
    cmddata = (index << 2) + (page << 7) + (reg << 13) + 3;
    RT_ERR_VOID_CHK(reg_write(unit, LONGAN_SDS_INDACS_CMDr, &cmddata), ret);

    for (i = 0; i < 100; i++)
    {
        osal_time_udelay(10);
        ret = reg_field_read(unit, LONGAN_SDS_INDACS_CMDr, LONGAN_SDS_CMDf,&flag);
        if(ret != RT_ERR_OK)
        {
            CNSTRT_PRINT("%s,%d:sds register access fail!\n", __FUNCTION__, __LINE__);
            return;
        }
        if (0 == flag)
        {
            break;
        }
    }

    if (i >= 100)
    {
        CNSTRT_PRINT("%s,%d:sds register access fail!\n", __FUNCTION__, __LINE__);
        return;
    }

    return;
}

static void _rtl9300_mac_serdes_patch_set(uint32 unit, uint32 sdsId, sds_config *cfg, uint32 size)
{
    uint32 phySdsId0;
    uint32 phySdsId1;

    if(NULL == cfg)
        return;

    while(size)
    {
        _rtl9300_serdes_index_to_physical(unit, cfg->page, sdsId, &phySdsId0, &phySdsId1);

        if(phySdsId0 == phySdsId1)
        {
            _rtl9300_serdes_reg_write(unit, phySdsId0, cfg->page, cfg->reg, cfg->data);

            CNSTRT_PRINT("sds %d write page:0x%x,reg:0x%x,data:0x%x\n",phySdsId0,cfg->page,cfg->reg, cfg->data);
        }
        else
        {
            _rtl9300_serdes_reg_write(unit, phySdsId0, cfg->page, cfg->reg, cfg->data);
            _rtl9300_serdes_reg_write(unit, phySdsId1, cfg->page, cfg->reg, cfg->data);

            CNSTRT_PRINT("sds %d write page:0x%x,reg:0x%x,data:0x%x\n",phySdsId0,cfg->page,cfg->reg, cfg->data);
            CNSTRT_PRINT("sds %d write page:0x%x,reg:0x%x,data:0x%x\n",phySdsId1,cfg->page,cfg->reg, cfg->data);
        }
        cfg++;
        size--;
    }

    return;
}

inline static int32 _dal_longan_sds_usxgmii_cfg_set(uint32 unit, uint32 sds, dal_longan_sds_usxgmii_cfg_t *cfg)
{
    uint32 data = 0;
    int32 ret = RT_ERR_OK;

    if (cfg->nway_enable == ENABLED)
        data = 1;
    else
        data = 0;

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x7, 0x11, 0, 0, data), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x7, 0x11, 1, 1, data), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x7, 0x11, 2, 2, data), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x7, 0x11, 3, 3, data), ret);

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x12, 15, 0, cfg->am_period), ret);

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x13, 7,  0, cfg->am_marker.marker0_m0), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x13, 15, 8, cfg->am_marker.marker0_m1), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x14, 7,  0, cfg->am_marker.marker0_m2), ret);

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x14, 15, 8, cfg->am_marker.marker1_m0), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x15, 7,  0, cfg->am_marker.marker1_m1), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x15, 15, 8, cfg->am_marker.marker1_m2), ret);

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x16, 7,  0, cfg->am_marker.marker2_m0), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x16, 15, 8, cfg->am_marker.marker2_m1), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x17, 7,  0, cfg->am_marker.marker2_m2), ret);

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x17, 15, 8, cfg->am_marker.marker3_m0), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x18, 7,  0, cfg->am_marker.marker3_m1), ret);
    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x18, 15, 8, cfg->am_marker.marker3_m2), ret);

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x7, 0x10, 7, 0, cfg->opcode), ret);

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0xe, 10, 10, cfg->an_table), ret);

    RT_ERR_CHK(SDS_FIELD_W(unit, sds, 0x6, 0x1d, 11, 10, cfg->sync_bit), ret);

    return ret;
}

/* Function Name:
 *      _dal_longan_construct_phy_powerOnOff
 * Description:
 *      Power-On PHY.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void _dal_longan_construct_phy_powerOnOff(uint32 unit)
{
    rtk_port_t  port;
    uint32  pwr_flag = 0;

    CNSTRT_PRINT("%s()\n",__FUNCTION__);

    HWP_PORT_TRAVS(unit, port)
    {
        if((RTK_PHYTYPE_RTL8218B == HWP_PHY_MODEL_BY_PORT(unit,port)) || (RTK_PHYTYPE_RTL8214FC == HWP_PHY_MODEL_BY_PORT(unit,port)))
        {
            pwr_flag = 1;
            phy_enable_set(unit, port,ENABLED);
        }

        if(0 == pwr_flag)
            return;
    }

    osal_time_mdelay(500);

    HWP_PORT_TRAVS(unit, port)
    {
        if((RTK_PHYTYPE_RTL8218B == HWP_PHY_MODEL_BY_PORT(unit,port)) || (RTK_PHYTYPE_RTL8214FC == HWP_PHY_MODEL_BY_PORT(unit,port)))
        {
            phy_enable_set(unit, port,DISABLED);
        }
    }

    return;
}/* end of _dal_longan_construct_phy_powerOnOff */

static int32 _dal_longan_smi_defalut_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;

    if( (RTL9301_CHIP_ID_24G == HWP_CHIP_ID(unit) || RTL9303_CHIP_ID_8XG == HWP_CHIP_ID(unit)) &&
        (2 == HWP_CHIP_REV(unit)))
    {
        uint32      data = 0, freq = 0x1; /* 400ns(2.5MHz); */
        if (reg_read(unit, LONGAN_SMI_GLB_CTRLr, &data) == RT_ERR_OK)
        {
            if ((ret = reg_field_set(unit, LONGAN_SMI_GLB_CTRLr, LONGAN_SMI0_FREQ_SELf, &freq, &data)) != RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
                return ret;
            }
            if ((ret = reg_field_set(unit, LONGAN_SMI_GLB_CTRLr, LONGAN_SMI1_FREQ_SELf, &freq, &data)) != RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
                return ret;
            }
            if ((ret = reg_field_set(unit, LONGAN_SMI_GLB_CTRLr, LONGAN_SMI2_FREQ_SELf, &freq, &data)) != RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
                return ret;
            }
            if ((ret = reg_field_set(unit, LONGAN_SMI_GLB_CTRLr, LONGAN_SMI3_FREQ_SELf, &freq, &data)) != RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
                return ret;
            }
            if ((ret = reg_write(unit, LONGAN_SMI_GLB_CTRLr, &data)) != RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
                return ret;
            }
        }
    }

    value = 0;
    if ((ret = reg_field_write(unit, LONGAN_SMI_GLB_CTRLr, LONGAN_SMI0_POLL_SELf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }
    value = 0;
    if ((ret = reg_field_write(unit, LONGAN_SMI_GLB_CTRLr, LONGAN_SMI1_POLL_SELf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }
    value = 0;
    if ((ret = reg_field_write(unit, LONGAN_SMI_GLB_CTRLr, LONGAN_SMI2_POLL_SELf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }
    value = 1;
    if ((ret = reg_field_write(unit, LONGAN_SMI_GLB_CTRLr, LONGAN_SMI3_POLL_SELf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }

    return RT_ERR_OK;
}

static int32 _dal_longan_port_defalut_init_config(uint32 unit)
{
    int32   ret;
    uint32 value;

    /******************Auto Recovery Init***********************/
    /*Disable Asic Auto Software Queue Reset featrue*/
    value = 0x0;
    if ((ret = reg_field_write(unit, LONGAN_TRIG_AUTO_RECOVER_CTRL_INGRESSr, LONGAN_EN_SYS_DSC_ERR_TRIGf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }
    value = 0x0;
    if ((ret = reg_field_write(unit, LONGAN_TRIG_AUTO_RECOVER_CTRL_INGRESSr, LONGAN_EN_RXPORT_DSC_ERR_TRIGf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }
    value = 0x0;
    if ((ret = reg_field_write(unit, LONGAN_TRIG_AUTO_RECOVER_CTRL_INGRESSr, LONGAN_EN_TOKEN_ERR_TRIGf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }
    value = 0x0;
    if ((ret = reg_field_write(unit, LONGAN_TRIG_AUTO_RECOVER_CTRL_EGRESSr, LONGAN_EN_LD_TX_DSC_ERR_TRIGf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }
    value = 0x0;
    if ((ret = reg_field_write(unit, LONGAN_TRIG_AUTO_RECOVER_CTRL_EGRESSr, LONGAN_EN_PINGPONG_ERR_TRIGf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }
    value = 0x0;
    if ((ret = reg_field_write(unit, LONGAN_TRIG_AUTO_RECOVER_CTRL_MACr, LONGAN_EN_FIFO_ERR_TRIGf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }

    /*SS-501*/
    value = 0xfffffff;
    if ((ret = reg_field_write(unit, LONGAN_DMY_REG0_CHIP_MISC_Rr, LONGAN_DUMMYf, &value)) != RT_ERR_OK)
    {
        RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
        return ret;
    }

    return RT_ERR_OK;
}

typedef struct regActCtrl_s
{
	uint32	 reg;
	uint32	 field;
	uint32	 actValue;
}regActCtrl_t;

static int32
_dal_longan_ipmcast_init_config(uint32 unit)
{
    int32 ret;
    int32 i;


    regActCtrl_t    regInfo[] = {
        /*set ipmc except action is bridge*/
        {LONGAN_L3_IPMC_ROUTE_CTRLr, LONGAN_DMAC_MISMATCH_ACTf,     0x3},
        {LONGAN_L3_IPMC_ROUTE_CTRLr, LONGAN_ZERO_SIP_ACTf,                  0x3},
        {LONGAN_L3_IPMC_ROUTE_CTRLr, LONGAN_BAD_SIP_ACTf,                   0x3},
		{LONGAN_L3_IPMC_ROUTE_CTRLr, LONGAN_HDR_OPT_ACTf,                   0x6},

        {LONGAN_L3_IP6MC_ROUTE_CTRLr, LONGAN_DMAC_MISMATCH_ACTf,    0x3},
        {LONGAN_L3_IP6MC_ROUTE_CTRLr, LONGAN_ZERO_SIP_ACTf,                 0x3},
        {LONGAN_L3_IP6MC_ROUTE_CTRLr, LONGAN_BAD_SIP_ACTf,                  0x3},

        /*set ip6mc hop action is bridge*/
        {LONGAN_L3_IP6MC_ROUTE_CTRLr, LONGAN_HBH_ERR_ACTf,       0x6},
        {LONGAN_L3_IP6MC_ROUTE_CTRLr, LONGAN_HBH_ACTf,              0x6},
		{LONGAN_L3_IP6MC_ROUTE_CTRLr, LONGAN_HDR_ROUTE_ACTf,        0x6},
    };

    for (i = 0; i < sizeof(regInfo)/sizeof(regActCtrl_t); i++)
    {
        RT_ERR_CHK(reg_field_write(unit, regInfo[i].reg, regInfo[i].field, &regInfo[i].actValue), ret);
    }

    return RT_ERR_OK;
}

typedef enum fcModelIdx_e
{
    FC_MODEL_IDX_24G_4XG,
    FC_MODEL_IDX_8XG,
    FC_MODEL_IDX_48G_CASCADE,
    FC_MODEL_IDX_24x2_5G_2XG,
    FC_MODEL_IDX_END,
} fcModelIdx_t;

typedef struct fcRegActCtrl_s
{
    uint32   reg;
    uint32   field;
    uint32   actValue[FC_MODEL_IDX_END];   /* 0 for 24G+4*10G, 1 for 8*10G, 2 for 48G stacking, 3 for 24*2.5G+2*10G */
}fcRegActCtrl_t;

typedef struct fcRegIdxActCtrl_s
{
    uint32  idx;
    fcRegActCtrl_t    regAct;
}fcRegIdxActCtrl_t;

static fcRegActCtrl_t    fcPerPortCfg[] = {
        /*register*/              /*field*/                         /*24G+4*10G*/    /*8*10G*/       /*48G cascade*/ /*24*2.5G+2*10G*/
        {LONGAN_FC_PORT_ACT_CTRLr, LONGAN_ALLOW_PAGE_CNTf,          {0x032,          0x032,          0x032,          0x034, }},
};

static fcRegActCtrl_t    flowctrlGlobCfg[] = {
        /*register*/              /*field*/                         /*24G+4*10G*/    /*8*10G*/       /*48G cascade*/ /*24*2.5G+2*10G*/
        {LONGAN_FC_GLB_DROP_THRr, LONGAN_DROP_ALLf,                 {0xfe4,          0xff8,          0xfc8,          0xfe4, }},
        {LONGAN_FC_GLB_SYS_UTIL_THRr, LONGAN_THRf,                  {0x5d4,          0x958,          0x4a6,          0x5d4, }},

        {LONGAN_FC_GLB_HI_THRr, LONGAN_ONf,                         {0x890,          0xa20,          0x542,          0x890, }},
        {LONGAN_FC_GLB_HI_THRr, LONGAN_OFFf,                        {0x778,          0x9d0,          0x50e,          0x778, }},
        {LONGAN_FC_GLB_LO_THRr, LONGAN_ONf,                         {0x5d4,          0x958,          0x4a6,          0x5d4, }},
        {LONGAN_FC_GLB_LO_THRr, LONGAN_OFFf,                        {0x4bc,          0x908,          0x472,          0x4bc, }},
        {LONGAN_FC_GLB_FCOFF_HI_THRr, LONGAN_ONf,                   {0x890,          0xa20,          0x542,          0x890, }},
        {LONGAN_FC_GLB_FCOFF_HI_THRr, LONGAN_OFFf,                  {0x778,          0x9d0,          0x50e,          0x778, }},
        {LONGAN_FC_GLB_FCOFF_LO_THRr, LONGAN_ONf,                   {0x5d4,          0x958,          0x4a6,          0x5d4, }},
        {LONGAN_FC_GLB_FCOFF_LO_THRr, LONGAN_OFFf,                  {0x4bc,          0x908,          0x472,          0x4bc, }},

        {LONGAN_FC_JUMBO_HI_THRr, LONGAN_ONf,                       {0x628,          0xd30,          0x542,          0x628, }},
        {LONGAN_FC_JUMBO_HI_THRr, LONGAN_OFFf,                      {0x510,          0xce0,          0x50e,          0x510, }},
        {LONGAN_FC_JUMBO_LO_THRr, LONGAN_ONf,                       {0x36c,          0xc68,          0x4a6,          0x36c, }},
        {LONGAN_FC_JUMBO_LO_THRr, LONGAN_OFFf,                      {0x254,          0xc18,          0x472,          0x254, }},
        {LONGAN_FC_JUMBO_FCOFF_HI_THRr, LONGAN_ONf,                 {0x628,          0xd30,          0x542,          0x628, }},
        {LONGAN_FC_JUMBO_FCOFF_HI_THRr, LONGAN_OFFf,                {0x510,          0xce0,          0x50e,          0x510, }},
        {LONGAN_FC_JUMBO_FCOFF_LO_THRr, LONGAN_ONf,                 {0x36c,          0xc68,          0x4a6,          0x36c, }},
        {LONGAN_FC_JUMBO_FCOFF_LO_THRr, LONGAN_OFFf,                {0x254,          0xc18,          0x472,          0x254, }},

        {LONGAN_FC_JUMBO_THR_ADJUSTr, LONGAN_SYS_USED_PAGE_THRf,    {0x540,          0xdc8,          0xa80,          0x540, }},

        {LONGAN_FC_LB_PORT_Q_EGR_DROP_THRr, LONGAN_ONf,             {0x4e,           0x4e,           0x4e ,          0x4e,  }},
        {LONGAN_FC_LB_PORT_Q_EGR_DROP_THRr, LONGAN_OFFf,            {0x44,           0x44,           0x44 ,          0x44,  }},

        {LONGAN_SC_P_CTRLr, LONGAN_DRAIN_OUT_THR_Hf,                {0xc8,           0x140,          0x32 ,          0xc8,  }},
        {LONGAN_SC_P_CTRLr, LONGAN_DRAIN_OUT_THRf,                  {0xc8,           0x140,          0x32 ,          0xc8,  }},

        /*non-stacking mode use default vlaue*/                     /*default               */
        {LONGAN_ETE_FC_CASCADE_PORT_DROP_THRr, LONGAN_ONf,          {0x507,          0x507,          0xfac,          0x507, }},
        {LONGAN_ETE_FC_CASCADE_PORT_DROP_THRr, LONGAN_OFFf,         {0x485,          0x485,          0xf90,          0x485, }}

};

static fcRegIdxActCtrl_t    regPortInfo[]= {
        /*register*/              /*field*/                         /*24G+4*10G*/ /*8*10G*/ /*48G cascade*/ /*24*2.5G+2*10G*/
        {0x0, {LONGAN_FC_PORT_HI_THRr, LONGAN_ONf,                  {0xab,        0x11b,        0x64,        0xab, }}},
        {0x0, {LONGAN_FC_PORT_HI_THRr, LONGAN_OFFf,                 {0xa1,        0x111,        0x5a,        0xa1, }}},
        {0x0, {LONGAN_FC_PORT_LO_THRr, LONGAN_ONf,                  {0x28,        0xa0,         0x19,        0x28, }}},
        {0x0, {LONGAN_FC_PORT_LO_THRr, LONGAN_OFFf,                 {0x1e,        0x78,         0x0f,        0x1e, }}},
        {0x0, {LONGAN_FC_PORT_FCOFF_HI_THRr, LONGAN_ONf,            {0xab,        0x11b,        0x64,        0xab, }}},
        {0x0, {LONGAN_FC_PORT_FCOFF_HI_THRr, LONGAN_OFFf,           {0xa1,        0x111,        0x5a,        0xa1, }}},
        {0x0, {LONGAN_FC_PORT_FCOFF_LO_THRr, LONGAN_ONf,            {0x28,        0xa0,         0x19,        0x28, }}},
        {0x0, {LONGAN_FC_PORT_FCOFF_LO_THRr, LONGAN_OFFf,           {0x1e,        0x78,         0x0f,        0x1e, }}},
        {0x0, {LONGAN_FC_PORT_GUAR_THRr, LONGAN_THRf,               {0x10,        0x10,         0xc,         0x10, }}},

        {0x1, {LONGAN_FC_PORT_HI_THRr, LONGAN_ONf,                  {0xab,        0x11b,        0x3ad,       0xab, }}},
        {0x1, {LONGAN_FC_PORT_HI_THRr, LONGAN_OFFf,                 {0xa1,        0x111,        0x35f,       0xa1, }}},
        {0x1, {LONGAN_FC_PORT_LO_THRr, LONGAN_ONf,                  {0x28,        0xa0,         0x32b,       0x28, }}},
        {0x1, {LONGAN_FC_PORT_LO_THRr, LONGAN_OFFf,                 {0x1e,        0x78,         0x2dd,       0x1e, }}},
        {0x1, {LONGAN_FC_PORT_FCOFF_HI_THRr, LONGAN_ONf,            {0xab,        0x11b,        0x3ad,       0xab, }}},
        {0x1, {LONGAN_FC_PORT_FCOFF_HI_THRr, LONGAN_OFFf,           {0xa1,        0x111,        0x35f,       0xa1, }}},
        {0x1, {LONGAN_FC_PORT_FCOFF_LO_THRr, LONGAN_ONf,            {0x28,        0xa0,         0x32b,       0x28, }}},
        {0x1, {LONGAN_FC_PORT_FCOFF_LO_THRr, LONGAN_OFFf,           {0x1e,        0x78,         0x2dd,       0x1e, }}},
        {0x1, {LONGAN_FC_PORT_GUAR_THRr, LONGAN_THRf,               {0x10,        0x10,         0xc,         0x10, }}},

        {0x2, {LONGAN_FC_PORT_HI_THRr, LONGAN_ONf,                  {0x2ac,       0x11b,        0x64,        0x2ac,}}},
        {0x2, {LONGAN_FC_PORT_HI_THRr, LONGAN_OFFf,                 {0x284,       0x111,        0x5a,        0x284,}}},
        {0x2, {LONGAN_FC_PORT_LO_THRr, LONGAN_ONf,                  {0xa0,        0xa0,         0x19,        0xa0, }}},
        {0x2, {LONGAN_FC_PORT_LO_THRr, LONGAN_OFFf,                 {0x78,        0x78,         0x0f,        0x78, }}},
        {0x2, {LONGAN_FC_PORT_FCOFF_HI_THRr, LONGAN_ONf,            {0x2ac,       0x11b,        0x64,        0x2ac,}}},
        {0x2, {LONGAN_FC_PORT_FCOFF_HI_THRr, LONGAN_OFFf,           {0x284,       0x111,        0x5a,        0x284,}}},
        {0x2, {LONGAN_FC_PORT_FCOFF_LO_THRr, LONGAN_ONf,            {0xa0,        0xa0,         0x19,        0xa0, }}},
        {0x2, {LONGAN_FC_PORT_FCOFF_LO_THRr, LONGAN_OFFf,           {0x78,        0x78,         0x0f,        0x78, }}},
        {0x2, {LONGAN_FC_PORT_GUAR_THRr, LONGAN_THRf,               {0x10,        0x10,         0xc,         0x10, }}},

        {0x3, {LONGAN_FC_PORT_HI_THRr, LONGAN_ONf,                  {0x5e,        0x17d,        0x64,        0x5e, }}},
        {0x3, {LONGAN_FC_PORT_HI_THRr, LONGAN_OFFf,                 {0x54,        0x173,        0x5a,        0x54, }}},
        {0x3, {LONGAN_FC_PORT_LO_THRr, LONGAN_ONf,                  {0x23,        0x23,         0x19,        0x23, }}},
        {0x3, {LONGAN_FC_PORT_LO_THRr, LONGAN_OFFf,                 {0x19,        0x19,         0x0f,        0x19, }}},
        {0x3, {LONGAN_FC_PORT_FCOFF_HI_THRr, LONGAN_ONf,            {0x5e,        0x17d,        0x64,        0x5e, }}},
        {0x3, {LONGAN_FC_PORT_FCOFF_HI_THRr, LONGAN_OFFf,           {0x54,        0x173,        0x5a,        0x54, }}},
        {0x3, {LONGAN_FC_PORT_FCOFF_LO_THRr, LONGAN_ONf,            {0x23,        0x23,         0x19,        0x23, }}},
        {0x3, {LONGAN_FC_PORT_FCOFF_LO_THRr, LONGAN_OFFf,           {0x19,        0x19,         0x0f,        0x19, }}},
        {0x3, {LONGAN_FC_PORT_GUAR_THRr, LONGAN_THRf,               {0x10,        0x10,         0xc,         0x10, }}},

        /*non-stacking mode use default vlaue*/                     /*default     */
        {0x0, {LONGAN_ETE_FC_ON_REMOTE_PORT_THRr, LONGAN_ONf,       {0x17,        0x17,         0x19,        0x17, }}},
        {0x0, {LONGAN_ETE_FC_ON_REMOTE_PORT_THRr, LONGAN_OFFf,      {0x0d,        0x0d,         0x0f,        0x0d, }}},
        {0x0, {LONGAN_ETE_FC_OFF_REMOTE_PORT_THRr, LONGAN_ONf,      {0x17,        0x17,         0x19,        0x17, }}},
        {0x0, {LONGAN_ETE_FC_OFF_REMOTE_PORT_THRr, LONGAN_OFFf,     {0x0d,        0x0d,         0x0f,        0x0d, }}},
        {0x0, {LONGAN_ETE_FC_REMOTE_PORT_GUAR_THRr, LONGAN_THRf,    {0x10,        0x10,         0x0c,        0x10, }}},

        {0x1, {LONGAN_ETE_FC_ON_REMOTE_PORT_THRr, LONGAN_ONf,       {0x17,        0x17,         0x19,        0x17, }}},
        {0x1, {LONGAN_ETE_FC_ON_REMOTE_PORT_THRr, LONGAN_OFFf,      {0x0d,        0x0d,         0x0f,        0x0d, }}},
        {0x1, {LONGAN_ETE_FC_OFF_REMOTE_PORT_THRr, LONGAN_ONf,      {0x17,        0x17,         0x19,        0x17, }}},
        {0x1, {LONGAN_ETE_FC_OFF_REMOTE_PORT_THRr, LONGAN_OFFf,     {0x0d,        0x0d,         0x0f,        0x0d, }}},
        {0x1, {LONGAN_ETE_FC_REMOTE_PORT_GUAR_THRr, LONGAN_THRf,    {0x10,        0x10,         0x0c,        0x10, }}}

};

static fcRegIdxActCtrl_t    regQueueInfo[] = {
        {0x0, {LONGAN_FC_Q_EGR_DROP_THRr, LONGAN_ONf,               {0x4e,        0x4e,         0x4e,        0x4e, }}},
        {0x0, {LONGAN_FC_Q_EGR_DROP_THRr, LONGAN_OFFf,              {0x44,        0x44,         0x44,        0x44, }}},

        {0x1, {LONGAN_FC_Q_EGR_DROP_THRr, LONGAN_ONf,               {0x4e,        0x118,        0x30c,       0x4e, }}},
        {0x1, {LONGAN_FC_Q_EGR_DROP_THRr, LONGAN_OFFf,              {0x44,        0x0f0,        0x2a8,       0x44, }}},

        {0x2, {LONGAN_FC_Q_EGR_DROP_THRr, LONGAN_ONf,               {0x118,       0x4e,         0x4e,        0x118,}}},
        {0x2, {LONGAN_FC_Q_EGR_DROP_THRr, LONGAN_OFFf,              {0x0f0,       0x44,         0x44,        0x0f0,}}},

        {0x3, {LONGAN_FC_Q_EGR_DROP_THRr, LONGAN_ONf,               {0x64,        0x64,         0x4e,        0x64, }}},
        {0x3, {LONGAN_FC_Q_EGR_DROP_THRr, LONGAN_OFFf,              {0x44,        0x44,         0x44,        0x44, }}},

        {0x0, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_RATEf,         {0x7f,        0x7f,         0x7f,        0x7f, }}},
        {0x0, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_MAXf,          {0x71,        0x71,         0x69,        0x71, }}},
        {0x0, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_MINf,          {0x67,        0x67,         0x5f,        0x67, }}},

        {0x1, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_RATEf,         {0x7f,        0x7f,         0x7f,        0x7f, }}},
        {0x1, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_MAXf,          {0x4e,        0x4e,         0x46,        0x4e, }}},
        {0x1, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_MINf,          {0x44,        0x44,         0x3c,        0x44, }}},

        {0x2, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_RATEf,         {0x7f,        0x7f,         0x7f,        0x7f, }}},
        {0x2, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_MAXf,          {0x2b,        0x2b,         0x23,        0x2b, }}},
        {0x2, {LONGAN_SWRED_QUEUE_DROP_CTRLr, LONGAN_MINf,          {0x21,        0x21,         0x19,        0x21, }}}
};

static fcRegActCtrl_t    regCpuQInfo[] = {
        {LONGAN_FC_CPU_Q_EGR_DROP_THRr, LONGAN_ONf,                 {0x4e,        0x4e,         0x4e,        0x4e, }},
        {LONGAN_FC_CPU_Q_EGR_DROP_THRr, LONGAN_OFFf,                {0x44,        0x44,         0x44,        0x44, }}
};

static int32
_dal_longan_flowctrl_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;
    uint32 port, queue;
    uint32  i;
    uint32  modelIdx;
    uint32  idx_1g, idx_10g, idx_cascade;
    uint32  idx_ete_fc_remote_1g, idx_ete_fc_remote_10g, idx_ete_fc_cascade;

    idx_ete_fc_remote_1g = 0;
    idx_ete_fc_remote_10g = 1;
    idx_ete_fc_cascade = 1;

    idx_cascade = 0;
    if (RTL9301_CHIP_ID == HWP_CHIP_ID(unit))
    {
        if (HWP_CASCADE_MODE())/*cascade master unit*/
        {
            modelIdx = FC_MODEL_IDX_48G_CASCADE;
            idx_1g = 0;
            idx_10g = 2;
            idx_cascade = 1;
        }
        else
        {
            modelIdx = FC_MODEL_IDX_24G_4XG;
            idx_1g = 0;
            idx_10g = 2;
        }
    }
    else if (RTL9303_CHIP_ID == HWP_CHIP_ID(unit))
    {
        modelIdx = FC_MODEL_IDX_8XG;
        idx_1g = 0;
        idx_10g = 1;
    }
    else if (RTL9302D_CHIP_ID == HWP_CHIP_ID(unit))
    {
        modelIdx = FC_MODEL_IDX_24x2_5G_2XG;
        idx_1g = 0;
        idx_10g = 2;
    }
    else
    {
        modelIdx = FC_MODEL_IDX_24x2_5G_2XG;
        idx_1g = 0;
        idx_10g = 2;
    }


    HWP_PORT_TRAVS_EXCEPT_CPU(unit, port)
    {
        if (HWP_CASCADE_PORT(unit, port))
        {
            if (HWP_SXGE_PORT(unit, port))
            {
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_PORT_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_cascade), ret);
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_PORT_EGR_DROP_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_cascade), ret);
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_ETE_FC_REMOTE_PORT_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_ete_fc_cascade), ret);
            }
        }
        else
        {
            if (HWP_GE_PORT(unit, port))
            {
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_PORT_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_1g), ret);
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_PORT_EGR_DROP_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_1g), ret);
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_ETE_FC_REMOTE_PORT_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_ete_fc_remote_1g), ret);
            }
            else if (HWP_10GE_PORT(unit, port))
            {
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_PORT_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_10g), ret);
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_PORT_EGR_DROP_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_10g), ret);
                RT_ERR_CHK(reg_array_field_write(unit, LONGAN_ETE_FC_REMOTE_PORT_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                                LONGAN_IDXf, &idx_ete_fc_remote_10g), ret);
            }
            else
            {
                ;
            }

        }
    }

    port = HWP_CPU_MACID(unit);
    value = 0;
    RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_PORT_EGR_DROP_CTRLr, port, REG_ARRAY_INDEX_NONE,
                    LONGAN_REF_RXCNGSTf, &value), ret);
    RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_PORT_THR_SET_SELr, port, REG_ARRAY_INDEX_NONE,
                    LONGAN_IDXf, &idx_1g), ret);

    /*config global register*/
    for (i = 0; i < sizeof(flowctrlGlobCfg)/sizeof(fcRegActCtrl_t); i++)
    {
        RT_ERR_CHK(reg_field_write(unit, flowctrlGlobCfg[i].reg, flowctrlGlobCfg[i].field, &(flowctrlGlobCfg[i].actValue[modelIdx])), ret);
    }

    /*config per port register*/
    HWP_PORT_TRAVS_EXCEPT_CPU(unit, port)
    {
        for (i = 0; i < sizeof(fcPerPortCfg)/sizeof(fcRegActCtrl_t); i++)
        {
            RT_ERR_CHK(reg_array_field_write(unit, fcPerPortCfg[i].reg, port, REG_ARRAY_INDEX_NONE,
                        fcPerPortCfg[i].field, &(fcPerPortCfg[i].actValue[modelIdx])), ret);
        }
    }

    /*config port group set*/
    for (i = 0; i < sizeof(regPortInfo)/sizeof(fcRegIdxActCtrl_t); i++)
    {
        RT_ERR_CHK(reg_array_field_write(unit, regPortInfo[i].regAct.reg, REG_ARRAY_INDEX_NONE, regPortInfo[i].idx,
                            regPortInfo[i].regAct.field, &(regPortInfo[i].regAct.actValue[modelIdx])), ret);

    }

    /*config queue group set*/
    for (queue = 0; queue < HAL_MAX_NUM_OF_STACK_QUEUE(unit); queue++)
    {
        for (i = 0; i < sizeof(regQueueInfo)/sizeof(fcRegIdxActCtrl_t); i++)
        {
            RT_ERR_CHK(reg_array_field_write(unit, regQueueInfo[i].regAct.reg, queue, regQueueInfo[i].idx,
                            regQueueInfo[i].regAct.field, &(regQueueInfo[i].regAct.actValue[modelIdx])), ret);
        }
    }

    /*config cpu port*/
    value = 1;
    for (queue = 0; queue < HAL_MAX_NUM_OF_CPU_QUEUE(unit); queue++)
    {
        for (i = 0; i < sizeof(regCpuQInfo)/sizeof(fcRegActCtrl_t); i++)
        {
            RT_ERR_CHK(reg_array_field_write(unit, regCpuQInfo[i].reg, REG_ARRAY_INDEX_NONE, queue,
                                regCpuQInfo[i].field, &(regCpuQInfo[i].actValue[modelIdx])), ret);
        }
        RT_ERR_CHK(reg_array_field_write(unit, LONGAN_FC_CPU_Q_EGR_FORCE_DROP_CTRLr, REG_ARRAY_INDEX_NONE, queue,
                            LONGAN_ENf, &value), ret);

    }

	value = 1;
	RT_ERR_CHK(reg_field_write(unit, LONGAN_FC_GLB_SYS_UTIL_THRr, LONGAN_THRf, &value), ret);
    return RT_ERR_OK;
}


static int32
_dal_longan_rate_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;
    uint32 port, queue;

    value=RTK_DEFAULT_EGR_BANDWIDTH_CPU_PORT_RATE_MODE==RATE_MODE_PKT ? 0 : 1;
    if ((ret = reg_field_write(unit, LONGAN_EGBW_CTRLr, LONGAN_RATE_MODE_CPUf, &value)) != RT_ERR_OK)
    {
        return ret;
    }

    port = HWP_CPU_MACID(unit);
    value = RTK_DEFAULT_EGR_BANDWIDTH_CPU_PORT_BURST;
    if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_CTRLr, port, REG_ARRAY_INDEX_NONE, LONGAN_BURSTf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
    for(queue=0; queue<HAL_MAX_NUM_OF_CPU_QUEUE(unit); queue++)
    {
        if ((ret = reg_array_field_write(unit, LONGAN_EGBW_CPU_Q_MAX_LB_CTRLr, REG_ARRAY_INDEX_NONE, queue, LONGAN_BURSTf, &value)) != RT_ERR_OK)
        {
            return ret;
        }
    }

	HWP_PORT_TRAVS_EXCEPT_CPU(unit, port)
	{
		value = RTK_DEFAULT_EGR_BANDWIDTH_PORT_BURST;
        RT_ERR_CHK(reg_array_field_write(unit, LONGAN_EGBW_PORT_CTRLr, port, REG_ARRAY_INDEX_NONE, LONGAN_BURSTf, &value), ret);

		if(port<24)
		{
			for(queue=0; queue<HAL_MAX_NUM_OF_QUEUE(unit); queue++)
			{
				value = RTK_DEFAULT_EGR_BANDWIDTH_PORT_BURST;
				if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_Q_MAX_LB_CTRL_SET0r, port, queue, LONGAN_BURSTf, &value)) != RT_ERR_OK)
				{
					return ret;
				}
				if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_Q_ASSURED_FIX_BURST_CTRL_SET0r, port, queue, LONGAN_BURSTf, &value)) != RT_ERR_OK)
				{
					return ret;
				}
				value = RTK_DEFAULT_EGR_BANDWIDTH_ASSURE_RATE;
				if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_Q_ASSURED_LB_CTRL_SET0r, port, queue, LONGAN_RATEf, &value)) != RT_ERR_OK)
				{
					return ret;
				}
				if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_Q_FIX_LB_CTRL_SET0r, port, queue, LONGAN_RATEf, &value)) != RT_ERR_OK)
				{
					return ret;
				}
			}
		}
		else if(port<28)
		{
			for(queue=0; queue<HAL_MAX_NUM_OF_STACK_QUEUE(unit); queue++)
			{
				value = RTK_DEFAULT_EGR_BANDWIDTH_PORT_BURST;
				if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_Q_MAX_LB_CTRL_SET1r, port, queue, LONGAN_BURSTf, &value)) != RT_ERR_OK)
				{
					return ret;
				}
				if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_Q_ASSURED_FIX_BURST_CTRL_SET1r, port, queue, LONGAN_BURSTf, &value)) != RT_ERR_OK)
				{
					return ret;
				}
				value = RTK_DEFAULT_EGR_BANDWIDTH_ASSURE_RATE;
				if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_Q_ASSURED_LB_CTRL_SET1r, port, queue, LONGAN_RATEf, &value)) != RT_ERR_OK)
				{
					return ret;
				}
				if ((ret = reg_array_field_write(unit, LONGAN_EGBW_PORT_Q_FIX_LB_CTRL_SET1r, port, queue, LONGAN_RATEf, &value)) != RT_ERR_OK)
				{
					return ret;
				}
			}
		}
	}
    return RT_ERR_OK;
}

static int32
_dal_longan_qos_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;
    uint32  port;
    uint32  queue = 0;

    port = HWP_CPU_MACID(unit);
    value = RTK_DEFAULT_QOS_SCHED_CPU_ALGORITHM==WRR ? 1 : 0;
    if ((ret = reg_array_field_write(unit, LONGAN_SCHED_PORT_ALGO_CTRLr, port, REG_ARRAY_INDEX_NONE, LONGAN_SCHED_TYPEf, &value)) != RT_ERR_OK)
    {
        return ret;
    }

    value = RTK_DEFAULT_QOS_PRI_DECISION_REMAP_EN==ENABLED ? 0x1: 0x0;
    if ((ret = reg_field_write(unit, LONGAN_PRI_SEL_CTRLr, LONGAN_PORT_PRI_REMAP_ENf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
    if ((ret = reg_field_write(unit, LONGAN_PRI_SEL_CTRLr, LONGAN_PROTO_VLAN_PRI_REMAP_ENf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
    if ((ret = reg_field_write(unit, LONGAN_PRI_SEL_CTRLr, LONGAN_MAC_IP_VLAN_PRI_REMAP_ENf, &value)) != RT_ERR_OK)
    {
        return ret;
    }

    /*SS-1347*/
    for (queue = 0; queue < HAL_MAX_NUM_OF_QUEUE(unit); queue++)
    {
        RT_ERR_CHK(reg_array_field_write(unit, LONGAN_QM_CPUQID2QID_CTRLr, REG_ARRAY_INDEX_NONE, queue, LONGAN_QIDf, &queue), ret);
    }

    for (queue = 0; queue < HAL_MAX_NUM_OF_STACK_QUEUE(unit); queue++)
    {
        RT_ERR_CHK(reg_array_field_write(unit, LONGAN_QM_CPUQID2XGQID_CTRLr, REG_ARRAY_INDEX_NONE, queue, LONGAN_QIDf, &queue), ret);
    }

    return RT_ERR_OK;
}
/* acl default config */
static int32
_dal_longan_acl_init_config(uint32 unit)
{
    int32 ret;
    rtk_port_t port;
	uint32 value;

	value = RTK_DEFAULT_ACL_LOOKUP_EN == ENABLED ? 1 : 0;
    HWP_PORT_TRAVS(unit, port)
    {
        RT_ERR_CHK(reg_array_field_write(unit, LONGAN_ACL_PORT_LOOKUP_CTRLr, port, REG_ARRAY_INDEX_NONE, LONGAN_LOOKUP_ENf, &value), ret);
    }

    return RT_ERR_OK;
}


/* trunk default config */
static int32
_dal_longan_trunk_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;

    value = RTK_DEFAULT_TRUNK_LINK_DOWN_AVOID_EN==ENABLED ? 1 : 0;
    if ((ret = reg_field_write(unit, LONGAN_TRK_CTRLr, LONGAN_LINK_DOWN_AVOIDf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
	value = RTK_DEFAULT_TRUNK_LOCAL_FIRST_EN==ENABLED ? 1 : 0;
	if ((ret = reg_field_write(unit, LONGAN_TRK_CTRLr, LONGAN_LOCAL_FIRSTf, &value)) != RT_ERR_OK)
	{
		return ret;
	}
	value = RTK_DEFAULT_TRUNK_DISTRIBUTION_L3_ALGORITHM;
	if ((ret = reg_field_write(unit, LONGAN_TRK_HASH_CTRLr, LONGAN_L3_HASH_MSKf, &value)) != RT_ERR_OK)
	{
		return ret;
	}

	return RT_ERR_OK;
}

/* vlan default config */
static int32
_dal_longan_vlan_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;
	uint32  port;

    value = RTK_DEFAULT_STP_LEAK_EN==ENABLED ? 1 : 0;
    if ((ret = reg_field_write(unit, LONGAN_VLAN_CTRLr, LONGAN_STP_LEAK_ENf, &value)) != RT_ERR_OK)
    {
        return ret;
    }

	port = HWP_CPU_MACID(unit);
	value = RTK_DEFAULT_VLAN_CPU_PORT_IGR_FILTER==ENABLED ? 1 : 0;
    if ((ret = reg_array_field_write(unit, LONGAN_VLAN_PORT_IGR_FLTRr, port,  REG_ARRAY_INDEX_NONE, LONGAN_IGR_FLTR_ACTf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
	value = RTK_DEFAULT_VLAN_CPU_PORT_PVID_FMT==PBVLAN_MODE_UNTAG_AND_PRITAG ? 0x0 : 0x2;
    if ((ret = reg_array_field_write(unit, LONGAN_VLAN_PORT_PB_VLANr, port,  REG_ARRAY_INDEX_NONE, LONGAN_OPVID_FMTf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
    if ((ret = reg_array_field_write(unit, LONGAN_VLAN_PORT_PB_VLANr, port,  REG_ARRAY_INDEX_NONE, LONGAN_IPVID_FMTf, &value)) != RT_ERR_OK)
    {
        return ret;
    }

    /*SSUT-645*/
    HWP_PORT_TRAVS_EXCEPT_CPU(unit, port)
    {
        value = 0x0;
        if ((ret = reg_array_field_write(unit, LONGAN_VLAN_PORT_PB_VLANr, port,  REG_ARRAY_INDEX_NONE, LONGAN_OPVID_FMTf, &value)) != RT_ERR_OK)
        {
            return ret;
        }
        if ((ret = reg_array_field_write(unit, LONGAN_VLAN_PORT_PB_VLANr, port,  REG_ARRAY_INDEX_NONE, LONGAN_IPVID_FMTf, &value)) != RT_ERR_OK)
        {
            return ret;
        }
    }


	return RT_ERR_OK;
}

/* l2 default config */
static int32
_dal_longan_l2_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;
    uint32  port;
	uint32  trunk;


    value = RTK_DEFAULT_L2_FLUSH_LINKDOWN_MAC == ENABLED ? 1 : 0;
    if ((ret = reg_field_write(unit, LONGAN_L2_CTRLr,LONGAN_LINK_DOWN_P_INVLDf, &value)) != RT_ERR_OK)
    {
        return ret;
    }

    value = RTK_DEFAULT_L2_STTC_PM_LRN_EN==ENABLED ? 0x1 : 0x0;
    if ((ret = reg_field_write(unit, LONGAN_L2_GLB_STT_PORT_MV_LRNr, LONGAN_LRNf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
    HWP_PORT_TRAVS(unit, port)
    {
        RT_ERR_CHK(reg_array_field_write(unit, LONGAN_L2_STT_PORT_MV_LRNr, port, REG_ARRAY_INDEX_NONE, LONGAN_LRNf, &value), ret);
    }
	for(trunk=0; trunk<HAL_MAX_NUM_OF_TRUNK(unit); trunk++)
	{
		RT_ERR_CHK(reg_array_field_write(unit, LONGAN_L2_STT_TRK_MV_LRNr, REG_ARRAY_INDEX_NONE, trunk, LONGAN_LRNf, &value), ret);
	}


	value = RTK_DEFAULT_L2_NTFY_LD_FLUSH_EN==ENABLED ? 0x1 : 0x0;
    if ((ret = reg_field_write(unit, LONGAN_L2_NTFY_CTRLr, LONGAN_LD_FLUSH_NTFY_ENf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
	value = RTK_DEFAULT_L2_NTFY_DYN_EN==ENABLED ? 0x1 : 0x0;
    if ((ret = reg_field_write(unit, LONGAN_L2_NTFY_CTRLr, LONGAN_DYN_NTFY_ENf, &value)) != RT_ERR_OK)
    {
        return ret;
    }

    port = HWP_CPU_MACID(unit);
	value = RTK_DEFAULT_L2_DA_BLOCK_CPU_PORT_STATE == ENABLED ? 1 : 0;
    if ((ret = reg_array_field_write(unit, LONGAN_L2_PORT_DABLK_CTRLr, port,  REG_ARRAY_INDEX_NONE, LONGAN_ENf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
	value = RTK_DEFAULT_L2_SA_BLOCK_CPU_PORT_STATE == ENABLED ? 1 : 0;
    if ((ret = reg_array_field_write(unit, LONGAN_L2_PORT_SABLK_CTRLr, port,  REG_ARRAY_INDEX_NONE, LONGAN_ENf, &value)) != RT_ERR_OK)
    {
        return ret;
    }

    return RT_ERR_OK;
}


/* l3 default config */
static int32
_dal_longan_l3_init_config(uint32 unit)
{
    int32 ret;
    int32 i;

    regActCtrl_t    regInfo[] = {
        /*set ipuc except action is bridge*/
        {LONGAN_L3_IP6UC_ROUTE_CTRLr, 	LONGAN_DMAC_MISMATCH_ACTf,     0x0},
        {LONGAN_L3_IP_ROUTE_CTRLr, 		LONGAN_IP_HDR_ERR_ACTf,        0x3},
        {LONGAN_L3_IP_ROUTE_CTRLr, 		LONGAN_IP6_HDR_ERR_ACTf,       0x3}
    };

    for (i = 0; i < sizeof(regInfo)/sizeof(regActCtrl_t); i++)
    {
        RT_ERR_CHK(reg_field_write(unit, regInfo[i].reg, regInfo[i].field, &regInfo[i].actValue), ret);
    }

	return RT_ERR_OK;
}


/* parser default config */
static int32
_dal_longan_parser_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;

	value = RTK_DEFAULT_PARSER_PPPOE_EN==ENABLED ? 1 : 0;
	if ((ret = reg_field_write(unit, LONGAN_PARSER_CTRLr, LONGAN_PPPOE_PARSE_ENf, &value)) != RT_ERR_OK)
	{
		return ret;
	}

	return RT_ERR_OK;
}

/* misc default config */
static int32
_dal_longan_misc_init_config(uint32 unit)
{
    int32   ret;
    uint32  value;

	value = RTK_DEFAULT_MISC_CHIP_RST_EN==ENABLED ? 1 : 0;
	if ((ret = reg_field_write(unit, LONGAN_RST_GLB_CTRL_0r, LONGAN_CHIP_RST_ENf, &value)) != RT_ERR_OK)
	{
		return ret;
	}
	value = RTK_DEFAULT_MISC_WD_RST_EN==ENABLED ? 1 : 0;
	if ((ret = reg_field_write(unit, LONGAN_RST_GLB_CTRL_0r, LONGAN_WD_RST_ENf, &value)) != RT_ERR_OK)
	{
		return ret;
	}
#ifndef __BOOTLOADER__
    value = 0xf;
    if ((ret = reg_field_write(unit, LONGAN_MAC_DMY_RESULTr, LONGAN_MAC_STK_FILTERf, &value)) != RT_ERR_OK)
    {
        return ret;
    }
#endif

    return RT_ERR_OK;
}

/* Function Name:
 *      _dal_longan_port_smiPollSel_set
 * Description:
 *      configure SMI Poll Select
 * Input:
 *      unit          - unit id
 *      port          - port id
 *      value         - POLL_SEL register value
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK
 *      RT_ERR_FAILED
 * Note:
 *      None
 */
int32
_dal_longan_port_smiPollSel_set(uint32 unit, uint32 smi_id, uint32 poll_sel)
{
    uint32      field;

    switch (smi_id)
    {
      case 0:
        field = LONGAN_SMI0_POLL_SELf;
        break;
      case 1:
        field = LONGAN_SMI1_POLL_SELf;
        break;
      case 2:
        field = LONGAN_SMI2_POLL_SELf;
        break;
      case 3:
        field = LONGAN_SMI3_POLL_SELf;
        break;
      default:
        RT_LOG(LOG_DEBUG, (MOD_HAL), "unit %u smi_id %u wrong", unit, smi_id);
        return RT_ERR_INPUT;
    }
    return reg_field_write(unit, LONGAN_SMI_GLB_CTRLr, field, &poll_sel);
}

/* Function Name:
 *      dal_longan_construct_default_init
 * Description:
 *      Init chip default value
 * Input:
 *      unit - which unit
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void dal_longan_construct_default_init(uint32 unit)
{
    /* smi default config */
    _dal_longan_smi_defalut_init_config(unit);

    /* port default config */
    _dal_longan_port_defalut_init_config(unit);

    /* Rate default config */
    _dal_longan_rate_init_config(unit);

    /* QoS default config */
    _dal_longan_qos_init_config(unit);

    /* FlowCtrl default config */
    _dal_longan_flowctrl_init_config(unit);

    /* ipmcast default config */
    _dal_longan_ipmcast_init_config(unit);
    /* Acl default config */
    _dal_longan_acl_init_config(unit);

    /* Trunk default config */
    _dal_longan_trunk_init_config(unit);

    /* VLAN default config */
    _dal_longan_vlan_init_config(unit);

    /* l2 default config */
    _dal_longan_l2_init_config(unit);

    /* l3 default config */
    _dal_longan_l3_init_config(unit);

    /* parser default config */
    _dal_longan_parser_init_config(unit);

    /* misc default config */
    _dal_longan_misc_init_config(unit);

    return;
}






/* Function Name:
 *      dal_longan_construct_phy_reset
 * Description:aaa
 *      Reset PHY.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void dal_longan_construct_phy_reset(uint32 unit)
{
    CNSTRT_PRINT("%s()\n",__FUNCTION__);

    phy_construct_reset(unit);

    return;
} /* end of dal_longan_construct_phy_reset */

void dal_longan_construct_macConfig_init(uint32 unit )
{
    uint32 sds;
    HWP_SDS_TRAVS(unit, sds)
    {
        if (SERDES_POLARITY_CHANGE == HWP_SDS_RX_POLARITY(unit, sds))
        {
            // 10gr_rx_inv
            SDS_FIELD_W(unit, sds, 0x6, 0x2, 13, 13, 1);

            // else_rx_inv
            SDS_FIELD_W(unit, sds, 0x0, 0x0, 9, 9, 1);
        }
        else
        {
            // 10gr_rx_default
            SDS_FIELD_W(unit, sds, 0x6, 0x2, 13, 13, 0);

            // else_rx_default
            SDS_FIELD_W(unit, sds, 0x0, 0x0, 9, 9, 0);
        }

        if (SERDES_POLARITY_CHANGE == HWP_SDS_TX_POLARITY(unit, sds))
        {
            // 10gr_tx_inv
            SDS_FIELD_W(unit, sds, 0x6, 0x2, 14, 14, 1);

            // else_tx_inv
            SDS_FIELD_W(unit, sds, 0x0, 0x0, 8, 8, 1);
        }
        else
        {
            // 10gr_tx_default
            SDS_FIELD_W(unit, sds, 0x6, 0x2, 14, 14, 0);

            // else_tx_default
            SDS_FIELD_W(unit, sds, 0x0, 0x0, 8, 8, 0);
        }
    }
    return;
}/* end of dal_longan_construct_macConfig_init */

void dal_longan_construct_pollingPhy_enable(uint32 unit)
{

    uint32 val;
    rtk_portmask_t      portmask;
    uint32              port;

    RTK_PORTMASK_RESET(portmask);
    HWP_PORT_TRAVS(unit, port)
    {
        if (HWP_ETHER_PORT(unit, port))
        {
            RTK_PORTMASK_PORT_SET(portmask, port);
        }
    }

    val = RTK_PORTMASK_WORD_GET(portmask, 0);
    reg_field_write(unit, LONGAN_SMI_POLL_CTRLr, LONGAN_SMI_POLL_MASK_27_0f, &val);

}

void dal_longan_construct_pollingPhy_disable(uint32 unit)
{

    uint32 val;
    rtk_portmask_t      portmask;
    uint32              port;

    RTK_PORTMASK_RESET(portmask);
    HWP_PORT_TRAVS(unit, port)
    {
        if (HWP_ETHER_PORT(unit, port))
        {
            RTK_PORTMASK_PORT_CLEAR(portmask, port);
        }
    }

    val = RTK_PORTMASK_WORD_GET(portmask, 0);
    reg_field_write(unit, LONGAN_SMI_POLL_CTRLr, LONGAN_SMI_POLL_MASK_27_0f, &val);

    osal_time_mdelay(3);

}

/* Function Name:
 *      dal_longan_construct_macpollingphy_init
 * Description:
 *      MAC Polling PHY config initialization
 * Input:
 *      unit                - unit id
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void dal_longan_construct_MacPollingPhy_init(uint32 unit)
{
    uint32      port, poll_sel, data;
    int32       ret;
    uint32      config_10gPhyPollingReg = FALSE;
    rtk_portmask_t prv_poll_pm;
    rt_phyInfo_t    phyInfo;
    uint32      addr_reg0_bit = 0, addr_reg0_dev = 0, addr_reg0_addr = 0;
    uint32      addr_reg9_bit = 0, addr_reg9_dev = 0, addr_reg9_addr = 0;
    uint32      addr_reg10_bit = 0, addr_reg10_dev = 0, addr_reg10_addr = 0;

    if (HWP_UNIT_VALID_LOCAL(unit))
    {
        RTK_PORTMASK_RESET(prv_poll_pm);

        HWP_PORT_TRAVS_EXCEPT_CPU(unit, port)
        {
            /* configure smi private polling */
            switch (HWP_PHY_MODEL_BY_PORT(unit, port))
            {
              case RTK_PHYTYPE_RTL8214C:
              case RTK_PHYTYPE_RTL8212B:
              case RTK_PHYTYPE_RTL8214B:
              case RTK_PHYTYPE_RTL8214FB:
              case RTK_PHYTYPE_RTL8218B:
              case RTK_PHYTYPE_RTL8218FB:
              case RTK_PHYTYPE_RTL8214FC:
              case RTK_PHYTYPE_RTL8218D:
              case RTK_PHYTYPE_RTL8226:
              case RTK_PHYTYPE_RTL8226B:
              case RTK_PHYTYPE_RTL8261:
              case RTK_PHYTYPE_RTL8264:
              case RTK_PHYTYPE_RTL8261I:
              case RTK_PHYTYPE_RTL8264I:
              case RTK_PHYTYPE_RTL8251:
              case RTK_PHYTYPE_RTL8254:
              case RTK_PHYTYPE_RTL8251I:
              case RTK_PHYTYPE_RTL8254I:
              case RTK_PHYTYPE_RTL8251L:
              case RTK_PHYTYPE_RTL8254L:
              case RTK_PHYTYPE_RTL8224:
              case RTK_PHYTYPE_RTL8261B:
              case RTK_PHYTYPE_RTL8264B:
                RTK_PORTMASK_PORT_SET(prv_poll_pm, port);
                break;
              default:
                break;
            }

            data = RTK_PORTMASK_WORD_GET(prv_poll_pm, 0);
            if ((ret = reg_field_write(unit, LONGAN_SMI_PRVTE_POLLING_CTRLr, LONGAN_SMI_PRVTE_POLLING27_0f, &data)) != RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_DAL|MOD_PORT), "");
            }

            /* configure mac type */
            switch (HWP_PHY_MODEL_BY_PORT(unit, port))
            {
                case RTK_PHYTYPE_RTL8295R_C22:
                    /* configure to polling SerDes */
                    dal_longan_port_smiMacType_set(unit, port, 0x0); /* 0:10G/1G Fiber; 1:10G/2.5G PHY */
                    break;
                case RTK_PHYTYPE_RTL8224QF:
                    /* configure to polling SerDes */
                    dal_longan_port_smiMacType_set(unit, port, 0x0); /* 0:10G/1G Fiber; 1:10G/2.5G PHY */
                    break;
                default:
                    break;
            }


            if (port != HWP_PHY_BASE_MACID(unit, port))
            {
                continue;
            }
            /* configure poll_sel */
            switch (HWP_PHY_MODEL_BY_PORT(unit, port))
            {
                case RTK_PHYTYPE_RTL8226:
                case RTK_PHYTYPE_RTL8226B:
                case RTK_PHYTYPE_RTL8224:
                case RTK_PHYTYPE_CUST1 ... RTK_PHYTYPE_CUST5:
                    phy_info_get(unit, port, &phyInfo);
                    if (phyInfo.flags & RTK_PHYINFO_FLAG_NO_RES_REG)
                    {
                        poll_sel = 0;/* STD */
                    }
                    else
                    {
                        poll_sel = 1;/* resolution reg */
                    }

                    if ((phyInfo.flags & RTK_PHYINFO_FLAG_1G_MMD_CFG) != 0)
                    {
                        config_10gPhyPollingReg = TRUE;

                        addr_reg0_bit       = phyInfo.xGePhyLocalDuplexAbilityBit;
                        addr_reg0_dev       = phyInfo.xGePhyLocalDuplexAbilityDev;
                        addr_reg0_addr      = phyInfo.xGePhyLocalDuplexAbilityAddr;

                        addr_reg9_bit       = phyInfo.xGePhyLocal1000MSpeedAbilityBit;
                        addr_reg9_dev       = phyInfo.xGePhyLocal1000MSpeedAbilityDev;
                        addr_reg9_addr      = phyInfo.xGePhyLocal1000MSpeedAbilityAddr;

                        addr_reg10_bit      = phyInfo.xGePhyLinkPartner1000MSpeedAbilityBit;
                        addr_reg10_dev      = phyInfo.xGePhyLinkPartner1000MSpeedAbilityDev;
                        addr_reg10_addr     = phyInfo.xGePhyLinkPartner1000MSpeedAbilityAddr;
                    }
                    break;
                case RTK_PHYTYPE_RTL8295R:
                case RTK_PHYTYPE_RTL8261:
                case RTK_PHYTYPE_RTL8264:
                case RTK_PHYTYPE_RTL8261I:
                case RTK_PHYTYPE_RTL8264I:
                case RTK_PHYTYPE_RTL8251:
                case RTK_PHYTYPE_RTL8254:
                case RTK_PHYTYPE_RTL8251I:
                case RTK_PHYTYPE_RTL8254I:
                case RTK_PHYTYPE_RTL8251L:
                case RTK_PHYTYPE_RTL8254L:
                case RTK_PHYTYPE_RTL8261B:
                case RTK_PHYTYPE_RTL8264B:
                    poll_sel = 1;   /* resolution reg */
                    break;
                default:
                    continue;
            }
            if ((ret = _dal_longan_port_smiPollSel_set(unit, HWP_PORT_SMI(unit, port), poll_sel)) != RT_ERR_OK)
            {
                RT_ERR(ret, (MOD_DAL|MOD_PORT), "unit %u macId %u SMI%u pollSel:%u", unit, port, HWP_PORT_SMI(unit, port), poll_sel);
            }
        }

        if (config_10gPhyPollingReg == TRUE)
        {
            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG0_CFGr,LONGAN_REG0_BIT_2P5G_10GPHYf, &addr_reg0_bit);
            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG0_CFGr,LONGAN_REG0_DEV_2P5G_10GPHYf, &addr_reg0_dev);
            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG0_CFGr,LONGAN_REG0_REG_2P5G_10GPHYf, &addr_reg0_addr);

            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG9_CFGr,LONGAN_REG9_BIT_2P5G_10GPHYf, &addr_reg9_bit);
            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG9_CFGr,LONGAN_REG9_DEV_2P5G_10GPHYf, &addr_reg9_dev);
            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG9_CFGr,LONGAN_REG9_REG_2P5G_10GPHYf, &addr_reg9_addr);

            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG10_CFGr,LONGAN_REG10_BIT_2P5G_10GPHYf, &addr_reg10_bit);
            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG10_CFGr,LONGAN_REG10_DEV_2P5G_10GPHYf, &addr_reg10_dev);
            reg_field_write(unit, LONGAN_SMI_10GPHY_POLLING_REG10_CFGr,LONGAN_REG10_REG_2P5G_10GPHYf, &addr_reg10_addr);

        }
    }
}

/* Function Name:
 *      dal_longan_construct_serdes_off
 * Description:
 *      turn off all serdes
 * Input:
 *      unit
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void dal_longan_construct_serdes_off(uint32 unit)
{
    uint32  sdsId;
    uint32  value;
    uint32  reg;
    uint32  field;

    HWP_LONGAN_SDS_TRAVS(unit, sdsId)
    {
        if(sdsId >= sizeof(sds_mode_sel)/sizeof(reg_field_t))
            continue;

        /* serdes off before write serdes patch */
        reg = sds_mode_sel[sdsId].reg;
        field = sds_mode_sel[sdsId].field;
        value = 0x1f;
        reg_field_write(unit, reg, field, &value);

    }
}


void dal_longan_construct_serdesRxauiplus_initial(uint32 unit,uint32 sdsId)
{
    uint32 baseSdsId;

    baseSdsId = HWP_MULTI_SDS_BASESDS(unit, sdsId);

    if(sdsId != baseSdsId)
        return;

    /*REG0_CDR_RESET_SEL = 1*/
    SDS_FIELD_W(unit, baseSdsId, 0x2d, 5, 1, 1, 1);
    SDS_FIELD_W(unit, baseSdsId + 1, 0x2d, 5, 1, 1, 1);

    /*REG_RG_TIME0_CK<2:0> = 7*/
    SDS_FIELD_W(unit, baseSdsId + 1, 0x2d, 21, 2, 0, 7);
    /*REG_RG_TIME_RDY_CKOUT<1:0> = 3*/
    SDS_FIELD_W(unit, baseSdsId + 1, 0x2d, 21, 6, 5, 3);

    /* ber-notify form ori sel = 1*/
    SDS_FIELD_W(unit, baseSdsId, 0xa, 2, 15, 15, 0);
    SDS_FIELD_W(unit, baseSdsId + 1, 0xa, 2, 15, 15, 0);

    /* clk inverse = 1*/
    SDS_FIELD_W(unit, baseSdsId, 0xa, 13, 9, 9, 1);
    /* clk duty =*/
    SDS_FIELD_W(unit, baseSdsId, 0x2d, 16, 3, 3, 1);
    SDS_FIELD_W(unit, baseSdsId + 1, 0x2d, 16, 3, 3, 1);

}

void dal_longan_construct_serdesRxauiplus_on(uint32 unit,uint32 sdsId)
{
    uint32 value;
    uint32 baseSdsId;

    baseSdsId = HWP_MULTI_SDS_BASESDS(unit, sdsId);

    if(sdsId != baseSdsId)
        return;

    /* force LC & ring disable*/
    SDS_FIELD_W(unit, baseSdsId, 0x20, 18, 7, 4, 15);
    SDS_FIELD_W(unit, baseSdsId, 0x20, 18, 3, 2, 1);
    SDS_FIELD_W(unit, baseSdsId, 0x20, 18, 1, 0, 1);
    /* FSM is under reset*/
    SDS_FIELD_W(unit, baseSdsId, 0x6, 2, 12, 12, 1);
    osal_time_mdelay(10);

    /*CMU clk is 2GHz*/
    SDS_FIELD_W(unit, baseSdsId + 1, 0x2d, 14, 14, 7, 14);
    /* force PDOWN = 1 & RX_EN = 0 & V2ANALOG = 0*/
    SDS_FIELD_W(unit, baseSdsId, 0x20, 0, 7, 0, 0xd1);
    osal_time_mdelay(10);

    /*serdes on*/
    value = 0x19;
    reg_field_write(unit, sds_mode_sel[baseSdsId].reg, sds_mode_sel[baseSdsId].field, &value);
    reg_field_write(unit, sds_mode_sel[baseSdsId + 1].reg, sds_mode_sel[baseSdsId + 1].field, &value);
    osal_time_mdelay(100);

    /*release LC & ring*/
    SDS_FIELD_W(unit, baseSdsId, 0x20, 18, 3, 2, 0);
    osal_time_mdelay(100);

    SDS_FIELD_W(unit, baseSdsId, 0x20, 18, 7, 4, 5);
    osal_time_mdelay(100);

    SDS_FIELD_W(unit, baseSdsId, 0x6, 2, 12, 12, 0);
    osal_time_mdelay(100);

    SDS_FIELD_W(unit, baseSdsId + 1, 0x2d, 14, 14, 7, 0x1e);
    osal_time_mdelay(100);

    SDS_FIELD_W(unit, baseSdsId, 0x20, 0, 7, 0, 0x11);
    osal_time_mdelay(100);

    SDS_FIELD_W(unit, baseSdsId, 0x20, 0, 7, 0, 0x10);
    osal_time_mdelay(100);

    SDS_FIELD_W(unit, baseSdsId, 0x20, 0, 7, 0, 0x0);

    if(HWP_CASCADE_SLAVE_UNIT_ID() == unit)
    {
        osal_time_mdelay(200);
        SDS_FIELD_W(HWP_MY_UNIT_ID(), baseSdsId, 0x2c, 0x15, 4, 4,1);
        osal_time_mdelay(10);
        SDS_FIELD_W(HWP_MY_UNIT_ID(), baseSdsId, 0x2c, 0x15, 4, 4,0);
        osal_time_mdelay(100);

        SDS_FIELD_W(unit, baseSdsId, 0x2c, 0x15, 4, 4,1);
        osal_time_mdelay(10);
        SDS_FIELD_W(unit, baseSdsId, 0x2c, 0x15, 4, 4,0);
        osal_time_mdelay(100);
    }
}

/* Function Name:
 *      dal_longan_construct_serdes_on
 * Description:
 *      turn on all serdes
 * Input:
 *      unit
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void dal_longan_construct_serdes_on(uint32 unit)
{
    uint32  sdsId;
    uint32  value;
    uint32 reg;
    uint32 field;


    HWP_LONGAN_SDS_TRAVS(unit, sdsId)
    {
        if(RTK_MII_RXAUI_PLUS == HWP_SDS_MODE(unit, sdsId))
        {
            dal_longan_construct_serdesRxauiplus_initial(unit, sdsId);
        }
    }

    HWP_LONGAN_SDS_TRAVS(unit, sdsId)
    {
        if(sdsId >= sizeof(sds_mode_sel)/sizeof(reg_field_t))
            continue;

        reg = sds_mode_sel[sdsId].reg;
        field = sds_mode_sel[sdsId].field;

        switch (HWP_SDS_MODE(unit, sdsId))
        {
            case RTK_MII_SGMII:
                /* serdes mode SGMII */
                _dal_longan_sds_10gSdsMode_force(unit, sdsId, RTK_MII_SGMII);
                break;

            case RTK_MII_1000BX_FIBER:
            case RTK_MII_100BX_FIBER:
                /* serdes mode FIBER1G */
                _dal_longan_sds_10gSdsMode_force(unit, sdsId, RTK_MII_1000BX_FIBER);
                break;

            case RTK_MII_HISGMII:
                /* serdes mode HISGMII */
                _dal_longan_sds_10gSdsMode_force(unit, sdsId, RTK_MII_HISGMII);
                break;

            case RTK_MII_QSGMII:
                /* serdes mode QSGMII */
                value = 0x6;
                reg_field_write(unit, reg, field, &value);
                break;

            case RTK_MII_RSGMII:
                /* serdes mode RSGMII or XSMII */
                value = 0x9;
                reg_field_write(unit, reg, field, &value);
                break;

            case RTK_MII_USXGMII_10GQXGMII:
                /* serdes mode USXGMIIQX */
                value = 0x0D;
                reg_field_write(unit, reg, field, &value);

                reg = sds_sub_mode_sel[sdsId].reg;
                field = sds_sub_mode_sel[sdsId].field;
                if(LONGAN_REG_LIST_END == reg)
                {
                    CNSTRT_PRINT("%s,%d:serdes media not found\n", __FUNCTION__, __LINE__);
                    break;
                }
                value = 0x02;
                reg_field_write(unit, reg, field, &value);
                break;

            case RTK_MII_USXGMII_10GSXGMII:
                /* serdes mode USXGMIIQX */
                value = 0x0D;
                reg_field_write(unit, reg, field, &value);

                reg = sds_sub_mode_sel[sdsId].reg;
                field = sds_sub_mode_sel[sdsId].field;
                if(LONGAN_REG_LIST_END == reg)
                {
                    CNSTRT_PRINT("%s,%d:serdes media not found\n", __FUNCTION__, __LINE__);
                    break;
                }
                value = 0x0;
                reg_field_write(unit, reg, field, &value);
                break;

           case RTK_MII_XSGMII:
                /* serdes mode XSGMII */
                value = 0x10;
                reg_field_write(unit, reg, field, &value);
                break;

            case RTK_MII_2500Base_X:
                /* serdes mode 2500BaseX */
                _dal_longan_sds_10gSdsMode_force(unit, sdsId, RTK_MII_2500Base_X);
                break;

            case RTK_MII_RXAUI_LITE:
                /* serdes mode RXAUI Lite */
                value = 0x17;
                reg_field_write(unit, reg, field, &value);
                break;

            case RTK_MII_RXAUI_PLUS:
                /* serdes mode RXAUI+ */
                dal_longan_construct_serdesRxauiplus_on(unit, sdsId);
                break;

            case RTK_MII_10GR:
                _dal_longan_sds_10gSdsMode_force(unit, sdsId, RTK_MII_10GR);
                break;

            case RTK_MII_10GR1000BX_AUTO:
                /* serdes mode 10R1000BX Auto */
                value = 0x1b;
                reg_field_write(unit, reg, field, &value);
                break;

            case RTK_MII_DISABLE:
                break;
            default:
                CNSTRT_PRINT("%s,%d:serdes media not found\n", __FUNCTION__, __LINE__);
                break;
        }
    }
}
/* Function Name:
 *      dal_longan_construct_mac_default_10gmedia_fiber
 * Description:
 *      set 10Gr serdes port default fiber
 * Input:
 *      unit
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void dal_longan_construct_mac_default_10gmedia_fiber(uint32 unit)
{
    uint32  port = 0;
    uint32  data;
    int32   ret = RT_ERR_OK;

    HWP_PORT_TRAVS(unit, port)
    {
        if(HWP_10GE_PORT(unit,port))
        {
            ret = hal_serdes_reg_get(unit,  HWP_PORT_SDSID(unit, port), 0x1f, 11, &data);
            if(RT_ERR_OK != ret)
            {
                return;
            }

            data = REG32_FIELD_SET(data, 1, 1, (0x1 << 1));

            ret = hal_serdes_reg_set(unit,  HWP_PORT_SDSID(unit, port), 0x1f ,11 , data);
            if(RT_ERR_OK != ret)
            {
                return;
            }
        }

    }
}
/* Function Name:
 *      dal_longan_construct_phyConfig_init
 * Description:
 *      PHY Configuration code that connect with RTL9300
 * Input:
 *      pModel - pointer to switch model of platform
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void dal_longan_construct_phyConfig_init(uint32 unit)
{
    CNSTRT_PRINT("%s()\n",__FUNCTION__);

    phy_construct_config_init(unit);

    _dal_longan_construct_phy_powerOnOff(unit);

    return;
} /* end of dal_longan_construct_phyConfig_init */

void dal_longan_construc_serdesConfig_cust(uint32 unit)
{
    sds_conf_t  *p_rtl9300_sds_cust_conf = NULL;
    sds_conf_t  **pp_sds_conf;
    uint32      sdsId;


    /* Search if there is customer's serdes config for current board  */
    for (pp_sds_conf = conf_rtl9300_cust_board_list; *pp_sds_conf != NULL; pp_sds_conf++)
    {
        if ((*pp_sds_conf)->hwp_id == HWP_IDENTIFIER_ID())
        {
            p_rtl9300_sds_cust_conf = *pp_sds_conf;
            break;
        }
    }

    if (p_rtl9300_sds_cust_conf == NULL)
    {
        return;
    }

    if (p_rtl9300_sds_cust_conf->sds_conf_per_unit[unit] == NULL)
    {
        return;
    }

    HWP_LONGAN_SDS_TRAVS(unit, sdsId)
    {
        if (p_rtl9300_sds_cust_conf->sds_conf_per_unit[unit]->sds_cfg[sdsId] == NULL)
            continue;

        if (p_rtl9300_sds_cust_conf->sds_conf_per_unit[unit]->sds_cfg[sdsId]->sds_param == NULL)
            continue;

        while(p_rtl9300_sds_cust_conf->sds_conf_per_unit[unit]->sds_cfg[sdsId]->sds_param->page != RTK_SDS_PAGEREGVAL_END)
        {
            _rtl9300_mac_serdes_patch_set(unit, sdsId,p_rtl9300_sds_cust_conf->sds_conf_per_unit[unit]->sds_cfg[sdsId]->sds_param,1);
            p_rtl9300_sds_cust_conf->sds_conf_per_unit[unit]->sds_cfg[sdsId]->sds_param++;
        }
    }
}

void dal_longan_construct_serdesConfig_init(uint32 unit)
{
    uint32  sdsId;
    uint32  size = 0;
    uint32  laneNum;
    uint32  i;
    uint32  patch_list_sel = 0;
    uint32  patch_ready = 0;
    patch_list_t *pPatchListSel = NULL;
    patch_t *pPatchList = NULL;

    int32    ret;

    if((RTL9301_CHIP_ID_24G == HWP_CHIP_ID(unit) || RTL9303_CHIP_ID_8XG == HWP_CHIP_ID(unit)) &&
        (CHIP_REV_ID_B == HWP_CHIP_REV(unit)))
    {
        pPatchList = serdes_patch_List_bT;
        size = sizeof(serdes_patch_List_bT)/sizeof(patch_t);
        patch_list_sel = 1;
    }
    else if((RTL9301_CHIP_ID_24G == HWP_CHIP_ID(unit) || RTL9303_CHIP_ID_8XG == HWP_CHIP_ID(unit)) &&
        (CHIP_REV_ID_C == HWP_CHIP_REV(unit)))
    {
        pPatchList = serdes_patch_List_cT;
        size = sizeof(serdes_patch_List_cT)/sizeof(patch_t);
        patch_list_sel = 1;
    }
    else if((IF_CHIP_TYPE_1(unit)) && (CHIP_REV_ID_D == HWP_CHIP_REV(unit)))
    {
        patch_list_sel = 0;
        pPatchListSel = &serdes_patch_list_dT;
    }
    else
    {
        patch_list_sel = 0;
        pPatchListSel = &serdes_patch_list_a;
    }

    HWP_LONGAN_SDS_TRAVS(unit, sdsId)
    {
        if(patch_list_sel == 0)
        {
            if(HWP_SDS_5G(sdsId))
            {
                pPatchList = pPatchListSel->patch_list_5g;
                size = pPatchListSel->size_5g;
            }
            else
            {
                if(HWP_SDS_ODD(sdsId))
                {
                    pPatchList = pPatchListSel->patch_list_10g_odd;
                    size = pPatchListSel->size_10g_odd;
                }
                else
                {
                    pPatchList = pPatchListSel->patch_list_10g_even;
                    size = pPatchListSel->size_10g_even;
                }
            }
        }

        for (i = 0; i < size; i++)
        {
            if ((pPatchList[i].sds_mode == HWP_SDS_MODE(unit, sdsId)) &&
                 (pPatchList[i].phy_type != RTK_PHYTYPE_NONE) &&
                 (pPatchList[i].phy_type == HWP_SDS_ID2PHYMODEL(unit, sdsId)))
            {
                _rtl9300_mac_serdes_patch_set(unit, sdsId, pPatchList[i].patch, pPatchList[i].patch_size);
                patch_ready = 1;
                break;
            }
        }

        if(1 == patch_ready)
        {
            patch_ready = 0;
            continue;
        }

        for (i = 0; i < size; i++)
        {
            if (pPatchList[i].sds_mode == HWP_SDS_MODE(unit, sdsId))
            {
                if(RTK_MII_RXAUI_PLUS == pPatchList[i].sds_mode)
                {
                    if((ret = hwp_multiSdsPortLaneNum_get(unit, sdsId,&laneNum)) == RT_ERR_OK)
                    {
                        if(pPatchList[i].laneNum == laneNum)
                        {
                            _rtl9300_mac_serdes_patch_set(unit, sdsId, pPatchList[i].patch, pPatchList[i].patch_size);
                            break;
                        }
                    }
                }
                else
                {
                    if(pPatchList[i].phy_type == RTK_PHYTYPE_NONE)
                    {
                        _rtl9300_mac_serdes_patch_set(unit, sdsId, pPatchList[i].patch, pPatchList[i].patch_size);
                        break;
                    }
                }
            }
        }
    }

    HWP_LONGAN_SDS_TRAVS(unit, sdsId)
    {
        if ((RTK_MII_USXGMII_10GQXGMII == HWP_SDS_MODE(unit, sdsId)) ||
                (RTK_MII_USXGMII_10GSXGMII == HWP_SDS_MODE(unit, sdsId)))
        {
            switch (HWP_SDS_ID2PHYMODEL(unit, sdsId))
            {
                case RTK_PHYTYPE_RTL8224QF:
                    _dal_longan_sds_usxgmii_cfg_set(unit, sdsId, &sds_usxgmii_cfg_rtl8224qf);
                    break;
                case RTK_PHYTYPE_RTL8224:
                    _dal_longan_sds_usxgmii_cfg_set(unit, sdsId, &sds_usxgmii_cfg_rtl8224);
                    break;
                case RTK_PHYTYPE_CUST1 ... RTK_PHYTYPE_CUST5:
                case RTK_PHYTYPE_UNKNOWN:
                    /* patch array default */
                    break;
                default:
                    _dal_longan_sds_usxgmii_cfg_set(unit, sdsId, &sds_usxgmii_cfg_rtk_default);
                    break;
            }
        }
    }

    dal_longan_construct_mac_default_10gmedia_fiber(unit);
    dal_longan_construc_serdesConfig_cust(unit);

    return;
}

/* Function Name:
 *      dal_longan_construct_miscConfig_init
 * Description:
 *      Miscellaneous Configuration code for RTL9300
 * Input:
 *      unit - unit ID
 * Output:
 *      None
 * Return:
 *      None
 * Note:
 *      None
 */
void dal_longan_construct_miscConfig_init(uint32 unit)
{

    return;

}

