#ifndef __RTK_CYPRESS_REG_STRUCT_H__
#define __RTK_CYPRESS_REG_STRUCT_H__

/*
 * Include Files
 */
#include <common/rt_autoconf.h>
#include <hal/chipdef/allreg.h>
#ifdef __BOOTLOADER__
#include <hal/chipdef/cypress/rtk_cypress_uboot_feature_def.h>
#else   /* __BOOTLOADER__ */
#include <hal/chipdef/cypress/rtk_cypress_feature_def.h>
#endif  /* __BOOTLOADER__ */

/* Superset Register Enum */
typedef enum rtk_cypress_reg_list_e
{
#if defined(CONFIG_SDK_CHIP_FEATURE_INTERFACE)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ECO_DUMMY_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_IF_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_SERDES_IF_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_IO_DRIV_ABLTYr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_INTERFACE */
#if defined(CONFIG_SDK_CHIP_FEATURE_RESET)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_GLB_STS0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_GLB_STS1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_RST_DUR_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_RESET */
#if defined(CONFIG_SDK_CHIP_FEATURE_PLL___BIAS)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PLL_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_PLL_CTRL0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_PLL_CTRL1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_PLL_SSC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_PLL_MISC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_PLL_CTRL0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_PLL_CTRL1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_PLL_SSC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_PLL_MISC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_PLL_CTRL0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_PLL_CTRL1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_PLL_SSC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_PLL_MISC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_PLL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_PLL_MISC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_PLL_SSC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CKREFBUF_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PLL___BIAS */
#if defined(CONFIG_SDK_CHIP_FEATURE_INTERRUPT)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_GLBr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_LINK_STS_CHGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_MEDIA_CHGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_FEFIr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_EEE_CHGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_TIMESTAMP_LATCHr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_SERDESr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_EXT_GPIOr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_MISCr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_SRCr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_LINK_STS_CHGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_MEDIA_CHGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_FEFIr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_EEE_CHGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_TIMESTAMP_LATCHr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_SERDESr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_EXT_GPIOr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_MISCr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GPIO_INT_MODEr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_INTERRUPT */
#if defined(CONFIG_SDK_CHIP_FEATURE_BIST___BISR)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_OQ_INFO_STATUSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_OQ_LL_STATUS_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_OQ_LL_STATUS_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_OQ_HSA_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_INFO_OQ_HSA0_Lr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_OQ_HSA_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_INFO_OQ_HSA1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_EGR_DVS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_PG_MEMr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_PH_MEMr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_PT_MEMr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_ENCAP_MEM_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_ENCAP_MEM_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_ENCAP_TCAMr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_UNTAG_MEMr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_INFO_UNTAG_MEMr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_ENCAP_DVS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_MAC1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_MAC2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_MAC3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_MAC4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_MAC5r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE5r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE6r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE7r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE8r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE10r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_CTL_ALE11r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_TCAM_128_144_9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_TCAM_128_72_9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_TCAM_128_144_4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_BCAM_64r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_CTL_ALE12r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_CTL_ALE12_INFOr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DVS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_NIC_L2MSGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NIC_DVS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_CTL_STDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_PARSE_DVS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_CTL_STDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW02_CTL_STDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW03_CTL_STDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_CTL_STDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBISR_SW07_CTLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_STDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_STDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_STDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INGR_PKT_BUF_BYPASS_PG_ADDR_0_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INGR_PKT_BUF_BYPASS_PG_ADDR_2_3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INGR_DVS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_GLB_STARTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_GLB_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBISR_GLB_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_TCAM_DRF_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_SOC_DVS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_CPU_BIST_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_CPU_BIST_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_CPU_BIST_2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_CPU_SRAM_CTRL_BISTr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_BIST___BISR */
#if defined(CONFIG_SDK_CHIP_FEATURE_LED)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_SET_2_3_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_SET_0_1_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_COPR_SET_SEL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_FIB_SET_SEL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_COPR_PMASK_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_FIB_PMASK_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_COMBO_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_SW_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_SW_P_EN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_SW_P_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_GPIO_DIR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_GPIO_DATA_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_GPIO_INDRT_ACCESSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV1_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV2_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV3_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV1_1Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV2_1Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV3_1Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV1_100Mr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV2_100Mr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV3_100Mr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV1_10Mr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV2_10Mr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_LV3_10Mr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_P_LOAD_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BUZZER_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_LED */
#if defined(CONFIG_SDK_CHIP_FEATURE_HW_MISC_)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_CMDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_WDATAr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_RDATAr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VOL_CTRL_RESISr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_CTRL_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_CTRL_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_CTRL_2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_RESULTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_CTRL_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_CTRL_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_CTRL_2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_RESULTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_SENR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_DATA_IN_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_DATA_IN_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_DATA_OUT_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_DATA_OUT_1r,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_HW_MISC_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_CHP_INFORMATION)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MODEL_NAME_INFOr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CHIP_INFOr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_CHP_INFORMATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_MAC_CONTROL)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_PADDING_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_EFUSE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_MAX_LEN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_ADDR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_PORT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_FORCE_MODE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_LINK_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_LINK_MEDIA_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_LINK_SPD_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_LINK_DUP_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_TX_PAUSE_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_RX_PAUSE_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_EEE_ABLTYr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_FEFI_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_CPU_TAG_ID_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PHYREG_ACCESS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PHYREG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PHYREG_PORT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BROADCAST_PHYID_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PHYREG_DATA_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PHYREG_MMD_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMI_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMI_PORT_POLLING_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CHG_DUP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_LINK_500M_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMI_PORT_500M_POLLING_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_MISC_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MAC_CONTROL */
#if defined(CONFIG_SDK_CHIP_FEATURE_PHY___SERDES)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS0_1_XSG0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS0_1_XSG1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS0_1_ANA_RG_EXTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS2_3_XSG0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS2_3_XSG1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS2_3_ANA_RG_EXTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS4_5_XSG0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS4_5_XSG1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS4_5_ANA_RG_EXTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS6_7_XSG0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS6_7_XSG1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS6_7_ANA_RG_EXTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS8_9_XSG0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS8_9_XSG1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS8_9_TGRXr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS8_9_ANA_TGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS10_11_XSG0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS10_11_XSG1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS10_11_ANA_RG_EXTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS12_13_XSG0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS12_13_XSG1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS12_13_TGRXr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SDS12_13_ANA_TGr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PHY___SERDES */
#if defined(CONFIG_SDK_CHIP_FEATURE_POWER_SAVING)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_Q_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_MINIFG_CTRL0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_MINIFG_CTRL1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_TIMER_100M_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_TIMER_GELITE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_TIMER_GIGA_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_TIMER_10G_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_EEEP_PORT_TX_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_EEEP_PORT_RX_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_PORT_TX_EN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_PORT_RX_EN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_TIMER_UNIT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_TX_100M_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_TX_500M_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_TX_GIGA_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_TX_WAKE_TIMER_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_RATE_100M_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_RATE_500M_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_RATE_GIGA_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_SLEEP_STEP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_TIMER_100M_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_TIMER_500M_CTRL0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_TIMER_500M_CTRL1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_TIMER_GIGA_CTRL0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_TIMER_GIGA_CTRL1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PS_GATCLK_SLCLK_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PS_LINKID_GATCLK_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PS_EEE_GATCLK_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PS_ACL_PWR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_IDLE_TIMER_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_TX_IDLE_TIMER_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_GBL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_POWER_SAVING */
#if defined(CONFIG_SDK_CHIP_FEATURE_SYSTEM_CLOCK)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REF_TIME_SECr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REF_TIME_NSECr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REF_TIME_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REF_TIME_ENr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SYSTEM_CLOCK */
#if defined(CONFIG_SDK_CHIP_FEATURE_PTP__PRECISION_TIME_PROTOCOL_)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PTP_PORT_ENr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PTP_PORT_RX_TIMEr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PTP_PORT_TX_TIMEr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PTP_INTR_STSr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PTP__PRECISION_TIME_PROTOCOL_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_ADDRESS_TABLE_LOOKUP)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_CTRL_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_CTRL_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_LM_ACTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_STTC_MV_ACTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_FLD_PMSKr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_NEW_SALRNr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_NEW_SA_FWDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_LRN_CONSTRTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_LRN_CONSTRTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_VLAN_LRN_CONSTRTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_VLAN_LRN_CONSTRT_CNTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_VLAN_LRN_CONSTRT_ACTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_NOTIFICATION_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_IGR_P_FLTRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_AGING_OUTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_IPV6_MC_IP_CARE_BYTEr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_MV_ACTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_MV_INVALIDATEr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_PORT_MV_FORBIDr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ADDRESS_TABLE_LOOKUP */
#if defined(CONFIG_SDK_CHIP_FEATURE_ADDRESS_LEARNING___FLUSH)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_TBL_FLUSH_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ADDRESS_LEARNING___FLUSH */
#if defined(CONFIG_SDK_CHIP_FEATURE__IEEE802_1Q__VLAN)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_TAG_TPID_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_ETAG_TPID_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_ITAG_TPID_CMP_MSKr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_OTAG_TPID_CMP_MSKr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_ETAG_TPID_CMPr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_ACCEPT_FRAME_TYPEr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_PB_VLANr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_FWDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_IGR_FLTRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_EGR_FLTRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PROFILEr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_IGR_CNVT_BLK_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_EGR_CNVT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_TAG_STS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_EGR_ITPID_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_EGR_OTPID_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_VID_EGR_XLATE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_NTO1_AGGRr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE__IEEE802_1Q__VLAN */
#if defined(CONFIG_SDK_CHIP_FEATURE__IEEE802_1V__PROTOCOL_BASED_VLAN)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PPB_VLAN_VALr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PORT_PPB_VLANr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE__IEEE802_1V__PROTOCOL_BASED_VLAN */
#if defined(CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_MBR_CTRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_HASH_IDX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_HASH_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_SEP_TRAFFIC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_EXTRA_EN_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ST_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE */
#if defined(CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION_FORWARDING_FORCE_MODE)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_ISO_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_ISO_VB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_ISO_VB_ISO_PM_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION_FORWARDING_FORCE_MODE */
#if defined(CONFIG_SDK_CHIP_FEATURE_RMA)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_CTRL_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_CTRL_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_CTRL_2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_CTRL_3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_SMAC_LRN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_MGN_LRN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_USR_DEF_CTRL_SET0_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_USR_DEF_CTRL_SET0_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_USR_DEF_CTRL_SET1_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_USR_DEF_CTRL_SET1_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_PORT_BPDU_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_PORT_PTP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_PORT_LLDP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_BPDU_FLD_PMSKr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_RMA */
#if defined(CONFIG_SDK_CHIP_FEATURE_NIC___DMA)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_RX_BASE_DESC_ADDR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_RX_CUR_DESC_ADDR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_TX_BASE_DESC_ADDR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_TX_CUR_DESC_ADDR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_NBUF_BASE_DESC_ADDR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_NBUF_CUR_DESC_ADDR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_INTR_MSKr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_INTR_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_PKT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_RX_RING_SIZEr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_RX_RING_CNTRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_PKT_FLTR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_IF_PHYSICAL_ADDR_MSKr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_L2MSG_TMROUTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_L2MSG_CNT_SELr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMA_RDMA_CNT_SELr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_NIC___DMA */
#if defined(CONFIG_SDK_CHIP_FEATURE_STORM_CONTROL__B_M_UM_DLF_)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_LB_TICK_TKN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_BC_EXCEED_FLGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_MC_EXCEED_FLGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_UC_EXCEED_FLGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_MC_TYPE_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_UC_TYPE_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_BC_RATE_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_MC_RATE_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_UC_RATE_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_BC_BURST_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_MC_BURST_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_UC_BURST_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_UCr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_MCr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_PORT_BCr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_SPCL_LB_TICK_TKN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_SPCL_PORT_BPDU_EXCEED_FLGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_SPCL_PORT_IGMP_EXCEED_FLGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_SPCL_PORT_ARP_EXCEED_FLGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STORM_CTRL_SPCL_PORT_RATEr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_STORM_CONTROL__B_M_UM_DLF_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_BANDWIDTH_CONTROL__INGRESS_EGRESS_)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_BWCTRL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_BWCTRL_LB_TICK_TKN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_BWCTRL_PORT_EXCEED_FLGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_BWCTRL_CTRL_LB_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_BWCTRL_PORT_CTRL_10Gr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_BWCTRL_PORT_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_BANDWIDTH_CONTROL__INGRESS_EGRESS_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_METER_MARKER)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_MODE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_LB_TICK_TKN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_BYTE_DLB_LB_THR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_BYTE_SRTCM_LB_THR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_BYTE_TRTCM_LB_THR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_PKT_DLB_LB_THR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_PKT_SRTCM_LB_THR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_PKT_TRTCM_LB_THR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_LB_EXCEED_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_CNTR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_GREEN_CNTR_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_YELLOW_CNTR_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_RED_CNTR_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_TOTAL_CNTR_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_RATE_MODE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_LB_GLB_EXCEED_STSr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_METER_MARKER */
#if defined(CONFIG_SDK_CHIP_FEATURE_ATTACK_PREVENTION)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_PORT_ENr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_ACTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_IPV6_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_ICMP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_TCP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_SMURF_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_ARP_INVLD_PORT_ACTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_PRVNT_PORT_GARP_ACTr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ATTACK_PREVENTION */
#if defined(CONFIG_SDK_CHIP_FEATURE_MIRRORING)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_SPM_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_DPM_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_RSPAN_VLAN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_RSPAN_TX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_RSPAN_RX_TAG_RM_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_RSPAN_RX_TAG_EN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_SAMPLE_RATE_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MIRRORING */
#if defined(CONFIG_SDK_CHIP_FEATURE_SFLOW)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SFLOW_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SFLOW_PORT_RATE_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SFLOW */
#if defined(CONFIG_SDK_CHIP_FEATURE_STATISTIC_COUNTERS)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER5r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER6r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER7r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER8r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER10r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER11r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER12r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER13r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER14r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER15r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER16r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER17r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER18r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER19r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER20r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER21r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER22r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER23r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER24r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER25r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER26r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER27r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER28r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER29r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER30r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER31r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER32r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER33r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER34r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER35r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER36r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER37r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER38r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER39r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER40r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER41r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER42r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER43r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PRVTE_DROP_COUNTER44r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PORT_STANDARD_MIBr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_BRIDGE_DOT1DTPLEARNEDENTRYDISCARDSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_RSTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_PORT_RSTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STAT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIB_BIST_CTLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_STATISTIC_COUNTERS */
#if defined(CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE_THRESHOLD)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_DROP_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_GLB_HI_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_GLB_LO_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_GLB_FCOFF_HI_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_GLB_FCOFF_LO_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_P_THR_SET_SELr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_P_HI_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_P_LO_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_P_FCOFF_HI_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_P_Q_EGR_DROP_ENr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_P_RXCNGST_IGNOREr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_Q_EGR_DROP_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_CPUQ_EGR_DROP_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_P_USED_PAGE_CNTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_TL_USED_PAGE_CNTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_ACT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_P_FLD_HOL_PRVNT_ENr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_FLD_HOL_PRVNT_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE_THRESHOLD */
#if defined(CONFIG_SDK_CHIP_FEATURE_CONGESTION_AVOIDANCE)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WRED_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WRED_PORT_THR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WRED_QUEUE_THR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WRED_DROP_CNTR_PIDXr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WRED_DROP_CNTR_CIDXr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WRED_DROP_CNTRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WRED_CNTR_RSTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SC_P_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SC_P_ENr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_CONGESTION_AVOIDANCE */
#if defined(CONFIG_SDK_CHIP_FEATURE_QUEUE_MANAGEMENT)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_QM_INTPRI2QID_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_QM_PORT_QNUMr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_QM_PKT2CPU_INTPRI_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_QM_PKT2CPU_INTPRI_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_QM_PKT2CPU_INTPRI_2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_QM_PKT2CPU_INTPRI_MAPr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_EGR_DROP_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_QUEUE_MANAGEMENT */
#if defined(CONFIG_SDK_CHIP_FEATURE_INGRESS_PRIORITY_DECISION)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_IPRI_REMAPr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_OPRI_DEI0_REMAPr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_OPRI_DEI1_REMAPr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_DSCP_REMAPr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_PORT_PRIr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_PORT_TBL_IDX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_TBL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_PORT_DEI_TAG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_DEI2DP_REMAPr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_DSCP2DP_REMAPr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_INGRESS_PRIORITY_DECISION */
#if defined(CONFIG_SDK_CHIP_FEATURE_REMARKING)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_PORT_RMK_EN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_PORT_OPRI_SRC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_IPRI_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_OPRI_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_PORT_DEI_TAG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_DEI_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_DSCP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_PORT_OPRI_SRC_EXT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI_SEL_PORT_PRI_COPYr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_DSCP2IPRI_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMK_DSCP2OPRI_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_REMARKING */
#if defined(CONFIG_SDK_CHIP_FEATURE_SCHEDULING)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SCHED_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SCHED_LB_TICK_TKN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SCHED_LB_THRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SCHED_LB_TICK_TKN_PPS_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SCHED_PPS_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SCHEDULING */
#if defined(CONFIG_SDK_CHIP_FEATURE_ETHERNET_AV)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_AVB_PORT_CLASS_A_ENr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_AVB_PORT_CLASS_B_ENr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_AVB_PORT_CLASS_A_EN_MACr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_AVB_PORT_CLASS_B_EN_MACr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_AVB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_AVB_CTRL_MACr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ETHERNET_AV */
#if defined(CONFIG_SDK_CHIP_FEATURE_INGRESS_AND_EGRESS_ACL)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_BLK_LOOKUP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_BLK_TMPLTE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_RESERVEDr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_BLK_GROUP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_BLK_RESULT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_MV_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_MV_LEN_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_CLR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_TMPLTE_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_VLAN_CNVT_DFLT_ACTr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_RULE_HIT_INDICATIONr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_GLB_HIT_INDICATIONr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_INGRESS_AND_EGRESS_ACL */
#if defined(CONFIG_SDK_CHIP_FEATURE_RANGE_CHECK__PORT_VLAN_IP_L4PORT_)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_SPM_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_DPM_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_VID_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_IP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_IP_RNGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_L4PORT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_L4PORT_RNGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RNG_CHK_PKT_LEN_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_RANGE_CHECK__PORT_VLAN_IP_L4PORT_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_OAM)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OAM_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OAM_PORT_ACT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OAM_GLB_DYING_GASP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OAM_PORT_DYING_GASP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DYING_GASP_POLARITY_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_OAM */
#if defined(CONFIG_SDK_CHIP_FEATURE_CFM)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFM_UNKN_RX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFM_LBLT_RX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFM_CCM_RX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CCM_TAG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CCM_LIFETIME_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CCM_TX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CCM_TX_INST_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CCM_TX_INST_P_CFGr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CCM_RX_INST_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CCM_INST_CNTR_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CCM_INST_CNTR_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETH_DM_PORT_ENr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETH_DM_RX_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETH_DM_TX_DLYr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETH_DM_RX_TIMEr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_CFM */
#if defined(CONFIG_SDK_CHIP_FEATURE_PARSER_HSB)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA5r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA6r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA7r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA8r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA10r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA11r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA12r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA13r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA14r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA15r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA16r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA17r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA18r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA19r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA20r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA21r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA22r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA23r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA24r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA25r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA26r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_DATA27r,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PARSER_HSB */
#if defined(CONFIG_SDK_CHIP_FEATURE_HSM)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA5r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA6r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA7r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA8r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA10r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA11r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA12r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA13r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA14r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_PRE_DATA15r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA5r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA6r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA7r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA8r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA10r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA11r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA12r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSM_LU_DATA13r,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_HSM */
#if defined(CONFIG_SDK_CHIP_FEATURE_MODIFIER_HSA)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA5r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA6r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA7r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA8r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA10r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA11r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA12r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA13r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA14r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA15r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA16r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_DATA17r,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MODIFIER_HSA */
#if defined(CONFIG_SDK_CHIP_FEATURE_DEBUGGING__ALE__LOOPBACK__DROP_MECHANISM__FC_AND_QM_)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DBG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DBG_DATA_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_CMP_DATAr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_CARE_BITr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_RISING_CHKr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_FALLING_CHKr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_5r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_6r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_7r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_8r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_9r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_10r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_11r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_12r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_13r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_14r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_15r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_16r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_PORT_DBG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_DBG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKTENCAP_PORT_DBG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PARSER_DBG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_DBG_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_3r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_4r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_5r,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_DEBUGGING__ALE__LOOPBACK__DROP_MECHANISM__FC_AND_QM_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_SMART_PACKET_GENERATOR)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPG_GLB_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPG_PORT_TX_GRP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPG_PORT_STSr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPG_PORT_PKT_TRAPr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SMART_PACKET_GENERATOR */
#if defined(CONFIG_SDK_CHIP_FEATURE_L3_ROUTING)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ROUTING_EXCPT_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ROUTING_SA_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_L3_ROUTING */
#if defined(CONFIG_SDK_CHIP_FEATURE_L3_VPN_MPLS)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MPLS_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_L3_VPN_MPLS */
#if defined(CONFIG_SDK_CHIP_FEATURE_TABLE_ACCESS)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACCESS_L2_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACCESS_L2_DATAr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACCESS_CTRL_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACCESS_DATA_0r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACCESS_CTRL_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACCESS_DATA_1r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACCESS_CTRL_2r,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACCESS_DATA_2r,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_TABLE_ACCESS */
#if defined(CONFIG_SDK_CHIP_FEATURE_SPECIAL_TRAP)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPCL_TRAP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPCL_TRAP_IGMP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPCL_TRAP_EAPOL_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPCL_TRAP_ARP_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPCL_TRAP_IPV6_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPCL_TRAP_SWITCH_MAC_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPCL_TRAP_SWITCH_IPV4_ADDRr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPCL_TRAP_CRC_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SPECIAL_TRAP */
#if defined(CONFIG_SDK_CHIP_FEATURE_PARSER)
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PARSER_FIELD_SELTOR_CTRLr,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PARSER_CTRLr,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PARSER */

    CYPRESS_REG_LIST_END,
} rtk_cypress_reg_list_t;


/* Internal Register Enum */
typedef enum rtk_int_cypress_reg_list_e
{
#if defined(CONFIG_SDK_CHIP_FEATURE_INTERFACE)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ECO_DUMMY_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_IF_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_SERDES_IF_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_IO_DRIV_ABLTY_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_INTERFACE */
#if defined(CONFIG_SDK_CHIP_FEATURE_RESET)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RST_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RST_GLB_STS0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RST_GLB_STS1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_RST_DUR_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_RESET */
#if defined(CONFIG_SDK_CHIP_FEATURE_PLL___BIAS)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PLL_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CPU_PLL_CTRL0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CPU_PLL_CTRL1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CPU_PLL_SSC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CPU_PLL_MISC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LXB_PLL_CTRL0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LXB_PLL_CTRL1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LXB_PLL_SSC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LXB_PLL_MISC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MEM_PLL_CTRL0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MEM_PLL_CTRL1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MEM_PLL_SSC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MEM_PLL_MISC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SW_PLL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SW_PLL_MISC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SW_PLL_SSC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CKREFBUF_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PLL___BIAS */
#if defined(CONFIG_SDK_CHIP_FEATURE_INTERRUPT)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_GLB_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_PORT_LINK_STS_CHG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_PORT_MEDIA_CHG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_PORT_FEFI_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_PORT_EEE_CHG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_PORT_TIMESTAMP_LATCH_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_SERDES_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_EXT_GPIO_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IMR_MISC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_GLB_SRC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_PORT_LINK_STS_CHG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_PORT_MEDIA_CHG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_PORT_FEFI_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_PORT_EEE_CHG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_PORT_TIMESTAMP_LATCH_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_SERDES_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_EXT_GPIO_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ISR_MISC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_GPIO_INT_MODE_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_INTERRUPT */
#if defined(CONFIG_SDK_CHIP_FEATURE_BIST___BISR)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_OQ_INFO_STATUS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_OQ_LL_STATUS_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_OQ_LL_STATUS_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_OQ_HSA_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_INFO_OQ_HSA0_L_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_OQ_HSA_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_INFO_OQ_HSA1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_EGR_DVS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_PG_MEM_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_PH_MEM_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_PT_MEM_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_ENCAP_MEM_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_ENCAP_MEM_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_ENCAP_TCAM_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_UNTAG_MEM_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_INFO_UNTAG_MEM_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_ENCAP_DVS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_MAC1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_MAC2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_MAC3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_MAC4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_MAC5_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE5_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE6_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE7_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE8_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE10_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_CTL_ALE11_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_TCAM_128_144_9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_TCAM_128_72_9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_TCAM_128_144_4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_BCAM_64_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_CTL_ALE12_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BISR_CTL_ALE12_INFO_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DVS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_NIC_L2MSG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_NIC_DVS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_SW05_CTL_STD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PKT_PARSE_DVS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_SW01_CTL_STD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_SW02_CTL_STD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_SW03_CTL_STD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_SW04_CTL_STD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBISR_SW07_CTL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_SW07_0_STD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_SW07_1_STD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_SW07_2_STD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_INGR_PKT_BUF_BYPASS_PG_ADDR_0_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_INGR_PKT_BUF_BYPASS_PG_ADDR_2_3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_INGR_DVS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_GLB_START_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_GLB_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBISR_GLB_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MBIST_TCAM_DRF_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BIST_SOC_DVS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SOC_CPU_BIST_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SOC_CPU_BIST_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SOC_CPU_BIST_2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SOC_CPU_SRAM_CTRL_BIST_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_BIST___BISR */
#if defined(CONFIG_SDK_CHIP_FEATURE_LED)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_SET_2_3_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_SET_0_1_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_COPR_SET_SEL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_FIB_SET_SEL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_COPR_PMASK_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_FIB_PMASK_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_COMBO_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_SW_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_SW_P_EN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_SW_P_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EXT_GPIO_DIR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EXT_GPIO_DATA_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EXT_GPIO_INDRT_ACCESS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV1_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV2_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV3_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV1_1G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV2_1G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV3_1G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV1_100M_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV2_100M_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV3_100M_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV1_10M_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV2_10M_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_LOAD_LV3_10M_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_LED_P_LOAD_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BUZZER_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_LED */
#if defined(CONFIG_SDK_CHIP_FEATURE_HW_MISC_)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EFUSE_CMD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EFUSE_WDATA_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EFUSE_RDATA_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EFUSE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VOL_CTRL_RESIS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TM0_CTRL_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TM0_CTRL_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TM0_CTRL_2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TM0_RESULT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TM1_CTRL_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TM1_CTRL_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TM1_CTRL_2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TM1_RESULT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPD_SENR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPD_DATA_IN_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPD_DATA_IN_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPD_DATA_OUT_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPD_DATA_OUT_1_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_HW_MISC_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_CHP_INFORMATION)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MODEL_NAME_INFO_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CHIP_INFO_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_CHP_INFORMATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_MAC_CONTROL)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_PADDING_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_EFUSE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_MAX_LEN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_ADDR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_PORT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_FORCE_MODE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_LINK_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_LINK_MEDIA_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_LINK_SPD_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_LINK_DUP_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_TX_PAUSE_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_RX_PAUSE_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_EEE_ABLTY_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_FEFI_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_CPU_TAG_ID_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PHYREG_ACCESS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PHYREG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PHYREG_PORT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_BROADCAST_PHYID_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PHYREG_DATA_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PHYREG_MMD_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SMI_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SMI_PORT_POLLING_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CHG_DUP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_LINK_500M_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SMI_PORT_500M_POLLING_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_MISC_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MAC_CONTROL */
#if defined(CONFIG_SDK_CHIP_FEATURE_PHY___SERDES)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS0_1_XSG0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS0_1_XSG1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS0_1_ANA_RG_EXT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS2_3_XSG0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS2_3_XSG1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS2_3_ANA_RG_EXT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS4_5_XSG0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS4_5_XSG1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS4_5_ANA_RG_EXT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS6_7_XSG0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS6_7_XSG1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS6_7_ANA_RG_EXT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS8_9_XSG0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS8_9_XSG1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS8_9_TGRX_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS8_9_ANA_TG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS10_11_XSG0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS10_11_XSG1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS10_11_ANA_RG_EXT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS12_13_XSG0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS12_13_XSG1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS12_13_TGRX_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SDS12_13_ANA_TG_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PHY___SERDES */
#if defined(CONFIG_SDK_CHIP_FEATURE_POWER_SAVING)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_TX_Q_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_TX_MINIFG_CTRL0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_TX_MINIFG_CTRL1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_TX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_TX_TIMER_100M_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_TX_TIMER_GELITE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_TX_TIMER_GIGA_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_TX_TIMER_10G_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_EEEP_PORT_TX_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_EEEP_PORT_RX_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_PORT_TX_EN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_PORT_RX_EN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_TIMER_UNIT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_TX_100M_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_TX_500M_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_TX_GIGA_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_TX_WAKE_TIMER_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_RATE_100M_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_RATE_500M_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_RATE_GIGA_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_SLEEP_STEP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_TIMER_100M_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_TIMER_500M_CTRL0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_TIMER_500M_CTRL1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_TIMER_GIGA_CTRL0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_TIMER_GIGA_CTRL1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PS_GATCLK_SLCLK_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PS_LINKID_GATCLK_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PS_EEE_GATCLK_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PS_ACL_PWR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_RX_IDLE_TIMER_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_TX_IDLE_TIMER_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEEP_GBL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_EEE_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_POWER_SAVING */
#if defined(CONFIG_SDK_CHIP_FEATURE_SYSTEM_CLOCK)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_REF_TIME_SEC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_REF_TIME_NSEC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_REF_TIME_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_REF_TIME_EN_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SYSTEM_CLOCK */
#if defined(CONFIG_SDK_CHIP_FEATURE_PTP__PRECISION_TIME_PROTOCOL_)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PTP_PORT_EN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PTP_PORT_RX_TIME_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PTP_PORT_TX_TIME_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PTP_INTR_STS_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PTP__PRECISION_TIME_PROTOCOL_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_ADDRESS_TABLE_LOOKUP)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_CTRL_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_CTRL_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_LM_ACT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_STTC_MV_ACT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_FLD_PMSK_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_NEW_SALRN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_NEW_SA_FWD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_LRN_CONSTRT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_LRN_CONSTRT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_VLAN_LRN_CONSTRT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_VLAN_LRN_CONSTRT_CNT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_VLAN_LRN_CONSTRT_ACT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_NOTIFICATION_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_IGR_P_FLTR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_AGING_OUT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_IPV6_MC_IP_CARE_BYTE_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_MV_ACT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_MV_INVALIDATE_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_PORT_MV_FORBID_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ADDRESS_TABLE_LOOKUP */
#if defined(CONFIG_SDK_CHIP_FEATURE_ADDRESS_LEARNING___FLUSH)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_L2_TBL_FLUSH_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ADDRESS_LEARNING___FLUSH */
#if defined(CONFIG_SDK_CHIP_FEATURE__IEEE802_1Q__VLAN)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_TAG_TPID_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_ETAG_TPID_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_ITAG_TPID_CMP_MSK_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_OTAG_TPID_CMP_MSK_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_ETAG_TPID_CMP_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_ACCEPT_FRAME_TYPE_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_PB_VLAN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_FWD_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_IGR_FLTR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_EGR_FLTR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PROFILE_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_IGR_CNVT_BLK_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_EGR_CNVT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_TAG_STS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_EGR_ITPID_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_EGR_OTPID_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_VID_EGR_XLATE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_NTO1_AGGR_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE__IEEE802_1Q__VLAN */
#if defined(CONFIG_SDK_CHIP_FEATURE__IEEE802_1V__PROTOCOL_BASED_VLAN)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PPB_VLAN_VAL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_VLAN_PORT_PPB_VLAN_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE__IEEE802_1V__PROTOCOL_BASED_VLAN */
#if defined(CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TRK_MBR_CTR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TRK_HASH_IDX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TRK_HASH_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TRK_SEP_TRAFFIC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TRK_EXTRA_EN_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ST_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE */
#if defined(CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION_FORWARDING_FORCE_MODE)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PORT_ISO_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PORT_ISO_VB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PORT_ISO_VB_ISO_PM_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION_FORWARDING_FORCE_MODE */
#if defined(CONFIG_SDK_CHIP_FEATURE_RMA)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_CTRL_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_CTRL_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_CTRL_2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_CTRL_3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_SMAC_LRN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_MGN_LRN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_USR_DEF_CTRL_SET0_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_USR_DEF_CTRL_SET0_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_USR_DEF_CTRL_SET1_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_USR_DEF_CTRL_SET1_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_PORT_BPDU_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_PORT_PTP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_PORT_LLDP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMA_BPDU_FLD_PMSK_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_RMA */
#if defined(CONFIG_SDK_CHIP_FEATURE_NIC___DMA)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_RX_BASE_DESC_ADDR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_RX_CUR_DESC_ADDR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_TX_BASE_DESC_ADDR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_TX_CUR_DESC_ADDR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_NBUF_BASE_DESC_ADDR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_NBUF_CUR_DESC_ADDR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_INTR_MSK_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_INTR_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_PKT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_RX_RING_SIZE_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_RX_RING_CNTR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_PKT_FLTR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_IF_PHYSICAL_ADDR_MSK_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_L2MSG_TMROUT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_L2MSG_CNT_SEL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DMA_RDMA_CNT_SEL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_NIC___DMA */
#if defined(CONFIG_SDK_CHIP_FEATURE_STORM_CONTROL__B_M_UM_DLF_)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_LB_TICK_TKN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_BC_EXCEED_FLG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_MC_EXCEED_FLG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_UC_EXCEED_FLG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_MC_TYPE_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_UC_TYPE_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_BC_RATE_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_MC_RATE_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_UC_RATE_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_BC_BURST_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_MC_BURST_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_UC_BURST_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_UC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_MC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_PORT_BC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_SPCL_LB_TICK_TKN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_SPCL_PORT_BPDU_EXCEED_FLG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_SPCL_PORT_IGMP_EXCEED_FLG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_SPCL_PORT_ARP_EXCEED_FLG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STORM_CTRL_SPCL_PORT_RATE_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_STORM_CONTROL__B_M_UM_DLF_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_BANDWIDTH_CONTROL__INGRESS_EGRESS_)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IGR_BWCTRL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IGR_BWCTRL_LB_TICK_TKN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IGR_BWCTRL_PORT_EXCEED_FLG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IGR_BWCTRL_CTRL_LB_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IGR_BWCTRL_PORT_CTRL_10G_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IGR_BWCTRL_PORT_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_BANDWIDTH_CONTROL__INGRESS_EGRESS_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_METER_MARKER)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_MODE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_LB_TICK_TKN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_BYTE_DLB_LB_THR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_BYTE_SRTCM_LB_THR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_BYTE_TRTCM_LB_THR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_PKT_DLB_LB_THR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_PKT_SRTCM_LB_THR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_PKT_TRTCM_LB_THR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_LB_EXCEED_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_CNTR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_GREEN_CNTR_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_YELLOW_CNTR_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_RED_CNTR_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_TOTAL_CNTR_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_RATE_MODE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_METER_LB_GLB_EXCEED_STS_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_METER_MARKER */
#if defined(CONFIG_SDK_CHIP_FEATURE_ATTACK_PREVENTION)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_PORT_EN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_ACT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_IPV6_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_ICMP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_TCP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_SMURF_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_ARP_INVLD_PORT_ACT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ATK_PRVNT_PORT_GARP_ACT_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ATTACK_PREVENTION */
#if defined(CONFIG_SDK_CHIP_FEATURE_MIRRORING)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIR_SPM_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIR_DPM_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIR_RSPAN_VLAN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIR_RSPAN_TX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIR_RSPAN_RX_TAG_RM_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIR_RSPAN_RX_TAG_EN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIR_SAMPLE_RATE_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MIRRORING */
#if defined(CONFIG_SDK_CHIP_FEATURE_SFLOW)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SFLOW_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SFLOW_PORT_RATE_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SFLOW */
#if defined(CONFIG_SDK_CHIP_FEATURE_STATISTIC_COUNTERS)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER5_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER6_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER7_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER8_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER10_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER11_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER12_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER13_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER14_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER15_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER16_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER17_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER18_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER19_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER20_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER21_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER22_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER23_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER24_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER25_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER26_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER27_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER28_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER29_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER30_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER31_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER32_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER33_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER34_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER35_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER36_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER37_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER38_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER39_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER40_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER41_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER42_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER43_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PRVTE_DROP_COUNTER44_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PORT_STANDARD_MIB_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_BRIDGE_DOT1DTPLEARNEDENTRYDISCARDS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_RST_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_PORT_RST_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_STAT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MIB_BIST_CTL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_STATISTIC_COUNTERS */
#if defined(CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE_THRESHOLD)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_DROP_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_GLB_HI_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_GLB_LO_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_GLB_FCOFF_HI_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_GLB_FCOFF_LO_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_P_THR_SET_SEL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_P_HI_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_P_LO_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_P_FCOFF_HI_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_P_Q_EGR_DROP_EN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_P_RXCNGST_IGNORE_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_Q_EGR_DROP_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_CPUQ_EGR_DROP_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_P_USED_PAGE_CNT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_TL_USED_PAGE_CNT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_ACT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_P_FLD_HOL_PRVNT_EN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_FLD_HOL_PRVNT_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE_THRESHOLD */
#if defined(CONFIG_SDK_CHIP_FEATURE_CONGESTION_AVOIDANCE)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_WRED_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_WRED_PORT_THR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_WRED_QUEUE_THR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_WRED_DROP_CNTR_PIDX_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_WRED_DROP_CNTR_CIDX_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_WRED_DROP_CNTR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_WRED_CNTR_RST_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SC_P_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SC_P_EN_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_CONGESTION_AVOIDANCE */
#if defined(CONFIG_SDK_CHIP_FEATURE_QUEUE_MANAGEMENT)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_QM_INTPRI2QID_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_QM_PORT_QNUM_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_QM_PKT2CPU_INTPRI_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_QM_PKT2CPU_INTPRI_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_QM_PKT2CPU_INTPRI_2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_QM_PKT2CPU_INTPRI_MAP_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_FC_EGR_DROP_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_QUEUE_MANAGEMENT */
#if defined(CONFIG_SDK_CHIP_FEATURE_INGRESS_PRIORITY_DECISION)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_IPRI_REMAP_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_OPRI_DEI0_REMAP_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_OPRI_DEI1_REMAP_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_DSCP_REMAP_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_PORT_PRI_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_PORT_TBL_IDX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_TBL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_PORT_DEI_TAG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_DEI2DP_REMAP_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_DSCP2DP_REMAP_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_INGRESS_PRIORITY_DECISION */
#if defined(CONFIG_SDK_CHIP_FEATURE_REMARKING)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_PORT_RMK_EN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_PORT_OPRI_SRC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_IPRI_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_OPRI_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_PORT_DEI_TAG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_DEI_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_DSCP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_PORT_OPRI_SRC_EXT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PRI_SEL_PORT_PRI_COPY_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_DSCP2IPRI_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RMK_DSCP2OPRI_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_REMARKING */
#if defined(CONFIG_SDK_CHIP_FEATURE_SCHEDULING)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SCHED_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SCHED_LB_TICK_TKN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SCHED_LB_THR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SCHED_LB_TICK_TKN_PPS_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SCHED_PPS_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SCHEDULING */
#if defined(CONFIG_SDK_CHIP_FEATURE_ETHERNET_AV)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_AVB_PORT_CLASS_A_EN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_AVB_PORT_CLASS_B_EN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_AVB_PORT_CLASS_A_EN_MAC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_AVB_PORT_CLASS_B_EN_MAC_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_AVB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_AVB_CTRL_MAC_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ETHERNET_AV */
#if defined(CONFIG_SDK_CHIP_FEATURE_INGRESS_AND_EGRESS_ACL)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_BLK_LOOKUP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_BLK_TMPLTE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_RESERVED_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_BLK_GROUP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_BLK_RESULT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_MV_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_MV_LEN_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_CLR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_TMPLTE_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_VLAN_CNVT_DFLT_ACT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_RULE_HIT_INDICATION_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ACL_GLB_HIT_INDICATION_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_INGRESS_AND_EGRESS_ACL */
#if defined(CONFIG_SDK_CHIP_FEATURE_RANGE_CHECK__PORT_VLAN_IP_L4PORT_)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_SPM_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_DPM_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_VID_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_IP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_IP_RNG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_L4PORT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_L4PORT_RNG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_RNG_CHK_PKT_LEN_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_RANGE_CHECK__PORT_VLAN_IP_L4PORT_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_OAM)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_OAM_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_OAM_PORT_ACT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_OAM_GLB_DYING_GASP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_OAM_PORT_DYING_GASP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DYING_GASP_POLARITY_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_OAM */
#if defined(CONFIG_SDK_CHIP_FEATURE_CFM)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFM_UNKN_RX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFM_LBLT_RX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFM_CCM_RX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CCM_TAG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CCM_LIFETIME_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CCM_TX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CCM_TX_INST_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CCM_TX_INST_P_CFG_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CCM_RX_INST_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CCM_INST_CNTR_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CCM_INST_CNTR_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ETH_DM_PORT_EN_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ETH_DM_RX_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ETH_DM_TX_DLY_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ETH_DM_RX_TIME_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_CFM */
#if defined(CONFIG_SDK_CHIP_FEATURE_PARSER_HSB)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA5_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA6_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA7_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA8_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA10_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA11_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA12_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA13_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA14_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA15_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA16_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA17_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA18_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA19_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA20_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA21_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA22_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA23_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA24_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA25_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA26_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSB_DATA27_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PARSER_HSB */
#if defined(CONFIG_SDK_CHIP_FEATURE_HSM)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA5_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA6_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA7_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA8_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA10_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA11_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA12_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA13_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA14_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_PRE_DATA15_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA5_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA6_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA7_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA8_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA10_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA11_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA12_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSM_LU_DATA13_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_HSM */
#if defined(CONFIG_SDK_CHIP_FEATURE_MODIFIER_HSA)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA5_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA6_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA7_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA8_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA10_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA11_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA12_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA13_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA14_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA15_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA16_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_HSA_DATA17_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MODIFIER_HSA */
#if defined(CONFIG_SDK_CHIP_FEATURE_DEBUGGING__ALE__LOOPBACK__DROP_MECHANISM__FC_AND_QM_)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DBG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_DBG_DATA_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_CMP_DATA_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_CARE_BIT_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_RISING_CHK_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_FALLING_CHK_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_5_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_6_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_7_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_8_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_9_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_10_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_11_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_12_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_13_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_14_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_15_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ALE_DBG_OUT_16_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IGR_PORT_DBG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_IGR_DBG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PKTENCAP_PORT_DBG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PARSER_DBG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MAC_DBG_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFG_NICDBG_SEL_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFG_NICDBG_SEL_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFG_NICDBG_SEL_2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFG_NICDBG_SEL_3_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFG_NICDBG_SEL_4_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_CFG_NICDBG_SEL_5_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_DEBUGGING__ALE__LOOPBACK__DROP_MECHANISM__FC_AND_QM_ */
#if defined(CONFIG_SDK_CHIP_FEATURE_SMART_PACKET_GENERATOR)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPG_GLB_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPG_PORT_TX_GRP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPG_PORT_STS_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPG_PORT_PKT_TRAP_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SMART_PACKET_GENERATOR */
#if defined(CONFIG_SDK_CHIP_FEATURE_L3_ROUTING)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ROUTING_EXCPT_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_ROUTING_SA_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_L3_ROUTING */
#if defined(CONFIG_SDK_CHIP_FEATURE_L3_VPN_MPLS)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_MPLS_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_L3_VPN_MPLS */
#if defined(CONFIG_SDK_CHIP_FEATURE_TABLE_ACCESS)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TBL_ACCESS_L2_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TBL_ACCESS_L2_DATA_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TBL_ACCESS_CTRL_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TBL_ACCESS_DATA_0_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TBL_ACCESS_CTRL_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TBL_ACCESS_DATA_1_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TBL_ACCESS_CTRL_2_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_TBL_ACCESS_DATA_2_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_TABLE_ACCESS */
#if defined(CONFIG_SDK_CHIP_FEATURE_SPECIAL_TRAP)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPCL_TRAP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPCL_TRAP_IGMP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPCL_TRAP_EAPOL_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPCL_TRAP_ARP_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPCL_TRAP_IPV6_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPCL_TRAP_SWITCH_MAC_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPCL_TRAP_SWITCH_IPV4_ADDR_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_SPCL_TRAP_CRC_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SPECIAL_TRAP */
#if defined(CONFIG_SDK_CHIP_FEATURE_PARSER)
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PARSER_FIELD_SELTOR_CTRL_RTL8390,
#endif
#if defined(CONFIG_SDK_RTL8390)
    INT_CYPRESS_PARSER_CTRL_RTL8390,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PARSER */

    INT_CYPRESS_REG_LIST_END,
} rtk_int_cypress_reg_list_t;


typedef enum rtk_cypress_regField_list_e
{
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ECO_DUMMYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ECO_ENCAP_TCAM_BIST_DISf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ECO_SPCL_CNGSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ECO_JAM_BKPRES_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RESERVEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OUTPUT_1588_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALL_SERDES_SGMII_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_I2C_DATA_ENDIAN_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLK_25M_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPI_SIO_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MED_10G_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DDR_TYPE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPI_CS_IF_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REG_IF_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_JTAG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SERDES_SPD_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDX_IO_SLEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDX_IO_DRIV_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDX_CLK_SLEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDX_CLK_DRIV_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_IO_SLEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_IO_DRIV_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_CLK_SLEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_CLK_DRIV_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPI_IO_SLEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPI_IO_DRIV_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPI_CLK_SLEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPI_CLK_DRIV_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPIS_IO_SLEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPIS_IO_DRIV_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SYS_READYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_UNTAG_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_MSTI_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ROUTING_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_LOG_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_METER_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_ACL_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_VLAN_EGR_CNVT_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_VLAN_IGR_CNVT_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_VLAN_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_MC_PMSK_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_L2_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_MEM_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_SERDES_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_NIC_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_Q_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_FRC_EN_STAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_POR_1V_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_POR_3V_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_RST_DURf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IBIAS_FILTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CLKSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CLKSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CLKSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EN_PLL_MONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SEL_PLL_MONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_IF_PLLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_SW_PLLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_MEM_PLLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_LXB_PLLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_CPU_PLLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EN_MEM_PLLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EN_LXB_PLLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EN_CPU_PLLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_FCODE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_DIVN2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_NCODE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_BYPASS_PIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_SEL_D4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_SEL_PREDIVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_DIVN2_SELBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_DIVN3_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_SSC_ORDERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_EN_SSCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_STEP_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_TBASE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_TIME2_RST_WIDTHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_TIME0_CKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_CLKRDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_BIG_KVCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_LPF_RSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_EN_CENTER_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_EN_WDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_PI_I_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_SEL_CP_If,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_SEL_CCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_LDO_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_LPF_CPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_CP_NEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_LDO_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_VC_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CMU_EN_CKOOBSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_TEST_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_FCODE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_DIVN2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_NCODE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_BYPASS_PIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_SEL_D4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_SEL_PREDIVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_DIVN2_SELBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_DIVN3_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_SSC_ORDERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_EN_SSCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_STEP_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_TBASE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_TIME2_RST_WIDTHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_TIME0_CKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_CLKRDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_BIG_KVCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_LPF_RSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_EN_CENTER_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_EN_WDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_PI_I_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_SEL_CP_If,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_SEL_CCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_LDO_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_SEL_CPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_CP_NEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_LDO_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_VC_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_CMU_EN_CKOOBSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LXB_TEST_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_FCODE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_DIVN2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_NCODE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_BYPASS_PIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_SEL_D4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_SEL_PREDIVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_DIVN2_SELBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_DIVN3_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_SSC_ORDERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_EN_SSCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_STEP_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_TBASE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_TIME2_RST_WIDTHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_TIME0_CKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_CLKRDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_BIG_KVCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_LPF_RSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_EN_CENTER_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_EN_WDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_PI_I_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_SEL_CP_If,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_SEL_CCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_LDO_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_LPF_CPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_CP_NEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_LDO_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_VC_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_CMU_EN_CKOOBSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEM_TEST_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_FCODE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_DIVN2_SELBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_NCODE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_BYPASS_PIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_SEL_D4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_SEL_PREDIVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_TIME2_RST_WIDTHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_TIME0_CKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_CLKRDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_BIG_KVCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_LPF_RSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_EN_CENTER_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_EN_WDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_PI_I_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_SEL_CP_If,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_SEL_CCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_LDO_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_LPF_CPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_CP_NEW_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_LDO_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_VC_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_EN_CKOOBSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_TEST_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_SSC_ORDERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_EN_SSCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_STEP_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CMU_TBASE_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PLL_REG_BGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REG_BGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REG_CKREFBUF_CTRL3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REG_CKREFBUF_CTRL2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REG_CKREFBUF_CTRL1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REG_CKREFBUF_CTRL0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_EXT_CPUf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_LINK_STS_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_MEDIA_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_FEFIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_PORT_EEE_STS_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_TIMESTAMP_LATCH_PORT36f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_TIMESTAMP_LATCH_PORT24f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_SERDES_LINK_FAULTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_EXT_GPIOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_TM1_LOWf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_TM1_HIGHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_TM0_LOWf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_TM0_HIGHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_ETHDMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_OAM_DYGASPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMR_CCMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_EXT_GPIOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_ETHDMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_OAM_DYGASPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_CCMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_TIMESTAMP_LATCHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_EEE_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_SERDESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_FEFIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_MEDIA_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_GLB_LINK_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_LINK_STS_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_MEDIA_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_FEFIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_PORT_EEE_STS_CHGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_TIMESTAMP_LATCH_PORT36f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_TIMESTAMP_LATCH_PORT24f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_SERDES_LINK_FAULTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_EXT_GPIOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_TM1_LOWf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_TM1_HIGHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_TM0_LOWf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_TM0_HIGHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_ETHDMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_OAM_DYGASPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ISR_CCMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GPIO_INT_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_DISABLE_OQ_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_DONE_OQ_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BIST_DONE_OQ_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BIST_PAUSE_OQ_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_INFO_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_INFO_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_INFO_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_INFO_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_DISABLE_OQ_LLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_DONE_OQ_LLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BIST_DONE_OQ_LLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BIST_PAUSE_OQ_LLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_LL_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_LL_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_LL_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_LL_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_LL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_LL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_LL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_OQ_LL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_LL_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_LL_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_LL_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_LL_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_LL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_LL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_LL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_OQ_LL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BISR_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BISR_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_REPAIREDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_FAIL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_FAIL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_FAIL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_OUT_Hf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_OUT_Lf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DVSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DVSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_9f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_9f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DVSE_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DVS_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_PORT5_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_PORT4_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_PORT3_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_PORT2_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_PORT1_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_PORT0_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT5_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT4_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT3_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT2_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT1_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT0_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE01_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE01_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE01_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE01_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE01_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE01_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE01_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE01_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE02_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE02_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE03_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE03_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE04_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE04_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE04_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE04_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE04_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE04_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE05_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE05_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE05_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE05_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE05_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE05_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE05_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE05_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE05_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE05_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE05_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE05_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE05_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE05_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE06_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE06_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE06_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE06_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE06_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE06_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE06_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE06_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE06_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE06_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE06_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE06_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE06_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE06_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE06_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE06_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE07_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE07_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE07_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE07_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE07_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE07_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE07_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE07_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE07_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE07_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE07_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE07_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE07_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE07_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE07_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE07_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE08_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE08_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE08_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE08_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE08_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE08_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE08_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE08_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE08_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE08_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE09_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE09_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE09_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE09_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE10_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE10_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE10_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE10_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE11_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE11_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE11_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE11_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE11_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE11_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE11_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE11_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE11_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE11_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE11_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE11_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE11_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE11_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE11_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE11_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_DRF_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_9_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_4_DRF_FAIL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_4_DRF_FAIL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_4_DRF_FAIL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_4_DRF_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_4_FAIL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_4_FAIL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_4_FAIL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCAM_128_4_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BCAM_128_4_DRF_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BCAM_128_4_FAIL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_ALE12_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REPAIR_ALE12_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAIL_ALE12_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_FAIL_HSB_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_FAIL_HSB_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_FAIL_HSB_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_FAIL_HSB_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_FAIL_HSB_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_FAIL_HSB_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_DRF_FAIL_PTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_BIST_FAIL_HSB_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_BIST_FAIL_HSB_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_BIST_FAIL_HSB_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_BIST_FAIL_HSB_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_BIST_FAIL_HSB_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_BIST_FAIL_HSB_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW05_BIST_FAIL_PTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TYPE_1_MEM_DVSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TYPE_1_MEM_DVSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_L_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_L_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_L_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_L_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_L_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_H_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_H_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_H_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_H_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_DRF_FAIL_CELL_H_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_L_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_L_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_L_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_L_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_L_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_H_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_H_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_H_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_H_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW01_BIST_FAIL_CELL_H_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW02_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW02_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW02_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW02_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW02_DRF_FAIL_LLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW02_BIST_FAIL_LLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW03_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW03_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW03_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW03_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW03_DRF_FAIL_CCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW03_BIST_FAIL_CCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_DRF_FAIL_R1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_DRF_FAIL_R0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_DRF_FAIL_FPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_BIST_FAIL_R1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_BIST_FAIL_R0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW04_BIST_FAIL_FPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBISR_SW07_DISABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_DONE_SW07f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BISR_DONE_SW07f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BISR_PAUSE_SW07f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_BISR_FAIL_SW07f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_REPAIR_SW07f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BISR_FAIL_SW07f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_FAIL_PKB1_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_FAIL_PKB1_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_FAIL_PKB0_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_FAIL_PKB0_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_FAIL_PKB0_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_FAIL_PKB0_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_FAIL_PKB0_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_DRF_FAIL_PKB0_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_FAIL_PKB1_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_FAIL_PKB1_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_FAIL_PKB0_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_FAIL_PKB0_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_FAIL_PKB0_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_FAIL_PKB0_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_FAIL_PKB0_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_0_BIST_FAIL_PKB0_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_FAIL_PKB2_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_FAIL_PKB2_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_FAIL_PKB2_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_FAIL_PKB2_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_FAIL_PKB1_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_FAIL_PKB1_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_FAIL_PKB1_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_DRF_FAIL_PKB1_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_FAIL_PKB2_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_FAIL_PKB2_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_FAIL_PKB2_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_FAIL_PKB2_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_FAIL_PKB1_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_FAIL_PKB1_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_FAIL_PKB1_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_1_BIST_FAIL_PKB1_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_BIST_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_FAIL_PKB3_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_FAIL_PKB3_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_FAIL_PKB3_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_FAIL_PKB3_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_FAIL_PKB3_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_FAIL_PKB3_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_FAIL_PKB2_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_DRF_FAIL_PKB2_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_FAIL_PKB3_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_FAIL_PKB3_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_FAIL_PKB3_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_FAIL_PKB3_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_FAIL_PKB3_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_FAIL_PKB3_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_FAIL_PKB2_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MBIST_SW07_2_BIST_FAIL_PKB2_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ADDR_1_VLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ADDR_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ADDR_0_VLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ADDR_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ADDR_3_VLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ADDR_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ADDR_2_VLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ADDR_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TYPE_2_MEM_DVSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TYPE_2_MEM_DVSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_BISR_STARTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_BIST_STARTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DIS_SOC_BISTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DIS_SWC_BISTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DIS_MAC_BISTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DIS_ALE_BISTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TEST_ALL_BISTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_DRF_TCAM_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_DRF_TCAM_MODE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_BISR_CORNERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_BISR_HOLD_REMAPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_DRF_RESUMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_DRF_MODE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_BISR_MODE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_BIST_MODE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_DRF_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_DRF_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_DRF_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_BIST_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SOC_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SWC_DRF_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SWC_DRF_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SWC_DRF_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SWC_BIST_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SWC_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_DRF_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_DRF_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_DRF_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_BIST_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DRF_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DRF_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DRF_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_BIST_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_DRF_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_DRF_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_DRF_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_BIST_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_BIST_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_BISR_DRF_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_BISR_DRF_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_BISR_DRF_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_BISR_REPAIRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_BISR_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_BISR_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_TCAM_DRF_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_TCAM_DRF_PAUSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_TCAM_DRF_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_ACTIVEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLINK_TIME_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_CLK_DUTY_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_GPIO_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_LOAD_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SYS_LED_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SYS_LED_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STEP2_PWR_ON_LEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STEP1_PWR_ON_LEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PWR_ON_BLINK_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_MDC_DUTY_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_NUM_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_IF_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET3_LED2_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET3_LED1_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET3_LED0_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET2_LED2_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET2_LED1_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET2_LED0_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET1_LED2_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET1_LED1_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET1_LED0_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET0_LED2_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET0_LED1_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SET0_LED0_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_COPR_SET_PSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_FIB_SET_PSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_COPR_PMASKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIB_PMASKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LED_COMBOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_LED_LOADf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CTRL_LED_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_FIB_LED2_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_FIB_LED1_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_FIB_LED0_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_COPR_LED2_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_COPR_LED1_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_COPR_LED0_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_GPIO_DIRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_GPIO_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GPIO_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GPIO_REGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GPIO_PHY_ADDRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GPIO_RWOPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GPIO_CMDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV1_THR_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV2_THR_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV3_THR_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV1_THR_1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV2_THR_1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV3_THR_1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV1_THR_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV2_THR_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV3_THR_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV1_THR_10Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV2_THR_10Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LV3_THR_10Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_LOAD_CNTR_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_LOAD_CNTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BUZZER_FREQ_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BUZZER_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_CTRL_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_ACCESS_BUSYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_CMDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_RWOPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_ADDRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_WRITE_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_READ_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TMRFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VOL_CTRL_RESIS_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_LOWCMP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_LOW_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_HIGHCMP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_HIGH_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_REVERSE_CMP_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_ENABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_PWRON_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_COMPARE_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_SAMPLE_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_DATA_SAMPLEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_DATA_VALIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM0_TEMP_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_LOWCMP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_LOW_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_HIGHCMP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_HIGH_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_REVERSE_CMP_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_ENABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_PWRON_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_COMPARE_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_SAMPLE_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_DATA_SAMPLEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_DATA_VALIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TM1_TEMP_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_WSORT_GO_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_WSORT_GO_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_DATA_READY_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_DATA_READY_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_DATA_IN_READYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS__WIRE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_RO_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_RST_Nf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_DATA_IN_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_DATA_IN_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_DATA_OUT_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSS_DATA_OUT_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RTL_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MODEL_CHAR_1STf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MODEL_CHAR_2NDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CHIP_INFO_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CHIP_VERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RL_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKUP_DLY_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CRC_RC_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_DROP_48PASS1_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAX_RETX_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EFUSE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INBAND_ABORT_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_CLK_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DDR_CLK_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IOL_PAUSE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LATE_COLI_DROP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IOL_LEN_ERR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IOL_MAX_RETRY_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LIMIT_PAUSE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BKOFF_SPDUPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BKOFF_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HALF_48PASS1_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BKPRES_MTHD_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DEFER_IPG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPG_1G_COMPS_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPG_1G_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPG_10G_COMPS_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPG_10G_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PHY_ABLTY_GET_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PHY_ACCESS_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PADDING_UND_SIZE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_CLKSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BOND_OPTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_EGR_CNVT_SHRINK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_IGR_CNVT_SHRINK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MC_SHRINK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_SHRINK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_SHRINK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_BUF_SIZE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_CPU_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_APP_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CHIP_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAX_LEN_TAG_INCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAX_LEN_100M_10M_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAX_LEN_10G_1G_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_MAC_ADDR_47_32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW_MAC_ADDR_31_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPG_MIN_RX_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPG_LENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYP_TX_CRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PASS_ALL_MODE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LATE_COLI_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_CHK_CRC_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BKPRES_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FORCE_500M_SPDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_1000M_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_500M_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_100M_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_10G_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_1000M_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_500M_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_100M_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_FORCE_FC_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_PAUSE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PAUSE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DUP_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FORCE_LINK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_FORCE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINK_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEDIA_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DUP_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PAUSE_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_PAUSE_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_ABLTYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FEFI_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_TAG_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PARK_PAGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAIN_PAGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BROADCASTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RWOPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CMDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_PAGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PHYMSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BROADCAST_PHYIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INDATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MMD_DEVADf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MMD_REGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDIO_FREE_CNT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDIO_FREE_CNT_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDX_POLLING_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMI_FREQ_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMI_POLLING_START_ADDRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMI_POLLING_PMSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BND_POLL_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BIST_DISf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FULL_DETECT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REF_RX_CONGESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CHG_DUP_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINK_500M_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMI_POLLING_500M_PMSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINK_DOWN_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PADDING_CONTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINK_DOWN_TIME_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDX_SPDUPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_ABLTY_LOCKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ABLTY_SPDUPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ABORT_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TMOUT_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKUP_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKUP_DLY_10Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MODE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPI_MODE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_XTAL_CLK_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORIGINAL_CRSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORIGINAL_COLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_CFG_PTR_ERR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_CFG_AUTO_10BITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_CFG_FULL_ACK2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_CFG_NXP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_SDS_FRC_RXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_CFG_HSG_RTIGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_CFG_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_CFG_RG1X54f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR1_SDS_FRC_TXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_DIS_RENWAYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_BYP_8B10Bf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_CDETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_DIS_TMR_CMAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_DIS_APXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_INV_HSIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_INV_HSOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_SDS_SDET_DEGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_CODEC_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_AFE_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_REMOTE_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_SDS_TX_DOWNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_SDS_EN_RXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR0_SDS_EN_TXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_WR_SOFT_RSTBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_USE_25M_CLKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_MARK_CARR_EXTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_SEL_DEGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_REG_CALIB_OK_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_EXT_PWR_CTLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_SOFT_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_CLR_SOFT_RSTBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR3_CMA_RQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR2_FRC_PREAMBLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR2_FRC_IPGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR2_FRC_CGGOODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR2_SDS_FRC_ANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR2_CFG_INS_IPG_MDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR2_CFG_RDS_CMA_DETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR2_CFG_SEL_TMR_LIMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR2_SDS_RESTART_ANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_LPI_TRANSMIT_STYLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_PWRSV_INB_PERIODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_PWRSV_WAKEUP_C2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_PWRSV_WAKEUP_C1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_CFG_MARK_CARR_EXT_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_REG_PCSREQ_POSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_CFG_INBTOUT_LEVELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_CFG_SUDINBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_CFG_PCSRDABT_LDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_CFG_AN_UZf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR5_CFG_INBAND_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR4_CFG_FRC_SDS_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR4_CFG_FRC_SDS_MODE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR4_CFG_UPD_RXDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR4_CFG_UPD_TXDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR4_CFG_UPD_RXD_DYNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR4_CFG_EN_LINK_FIB1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR4_CFG_EN_LINK_SGMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR4_CFG_SGM_CK_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_CFG_8B10B_NO_CREXTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_CFG_NEG_CLKWR_A2Df,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_CFG_MIIXF_TS1Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_CFG_DLY_PRE8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_CFG_GRXD_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_CFG_LPI_CMD_MIIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_CFG_MARK_RXSCR_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_CFG_MARK_TXSCR_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_BYP_STARTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR7_BYP_ENDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR6_CFG_NO_GIGA_SCMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR6_CFG_RE_SYNC_STYLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR6_CFG_SYNC_GATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR6_CFG_BYPSCR_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR6_RX_BYPSCRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR6_CFG_SLP_RQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR6_TX_BYPSCRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR9_CFG_EEE_PROGRAM_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR8_CFG_EEE_PWRSAV_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR8_REG_EEE_SDS_ANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR8_REG_C3_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR8_REG_C2_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR8_REG_C1_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR8_REG_C0_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR8_CFG_MAC_C1_CHG_RESTC3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR8_CFG_PHY_GO_C1_COND_SPCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR11_CFG_EEE_DBG_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_CFG_RG10X1512f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_QSGMII_NO_DILE2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_QSGMII_EEE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_QSGMII_LPI_TX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_QSGMII_LPI_RX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_QSGMII_INB_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_QSGMII_RXER_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_CFG_FAST_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR10_EEE_LINK_FASTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR13_SDS_LK_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR13_CFG_APXT_TMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR12_CFG_INB_TIMEOUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR12_ABILITYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR12_RDM_ALGORf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR12_SD_DET_ALGORf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR12_AUTO_DET_ALGORf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR12_SEND_NP_ONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR15_CFG_INBAND_MASTER_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_SPDUPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_SPDUP_FIB100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_RXSLEEP_TMROUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_SEL_CALIBOKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_SEL_SDETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_SEL_ANOKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_SEL_ODD_BITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_FRC_LD_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_FRC_LDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_SGMI_CK1MS_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_LINK_TMR_SGMII_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR14_CFG_LINK_TMR_NORM_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR17_MACRDVLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR17_MACRDABTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR17_CFG_INBAND_MASTER_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR16_CFG_INBAND_MASTER_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR19_CFG_RSGP_TXCFG_MACf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR18_CFG_RSGP_TXCFG_PHYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR21_CFG_SGM_TXCFG_MACf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR20_CFG_SGM_TXCFG_PHYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR23_CFG_FIB2G_TXCFG_P1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR22_CFG_FIB2G_TXCFG_P0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR25_CFG_FIB2G_TXCFG_NP_P1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR24_CFG_FIB2G_TXCFG_NP_P0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR27_CFG_DBG_OUT_ECO1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR26_IP_VERSIONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR26_SDS_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR29_CFG_SDS_DBG_OUT_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR28_CFG_PHY_GO_C2_COND_SPCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR28_CFG_ERRMSK_NOSIGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR28_RM_LPK_EVEN_BITSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR28_CFG_QSGMII_PARITY_CHKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR28_CFG_DBG_S0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR28_CFG_SDS_DBG_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR28_CFG_SDS_DBG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SR30_CFG_SDS_DBG_OUT_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE1_ANA_RG1Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE0_ANA_RG0Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE3_ANA_RG3Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE2_ANA_RG2Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE5_ANA_RG5Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE4_ANA_RG4Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE7_ANA_RG7Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE6_ANA_RG6Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE9_ANA_RG9Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE8_ANA_RG8Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE11_ANA_RG11Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE10_ANA_RG10Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE13_CFG_NEG_GTXCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE13_CFG_LP_CNT_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE13_CFG_EPON_SYNC_SMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE13_CFG_DYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE12_ANA_RG12Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE12_CFG_IPG_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE15_ANA_RG15Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE15_CFG_LP_CNT_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE15_CFG_EPONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE15_CFG_DXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE14_ANA_RG14Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE16_CFG_DY_8Bf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE16_CFG_DX_8Bf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE25_ALL_SYMBOLERR_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE25_MUX_SYMBOLERR_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_SD_Hf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_RG24X14f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_HYSDETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_D2A_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_HAM_PTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_ENTXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_CMALI_SIGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_TMR_ALIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE24_CFG_SYMBOLERR_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE27_CFG_DBG_STATUS_ECO_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE26_P3LNKDOWNCNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE26_P2LNKDOWNCNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE26_P1LNKDOWNCNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE26_P0LNKDOWNCNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE29_CFG_DBG_STATUS_ECO_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE29_SIGNOK_LATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE29_LINKOK_LATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE29_SYNCOK_LATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE28_CFG_DBG_STATUS_ECO_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE30_CFG_DBG_STATUS_ECO_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE30_SIGNOKSTATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE30_LINKOKSTATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SRE30_SYNCOKSTATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR1_CAPBILITYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR1_AN_COMPLETEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR1_R_FAULTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR1_NWAY_ABILITYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR1_LINK_STATUSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR1_JABBER_DETECTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR1_EXTENDED_CAPBILITYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_SPD_RD_00f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_ANENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_PDOWNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_ISOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_RESTARTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_FULLDUPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_SPD_RD_01f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR0_CFG_FIB_FRCTXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR3_REALTEK_OUI_0500f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR3_MODEL_NO_0500f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR3_REVISION_NO_0300f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR2_REALTEK_OUI_2106f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR5_RX_CFG_REGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR4_TX_CFG_REGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR7_MR_NP_TXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR6_FIB_NP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR6_RXPAGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR8_MR_NP_RXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR13_INDR_FUNCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR13_DUMMY_REG13_1305f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR13_INDR_DEVADf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR14_MMDRDBUSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR17_ANA_RG3Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR16_ANA_RG2Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR19_ANA_RG5Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR18_ANA_RG4Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR21_ANA_RG7Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR20_ANA_RG6Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR23_QSGM_TXCFG_MACf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR22_QSGM_TXCFG_PHYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR25_ANA_RG13Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR24_ANA_RG12Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR27_ANA_RG15Xf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR29_CFG_AUTO_DET_ONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR29_CFG_TOUT_MAXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR29_CFG_STATE_TMRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR29_CFG_TEST_TMRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR28_CFG_CONS1_MAXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR28_CFG_CONS0_MAXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR28_CFG_CNT_MINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR30_CFG_RG30X1512f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR30_CFG_STATMR_LEVELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR30_CFG_CNTENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR30_CFG_CONSENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR30_CFG_STATMR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FR30_CFG_LNK_ON_TMRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE1_CAPBILITYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE1_AN_COMPLETEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE1_R_FAULTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE1_NWAY_ABILITYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE1_LINK_STATUSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE1_JABBER_DETECTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE1_EXTENDED_CAPBILITYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_SPD_RD_00f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_ANENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_PDOWNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_ISOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_RESTARTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_FULLDUPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_SPD_RD_01f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE0_CFG_FIB_FRCTXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE3_REALTEK_OUI_0500f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE3_MODEL_NO_0500f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE3_REVISION_NO_0300f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE2_REALTEK_OUI_2106f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE5_RX_CFG_REGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE4_TX_CFG_REGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE7_MR_NP_TXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE6_FIB_NP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE6_RXPAGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE8_MR_NP_RXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE13_INDR_FUNCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE13_DUMMY_REG13_1305f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE13_INDR_DEVADf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE14_MMDRDBUSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE17_DUMMY_REG17_1505f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE17_EEE_RSG_FIB100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE17_EEE_STD_FIB100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE17_C1_PWRSAV_EN_FIB100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE17_C2_PWRSAV_EN_FIB100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE17_EEE_QUIET_FIB100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_DUMMY_REG16_15f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_RSG_FIB1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_STD_FIB1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_C1_PWRSAV_EN_FIB1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_C2_PWRSAV_EN_FIB1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_QUIET_FIB1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_RSG_QSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_STD_QSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_C1_PWRSAV_EN_QSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_C2_PWRSAV_EN_QSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_QUIET_QSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_RSG_RSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_STD_RSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_C1_PWRSAV_EN_RSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_C2_PWRSAV_EN_RSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE16_EEE_QUIET_RSGPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE19_CFG_TX_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE19_DET_IDLE32_DISf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE19_DET_CG_DISf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE19_CFG_LINK_OK_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE19_RX_TS_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE19_RX_WF_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE19_RX_TW_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE19_RX_TQ_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE18_DUMMY_REG18_1509f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE18_TX_TR_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE18_TX_TQ_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE18_TX_TS_TIMERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE21_DUMMY_REG21_1513f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE21_DUMMY_REG21_1204f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE21_DUMMY_REG21_0300f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE20_CFG_SFD_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE20_CFG_IDLE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE20_CFG_CG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE20_CFG_IDLE32_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE20_CFG_IDLE_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE20_CFG_CG_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE23_DUMMY_REG23_1508f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE23_CFG_SILENT_PROB_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE23_CFG_LINK_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE23_DUMMY_REG23_0200f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE22_CFG_EPON_INTENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE22_CFG_LINK_INTENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE22_DUMMY_REG22_1302f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE22_DET_EPON_INTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRE22_SDS_LINK_INTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_ICP_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_VCP_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_HSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_LSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCBIAS_LPF_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCVCO_HSMODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_CPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_Rf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG00_1500f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SELPREDIVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_INJ_MODE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LOCKDET_REF_DIV_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_CSMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_VI_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CKLC_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_EN_WDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_CLKRDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIME0_CKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCVCO_TRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_LOOP_DIVNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_LOOP_DIV4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_VSEL_LREGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TESTENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_DIVIDE_NUMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LOCK_UP_LIMITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIME2_RST_WIDTHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_AUTO_Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_AUTO_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CALIB_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CALIB_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CP_EN_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CP_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_DM_0_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_INIT_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CLKOUT_Df,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CLKOUT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_DM_1_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_BGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IB_CENTER_FILTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IB_LANE_FILTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IBRX_BOOSTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IBTX_BOOSTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IBRXSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IBTXSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FLD_DSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_VCO_COARSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LOCK_DN_LIMITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_CALIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_CALSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_CKSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_FORCECALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_FREQSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_NSQDLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_RXIDLE_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_SENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_VCMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_Z0_NADJRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_Z0_NAUTO_Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_Z0_PADJRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_Z0_PAUTO_Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_Z0_TUNEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_Z0_TESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_GLB_DMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_KDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_KIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_KP1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_KP2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_PWR_DWN_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_PWR_DWN_CYCLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_DATA_ORDERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_SEL_TESTOUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_BYPASS_SDM_INTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_EN_LPF_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_INT_INITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_ST_M_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_PI_M_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_RESET_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_RESET_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_DMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_ACC2_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_ACC2_PERIODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_SQU_TRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CDR_EN_M_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EQ_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_IDLE_SPDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_IQDSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_OFFSET_ADJRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_OFFSET_AUTO_Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_OFFSET_RANGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN_CLKREQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN_SATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RXDSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_DCVS_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EN_KOFFSETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EN_SELFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EN_TESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EQ2SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EQ_EN_SLICERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EQ_GAINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EQ_HOLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EQ_SELREGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_FORCERUNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_TIMER_LPFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_SPDSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_125M_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_DMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OFFSET_DIG_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_PIENSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_PSAVE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_PS_AFEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_SEL_RXIDLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_D2S_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_TIMER_BERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_TIMER_EQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_DRV_DAC_DATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_DRV_DAC_POST1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_DRV_DAC_POST0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SWINGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_VREF_CTRLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_VCM_CTRLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_EN_EMPHASEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG21_1500f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_BEAENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FORCE_RCVDETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_EN_VCM_RESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SEL_CKRD_DUTYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SEL_VCMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_EN_TESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SWING25f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_DMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG01_1512f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG01_11f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG01_1009f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG01_1807f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG01_06f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG01_05f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG01_0403f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG01_0200f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG00_1500f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_1514f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_13f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_12f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_1110f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_0907f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_06f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_05f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_0403f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG03_0200f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG02_1511f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG02_1006f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG02_0504f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG02_0301f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG02_00f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG05_1510f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG05_0900f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_1514f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_13f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_12f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_11f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_1008f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_07f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_0604f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_03f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG04_0200f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG07_1513f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG07_1211f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG07_10f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG07_0908f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG07_07f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IB_LANE_FILTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IBRX_BOOSTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IBTX_BOOSTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IBRXSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IBTXSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG06_15f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG06_1410f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG06_0900f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_CALIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_CALSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_CKSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_FORCECALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_FREQSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_NSQDLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_RXIDLE_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_SENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_VCMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG08_1512f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG08_11f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG08_1007f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG08_06f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG08_05f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG08_04f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG08_0300f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_KDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_KIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_KP1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_KP2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_PWR_DWN_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_PWR_DWN_CYCLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_DATA_ORDERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_SEL_TESTOUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_BYPASS_SDM_INTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_EN_LPF_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_INT_INITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_ST_M_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_PI_M_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_RESET_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_RESET_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG13_0700f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_ACC2_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_ACC2_PERIODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_SQU_TRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CDR_EN_M_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EQ_INf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_IDLE_SPDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_IQDSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_OFFSET_ADJRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_OFFSET_AUTO_Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_OFFSET_RANGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN_CLKREQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN_SATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RXDSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_DCVS_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EN_KOFFSETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EN_SELFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EN_TESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EQ2SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EQ_EN_SLICERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EQ_GAINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EQ_HOLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EQ_SELREGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_FORCERUNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_TIMER_LPFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_SPDSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_125M_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG17_0700f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OFFSET_DIG_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_PIENSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_PSAVE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_PS_AFEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_SEL_RXIDLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_D2S_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_TIMER_BERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_TIMER_EQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_DRV_DAC_DATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_DRV_DAC_POST1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_DRV_DAC_POST0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SWINGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_DLYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_VREF_CTRLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_VCM_CTRLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_EN_EMPHASEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG21_1500f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_BEAENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FORCE_RCVDETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_EN_VCM_RESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SEL_CKRD_DUTYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SEL_VCMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_EN_TESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SWING25f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_DMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE1_FAULT_DETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE1_RX_LINKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE1_LO_PWR_ABLTYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE0_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE0_LPBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE0_SPD_SEL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE0_LO_PWRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE0_SPD_SEL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE0_SPD_TYPE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE2_3_DEV_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE5_NWAY_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE5_TC_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE5_DTE_XS_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE5_PHY_XS_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE5_PCS_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE5_WIS_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE5_PMA_PMD_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE5_CLAUSE_22_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE4_10G_CAPABLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE6_VNDR_SPEC_DEV_2_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE6_VNDR_SPEC_DEV_1_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE6_CLAUSE_22_EXT_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE8_DEV_PRSNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE8_TX_FAULTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE8_RX_FAULTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE14_15_PKG_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE25_TEST_PTRN_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE25_TEST_PTRN_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE24_DTE_XGXS_LANE_ALGNMNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE24_TEST_PTRN_ABLTYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE24_IGNOREDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE24_LANE_3_SYNCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE24_LANE_2_SYNCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE24_LANE_1_SYNCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DTE24_LANE_0_SYNCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_INV_HSO_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_INV_HSO_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_INV_HSI_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_INV_HSI_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_CLK_RD_INV_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_CLK_RD_INV_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_CLK_WR_INV_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_CLK_WR_INV_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_RS_BYPASSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_RS_RTLPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_RS_TRLPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_DIG_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_REM_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_AFE_LPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_XGM_RTLPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX1_CFG_XGM_TRLPKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_TXCG_DBGIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_PUDI_DBGIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_D2A_DBGIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_A2D_DBGIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_DUMMY_1110f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_PRBS7_GENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_JT_CPATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_TQ_TMRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_INVLD_CNT_2_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_RST_FIFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_TGX_RFENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_TGX_TFENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX0_CFG_EEE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_DUMMY_1514f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_HAMPTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_SM_RESETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_RXIDLEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_RXIDLE_HYS_1_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_EEE_RXCTLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_EEE_TXCTLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_V2ANALOGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_PDOWNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_CMU_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_RX_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_RX_CLKWRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_RX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX2_CFG_FRC_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX13_DUMMY_1507f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX13_CFG_MAC_CLK_DISf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX13_DBG_RXAUI_SEL_1_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX13_DBG81_SEL_3_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX12_DBG_SEL_15_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX14_BITERR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX14_ENABLE_CNT_4_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX14_COUNTER_NUM_3_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGX14_ERR_BIT_NUM_3_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_BIAS_PICORE_KPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_INT_INITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_BIAS_PICORE_KIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_BIAS_STRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ACC2_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ACC2_PERIODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_BITSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_LO_BND2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_LO_BND1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_LO_BND0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CLKLA_AMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CK25MO_E4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CK25MO_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_UP_BND3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_UP_BND2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_BIAS_PIFINE_KIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_PERIOD1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_PERIOD0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RELOAD_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_UP_BND1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_UP_BND0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_LO_BND3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ST2_INIT_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_BIAS_PIFINE_KPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_PERIOD3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_PERIOD2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LPFEN_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OCHOLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OC_SLICERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OC_SELREGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OC_GAINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN2_INIT_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ST_M_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ST_M_VALUE_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_BYPASS_SDM_INTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_EQ3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_EQ2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_EQ1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_OEB_CKPIO13f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_EQ0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_DCCALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_BERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_SLICER3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_SLICER2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_SLICER1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_SLICER0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_EQHOLD3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_EQHOLD2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQHOLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_EQHOLD1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIMER_EQHOLD0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CK25MO_E32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_DBG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_GAIN3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_GAIN2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_GAIN1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_GAIN0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OFFSET_ADJRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_SEN_VALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OC_PERIODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCVCO_TR_3_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCVCO_TR_2_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCVCO_TR_1_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCVCO_TR_0_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OFFSET_RANGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OFFSET_AUTOKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN_KOFFSETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TESTOUT_SEL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TESTOUT_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_SQU_TRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_DATA_EN_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_CLKWR_EN_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RESET_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_VCM_RESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ZTUNEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ZTESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_WDCKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IB_FILTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_SINGVCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_LS_1_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_LS_0_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CLKRDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ADP_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG1514_3116f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_DATA_TRANSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN_M_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FILTER_OUT0_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_SELREG_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_IN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FILTER_OUT0_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_SELREG_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EQ_IN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EQ_BOOST_DC_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FILTER_OUT3_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FILTER_OUT2_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FILTER_OUT1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EQ_BOOST_DC_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FILTER_OUT3_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FILTER_OUT2_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_FILTER_OUT1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ST2_M_VALUE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ST2_M_VALUE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CLKLA_EN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KI_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KD_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KP2_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KP1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KP1_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CLKLA_EN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KI_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KD_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KP2_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KP1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_KP1_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PR1_KP_RSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PR2_KI_RSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_VCM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_HOLD_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI2_HOLD_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_HOLD_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OFFSET_SR_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OFFSET_IH_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_FREQ_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_IBX_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PR1_KP_RSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PR2_KI_RSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_VCM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_HOLD_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI2_HOLD_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_HOLD_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OFFSET_SR_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OFFSET_IH_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_FREQ_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_IBX_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EN_SELF_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_RXIDLE_MANUAL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_CKSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI2_M_MODE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_M_MODE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_M_MODE_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN2_M_VALUE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_NSQDLY_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_SWEN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RSSI_SEN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_CALI_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_EN_SELF_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_RXIDLE_MANUAL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_CKSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI2_M_MODE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_M_MODE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_PI_M_MODE_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN2_M_VALUE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_NSQDLY_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_SWEN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RSSI_SEN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_OOBS_CALI_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_DIVIDE_NUM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LOCK_DN_LIMIT_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_DIVIDE_NUM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LOCK_DN_LIMIT_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCVCO_HSMODE_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_LOOP_DIVN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LOCK_UP_LIMIT_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LCVCO_HSMODE_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_LOOP_DIVN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_LOCK_UP_LIMIT_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_HS_TG_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_HS_TG_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_CP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SELPREDIV_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_LOOP_DIV4_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_ICP_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_R_TG_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_R_TG_2_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_HS_XSG_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_HS_XSG_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_CP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SELPREDIV_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_LOOP_DIV4_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_ICP_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_R_XSG_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_R_XSG_2_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TXLA_IBXSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D2_AMP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D1_AMP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D0_AMP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TXLA_IBXSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D2_AMP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D1_AMP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D0_AMP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SEL_VCM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TXDLY_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_ADDMOS_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D2S_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TXLA_SENDB_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IBRX_BOOSTER_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IBTX_BOOSTER_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN_M_VALUE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_TAMP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SEL_VCM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TXDLY_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_ADDMOS_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D2S_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TXLA_SENDB_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IBRX_BOOSTER_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_IBTX_BOOSTER_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_EN_M_VALUE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_TAMP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_PRDRV_CM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D2_PN_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D1_PN_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D0_PN_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D2_EN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D1_EN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D0_EN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SPDSEL_DIG_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG2D2C_22f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_CKLC_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_CKDIV2_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SPDSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_CKLC_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_CKDIV2_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_PRDRV_CM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D2_PN_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D1_PN_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D0_PN_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D2_EN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D1_EN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_D0_EN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SPDSEL_DIG_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG2D2C_06f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_CKLC_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_RX_CKDIV2_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_SPDSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_CKLC_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TX_CKDIV2_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIME2_RST_WIDTH_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_VI_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_INJ_MODE_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_CSM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_VCO_COARSE_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_ISTANK_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_TIME2_RST_WIDTH_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_VI_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_INJ_MODE_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_SEL_CSM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_REG_CMU_VCO_COARSE_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG3130_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG3332_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG3534_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG3736_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG3938_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DUMMY_RG3B3A_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_RU1_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_OOBS_RSTBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_TGRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_TGXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_BER_NOTIFYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_CLKRDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_RXAUIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_CLK156_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_SPDSEL1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_SPDSEL0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_RST_BITERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_V2ANALOGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_RX_DATA_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_RX_CLKWR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_RX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_PDOWNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_CMU_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FRC_CLK156_2_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_RU0_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_RU2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_RU1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_LNK_SG_TMRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DONE_LVLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_FULLL_LVLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_RU0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_CHK_TMRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_SYMB_TMRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_EYE_WIDTHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S0_DIS_ADf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_BIAS_PICORE_KPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_INT_INITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_BIAS_PICORE_KIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_BIAS_STRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ACC2_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ACC2_PERIODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_BITSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_LO_BND2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_LO_BND1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_LO_BND0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CLKLA_AMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CK25MO_E4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CK25MO_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_UP_BND3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_UP_BND2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_BIAS_PIFINE_KIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_PERIOD1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_PERIOD0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RELOAD_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_UP_BND1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_UP_BND0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_LO_BND3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ST2_INIT_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_BIAS_PIFINE_KPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_PERIOD3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_PERIOD2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LPFEN_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OCHOLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OC_SLICERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OC_SELREGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OC_GAINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN2_INIT_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ST_M_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ST_M_VALUE_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_BYPASS_SDM_INTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_EQ3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_EQ2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_EQ1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_OEB_CKPIO13f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_EQ0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_DCCALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_BERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_SLICER3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_SLICER2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_SLICER1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_SLICER0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_EQHOLD3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_EQHOLD2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQHOLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_EQHOLD1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIMER_EQHOLD0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CK25MO_E32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_DBG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_GAIN3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_GAIN2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_GAIN1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_GAIN0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OFFSET_ADJRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_SEN_VALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OC_PERIODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_VSEL_LREGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LCVCO_TR_3_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LCVCO_TR_2_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LCVCO_TR_1_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LCVCO_TR_0_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_INIT_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CP_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CALIB_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OFFSET_RANGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OFFSET_AUTOKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN_KOFFSETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TESTOUT_SEL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TESTOUT_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_SQU_TRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_DATA_EN_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_CLKWR_EN_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RESET_MANUALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_VCM_RESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ZTUNEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ZTESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_Z0_PAUTO_Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_Z0_PADJRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_Z0_NAUTO_Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_Z0_NADJRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_WDCKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_EN_WDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IB_CENTER_FILTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IB_FILTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_SINGVCOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LCBIAS_LPF_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ISTANK_SEL_LS_1_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ISTANK_SEL_LS_0_f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FLD_DSELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_VCP_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_AUTO_Kf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CLKRDYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ADP_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG1514_3116f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_BGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_DATA_TRANSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN_M_VALUEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FILTER_OUT0_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_SELREG_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_IN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FILTER_OUT0_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_SELREG_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EQ_IN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EQ_BOOST_DC_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FILTER_OUT3_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FILTER_OUT2_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FILTER_OUT1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EQ_BOOST_DC_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FILTER_OUT3_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FILTER_OUT2_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_FILTER_OUT1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ST2_M_VALUE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ST2_M_VALUE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CLKLA_EN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KI_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KD_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KP2_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KP1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KP1_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CLKLA_EN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KI_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KD_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KP2_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KP1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_KP1_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PR1_KP_RSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PR2_KI_RSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_VCM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_HOLD_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI2_HOLD_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_HOLD_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OFFSET_SR_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OFFSET_IH_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_FREQ_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_IBX_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PR1_KP_RSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PR2_KI_RSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_VCM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_HOLD_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI2_HOLD_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_HOLD_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OFFSET_SR_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OFFSET_IH_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_FREQ_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_IBX_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EN_SELF_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_RXIDLE_MANUAL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_CKSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI2_M_MODE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_M_MODE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_M_MODE_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN2_M_VALUE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_NSQDLY_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_SWEN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RSSI_SEN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_CALI_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_EN_SELF_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_RXIDLE_MANUAL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_CKSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI2_M_MODE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_M_MODE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_PI_M_MODE_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN2_M_VALUE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_NSQDLY_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_SWEN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RSSI_SEN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_OOBS_CALI_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_DIVIDE_NUM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LOCK_DN_LIMIT_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_DIVIDE_NUM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LOCK_DN_LIMIT_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LCVCO_HSMODE_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_LOOP_DIVN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LOCK_UP_LIMIT_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LCVCO_HSMODE_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_LOOP_DIVN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_LOCK_UP_LIMIT_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ISTANK_SEL_HS_TG_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ISTANK_SEL_HS_TG_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_CP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SELPREDIV_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_LOOP_DIV4_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_ICP_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_R_TG_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_R_TG_2_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ISTANK_SEL_HS_XSG_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ISTANK_SEL_HS_XSG_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_CP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SELPREDIV_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_LOOP_DIV4_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_ICP_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_R_XSG_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_R_XSG_2_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TXLA_IBXSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D2_AMP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D1_AMP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D0_AMP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TXLA_IBXSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D2_AMP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D1_AMP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D0_AMP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SEL_VCM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TXDLY_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_ADDMOS_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D2S_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TXLA_SENDB_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IBRX_BOOSTER_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IBTX_BOOSTER_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN_M_VALUE_1_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_TAMP_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SEL_VCM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TXDLY_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_ADDMOS_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D2S_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TXLA_SENDB_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IBRX_BOOSTER_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_IBTX_BOOSTER_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_EN_M_VALUE_1_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_TAMP_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_PRDRV_CM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D2_PN_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D1_PN_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D0_PN_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D2_EN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D1_EN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D0_EN_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SPDSEL_DIG_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG2D2C_22f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_CKLC_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_CKDIV2_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SPDSEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_CKLC_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_CKDIV2_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_PRDRV_CM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D2_PN_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D1_PN_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D0_PN_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D2_EN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D1_EN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_D0_EN_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SPDSEL_DIG_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG2D2C_06f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_CKLC_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_RX_CKDIV2_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_SPDSEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_CKLC_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TX_CKDIV2_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ISTANK_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIME2_RST_WIDTH_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_VI_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_INJ_MODE_SEL_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_CSM_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_VCO_COARSE_TGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_ISTANK_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_TIME2_RST_WIDTH_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_VI_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_INJ_MODE_SEL_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_SEL_CSM_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_REG_CMU_VCO_COARSE_XSGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3130_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3332_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3534_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3736_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3938_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3B3A_3100f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_31_26f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_25f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_24f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_23f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_22f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_21f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_20f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_19f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_18f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_17_16f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_15_14f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_13_12f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_11_10f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_9_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_7_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_5_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_3_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3D3C_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_31f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_30_22f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_21f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_20f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_19_16f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_15f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_14f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_13f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_12_9f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_8_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_3_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_S1_DUMMY_RG3F3E_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LOW_Q_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HIGH_Qf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_LPI_MINIPG_GELITEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_LPI_MINIPG_FEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_LPI_MINIPG_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_LPI_MINIPG_GEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WAIT_RX_INACTIVE_TIMER_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WAIT_RX_INACTIVE_TIMER_GEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WAIT_RX_INACTIVE_TIMER_GELITEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MULTIWAKE_PORTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MULTIWAKE_INTLVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MULTIWAKE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINK_UP_DELAYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_WAKE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LOW_Q_TX_DELAY_FEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_WAKE_TIMER_FEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WAIT_RX_INACTIVE_GELITEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PAUSE_WAKE_TIMER_GELITEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LOW_Q_TX_DELAY_GELITEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_WAKE_TIMER_GELITEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WAIT_RX_INACTIVE_GEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PAUSE_WAKE_TIMER_GEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LOW_Q_TX_DELAY_GEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_WAKE_TIMER_GEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WAIT_RX_INACTIVE_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PAUSE_WAKE_TIMER_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LOW_Q_TX_DELAY_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_WAKE_TIMER_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_EEEP_TX_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_EEEP_RX_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_TX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_RX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TIMER_UNIT_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TIMER_UNIT_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TIMER_UNIT_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_THR_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_EN_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_THR_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_TIMER_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_EN_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_THR_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_TIMER_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_RATE_EN_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_WAKE_TIMER_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_WAKE_TIMER_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_WAKE_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_RATE_THR_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_RATE_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_RATE_THR_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_RATE_TIMER_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_RATE_THR_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_RATE_TIMER_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_SLEEP_STEP_MAXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_WAKE_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_MIN_SLEEP_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_SLEEP_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_PAUSE_ON_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_WAKE_TIMER_500M_MASTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_MIN_SLEEP_TIMER_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_SLEEP_TIMER_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_PAUSE_ON_TIMER_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_WAKE_TIMER_500M_SLAVEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_WAKE_TIMER_GIGA_MASTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_MIN_SLEEP_TIMER_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_SLEEP_TIMER_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_PAUSE_ON_TIMER_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_WAKE_TIMER_GIGA_SLAVEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SLOW_DOWN_SYS_CLKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_GATCLKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_GATCLKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_ENCP_GATCLKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_PASR_GATCLKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EGR_CTRL_GATCLKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_CTRL_GATCLKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKID_TIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKID_MAC_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKID_PE_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKID_PP_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKID_EC_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINKID_IC_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_ACTIVEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_MAC_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_PE_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_PP_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_EC_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_IC_GATCLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_PWR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_IDLE_TIMER_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_IDLE_TIMER_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_IDLE_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_IDLE_TIMER_GIGAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_IDLE_TIMER_500Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_IDLE_TIMER_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEEP_SLAVE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_TX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EEE_RX_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SECf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NSECf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXECf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PDELAY_RESP_SEQ_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PDELAY_REQ_SEQ_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DELAY_REQ_SEQ_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SYNC_SEQ_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PDELAY_RESPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PDELAY_REQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_DELAY_REQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_SYNCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_PDELAY_RESPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_PDELAY_REQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_DELAY_REQf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_SYNCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALL_ZERO_SA_TRAPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALL_ZERO_SA_DROPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MC_BC_SA_TRAPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SECURE_SAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FLUSH_NOTIFY_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FORBID_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LUTCAM_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PPPOE_PARSE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MC_BC_SA_DROPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_MC_DIP_CHKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LINK_DOWN_P_INVLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SA_ALL_ZERO_LRNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_MC_FVID_CMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_MC_HASH_KEY_FMTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV4_MC_HASH_KEY_FMTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_HASH_ALGOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FAST_AGE_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_AGE_UNITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SA_BLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DA_BLK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP6_MC_LM_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_MC_LM_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_MC_LM_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_UC_LM_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_BC_FLD_PMSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_UNKN_UC_FLD_PMSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NEW_SALRNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NEW_SA_FWDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LRN_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CONSTRT_NUMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SUSPEND_NOTIFICATION_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BP_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIFO_EMPTYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NOTIFICATION_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EGR_FLTR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_AGING_OUT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DIP_CARE_BYTEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SIP_CARE_BYTEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_MV_INVLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FORBID_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FVID_CMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_CMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ENTRY_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REPLACING_PORTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTPIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITPIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETPIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITPID_CMP_MSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTPID_CMP_MSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETPID_CMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTAG_UNTAG_ACCEPTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTAG_ACCEPTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITAG_UNTAG_ACCEPTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITAG_ACCEPTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LKY_STP_FLTR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LKYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXCPTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OCFI_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ICFI_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPVID_FMTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPVID_FMTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FWD_BASEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_FLTR_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP6_UNKN_MC_FLD_PMSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP4_UNKN_MC_FLD_PMSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_UNKN_MC_FLD_PMSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_LRN_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLK_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VID_SRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DBL_TAG_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTAG_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITAG_STSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EGR_P_OTAG_KEEPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EGR_P_ITAG_KEEPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_P_OTAG_KEEPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_P_ITAG_KEEPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITPID_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTPID_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VID_UPPERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VID_LOWERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REVERSEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REPLACEMENT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETHER_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRAME_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PPB_VIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PPB_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VALIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_MBR_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_MBR_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HASH_MSK_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DPORT_SHIFT_BITSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPORT_SHIFT_BITSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DIP_SHIFT_BITSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SIP_SHIFT_BITSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMAC_SHIFT_BITSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMAC_SHIFT_BITSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPN_SHIFT_BITSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HASH_MSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SEP_TRAFFICf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MSTI_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_ISO_MBR_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_ISO_MBR_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VB_ISO_MBR_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VB_ISO_MBR_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0F_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0E_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0D_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0C_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0B_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0A_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_09_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_08_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_07_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_06_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_05_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_04_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_03_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_02_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_01_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_1F_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_1E_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_1D_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_1C_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_1B_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_1A_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_19_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_18_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_17_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_16_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_15_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_14_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_13_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_12_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_11_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_10_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_2F_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_2E_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_2D_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_2C_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_2B_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_2A_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_29_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_28_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_27_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_26_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_25_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_24_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_23_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_22_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_21_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_20_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_LM_ACT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PTP_BYPASS_VLANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LLDP_BYPASS_VLANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_00_BYPASS_VLANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_02_BYPASS_VLANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0E_BYPASS_VLANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0X_BYPASS_VLANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PTP_BYPASS_STPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LLDP_BYPASS_STPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_0X_BYPASS_STPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SLOW_PROTO_BYPASS_STPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LRNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PTP_LRNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LLDP_LRNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ADDR_LOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_VLANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYPASS_STPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ADDR_HIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PMSK_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PMSK_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ADDRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NTFY_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NTFY_BUF_RUN_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LOCAL_NTFY_BUF_RUN_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ALL_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_DONEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_RUN_OUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_TRUNCATE_LENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_TRUNCATE_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_FETCHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_BUSYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRAP_PKT_TAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FWD_PKT_TAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRAP_PKT_FMTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FWD_PKT_FMTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SIZEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_MAX_LENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_MAX_LENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MSKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_L2MSG_TMROUT_SPDUPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_L2MSG_TMROUT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_L2MSG_TMROUT_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_L2MSG_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_L2MSG_CNT_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_FRC_RX_READY_Ff,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_FRC_TX_READY_Ff,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_RDMA_CNT_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INC_IFGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ARPREQ_ADMITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_ADMITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BPDU_ADMITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RTKPKT_ADMITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGMP_ADMITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TICK_PERIOD_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TKN_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TICK_PERIODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TKNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BC_EXCEED_FLGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MC_EXCEED_FLGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UC_EXCEED_FLGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MC_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UC_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BC_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MC_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UC_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BC_BURSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MC_BURSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UC_BURSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BPDU_EXCEED_FLGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGMP_EXCEED_FLGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ARP_EXCEED_FLGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BPDU_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGMP_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ARP_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_COLOR_AWAREf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LOW_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EXCEED_FLGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HI_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INCL_PREIFGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYTE_DLB_LB1_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYTE_DLB_LB0_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYTE_SRTCM_LB1_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYTE_SRTCM_LB0_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYTE_TRTCM_LB1_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYTE_TRTCM_LB0_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_DLB_LB1_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_DLB_LB0_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_SRTCM_LB1_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_SRTCM_LB0_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_TRTCM_LB1_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_TRTCM_LB0_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LB_EXCEEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNT_METER_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UNITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNTR_CLRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GREEN_CNTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_YELLOW_CNTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RED_CNTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TOTAL_CNTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RATE_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LB_GLB_EXCEEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCP_FRAG_OFF_MINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SYN_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SYN_FINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_XMASf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NULL_SCANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SYN_SPORT_LESS_1024f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCP_HDR_LEN_MINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMURFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ICMPV6_PING_MAXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ICMPV4_PING_MAXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ICMP_FRAG_PKTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_FRAG_LEN_MINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PODf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCP_BLATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UDP_BLATf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LANDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DA_EQUAL_SAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRAG_LEN_MINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKT_LEN_MAXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HDR_LEN_MINf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NETMASKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GRATUITOUS_ARPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ARP_INVLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GARP_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_DST_Pf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DST_P_ISOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_OPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIR_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPM_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPM_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DPM_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DPM_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RSPAN_TAG_TPID_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RSPAN_TAG_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RSPAN_TAG_CFIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RSPAN_TAG_VIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RSPAN_TX_TAG_ADDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RSPAN_RX_TAG_RMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RSPAN_RX_TAG_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SAMPLE_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMPL_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EGR_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_RATEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_9f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_10f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_11f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_12f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_13f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_14f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_15f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_16f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_17f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_18f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_19f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_20f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_21f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_22f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_23f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_24f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_25f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_26f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_27f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_28f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_29f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_30f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_31f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_33f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_34f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_35f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_36f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_37f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_38f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_39f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_40f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_41f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_42f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_43f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASON_44f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFINOCTETS_Hf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFINOCTETS_Lf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFOUTOCTETS_Hf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFOUTOCTETS_Lf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFINUCASTPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFINMULTICASTPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFINBROADCASTPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFOUTUCASTPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFOUTMULTICASTPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFOUTBROADCASTPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IFOUTDISCARDSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT1DTPPORTINDISCARDSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3STATSSINGLECOLLISIONFRAMESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3STATSMULTIPLECOLLISIONFRAMESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3STATSDEFERREDTRANSMISSIONSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3STATSLATECOLLISIONSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3STATSEXCESSIVECOLLISIONSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3STATSSYMBOLERRORSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3CONTROLINUNKNOWNOPCODESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3INPAUSEFRAMESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT3OUTPAUSEFRAMESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETHERSTATSDROPEVENTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSBROADCASTPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSMULTICASTPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETHERSTATSCRCALIGNERRORSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSUNDERSIZEPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSUNDERSIZEPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSUNDERSIZEDROPPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSOVERSIZEPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSOVERSIZEPKTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETHERSTATSFRAGMENTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETHERSTATSJABBERSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETHERSTATSCOLLISIONSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSPKTS64OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSPKTS64OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSPKTS65TO127OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSPKTS65TO127OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSPKTS128TO255OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSPKTS128TO255OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSPKTS256TO511OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSPKTS256TO511OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSPKTS512TO1023OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSPKTS512TO1023OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSPKTS1024TO1518OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSPKTS1024TO1518OCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSPKTS1519TOMAXOCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_ETHERSTATSPKTS1519TOMAXOCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_LENGTHFIELDERRORf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_FALSECARRIERTIMESf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_UNDERSIZEOCTETSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSFRAGMENTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSJABBERSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_ETHERSTATSCRCALIGNERRORSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_FRAMINGERRORSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RXMACDISCARDSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DOT1DTPLEARNEDENTRYDISCARDSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_MIB_VALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_GLOBAL_MIBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_PORT_FLAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RST_PORT_MIBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_CNT_TAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RX_CNT_TAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRF_FAIL_SW12f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SW12_FAILf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DROP_ALL_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_HI_ON_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_HI_OFF_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_LO_ON_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_LO_OFF_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_FCOFF_HI_ON_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_FCOFF_HI_OFF_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_FCOFF_LO_ON_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_FCOFF_LO_OFF_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_THR_SET_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_HI_ON_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_HI_OFF_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_FCOFF_LO_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_LO_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_FCOFF_HI_ON_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_FCOFF_HI_OFF_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_Q_EGR_DROP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RXCNGST_IGNOREf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_Q_EGR_DROP_ON_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_Q_EGR_DROP_OFF_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPUQ_EGR_DROP_ON_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPUQ_EGR_DROP_OFF_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_MAX_USED_PAGE_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P_USED_PAGE_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TL_MAX_USED_PAGE_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TL_USED_PAGE_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_ALLOW_PKT_LENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FC_ALLOW_PKT_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FLD_HOL_PRVNT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UNKN_UC_EGR_DROP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_MC_EGR_DROP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_MC_EGR_DROP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BC_EGR_DROP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DROP_TYPE_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DROP_RATE_DPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_THMAX_DPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_THMIN_DPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_Q_DROP_RATE_DPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_Q_THMAX_DPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_Q_THMIN_DPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_IDX_GRPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_COLOR_IDX_GRPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DROP_CNTR_GRPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WRED_DROP_CNTR_RSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRAIN_OUT_THR_Hf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DRAIN_OUT_THRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNGST_TMR_Hf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNGST_SUST_TMR_LMT_Hf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNGST_TMRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNGST_SUST_TMR_LMTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTPRI_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_QNUMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LACPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BPDUf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_USR_DEF_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_USR_DEF_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGR_VLAN_FLTRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OAMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTHERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_HL_EXCEEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_HDR_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV4_OPTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV4_TTL_EXCEEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV4_HDR_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_UNKN_EXTHDRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_HBH_POS_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LLDPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PTPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INVLD_SAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_MACf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UNKNOWN_DAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_NDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ARPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EAPOLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GW_MAC_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_HOPBYHOPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PRI0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_P_ALGO_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTPRI_IPRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTPRI_OPRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTPRI_DSCPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTPRI_PORTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBL_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PROTO_VLAN_WTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_VLAN_WTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTAG_WTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITAG_WTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP_WTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ING_ACL_WTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_WTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTPRI_PORT_REMAP_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTPRI_PORT_REMAP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP_INVLD_VALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP_INVLD_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DP_SRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_DEI_TAG_SRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DEI2DP_VALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP2DP_VALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP_RMK_SRC_EXTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRI_RMK_SRC_EXTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPRI_RMK_SRC_EXTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPRI_DFLT_SRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRI_DFLT_CFGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRI_DFLT_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPRI_DFLT_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP_RMK_SRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRI_RMK_SRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPRI_RMK_SRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DEI_RMK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP_RMK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRI_RMK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPRI_RMK_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRI_DFLT_SRCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DEI_TAG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DP2DEIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRI_DFLT_SRC_EXTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP2IPRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DSCP2OPRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LB_MODE_CPU_Pf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_Q_PKT_THR_MAXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYTE_PER_TKN_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BYTE_PER_TKNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_APR_LB_SIZEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WFQ_LB_SIZEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TICK_PERIOD_PPSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TKN_PPSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_APR_LB_SIZE_PPSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_WFQ_LB_SIZE_PPSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLASS_NON_B_REDIRECT_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLASS_NON_A_REDIRECT_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLASS_B_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLASS_A_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLASS_B_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLASS_A_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLASS_NON_B_RMK_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLASS_NON_A_RMK_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LUT_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TMPLTE_IOTAG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CRC_LOOKUP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CUTLINEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLK_TMPLTE2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLK_TMPLTE1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TMPLTE_FIELDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLK_GROUP_ALLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLK_GROUP_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLK_GROUP_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLK_GROUP_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BLK_RESULT_MULTIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MV_TOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MV_FROMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MV_LENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLR_TOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLR_FROMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CLRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_CNVT_DFLT_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RULE_INDICATIONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GLB_INDICATIONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_UPPERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_LOWERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L4PORT_UPPERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L4PORT_LOWERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKTLEN_UPPERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKTLEN_LOWERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_SWAPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DIS_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PAR_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MUX_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DYING_GASP_PKTCNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DYING_GASP_TRIGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBP_VALf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_OAM_DYING_GASP_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DYGASP_POLARITYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UNKN_RXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MD_LV_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MD_LV_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MD_LV_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MD_LV_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MD_LV_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MD_LV_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MD_LV_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MD_LV_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PCPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TPIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LIFETIMEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TIMER_SPEED_UPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MEPIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LIFETIME_CODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MDLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VID_ADDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTLVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_P0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNTR1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CNTR0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_10Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_1Gf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_100Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPD_10Mf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PAGE_CNTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ENDSCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BGDSCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR11f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR10f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR9f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SELTOR0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIELD_SEL_VLDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMPLS_EXPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMPLS_LABELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OMPLS_EXPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OMPLS_LABELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ARPOPCODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGT_MAC_47_32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TGT_MAC_31_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SENDER_MAC_47_32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SENDER_MAC_31_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DPORTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPORTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCP_FLAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_VERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_TTLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_TOSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_PROTOCOLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_FLAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_OFFSETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DIPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SIPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMAC_47_32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SMAC_31_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMAC_47_32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DMAC_31_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPLENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV4HDLENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TCPSEQZEROf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6HOPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6ROUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6FRAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6DESTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6AUTHf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPCSOKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6EXT_LONGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OMPLS_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IMPLS_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ETAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPUTAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OAMPDUf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LLC_OTHERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PPPOE_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RFC_1042f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ERRPKTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L4HDCHKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PKTLENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PPPOEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CMACf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GMACf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV4_TTL_ZEROf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_HL_ZEROf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPV6_HOPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OAM_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_ZEROf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_SPMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UNKEYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MCKEYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_PROFILEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_METER_DROPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFM_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFM_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFI_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TAG_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NIVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_BYPASSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NOVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_MEETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACLC2SCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_HITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRK_EXTRA_BITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EAPOL_TRAP_PREf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IACL_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORG_IVIF_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORG_IVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPE_TRAP_RSNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPE_TRAP_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EAV_CLASSAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EAV_CLASSBf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HWATT_RSNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HWATT_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_PKTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_LEARNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_BYPASSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_C2SC_HIT_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_C2SC_HITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_C2SC_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTERNAL_PRIOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DP_PREf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PROTOCOL_STORMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IBW_PASSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SLIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRUNK_GRPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CTAG_LNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CTAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ROUTE_NH_BITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NH_AGE_ZEROf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TRKEXA_BITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EAPOL_TRAP_LUTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DPORT_MOVEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPORT_FILTER_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GMAC_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MC_SAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VLAN_SPFILTERf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DPM_52_32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DPM_31_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_LOOKUP_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FWD_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NEWSA_ACf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PMOVE_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MACLIMIT_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ROUTE_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DA_HITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DA_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SA_HITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SA_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RMA_BYP_VLANf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSA_BUSYf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_MPLS_HITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_MPLS_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MPLS_INDEXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ASTAGSTSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CTAG_DMf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CTAG_DGPKTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PTP_LOGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_PTP_OFFLOADf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NEW_SAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MAC_CSTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STC_L2_PMVf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ATK_TYPEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DM_RXIDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_IDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EAV_CLASS_Bf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EAV_CLASS_Af,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REASONf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ACL_TOSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NEW_TOSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_INTERNAL_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OPRI_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPRI_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_C2SC_PRIf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EACL_ITAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EACL_OTAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_C2SC_ITAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_C2SC_OTAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ITAG_STATUSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OTAG_STATUSf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EACL_IVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_C2SC_IVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EACL_OTPIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_EACL_ITPIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_C2SC_ITPIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NEW_OTAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NEW_ITAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_OVIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L3_ROUTEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DA_PIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_NORMAL_FWDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SWAP_MACf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CPU_FWDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SFLOW_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIRROR_1_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIRROR_2_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIRROR_3_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MIRROR_4_INFOf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT9_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT8_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT7_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT6_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT5_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT4_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT3_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT2_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT1_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT0_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT19_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT18_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT17_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT16_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT15_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT14_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT13_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT12_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT11_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT10_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT29_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT28_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT27_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT26_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT25_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT24_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT23_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT22_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT21_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT20_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT39_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT38_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT37_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT36_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT35_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT34_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT33_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT32_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT31_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT30_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT49_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT48_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT47_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT46_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT45_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT44_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT43_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT42_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT41_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT40_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT52_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT51_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT50_QIDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_COLORf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RVID_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DPCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_STPID_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CTPID_IDXf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORG_OTAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORG_ITAGf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORG_ETAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORG_CPUTAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORG_OTAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ORG_ITAG_IFf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RFC1042f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DBG_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DBG_SELf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_DBG_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_TRIG_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_CMDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_CMP_DATAf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_CARE_BITf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_RISING_CHKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_FALLING_CHKf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_6f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_7f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_8f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_9f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_10f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_11f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_12f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_13f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_14f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_15f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ALE_DBG_OUT_16f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_CALCULATE_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RTU_FIFO_FULLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RELEASE_FIFO_FULLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_PORT_FIFO_OVER_RUNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HSB_FIFO_OVER_RUNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIFO_UNDER_RUNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FIFO_OVER_RUNf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_1f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_2f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_3f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_4f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_CFG_NICDBG_SEL_5f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GRP_TX_CMDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SPG_MODEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_GRP_TX_PORTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TX_DONE_PORTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_BAD_CRC_TRAPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UNDER_SIZE_TRAPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OVER_SIZE_TRAPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FRAG_PKT_TRAPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ROUTING_AGEf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP6_HOPBYHOPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP6_HL_EXCEEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP6_HDR_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP4_OPTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP4_TTL_EXECEEDf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP4_HDR_ERRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SA_47_32f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_SA_31_0f,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MPLS_ENf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TTL_PROCf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_TBLf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP_CMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_VID_CMPf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_MLD_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IGMP_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_REQ_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_UNKNOWNEXTHDR_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_HBHEXTHDRERR_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_ND_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IPADDRf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_IP4_CRC_ERR_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_L2_CRC_ERR_ACTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_OFFSETf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_FMTf,
#endif
#if defined(CONFIG_SDK_RTL8390)
    CYPRESS_RFC1042_OUI_IGNOREf,
#endif

    CYPRESS_REGFIELD_LIST_END,
} rtk_cypress_regField_list_t;

extern rtk_reg_t rtk_cypress_reg_list[];


#endif    /* __RTK_CYPRESS_REG_STRUCT_H__ */
