typedef struct diag_table_reg_name_value_pair_s
{
    char name[64];
    int32 value;
} diag_table_reg_name_value_pair_t;

typedef enum diag_table_reg_field_name_type_s
{
    DIAG_TABLE_NAME,
    DIAG_TABLE_FIELD_NAME,
    DIAG_REG_NAME,
    DIAG_REG_FIELD_NAME
} diag_table_reg_field_name_type_t;

#ifdef CONFIG_SDK_RTL9300
static diag_table_reg_name_value_pair_t longan_diag_reg_array[] =
{
    {"model_name_info",    0},
    {"chip_info",    1},
    {"rst_glb_ctrl_0",    2},
    {"rst_glb_sts_0",    3},
    {"rst_glb_sts_1",    4},
    {"rst_glb_sts_2",    5},
    {"rst_glb_sts_3",    6},
    {"mac_rst_dur",    7},
    {"pll_glb_ctrl0",    8},
    {"pll_glb_ctrl1",    9},
    {"pll_cpu_ctrl0",    10},
    {"pll_cpu_ctrl1",    11},
    {"pll_cpu_misc_ctrl",    12},
    {"pll_sw_ctrl0",    13},
    {"pll_sw_ctrl1",    14},
    {"pll_sw_misc_ctrl",    15},
    {"pll_sw_div_ctrl",    16},
    {"pll_125m_ctrl0",    17},
    {"pll_125m_ctrl1",    18},
    {"pll_125m_misc_ctrl",    19},
    {"pll_bandgap_ctrl",    20},
    {"xtal_cml_ctrl_",    21},
    {"pll_cml_ctrl",    22},
    {"dmy_reg0_chip_pll",    23},
    {"mac_bist_mode",    24},
    {"mac_drf_bist_mode",    25},
    {"mac_bist_rstn",    26},
    {"mac_drf_test_resume",    27},
    {"mac_grxf0_result",    28},
    {"mac_gtxf0_result",    29},
    {"mac_tgrxf_result",    30},
    {"mac_tgtxf_result",    31},
    {"mac_grxf1_result0",    32},
    {"mac_gtxf1_result0",    33},
    {"mac_dmy_result",    34},
    {"mac_lbrxf_result",    35},
    {"mac_drf_pause",    36},
    {"mac_grxf0_gtxf0_sram_ls_en",    37},
    {"mac_grxf0_gtxf0_timing_cfg_en",    38},
    {"mac_grxf0_rma",    39},
    {"mac_grxf0_rmb",    40},
    {"mac_gtxf0_rma",    41},
    {"mac_gtxf0_rmb",    42},
    {"mac_tgrxf_tgtxf_sram_ls_en",    43},
    {"mac_tgrxf_tgtxf_timing_cfg_en",    44},
    {"mac_tgrxf_rma",    45},
    {"mac_tgrxf_rmb",    46},
    {"mac_tgtxf_rma",    47},
    {"mac_tgtxf_rmb",    48},
    {"mac_grxf1_gtxf1_sram_ls_en",    49},
    {"mac_grxf1_gtxf1_timing_cfg_en",    50},
    {"mac_grxf1_rma",    51},
    {"mac_grxf1_rmb",    52},
    {"mac_gtxf1_rma",    53},
    {"mac_gtxf1_rmb",    54},
    {"mac_dmy_sram_ls_en",    55},
    {"mac_dmy_timing_cfg_en",    56},
    {"mac_dmy_rma",    57},
    {"mac_dmy_rmb",    58},
    {"mac_lbrxf_sram_ls_en",    59},
    {"mac_lbrxf_timing_cfg_en",    60},
    {"mac_lbrxf_rma",    61},
    {"mac_lbrxf_rmb",    62},
    {"ale_bist_mode0",    63},
    {"ale_bist_mode1",    64},
    {"ale_drf_bist_mode0",    65},
    {"ale_drf_bist_mode1",    66},
    {"ale_drf_bist_resume0",    67},
    {"ale_drf_bist_resume1",    68},
    {"ale_timing_cfg0",    69},
    {"ale_timing_cfg1",    70},
    {"ale_timing_cfg2",    71},
    {"ale_timing_cfg3",    72},
    {"ale_rm_0",    73},
    {"ale_rm_1",    74},
    {"ale_rm_2",    75},
    {"ale_rm_3",    76},
    {"ale_rm_4",    77},
    {"ale_rm_5",    78},
    {"ale_rm_6",    79},
    {"ale_rm_7",    80},
    {"ale_rm_8",    81},
    {"ale_rm_9",    82},
    {"ale_rm_10",    83},
    {"ale_rm_11",    84},
    {"ale_rm_12",    85},
    {"ale_rm_13",    86},
    {"ale_rm_14",    87},
    {"ale_rm_15",    88},
    {"ale_cam_timing_mds_0",    89},
    {"ale_cam_timing_mds_1",    90},
    {"ale_cam_timing_mds_3",    91},
    {"ale_cam_timing_mds_4",    92},
    {"ale_cam_timing_mds_5",    93},
    {"ale_cam_timing_mds_2",    94},
    {"ale_cam_timing_rds_0",    95},
    {"ale_cam_timing_rds_1",    96},
    {"ale_cam_timing_rds_2",    97},
    {"ale_cam_timing_rds_3",    98},
    {"ale_cam_timing_rds_6",    99},
    {"ale_cam_timing_rds_7",    100},
    {"ale_cam_timing_rds_4",    101},
    {"ale_cam_timing_rds_5",    102},
    {"ale_bist_done0",    103},
    {"ale_bist_done1",    104},
    {"ale_drf_bist_pause0",    105},
    {"ale_drf_bist_pause1",    106},
    {"ale_bist_fail0",    107},
    {"ale_bist_fail1",    108},
    {"ale_bist_fail2",    109},
    {"ale_bist_fail3",    110},
    {"ale_bist_fail4",    111},
    {"ale_bist_fail5",    112},
    {"ale_drf_bist_done0",    113},
    {"ale_drf_bist_done1",    114},
    {"ale_drf_bist_fail0",    115},
    {"ale_drf_bist_fail1",    116},
    {"ale_drf_bist_fail2",    117},
    {"ale_drf_bist_fail3",    118},
    {"ale_drf_bist_fail4",    119},
    {"ale_drf_bist_fail5",    120},
    {"ale_bist_ls_mode",    121},
    {"chip_bist_mode",    122},
    {"chip_drf_bist_mode",    123},
    {"chip_bist_rstn",    124},
    {"chip_drf_test_resume",    125},
    {"chip_bist_done",    126},
    {"chip_drf_bist_done",    127},
    {"chip_bist_fail",    128},
    {"chip_drf_bist_fail",    129},
    {"chip_drf_start_pause",    130},
    {"chip_all_result",    131},
    {"chip_sram_ls",    132},
    {"ingr_bist_ctrl0",    133},
    {"ingr_bist_ctrl1",    134},
    {"ingr_bist_rslt0",    135},
    {"ingr_bist_rslt1",    136},
    {"ingr_bist_rslt2",    137},
    {"ingr_bist_rslt3",    138},
    {"ingr_bist_rslt4",    139},
    {"ingr_sram_ctrl",    140},
    {"ingr_bisr_ctrl",    141},
    {"ingr_bisr_rslt0",    142},
    {"ingr_bisr_rslt1",    143},
    {"egr_bist_ctrl0",    144},
    {"egr_bist_ctrl1",    145},
    {"egr_bist_rslt0",    146},
    {"egr_bist_rslt1",    147},
    {"egr_bist_rslt2",    148},
    {"egr_bist_rslt3",    149},
    {"egr_bist_rslt4",    150},
    {"egr_sram_ctrl",    151},
    {"soc_bist_ctrl0",    152},
    {"soc_bist_ctrl1",    153},
    {"soc_bist_ctrl2",    154},
    {"soc_bist_ctrl3",    155},
    {"soc_bist_ctrl4",    156},
    {"soc_bist_ctrl5",    157},
    {"soc_bist_ctrl6",    158},
    {"soc_bist_rstl0",    159},
    {"soc_bist_rstl1",    160},
    {"soc_bist_rstl2",    161},
    {"soc_bist_rstl3",    162},
    {"soc_bist_misc0",    163},
    {"soc_bist_misc1",    164},
    {"dmy_reg0_mac_bist",    165},
    {"dmy_reg0_ale_bist",    166},
    {"dmy_reg0_chip_bist",    167},
    {"mac_if_ctrl",    168},
    {"mac_slv_i2c_ctrl",    169},
    {"mac_slv_timeout",    170},
    {"i2c_mst1_ctrl1",    171},
    {"i2c_mst1_ctrl2",    172},
    {"i2c_mst1_data_word0",    173},
    {"i2c_mst1_data_word1",    174},
    {"i2c_mst1_data_word2",    175},
    {"i2c_mst1_data_word3",    176},
    {"i2c_mst_glb_ctrl",    177},
    {"i2c_mst2_ctrl1",    178},
    {"i2c_mst2_ctrl2",    179},
    {"i2c_mst2_data_word0",    180},
    {"i2c_mst2_data_word1",    181},
    {"i2c_mst2_data_word2",    182},
    {"i2c_mst2_data_word3",    183},
    {"spi_ctrl1",    184},
    {"spi_ctrl2",    185},
    {"spi_addr",    186},
    {"spi_data",    187},
    {"p0_intf_ctrl",    188},
    {"gpio_sel_ctrl",    189},
    {"jtag_sel_ctrl",    190},
    {"dmy_reg0_reg_if",    191},
    {"led_glb_ctrl",    192},
    {"led_port_num_ctrl",    193},
    {"led_set3_1_ctrl",    194},
    {"led_set3_0_ctrl",    195},
    {"led_set2_1_ctrl",    196},
    {"led_set2_0_ctrl",    197},
    {"led_set1_1_ctrl",    198},
    {"led_set1_0_ctrl",    199},
    {"led_set0_1_ctrl",    200},
    {"led_set0_0_ctrl",    201},
    {"led_port_copr_set_sel_ctrl",    202},
    {"led_port_fib_set_sel_ctrl",    203},
    {"led_port_copr_mask_ctrl",    204},
    {"led_port_fib_mask_ctrl",    205},
    {"led_port_combo_mask_ctrl",    206},
    {"sw_led_load",    207},
    {"led_port_sw_en_ctrl",    208},
    {"led_port_sw_ctrl",    209},
    {"led_indrt_access_ctrl",    210},
    {"led_load_lv1_10g",    211},
    {"led_load_lv2_10g",    212},
    {"led_load_lv3_10g",    213},
    {"led_load_lv1_5g",    214},
    {"led_load_lv2_5g",    215},
    {"led_load_lv3_5g",    216},
    {"led_load_lv1_2p5g",    217},
    {"led_load_lv2_2p5g",    218},
    {"led_load_lv3_2p5g",    219},
    {"led_load_lv1_1g",    220},
    {"led_load_lv2_1g",    221},
    {"led_load_lv3_1g",    222},
    {"led_load_lv1_500m",    223},
    {"led_load_lv2_500m",    224},
    {"led_load_lv3_500m",    225},
    {"led_load_lv1_100m",    226},
    {"led_load_lv2_100m",    227},
    {"led_load_lv3_100m",    228},
    {"led_load_lv1_10m",    229},
    {"led_load_lv2_10m",    230},
    {"led_load_lv3_10m",    231},
    {"led_p_load_ctrl",    232},
    {"ext_gpio_glb_ctrl",    233},
    {"ext_gpio_trig",    234},
    {"ext_gpio_dir_ctrl_1",    235},
    {"ext_gpio_dir_ctrl_2",    236},
    {"ext_gpio_dir_ctrl_3",    237},
    {"ext_gpio_data_ctrl_1",    238},
    {"ext_gpio_data_ctrl_2",    239},
    {"ext_gpio_data_ctrl_3",    240},
    {"ext_gpio_indrt_access_ctrl",    241},
    {"dmy_reg0_glb_ctrl",    242},
    {"dmy_reg0_led",    243},
    {"imr_glb",    244},
    {"imr_port_link_sts_chg",    245},
    {"imr_rsvd",    246},
    {"imr_serdes_link_fault_p",    247},
    {"imr_serdes_rx_sym_err",    248},
    {"imr_oam_dygasp",    249},
    {"imr_ext_gpio0",    250},
    {"imr_ext_gpio1",    251},
    {"imr_tm_rlfd",    252},
    {"imr_auto_rec",    253},
    {"imr_sds_upd_physts0",    254},
    {"imr_rout_lpbuf",    255},
    {"isr_glb",    256},
    {"isr_sw_int_mode",    257},
    {"isr_port_link_sts_chg",    258},
    {"isr_rsvd",    259},
    {"isr_serdes_link_fault_p",    260},
    {"isr_serdes_rx_sym_err",    261},
    {"isr_oam_dygasp",    262},
    {"isr_ext_gpio0",    263},
    {"isr_ext_gpio1",    264},
    {"isr_ext_gpio_mode0",    265},
    {"isr_ext_gpio_mode1",    266},
    {"isr_ext_gpio_mode2",    267},
    {"isr_tm_rlfd",    268},
    {"isr_auto_rec",    269},
    {"isr_sds_upd_physts",    270},
    {"isr_rout_lpbuf",    271},
    {"efuse_access_en",    272},
    {"efuse_access_ctrl",    273},
    {"efuse_wdata_ctrl",    274},
    {"efuse_rdata_ctrl",    275},
    {"calib_ctrl_1",    276},
    {"calib_ctrl_2",    277},
    {"calib_ctrl_3",    278},
    {"calib_ctrl_4",    279},
    {"spd_sensor0_ctrl",    280},
    {"spd_sensor1_ctrl",    281},
    {"spd_sensor2_ctrl",    282},
    {"spd_sensor3_ctrl",    283},
    {"spd_sensor0_result",    284},
    {"spd_sensor1_result",    285},
    {"spd_sensor2_result",    286},
    {"spd_sensor3_result",    287},
    {"spd_debug",    288},
    {"thermal_meter_ctrl_0",    289},
    {"thermal_meter_ctrl_1",    290},
    {"thermal_meter_ctrl_2",    291},
    {"thermal_meter_result_0",    292},
    {"thermal_meter_result_1",    293},
    {"io_driving_ability_ctrl0",    294},
    {"io_driving_ability_ctrl1",    295},
    {"io_driving_ability_ctrl2",    296},
    {"io_driving_ability_ctrl3",    297},
    {"io_driving_ability_ctrl4",    298},
    {"io_driving_ability_ctrl5",    299},
    {"io_driving_ability_ctrl6",    300},
    {"io_driving_ability_ctrl7",    301},
    {"io_driving_ability_ctrl8",    302},
    {"ft_scan_mode",    303},
    {"soc_debug",    304},
    {"bond_dbg",    305},
    {"strp_dbg",    306},
    {"dbg_mode",    307},
    {"dbg_sel0",    308},
    {"dbg_sel1",    309},
    {"dbg_sel2",    310},
    {"dbg_sel3",    311},
    {"dbg_sig_sel0",    312},
    {"dbg_sig_sel1",    313},
    {"dbg_sig_sel2",    314},
    {"dbg_sig_sel3",    315},
    {"dbg_val",    316},
    {"dmy_reg0_chip_misc",    317},
    {"dmy_reg0_chip_misc_r",    318},
    {"dma_if_rx_base_desc_addr_ctrl",    319},
    {"dma_if_rx_cur_desc_addr_ctrl",    320},
    {"dma_if_tx_base_desc_addr_ctrl",    321},
    {"dma_if_tx_cur_desc_addr_ctrl",    322},
    {"dma_if_intr_rx_runout_msk",    323},
    {"dma_if_intr_rx_done_msk",    324},
    {"dma_if_intr_tx_done_msk",    325},
    {"dma_if_intr_rx_runout_sts",    326},
    {"dma_if_intr_rx_done_sts",    327},
    {"dma_if_intr_tx_done_sts",    328},
    {"dma_if_ctrl",    329},
    {"dma_if_pkt_ctrl",    330},
    {"dma_if_rx_ring_size",    331},
    {"dma_if_rx_ring_cntr",    332},
    {"dma_if_physical_addr_msk",    333},
    {"nic_dbg_sel_0",    334},
    {"nic_dbg_sel_1",    335},
    {"nic_bist_ctrl_0",    336},
    {"nic_bist_ctrl_1",    337},
    {"dmy_reg0_nic",    338},
    {"spcl_switch_ipv4_addr_ctrl",    339},
    {"spcl_switch_ipv6_addr_ctrl",    340},
    {"spcl_trap_capwap_port_ctrl",    341},
    {"spcl_trap_ctrl",    342},
    {"spcl_trap_port_ctrl",    343},
    {"tbl_access_l2_ctrl",    344},
    {"tbl_access_l2_method_ctrl0",    345},
    {"tbl_access_l2_method_ctrl1",    346},
    {"tbl_access_l2_method_ctrl2",    347},
    {"tbl_access_l2_data",    348},
    {"tbl_access_ctrl_0",    349},
    {"tbl_access_data_0",    350},
    {"tbl_access_ctrl_1",    351},
    {"tbl_access_data_1",    352},
    {"tbl_access_ctrl_2",    353},
    {"tbl_access_data_2",    354},
    {"tbl_access_hsb_ctrl",    355},
    {"tbl_access_hsb_data",    356},
    {"tbl_access_hsa_ctrl",    357},
    {"tbl_access_hsa_data",    358},
    {"dmy_reg0_ale_tab",    359},
    {"dmy_reg0_rt_tab",    360},
    {"dmy_reg0_pkt_encap",    361},
    {"mac_glb_ctrl",    362},
    {"mac_port_ctrl",    363},
    {"half_chg_ctrl",    364},
    {"mac_eeprom_down_load_cntrl",    365},
    {"mac_eeprom_down_load_sts",    366},
    {"mac_eeprom_down_load_mac_pos",    367},
    {"mac_eeprom_down_load_serdes_pos",    368},
    {"mac_eeprom_down_load_phy_pos",    369},
    {"mac_eeprom_down_load_group_mac_pos",    370},
    {"smi_glb_ctrl",    371},
    {"smi_mac_type_ctrl",    372},
    {"smi_port0_15_polling_sel",    373},
    {"smi_port16_27_polling_sel",    374},
    {"smi_prvte_polling_ctrl",    375},
    {"mdio_free_cnt_ctrl",    376},
    {"smi_10gphy_polling_sel_0",    377},
    {"mac_force_mode_ctrl",    378},
    {"smi_poll_ctrl",    379},
    {"smi_reg_chk1_ctrl0",    380},
    {"smi_reg_chk1_ctrl1",    381},
    {"smi_reg_chk1_pmsk",    382},
    {"smi_reg_chk1_data",    383},
    {"smi_reg_chk1_data_10g",    384},
    {"smi_reg_chk1_result",    385},
    {"smi_reg_chk2_ctrl0",    386},
    {"smi_reg_chk2_ctrl1",    387},
    {"smi_reg_chk2_pmsk",    388},
    {"smi_reg_chk2_data",    389},
    {"smi_reg_chk2_data_10g",    390},
    {"smi_reg_chk2_result",    391},
    {"smi_reg_chk3_ctrl0",    392},
    {"smi_reg_chk3_ctrl1",    393},
    {"smi_reg_chk3_pmsk",    394},
    {"smi_reg_chk3_data",    395},
    {"smi_reg_chk3_data_10g",    396},
    {"smi_reg_chk3_result",    397},
    {"smi_reg_chk4_ctrl0",    398},
    {"smi_reg_chk4_ctrl1",    399},
    {"smi_reg_chk4_pmsk",    400},
    {"smi_reg_chk4_data",    401},
    {"smi_reg_chk4_data_10g",    402},
    {"smi_reg_chk4_result",    403},
    {"smi_reg_chk5_ctrl0",    404},
    {"smi_reg_chk5_ctrl1",    405},
    {"smi_reg_chk5_pmsk",    406},
    {"smi_reg_chk5_data",    407},
    {"smi_reg_chk5_data_10g",    408},
    {"smi_reg_chk5_result",    409},
    {"link_delay_ctrl",    410},
    {"mac_link_sts",    411},
    {"mac_link_media_sts",    412},
    {"mac_link_spd_sts",    413},
    {"mac_link_dup_sts",    414},
    {"mac_tx_pause_sts",    415},
    {"mac_rx_pause_sts",    416},
    {"mac_eee_ablty",    417},
    {"mac_mstr_slv_sts",    418},
    {"mac_mstr_slv_fault_sts",    419},
    {"phy_link_sts",    420},
    {"phy_link_media_sts",    421},
    {"phy_link_spd_sts",    422},
    {"phy_link_dup_sts",    423},
    {"phy_tx_pause_sts",    424},
    {"phy_rx_pause_sts",    425},
    {"phy_eee_ablty",    426},
    {"phy_mstr_slv_sts",    427},
    {"phy_mstr_slv_fault_sts",    428},
    {"smi_access_phy_ctrl_0",    429},
    {"smi_access_phy_ctrl_1",    430},
    {"smi_access_phy_ctrl_2",    431},
    {"smi_access_phy_ctrl_3",    432},
    {"smi_port0_5_addr_ctrl",    433},
    {"smi_port6_11_addr_ctrl",    434},
    {"smi_port12_17_addr_ctrl",    435},
    {"smi_port18_23_addr_ctrl",    436},
    {"smi_port24_27_addr_ctrl",    437},
    {"sds_mode_adj_ctrl",    438},
    {"smi_ctrl",    439},
    {"mac_efuse_ctrl",    440},
    {"bonding_redefine_reg",    441},
    {"mac_l2_global_ctrl0",    442},
    {"mac_l2_global_ctrl1",    443},
    {"mac_l2_port_ctrl",    444},
    {"mac_l2_padding_sel",    445},
    {"mac_l2_cpu_port_ctrl",    446},
    {"mac_l2_cpu_tag_id_ctrl",    447},
    {"mac_l2_addr_ctrl",    448},
    {"mac_l2_port_max_len_ctrl",    449},
    {"mac_l2_cpu_max_len_ctrl",    450},
    {"mac_ssc_ctrl_0",    451},
    {"mac_ssc_ctrl_1",    452},
    {"mac_ssc_ctrl_2",    453},
    {"mac_ssc_ctrl_3",    454},
    {"mac_ssc_ctrl_4",    455},
    {"ext_smi_access_ctrl",    456},
    {"dmy_reg0_per_port_mac",    457},
    {"dmy_reg0_ale_glb",    458},
    {"dmy_reg1_glb_ctrl",    459},
    {"dmy_reg0_smi_ctrl",    460},
    {"dmy_reg0_chip_afe",    461},
    {"rlfd_ctrl",    462},
    {"rlfd_10g_addr",    463},
    {"uni_dir_ctrl",    464},
    {"smi_10gphy_polling_sel_1",    465},
    {"smi_10gphy_polling_reg0_cfg",    466},
    {"smi_10gphy_polling_reg9_cfg",    467},
    {"smi_10gphy_polling_reg10_cfg",    468},
    {"fib0_intf_ctrl",    469},
    {"fib4_intf_ctrl",    470},
    {"fib10_intf_ctrl",    471},
    {"sds_cfg_reg0",    472},
    {"sds_cfg_reg1",    473},
    {"sds_cfg_reg2",    474},
    {"sds_mode_sel_0",    475},
    {"sds_mode_sel_1",    476},
    {"sds_mode_sel_2",    477},
    {"sds_mode_sel_3",    478},
    {"sds_indacs_cmd",    479},
    {"sds_indacs_data",    480},
    {"sds_oui",    481},
    {"sds_version",    482},
    {"sds_intf_ctrl0",    483},
    {"sds_intf_ctrl1",    484},
    {"sds_intf_ctrl2",    485},
    {"wrap_sds_intf_ctrl0",    486},
    {"wrap_sds_intf_ctrl1",    487},
    {"wrap_sds_intf_ctrl3",    488},
    {"wrap_sds_intf_ctrl4",    489},
    {"wrap_sds_intf_ctrl5",    490},
    {"wrap_sds_intf_ctrl6",    491},
    {"rg2x_rg1x_cen",    492},
    {"rg0x_cen_rtt",    493},
    {"sds_submode_ctrl0",    494},
    {"sds_submode_ctrl1",    495},
    {"dmy_reg0_chip_chip_afe",    496},
    {"eee_tx_q_ctrl",    497},
    {"eee_tx_minifg_ctrl0",    498},
    {"eee_tx_minifg_ctrl1",    499},
    {"eee_tx_minifg_ctrl2",    500},
    {"eee_tx_ctrl",    501},
    {"eee_tx_timer_100m_ctrl",    502},
    {"eee_tx_timer_gelite_ctrl",    503},
    {"eee_tx_timer_giga_ctrl",    504},
    {"eee_tx_timer_2p5g_ctrl",    505},
    {"eee_tx_timer_5g_ctrl",    506},
    {"eee_tx_timer_10g_ctrl",    507},
    {"eee_ctrl",    508},
    {"eee_rx_gelite_ctrl",    509},
    {"eee_rx_ge_ctrl",    510},
    {"eee_rx_2p5g_ctrl",    511},
    {"eee_rx_5g_ctrl",    512},
    {"eee_rx_10g_ctrl",    513},
    {"eeep_port_ctrl",    514},
    {"eeep_gbl_ctrl",    515},
    {"eeep_timer_unit_ctrl",    516},
    {"eeep_tx_rate_100m_ctrl",    517},
    {"eeep_tx_rate_500m_ctrl",    518},
    {"eeep_tx_rate_giga_ctrl",    519},
    {"eeep_tx_wake_timer_ctrl",    520},
    {"eeep_rx_rate_100m_ctrl",    521},
    {"eeep_rx_rate_500m_ctrl",    522},
    {"eeep_rx_rate_giga_ctrl",    523},
    {"eeep_rx_sleep_step_ctrl",    524},
    {"eeep_rx_timer_100m_ctrl",    525},
    {"eeep_rx_timer_500m_ctrl0",    526},
    {"eeep_rx_timer_500m_ctrl1",    527},
    {"eeep_rx_timer_giga_ctrl0",    528},
    {"eeep_rx_timer_giga_ctrl1",    529},
    {"eeep_rx_idle_timer_ctrl",    530},
    {"eeep_tx_idle_timer_ctrl",    531},
    {"ps_gatclk_mask",    532},
    {"ps_gatclk_en",    533},
    {"ps_gatclk_ctrl",    534},
    {"ps_soc_ctrl",    535},
    {"dmy_reg0_chip_misc_t",    536},
    {"vlan_tag_tpid_ctrl",    537},
    {"vlan_etag_tpid_ctrl",    538},
    {"vlan_port_itag_tpid_cmp_msk",    539},
    {"vlan_port_otag_tpid_cmp_msk",    540},
    {"vlan_port_etag_tpid_cmp",    541},
    {"vlan_port_aft",    542},
    {"vlan_ctrl",    543},
    {"vlan_port_pb_vlan",    544},
    {"vlan_port_fwd_ctrl",    545},
    {"vlan_app_pkt_ctrl",    546},
    {"vlan_port_igr_fltr",    547},
    {"vlan_port_egr_fltr",    548},
    {"vlan_port_tag_sts_ctrl",    549},
    {"vlan_port_egr_tpid_ctrl",    550},
    {"dmy_reg0_vlan",    551},
    {"dmy_reg1_vlan",    552},
    {"dmy_reg1_pkt_encap",    553},
    {"vlan_profile_set",    554},
    {"dmy_reg0_vlan_profile",    555},
    {"vlan_ppb_vlan_set",    556},
    {"vlan_port_ppb_vlan_set",    557},
    {"dmy_reg2_vlan",    558},
    {"vlan_igr_vid_rng_chk_set_0",    559},
    {"vlan_igr_vid_rng_chk_set_1",    560},
    {"vlan_egr_vid_rng_chk_set_0",    561},
    {"vlan_egr_vid_rng_chk_set_1",    562},
    {"dmy_reg0_vlan_ivc",    563},
    {"vlan_ivc_blk_ctrl",    564},
    {"vlan_port_l2tbl_cnvt_ctrl",    565},
    {"vlan_trunk_l2tbl_cnvt_ctrl",    566},
    {"vlan_ivc_ctrl",    567},
    {"vlan_evc_ctrl",    568},
    {"vlan_ivc_entry_indication",    569},
    {"vlan_evc_entry_indication",    570},
    {"dmy_reg0_l2",    571},
    {"dmy_reg2_pkt_encap",    572},
    {"rma_ctrl_0",    573},
    {"rma_ctrl_1",    574},
    {"rma_ctrl_2",    575},
    {"rma_mirror_ctrl",    576},
    {"rma_smac_lrn_ctrl",    577},
    {"rma_mgn_lrn_ctrl",    578},
    {"rma_port_bpdu_ctrl",    579},
    {"rma_port_ptp_ctrl",    580},
    {"rma_port_lldp_ctrl",    581},
    {"rma_port_eapol_ctrl",    582},
    {"rma_fld_pmsk",    583},
    {"rma_bpdu_fld_pmsk",    584},
    {"rma_eapol_fld_pmsk",    585},
    {"rma_usr_def_fld_pmsk",    586},
    {"rma_lldp_fld_pmsk",    587},
    {"rma_usr_def_ctrl",    588},
    {"dmy_reg0_rma",    589},
    {"trk_id_ctrl",    590},
    {"trk_mbr_ctrl",    591},
    {"trk_hash_ctrl",    592},
    {"trk_ctrl",    593},
    {"trk_shft_ctrl",    594},
    {"trk_local_tbl_refresh",    595},
    {"trk_local_tbl",    596},
    {"trk_stk_ctrl",    597},
    {"local_port_trk_map",    598},
    {"dmy_reg0_trunk",    599},
    {"st_ctrl",    600},
    {"dmy_reg3_vlan",    601},
    {"port_iso_restrict_route_ctrl",    602},
    {"port_iso_vb_iso_pmsk_ctrl",    603},
    {"port_iso_vb_egr_ctrl",    604},
    {"dmy_reg0_port_iso",    605},
    {"dmy_reg0_vlan_iso",    606},
    {"l2_ctrl",    607},
    {"l2_age_ctrl",    608},
    {"l2_port_age_ctrl",    609},
    {"l2_trk_age_ctrl",    610},
    {"l2_port_salrn",    611},
    {"l2_port_new_sa_fwd",    612},
    {"l2_dyn_port_mv_act",    613},
    {"l2_dyn_port_mv_lrn",    614},
    {"l2_stt_port_mv_act",    615},
    {"l2_stt_port_mv_lrn",    616},
    {"l2_stt_trk_mv_act",    617},
    {"l2_stt_trk_mv_lrn",    618},
    {"l2_glb_stt_port_mv_act",    619},
    {"l2_glb_stt_port_mv_lrn",    620},
    {"l2_port_mv_forbid",    621},
    {"l2_trk_mv_forbid",    622},
    {"l2_port_mv_forbid_ctrl",    623},
    {"l2_port_sablk_ctrl",    624},
    {"l2_port_dablk_ctrl",    625},
    {"l2_unkn_uc_fld_pmsk",    626},
    {"l2_bc_fld_pmsk",    627},
    {"l2_port_uc_lm_act",    628},
    {"l2_port_l2_mc_lm_act",    629},
    {"l2_port_ip4_mc_lm_act",    630},
    {"l2_port_ip6_mc_lm_act",    631},
    {"l2_lrn_constrt_ctrl",    632},
    {"l2_lrn_constrt_cnt",    633},
    {"l2_lrn_port_constrt_ctrl",    634},
    {"l2_lrn_port_constrt_cnt",    635},
    {"l2_lrn_trk_constrt_ctrl",    636},
    {"l2_lrn_trk_constrt_cnt",    637},
    {"l2_lrn_vlan_constrt_entry",    638},
    {"l2_lrn_vlan_constrt_cnt",    639},
    {"l2_vlan_constrt_ctrl",    640},
    {"l2_constrt_port_cnt_dbg",    641},
    {"l2_constrt_trk_cnt_dbg",    642},
    {"l2_constrt_sys_cnt_dbg",    643},
    {"l2_constrt_vlan_cnt_dbg",    644},
    {"l2_tbl_flush_ctrl",    645},
    {"l2_src_p_fltr",    646},
    {"l2_sa_act_ref",    647},
    {"l2_hash_full_cnt",    648},
    {"l2_ntfy_ctrl",    649},
    {"l2_ntfy_pkt_ctrl",    650},
    {"l2_ntfy_pkt_timeout",    651},
    {"l2_ntfy_pkt_mac",    652},
    {"l2_ntfy_pkt_itag_0",    653},
    {"l2_ntfy_pkt_itag_1",    654},
    {"l2_ntfy_rst",    655},
    {"l2_ntfy_pkt_magic_num",    656},
    {"l2_ntfy_pkt_local_thr",    657},
    {"l2_ntfy_pkt_remotel_thr",    658},
    {"l2_ntfy_remotel_congest",    659},
    {"l2_notify_ring_base_addr",    660},
    {"l2_notify_ring_cur_addr",    661},
    {"l2_notify_if_intr_msk",    662},
    {"l2_notify_if_intr_sts",    663},
    {"dma_l2msg_tmrout",    664},
    {"dma_l2msg_cnt_sel",    665},
    {"dma_rdma_cnt_sel",    666},
    {"dmy_reg1_nic",    667},
    {"dmy_reg0_spc_port",    668},
    {"dmy_reg0_nic_sys",    669},
    {"mac_tx_disable",    670},
    {"storm_ctrl",    671},
    {"storm_lb_ctrl",    672},
    {"storm_lb_pps_ctrl",    673},
    {"storm_lb_proto_ctrl",    674},
    {"storm_port_ctrl",    675},
    {"storm_port_uc_ctrl",    676},
    {"storm_port_uc_lb_rst",    677},
    {"storm_port_uc_exceed_flag",    678},
    {"storm_port_mc_ctrl",    679},
    {"storm_port_mc_lb_rst",    680},
    {"storm_port_mc_exceed_flag",    681},
    {"storm_port_bc_ctrl",    682},
    {"storm_port_bc_lb_rst",    683},
    {"storm_port_bc_exceed_flag",    684},
    {"storm_port_proto_dhcp_ctrl",    685},
    {"storm_port_proto_dhcp_lb_rst",    686},
    {"storm_port_proto_dhcp_exceed_flag",    687},
    {"storm_port_proto_bpdu_ctrl",    688},
    {"storm_port_proto_bpdu_lb_rst",    689},
    {"storm_port_proto_bpdu_exceed_flag",    690},
    {"storm_port_proto_igmp_ctrl",    691},
    {"storm_port_proto_igmp_lb_rst",    692},
    {"storm_port_proto_igmp_exceed_flag",    693},
    {"storm_port_proto_arp_ctrl",    694},
    {"storm_port_proto_arp_lb_rst",    695},
    {"storm_port_proto_arp_exceed_flag",    696},
    {"dmy_reg0_storm",    697},
    {"dmy_reg1_storm",    698},
    {"dmy_reg0_prestorm",    699},
    {"igbw_ctrl",    700},
    {"igbw_lb_ctrl",    701},
    {"igbw_port_ctrl",    702},
    {"igbw_port_burst_ctrl",    703},
    {"igbw_port_lb_rst",    704},
    {"igbw_port_exceed_flag",    705},
    {"igbw_port_fc_ctrl",    706},
    {"dmy_reg0_inbw",    707},
    {"egbw_encap_ctrl",    708},
    {"egbw_ctrl",    709},
    {"egbw_cpu_pps_lb_ctrl",    710},
    {"egbw_lb_ctrl",    711},
    {"egbw_port_ctrl",    712},
    {"egbw_port_lb_rst",    713},
    {"egbw_port_q_max_lb_ctrl_set0",    714},
    {"egbw_port_q_max_lb_ctrl_set1",    715},
    {"egbw_port_q_max_lb_rst_set0",    716},
    {"egbw_port_q_max_lb_rst_set1",    717},
    {"egbw_cpu_q_max_lb_ctrl",    718},
    {"egbw_cpu_q_max_lb_rst",    719},
    {"egbw_port_q_assured_fix_burst_ctrl_set0",    720},
    {"egbw_port_q_assured_fix_burst_ctrl_set1",    721},
    {"egbw_port_q_assured_lb_ctrl_set0",    722},
    {"egbw_port_q_assured_lb_ctrl_set1",    723},
    {"egbw_port_q_fix_lb_ctrl_set0",    724},
    {"egbw_port_q_fix_lb_ctrl_set1",    725},
    {"egbw_port_q_assured_fix_lb_rst_set0",    726},
    {"egbw_port_q_assured_fix_lb_rst_set1",    727},
    {"egbw_rate_10m_ctrl",    728},
    {"egbw_rate_100m_ctrl",    729},
    {"egbw_rate_1g_ctrl",    730},
    {"egbw_rate_500m_ctrl",    731},
    {"egbw_rate_10g_ctrl",    732},
    {"egbw_rate_2500m_ctrl",    733},
    {"egbw_rate_1250m_ctrl",    734},
    {"egbw_rate_5g_ctrl",    735},
    {"egbw_rate_sxg_ctrl",    736},
    {"dmy_reg0_egress_ctrl",    737},
    {"dmy_reg0_p28_txq_reg",    738},
    {"meter_glb_ctrl",    739},
    {"meter_lb_exceed_sts",    740},
    {"meter_lb_glb_exceed_sts",    741},
    {"meter_cntr_ctrl",    742},
    {"meter_green_cntr_sts",    743},
    {"meter_yellow_cntr_sts",    744},
    {"meter_red_cntr_sts",    745},
    {"meter_total_cntr_sts",    746},
    {"meter_lb_ctrl",    747},
    {"meter_lb_pps_ctrl",    748},
    {"dmy_reg0_ale_meter",    749},
    {"fc_ctrl",    750},
    {"fc_port_act_ctrl",    751},
    {"fc_glb_sys_util_thr",    752},
    {"fc_glb_drop_thr",    753},
    {"fc_glb_hi_thr",    754},
    {"fc_glb_lo_thr",    755},
    {"fc_glb_fcoff_hi_thr",    756},
    {"fc_glb_fcoff_lo_thr",    757},
    {"fc_jumbo_hi_thr",    758},
    {"fc_jumbo_lo_thr",    759},
    {"fc_jumbo_fcoff_hi_thr",    760},
    {"fc_jumbo_fcoff_lo_thr",    761},
    {"fc_jumbo_thr_adjust",    762},
    {"fc_port_hi_thr",    763},
    {"fc_port_lo_thr",    764},
    {"fc_port_fcoff_hi_thr",    765},
    {"fc_port_fcoff_lo_thr",    766},
    {"fc_port_guar_thr",    767},
    {"fc_port_thr_set_sel",    768},
    {"fc_port_egr_drop_ctrl",    769},
    {"fc_hol_prvnt_ctrl",    770},
    {"fc_port_q_egr_drop_ctrl_set0",    771},
    {"fc_port_q_egr_drop_ctrl_set1",    772},
    {"fc_cpu_q_egr_drop_ctrl",    773},
    {"fc_port_q_egr_force_drop_ctrl_set0",    774},
    {"fc_port_q_egr_force_drop_ctrl_set1",    775},
    {"fc_cpu_q_egr_force_drop_ctrl",    776},
    {"fc_q_egr_drop_thr",    777},
    {"fc_cpu_q_egr_drop_thr",    778},
    {"fc_port_egr_drop_thr_set_sel",    779},
    {"fc_lb_port_ctrl",    780},
    {"fc_lb_port_q_egr_drop_thr",    781},
    {"fc_glb_page_cnt",    782},
    {"fc_port_page_cnt",    783},
    {"fc_glb_page_peakcnt",    784},
    {"fc_port_cur_page_cnt",    785},
    {"fc_port_peak_page_cnt",    786},
    {"fc_port_egr_page_cnt",    787},
    {"fc_port_q_egr_page_cnt_set0",    788},
    {"fc_port_q_egr_page_cnt_set1",    789},
    {"fc_cpu_q_egr_page_cnt",    790},
    {"fc_port_q_egr_pkt_cnt_set0",    791},
    {"fc_port_q_egr_pkt_cnt_set1",    792},
    {"fc_cpu_q_egr_pkt_cnt",    793},
    {"fc_lb_port_egr_page_cnt",    794},
    {"fc_lb_port_egr_pkt_cnt",    795},
    {"fc_repct_q_hsm_thr",    796},
    {"fc_repct_q_hsa_thr",    797},
    {"fc_port_repct_fc_en",    798},
    {"fc_repct_q_port_sel_en",    799},
    {"fc_repct_q_port_sel",    800},
    {"fc_repct_q_int_pri_mapping",    801},
    {"fc_repct_q_hsm_cnt",    802},
    {"fc_repct_q_hsa_cnt",    803},
    {"ete_fc_ctrl",    804},
    {"ete_fc_cascade_port_drop_thr",    805},
    {"ete_fc_on_remote_port_thr",    806},
    {"ete_fc_off_remote_port_thr",    807},
    {"ete_fc_remote_port_guar_thr",    808},
    {"ete_fc_remote_port_thr_set_sel",    809},
    {"ete_fc_remote_tx_pause_sts",    810},
    {"ete_fc_remote_congest_sts",    811},
    {"ete_fc_special_pause_dmac",    812},
    {"ete_fc_special_pause_smac",    813},
    {"ete_fc_remote_port_page_cnt",    814},
    {"ete_fc_port_page_cnt_error",    815},
    {"ete_fc_remote_port_page_cnt_error",    816},
    {"ete_fc_l2ntfy_port_page_cnt",    817},
    {"ete_fc_remote_l2ntfy_port_page_cnt",    818},
    {"ete_fc_l2ntfy_port_page_cnt_error",    819},
    {"ete_fc_remote_l2ntfy_port_page_cnt_error",    820},
    {"ete_fc_pause_frame_port_congest_sts",    821},
    {"dmy_reg0_per_port_txq_reg_28p",    822},
    {"dmy_reg0_per_port_txq_reg_29p",    823},
    {"dmy_reg1_egress_ctrl",    824},
    {"dmy_reg1_p28_txq_reg",    825},
    {"dmy_reg0_rt_reg",    826},
    {"dmy_reg0_egress_drop",    827},
    {"dmy_reg0_ingress_ctrl",    828},
    {"dmy_reg1_ingress_ctrl",    829},
    {"swred_port_ctrl",    830},
    {"swred_queue_drop_ctrl",    831},
    {"swred_drop_cntr_pidx",    832},
    {"swred_drop_cntr_cidx",    833},
    {"swred_drop_cntr",    834},
    {"swred_drop_cntr_rst",    835},
    {"sc_p_ctrl",    836},
    {"sc_p_en",    837},
    {"dmy_reg0_ale_dbg_cnt",    838},
    {"pri_sel_ctrl",    839},
    {"pri_sel_port_ctrl",    840},
    {"pri_sel_remap_port",    841},
    {"pri_sel_remap_ipri_cfi0",    842},
    {"pri_sel_remap_ipri_cfi1",    843},
    {"pri_sel_remap_opri_dei0",    844},
    {"pri_sel_remap_opri_dei1",    845},
    {"pri_sel_remap_dscp",    846},
    {"pri_sel_port_tbl_idx_ctrl",    847},
    {"pri_sel_tbl_ctrl",    848},
    {"dp_sel_remap_itag_cfi0",    849},
    {"dp_sel_remap_itag_cfi1",    850},
    {"dp_sel_remap_otag_dei0",    851},
    {"dp_sel_remap_otag_dei1",    852},
    {"dp_sel_remap_dscp",    853},
    {"dp_sel_port_tbl_ctrl",    854},
    {"dmy_reg0_ingpri",    855},
    {"qm_intpri2qid_ctrl",    856},
    {"qm_cpuqid2qid_ctrl",    857},
    {"qm_cpuqid2xgqid_ctrl",    858},
    {"qm_rsn2cpuqid_ctrl_0",    859},
    {"qm_rsn2cpuqid_ctrl_1",    860},
    {"qm_rsn2cpuqid_ctrl_2",    861},
    {"qm_rsn2cpuqid_ctrl_3",    862},
    {"qm_rsn2cpuqid_ctrl_4",    863},
    {"qm_rsn2cpuqid_ctrl_5",    864},
    {"qm_rsn2cpuqid_ctrl_6",    865},
    {"qm_rsn2cpuqid_ctrl_7",    866},
    {"qm_rsn2cpuqid_ctrl_8",    867},
    {"qm_flag2cpuqid_ctrl_0",    868},
    {"qm_flag2cpuqid_ctrl_1",    869},
    {"sched_port_q_ctrl_set0",    870},
    {"sched_port_q_ctrl_set1",    871},
    {"sched_cpu_q_ctrl",    872},
    {"sched_port_algo_ctrl",    873},
    {"dmy_reg2_egress_ctrl",    874},
    {"dmy_reg0_queue",    875},
    {"dmy_reg0_per_port_txq_reg_24p",    876},
    {"dmy_reg0_port_txq_reg_4p",    877},
    {"dmy_reg1_port_txq_reg_4p",    878},
    {"dmy_reg2_port_txq_reg_4p",    879},
    {"dmy_reg3_port_txq_reg_4p",    880},
    {"rmk_ctrl",    881},
    {"rmk_port_ctrl",    882},
    {"rmk_intpri2ipri_ctrl",    883},
    {"rmk_ipri2ipri_ctrl",    884},
    {"rmk_opri2ipri_ctrl",    885},
    {"rmk_dscp2ipri_ctrl",    886},
    {"rmk_intpri2opri_ctrl",    887},
    {"rmk_ipri2opri_ctrl",    888},
    {"rmk_opri2opri_ctrl",    889},
    {"rmk_dscp2opri_ctrl",    890},
    {"rmk_intpri2dei_ctrl",    891},
    {"rmk_dp2dei_ctrl",    892},
    {"rmk_intpri2dscp_ctrl",    893},
    {"rmk_ipri2dscp_ctrl",    894},
    {"rmk_opri2dscp_ctrl",    895},
    {"rmk_dscp2dscp_ctrl",    896},
    {"rmk_dpintpri2dscp_ctrl",    897},
    {"dmy_reg3_pkt_encap",    898},
    {"avb_port_class_a_en",    899},
    {"avb_port_class_b_en",    900},
    {"avb_ctrl",    901},
    {"dmy_reg0_eavspe",    902},
    {"l3_ip_route_ctrl",    903},
    {"l3_host_tbl_ctrl",    904},
    {"l3_ipuc_route_ctrl",    905},
    {"l3_ip6uc_route_ctrl",    906},
    {"l3_ipmc_route_ctrl",    907},
    {"l3_ip6mc_route_ctrl",    908},
    {"l3_ip_mtu_ctrl",    909},
    {"l3_ip6_mtu_ctrl",    910},
    {"l3_port_ip_route_ctrl",    911},
    {"l3_port_ip6_route_ctrl",    912},
    {"l3_entry_counter_ctrl",    913},
    {"l3_entry_counter_data",    914},
    {"l3_entry_mv_ctrl",    915},
    {"l3_entry_mv_param",    916},
    {"l3_hw_lu_key_ctrl",    917},
    {"l3_hw_lu_key_ip_ctrl",    918},
    {"l3_hw_lu_key_dip_ctrl",    919},
    {"l3_hw_lu_ctrl",    920},
    {"dmy_reg1_rt_reg",    921},
    {"dmy_reg2_rt_reg",    922},
    {"dmy_reg3_rt_reg",    923},
    {"stat_rst",    924},
    {"stat_port_rst",    925},
    {"stat_ctrl",    926},
    {"stat_cnt_set1_ctrl",    927},
    {"stat_cnt_set0_ctrl",    928},
    {"dmy_reg0_mib_ctrl",    929},
    {"stat_bridge_dot1dtplearnedentrydiscards",    930},
    {"stat_port_mib_cntr",    931},
    {"stat_port_prvte_cntr",    932},
    {"stat_port_prvte_e_q_rst",    933},
    {"stat_port_e_drop_cntr0",    934},
    {"stat_port_e_drop_cntr1",    935},
    {"stat_port_e_drop_cntr2",    936},
    {"dmy_reg0_ale_egr_cnt",    937},
    {"dmy_reg1_ale_egr_cnt",    938},
    {"dmy_reg2_ale_egr_cnt",    939},
    {"dmy_reg3_ale_egr_cnt",    940},
    {"stat_prvte_drop_counter0",    941},
    {"stat_prvte_drop_counter1",    942},
    {"stat_prvte_drop_counter2",    943},
    {"stat_prvte_drop_counter3",    944},
    {"stat_prvte_drop_counter4",    945},
    {"stat_prvte_drop_counter5",    946},
    {"stat_prvte_drop_counter6",    947},
    {"stat_prvte_drop_counter7",    948},
    {"stat_prvte_drop_counter8",    949},
    {"stat_prvte_drop_counter9",    950},
    {"stat_prvte_drop_counter10",    951},
    {"stat_prvte_drop_counter11",    952},
    {"stat_prvte_drop_counter12",    953},
    {"stat_prvte_drop_counter13",    954},
    {"stat_prvte_drop_counter14",    955},
    {"stat_prvte_drop_counter15",    956},
    {"stat_prvte_drop_counter16",    957},
    {"stat_prvte_drop_counter17",    958},
    {"stat_prvte_drop_counter18",    959},
    {"stat_prvte_drop_counter19",    960},
    {"stat_prvte_drop_counter20",    961},
    {"stat_prvte_drop_counter21",    962},
    {"stat_prvte_drop_counter22",    963},
    {"stat_prvte_drop_counter23",    964},
    {"stat_prvte_drop_counter24",    965},
    {"stat_prvte_drop_counter25",    966},
    {"stat_prvte_drop_counter26",    967},
    {"stat_prvte_drop_counter27",    968},
    {"stat_prvte_drop_counter28",    969},
    {"stat_prvte_drop_counter29",    970},
    {"stat_prvte_drop_counter30",    971},
    {"stat_prvte_drop_counter31",    972},
    {"stat_prvte_drop_counter32",    973},
    {"stat_prvte_drop_counter33",    974},
    {"stat_prvte_drop_counter34",    975},
    {"stat_prvte_drop_counter35",    976},
    {"stat_prvte_drop_counter36",    977},
    {"stat_prvte_drop_counter37",    978},
    {"stat_prvte_drop_counter38",    979},
    {"stat_prvte_drop_counter39",    980},
    {"stat_prvte_drop_counter40",    981},
    {"stat_prvte_drop_counter41",    982},
    {"stat_prvte_drop_counter42",    983},
    {"stat_prvte_drop_counter43",    984},
    {"stat_prvte_drop_counter44",    985},
    {"stat_prvte_drop_counter45",    986},
    {"stat_prvte_drop_counter46",    987},
    {"stat_prvte_drop_counter47",    988},
    {"stat_prvte_drop_counter48",    989},
    {"stat_prvte_drop_counter49",    990},
    {"stat_prvte_drop_counter50",    991},
    {"stat_prvte_drop_counter51",    992},
    {"stat_prvte_drop_counter52",    993},
    {"stat_prvte_drop_counter53",    994},
    {"stat_prvte_drop_counter54",    995},
    {"stat_prvte_drop_counter55",    996},
    {"stat_prvte_drop_counter56",    997},
    {"stat_prvte_drop_counter57",    998},
    {"stat_prvte_drop_counter58",    999},
    {"stat_prvte_drop_counter59",    1000},
    {"stat_prvte_drop_counter60",    1001},
    {"stat_prvte_drop_counter61",    1002},
    {"stat_prvte_drop_counter62",    1003},
    {"stat_prvte_drop_counter63",    1004},
    {"stat_prvte_drop_counter64",    1005},
    {"stat_prvte_drop_counter65",    1006},
    {"stat_prvte_drop_counter66",    1007},
    {"stat_prvte_drop_counter67",    1008},
    {"stat_prvte_drop_counter68",    1009},
    {"stat_prvte_drop_counter69",    1010},
    {"stat_prvte_drop_counter70",    1011},
    {"stat_prvte_drop_counter71",    1012},
    {"stat_prvte_drop_counter72",    1013},
    {"stat_prvte_drop_counter73",    1014},
    {"stat_prvte_drop_counter74",    1015},
    {"stat_prvte_drop_counter75",    1016},
    {"stat_prvte_drop_counter76",    1017},
    {"stat_prvte_drop_counter77",    1018},
    {"stat_prvte_drop_counter78",    1019},
    {"stat_prvte_drop_counter79",    1020},
    {"stat_prvte_drop_counter80",    1021},
    {"stat_prvte_drop_counter81",    1022},
    {"stat_prvte_drop_counter82",    1023},
    {"stat_prvte_drop_counter83",    1024},
    {"stat_prvte_drop_counter84",    1025},
    {"mir_ctrl",    1026},
    {"mir_spm_ctrl",    1027},
    {"mir_dpm_ctrl",    1028},
    {"mir_sample_rate_ctrl",    1029},
    {"mir_qid_ctrl",    1030},
    {"dmy_reg0_mirror",    1031},
    {"mir_rspan_vlan_ctrl",    1032},
    {"mir_rspan_tx_ctrl",    1033},
    {"mir_rspan_rx_tag_rm_ctrl",    1034},
    {"dmy_reg4_pkt_encap",    1035},
    {"dmy_reg5_pkt_encap",    1036},
    {"sflow_ctrl",    1037},
    {"sflow_port_rate_ctrl",    1038},
    {"pie_blk_lookup_ctrl",    1039},
    {"pie_blk_phase_ctrl",    1040},
    {"pie_tmplte_ctrl",    1041},
    {"pie_blk_group_ctrl",    1042},
    {"pie_blk_tmplte_ctrl",    1043},
    {"pie_mv_ctrl",    1044},
    {"pie_mv_len_ctrl",    1045},
    {"pie_clr_ctrl",    1046},
    {"pie_rule_hit_indication",    1047},
    {"pie_glb_hit_indication",    1048},
    {"pie_misc",    1049},
    {"pie_ctrl",    1050},
    {"dmy_reg0_ale_acl_glb",    1051},
    {"acl_port_lookup_ctrl",    1052},
    {"acl_ctrl",    1053},
    {"dmy_reg1_ale_acl_glb",    1054},
    {"rng_chk_ctrl",    1055},
    {"rng_chk_ip_ctrl",    1056},
    {"rng_chk_ip_rng",    1057},
    {"dmy_reg0_acl_range",    1058},
    {"atk_prvnt_port_en",    1059},
    {"atk_prvnt_ctrl",    1060},
    {"atk_prvnt_act",    1061},
    {"atk_prvnt_ipv6_ctrl",    1062},
    {"atk_prvnt_icmp_ctrl",    1063},
    {"atk_prvnt_tcp_ctrl",    1064},
    {"atk_prvnt_smurf_ctrl",    1065},
    {"atk_prvnt_sts",    1066},
    {"atk_prvnt_arp_invld_port_act",    1067},
    {"dmy_reg0_attack",    1068},
    {"oam_ctrl",    1069},
    {"oam_port_act_ctrl",    1070},
    {"oam_glb_dying_gasp_ctrl",    1071},
    {"oam_port_dying_gasp_ctrl",    1072},
    {"dying_gasp_polarity_ctrl",    1073},
    {"dmy_reg0_oam",    1074},
    {"rldp_rlpp_ctrl",    1075},
    {"stk_glb_ctrl",    1076},
    {"stk_unit_port_map_ctrl",    1077},
    {"stk_non_unicast_block_ctrl",    1078},
    {"stk_cascade_ctrl",    1079},
    {"stk_one_hop_redir_pm_ctrl",    1080},
    {"stk_dbg_ctrl",    1081},
    {"parser_field_seltor_ctrl",    1082},
    {"parser_ctrl",    1083},
    {"parser_drop_reason",    1084},
    {"dmy_reg0_pkt_parser",    1085},
    {"hsb_data0",    1086},
    {"hsb_data1",    1087},
    {"hsb_data2",    1088},
    {"hsb_data3",    1089},
    {"hsb_data4",    1090},
    {"hsb_data5",    1091},
    {"hsb_data6",    1092},
    {"hsb_data7",    1093},
    {"hsb_data8",    1094},
    {"hsb_data9",    1095},
    {"hsb_data10",    1096},
    {"hsb_data11",    1097},
    {"hsb_data12",    1098},
    {"hsb_data13",    1099},
    {"hsb_data14",    1100},
    {"hsb_data15",    1101},
    {"hsb_data16",    1102},
    {"hsb_data17",    1103},
    {"hsb_data18",    1104},
    {"hsb_data19",    1105},
    {"hsb_data20",    1106},
    {"hsb_data21",    1107},
    {"hsb_data22",    1108},
    {"hsb_data23",    1109},
    {"hsb_data24",    1110},
    {"hsb_data25",    1111},
    {"hsb_data26",    1112},
    {"hsb_data27",    1113},
    {"hsb_data28",    1114},
    {"hsb_data29",    1115},
    {"dmy_reg0_hsb",    1116},
    {"hsm0_data0",    1117},
    {"hsm0_data1",    1118},
    {"hsm0_data2",    1119},
    {"hsm0_data3",    1120},
    {"hsm0_data4",    1121},
    {"hsm0_data5",    1122},
    {"hsm0_data6",    1123},
    {"hsm0_data7",    1124},
    {"hsm0_data8",    1125},
    {"hsm0_data9",    1126},
    {"hsm0_data10",    1127},
    {"hsm0_data11",    1128},
    {"hsm0_data12",    1129},
    {"hsm0_data13",    1130},
    {"hsm0_data14",    1131},
    {"hsm0_data15",    1132},
    {"hsm0_data16",    1133},
    {"hsm0_data17",    1134},
    {"hsm1_data0",    1135},
    {"hsm1_data1",    1136},
    {"hsm1_data2",    1137},
    {"hsm1_data3",    1138},
    {"hsm1_data4",    1139},
    {"hsm1_data5",    1140},
    {"hsm1_data6",    1141},
    {"hsm1_data7",    1142},
    {"hsm1_data8",    1143},
    {"hsm1_data9",    1144},
    {"hsm1_data10",    1145},
    {"hsm1_data11",    1146},
    {"hsm1_data12",    1147},
    {"hsm1_data13",    1148},
    {"hsm1_data14",    1149},
    {"hsm1_data15",    1150},
    {"hsm1_data16",    1151},
    {"hsm2_data0",    1152},
    {"hsm2_data1",    1153},
    {"hsm2_data2",    1154},
    {"hsm2_data3",    1155},
    {"hsm2_data4",    1156},
    {"hsm2_data5",    1157},
    {"hsm2_data6",    1158},
    {"hsm2_data7",    1159},
    {"hsm2_data8",    1160},
    {"hsm2_data9",    1161},
    {"hsm2_data10",    1162},
    {"hsm2_data11",    1163},
    {"hsm2_data12",    1164},
    {"hsm2_data13",    1165},
    {"hsm2_data14",    1166},
    {"hsm2_data15",    1167},
    {"hsm2_data16",    1168},
    {"hsm2_data17",    1169},
    {"hsm2_data18",    1170},
    {"hsm2_data19",    1171},
    {"hsm2_data20",    1172},
    {"hsm2_data21",    1173},
    {"hsm2_data22",    1174},
    {"hsm2_data23",    1175},
    {"hsm2_data24",    1176},
    {"hsm2_data25",    1177},
    {"hsm2_data26",    1178},
    {"hsm2_data27",    1179},
    {"hsm3_data0",    1180},
    {"hsm3_data1",    1181},
    {"hsm3_data2",    1182},
    {"hsm3_data3",    1183},
    {"hsm3_data4",    1184},
    {"hsm3_data5",    1185},
    {"hsm3_data6",    1186},
    {"hsm3_data7",    1187},
    {"hsm3_data8",    1188},
    {"hsm3_data9",    1189},
    {"hsm3_data10",    1190},
    {"hsm3_data11",    1191},
    {"hsm3_data12",    1192},
    {"hsm3_data13",    1193},
    {"hsm3_data14",    1194},
    {"hsm3_data15",    1195},
    {"hsm3_data16",    1196},
    {"hsm3_data17",    1197},
    {"hsm3_data18",    1198},
    {"hsm3_data19",    1199},
    {"hsm3_data20",    1200},
    {"hsm3_data21",    1201},
    {"hsm3_data22",    1202},
    {"hsm3_data23",    1203},
    {"hsm3_data24",    1204},
    {"hsm3_data25",    1205},
    {"hsm3_data26",    1206},
    {"hsm3_data27",    1207},
    {"dmy_reg0_hsm",    1208},
    {"dmy_reg1_hsm",    1209},
    {"dmy_reg2_hsm",    1210},
    {"dmy_reg3_hsm",    1211},
    {"hsa_data0",    1212},
    {"hsa_data1",    1213},
    {"hsa_data2",    1214},
    {"hsa_data3",    1215},
    {"hsa_data4",    1216},
    {"hsa_data5",    1217},
    {"hsa_data6",    1218},
    {"hsa_data7",    1219},
    {"hsa_data8",    1220},
    {"hsa_data9",    1221},
    {"hsa_data10",    1222},
    {"hsa_data11",    1223},
    {"hsa_data12",    1224},
    {"hsa_data13",    1225},
    {"hsa_data14",    1226},
    {"hsa_data15",    1227},
    {"hsa_data16",    1228},
    {"hsa_data17",    1229},
    {"hsa_data18",    1230},
    {"hsa_data19",    1231},
    {"hsa_data20",    1232},
    {"hsa_data21",    1233},
    {"dmy_reg0_hsa",    1234},
    {"test_mode_ale_ctrl",    1235},
    {"test_mode_ale_hsb_multi_ctrl",    1236},
    {"test_mode_ale_hsa_multi_ctrl",    1237},
    {"dmy_reg4_rt_reg",    1238},
    {"test_mode_ale_loopback_ctrl",    1239},
    {"spg_glb_ctrl",    1240},
    {"pkb_acc_debug_ctrl",    1241},
    {"spg_port_tx_grp_ctrl",    1242},
    {"spg_global_sts",    1243},
    {"spg_port_ipg_ctrl",    1244},
    {"spg_port_pkt_cnt_h",    1245},
    {"spg_port_pkt_cnt_l",    1246},
    {"spg_port_pkt_cnt_dbg_h",    1247},
    {"spg_port_pkt_cnt_dbg_l",    1248},
    {"spg_port_stream0_ctrl0",    1249},
    {"spg_port_stream0_ctrl1",    1250},
    {"spg_port_stream0_ctrl2",    1251},
    {"spg_port_stream0_ctrl3",    1252},
    {"spg_port_stream0_ctrl4",    1253},
    {"spg_port_stream1_ctrl0",    1254},
    {"spg_port_stream1_ctrl1",    1255},
    {"spg_port_stream1_ctrl2",    1256},
    {"spg_port_stream1_ctrl3",    1257},
    {"spg_port_stream1_ctrl4",    1258},
    {"spg_pb_access_ctrl0",    1259},
    {"spg_pb_access_ctrl1",    1260},
    {"spg_pb_access_ctrl2",    1261},
    {"spg_port_index_ctrl0",    1262},
    {"spg_global_index_ctrl0",    1263},
    {"rxport_dsc_sts",    1264},
    {"rxport_dsc_err",    1265},
    {"sw_q_rst_sys_thr",    1266},
    {"sw_q_rst_p_thr",    1267},
    {"dmy_reg1to28_ingress_ctrl_2",    1268},
    {"ld_tx_dsc_sts",    1269},
    {"ld_tx_dsc_err",    1270},
    {"tx_dsc_chk_tmr",    1271},
    {"rxfifo_overflow_sts",    1272},
    {"rxfifo_overflow_err",    1273},
    {"rxfifo_rdempty_sts",    1274},
    {"rxfifo_rdempty_err",    1275},
    {"txfifo_overflow_sts",    1276},
    {"txfifo_overflow_err",    1277},
    {"txfifo_rdempty_sts",    1278},
    {"txfifo_rdempty_err",    1279},
    {"pingpong_plus_sts",    1280},
    {"pingpong_plus_err",    1281},
    {"token_sts",    1282},
    {"token_err",    1283},
    {"sw_q_rst_cnt",    1284},
    {"trig_auto_recover_ctrl_ingress",    1285},
    {"trig_auto_recover_ctrl_egress",    1286},
    {"trig_auto_recover_ctrl_mac",    1287},
    {"auto_recover_event_flag_sts_ingress",    1288},
    {"auto_recover_event_flag_sts_egress",    1289},
    {"auto_recover_event_flag_sts_mac",    1290},
    {"auto_recover_event_flag_err_ingress",    1291},
    {"auto_recover_event_flag_err_egress",    1292},
    {"auto_recover_event_flag_err_mac",    1293},
    {"txerr_cnt",    1294},
    {"dmy_reg3_egress_ctrl",    1295},
    {"dmy_reg0_ingress_ctrl_2",    1296},
    {"dmy_reg4_egress_ctrl",    1297},
    {"code_protect_state",    1298},
    {"encap_sram_ctrl0",    1299},
    {"encap_sram_ctrl1",    1300},
    {"par_sram_ctrl0",    1301},
    {"par_sram_ctrl1",    1302},
    {"par_sram_ctrl2",    1303},
    {"port29_dbg_reg0",    1304},
    {"port29_dbg_reg1",    1305},
    {"port30_dbg_reg0",    1306},
    {"port30_dbg_reg1",    1307},
    {"",    1308}
};

static diag_table_reg_name_value_pair_t longan_diag_reg_field_array[] =
{
    {"rtl_id",    0},
    {"model_char_1st",    1},
    {"model_char_2nd",    2},
    {"model_char_3rd",    3},
    {"rtl_vid",    4},
    {"rl_vid",    5},
    {"mcid",    6},
    {"reserved",    7},
    {"chip_info_en",    8},
    {"rl_id",    9},
    {"rst_out_tmr",    10},
    {"frc_rstout",    11},
    {"frc_rstout_en",    12},
    {"chip_rst_en",    13},
    {"wd_rst_en",    14},
    {"sds_reg_rst",    15},
    {"sw_rst",    16},
    {"cpu_mem_rst",    17},
    {"sw_serdes_rst",    18},
    {"sw_nic_rst",    19},
    {"sw_q_rst",    20},
    {"sw_chip_rst",    21},
    {"chip_rst_sta",    22},
    {"wdog_rst_sta",    23},
    {"en_rst_deg",    24},
    {"en_aferst",    25},
    {"p28_txrst_option",    26},
    {"mac_sta",    27},
    {"dv_speedup_rst",    28},
    {"mac_rst_dur",    29},
    {"pll_dbg_out",    30},
    {"cpu_clk_sel",    31},
    {"nor_clk_sel",    32},
    {"lxb_clk_sel",    33},
    {"sw_pll_ready",    34},
    {"cpu_pll_ready",    35},
    {"reg_125m_pll_ready",    36},
    {"bypass_ale_pll",    37},
    {"bypass_nor_pll",    38},
    {"bypass_lxb_pll",    39},
    {"bypass_cpu_pll",    40},
    {"bypass_125m_pll",    41},
    {"bypass_sram_pll",    42},
    {"en_ddr_pll",    43},
    {"en_nor_pll",    44},
    {"en_nand_pll",    45},
    {"en_usb_pll",    46},
    {"en_lxb_pll",    47},
    {"en_cpu_pll",    48},
    {"en_125m_pll",    49},
    {"en_sram_pll",    50},
    {"dll_pre_divn",    51},
    {"reg_en_pll_mon",    52},
    {"reg_cmu_dly_en_cpu",    53},
    {"reg_cmu_dly_en_sw",    54},
    {"reg_cmu_dly_en_125m",    55},
    {"reg_fld_dsel_cpu",    56},
    {"reg_fld_dsel_sw",    57},
    {"reg_fld_dsel_125m",    58},
    {"cmu_test_en_cpu",    59},
    {"cmu_divn3_cpu",    60},
    {"cpu_cmu_fcode_in",    61},
    {"cpu_cmu_ncode_in",    62},
    {"cpu_cmu_bypass_pi",    63},
    {"cpu_cmu_sel_div4",    64},
    {"cpu_cmu_sel_prediv",    65},
    {"cpu_cmu_en_ssc",    66},
    {"cpu_cmu_step_in",    67},
    {"cpu_cmu_tbase_in",    68},
    {"cpu_cmu_ssc_order",    69},
    {"cpu_cmu_time2_rst_width",    70},
    {"cpu_cmu_time0_ck",    71},
    {"cpu_cmu_en",    72},
    {"cpu_cmu_clkrdy",    73},
    {"cpu_cmu_big_kvco",    74},
    {"cpu_cmu_lpf_rs",    75},
    {"cpu_cmu_en_center_in",    76},
    {"cpu_cmu_en_wd",    77},
    {"cpu_cmu_pi_i_sel",    78},
    {"cpu_cmu_sel_cp_i",    79},
    {"cpu_cmu_sel_cco",    80},
    {"cpu_cmu_ldo_sel",    81},
    {"cpu_cmu_lpf_cp",    82},
    {"cpu_cmu_cp_new_en",    83},
    {"cpu_cmu_ldo_en",    84},
    {"cpu_cmu_vc_dly",    85},
    {"cpu_cmu_en_ckoobs",    86},
    {"reg_cmu_divn2_cpu",    87},
    {"reg_cmu_divn2_dll",    88},
    {"reg_cmu_en_dll",    89},
    {"cmu_test_en_sw",    90},
    {"sw_cmu_fcode_in",    91},
    {"sw_cmu_ncode_in",    92},
    {"sw_cmu_bypass_pi",    93},
    {"sw_cmu_sel_div4",    94},
    {"sw_cmu_sel_prediv",    95},
    {"sw_cmu_en_ssc",    96},
    {"sw_cmu_step_in",    97},
    {"sw_cmu_tbase_in",    98},
    {"sw_cmu_ssc_order",    99},
    {"sw_cmu_time2_rst_width",    100},
    {"sw_cmu_time0_ck",    101},
    {"sw_cmu_clkrdy",    102},
    {"sw_cmu_big_kvco",    103},
    {"sw_cmu_lpf_rs",    104},
    {"sw_cmu_en_center_in",    105},
    {"sw_cmu_en_wd",    106},
    {"sw_cmu_pi_i_sel",    107},
    {"sw_cmu_sel_cp_i",    108},
    {"sw_cmu_sel_cco",    109},
    {"sw_cmu_ldo_sel",    110},
    {"sw_cmu_lpf_cp",    111},
    {"sw_cmu_cp_new_en",    112},
    {"sw_cmu_ldo_en",    113},
    {"sw_cmu_vc_dly",    114},
    {"sw_cmu_en_ckoobs",    115},
    {"sw_cmu_en",    116},
    {"reg_cmu_divn2_spi_nor",    117},
    {"reg_cmu_divn2_lxb_nand_usb",    118},
    {"reg_cmu_divn2_swcore",    119},
    {"reg_cmu_divn2_gphydbg",    120},
    {"en_gphy_dbg_pll",    121},
    {"cmu_test_en_125m",    122},
    {"reg_125m_cmu_fcode_in",    123},
    {"reg_125m_cmu_ncode_in",    124},
    {"reg_125m_cmu_bypass_pi",    125},
    {"reg_125m_cmu_sel_div4",    126},
    {"reg_125m_cmu_sel_prediv",    127},
    {"reg_cmu_divn2_125m",    128},
    {"reg_125m_cmu_en_ssc",    129},
    {"reg_125m_cmu_step_in",    130},
    {"reg_125m_cmu_tbase_in",    131},
    {"reg_cmu_div5_en_125m",    132},
    {"reg_cmu_div4_en_125m",    133},
    {"reg_125m_cmu_en",    134},
    {"reg_125m_cmu_ssc_order",    135},
    {"reg_125m_cmu_time2_rst_width",    136},
    {"reg_125m_cmu_time0_ck",    137},
    {"reg_125m_cmu_clkrdy",    138},
    {"reg_125m_cmu_big_kvco",    139},
    {"reg_125m_cmu_lpf_rs",    140},
    {"reg_125m_cmu_en_center_in",    141},
    {"reg_125m_cmu_en_wd",    142},
    {"reg_125m_cmu_pi_i_sel",    143},
    {"reg_125m_cmu_sel_cp_i",    144},
    {"reg_125m_cmu_sel_cco",    145},
    {"reg_125m_cmu_ldo_sel",    146},
    {"reg_125m_cmu_lpf_cp",    147},
    {"reg_125m_cmu_cp_new_en",    148},
    {"reg_125m_cmu_ldo_en",    149},
    {"reg_125m_cmu_vc_dly",    150},
    {"reg_125m_cmu_en_ckoobs",    151},
    {"reg_rsvd_xtal",    152},
    {"xtal_dbg_out",    153},
    {"cmu_test_en_xtal",    154},
    {"reg_sel_iblpf_xtalpll",    155},
    {"reg_bg_pow",    156},
    {"reg_bg",    157},
    {"sel_125m_clk_test_en",    158},
    {"sel_osc_clk_test_en",    159},
    {"reg_ckrefbuf_cml_i_s0s1",    160},
    {"reg_ckrefbuf_cml_i_s0s0",    161},
    {"reg_ckrefbuf_cml_i_gphy",    162},
    {"reg_ckrefbuf_cml_i_pll",    163},
    {"reg_ckref_buf_en_gphy",    164},
    {"reg_ckref_buf_en_pll",    165},
    {"reg_ckref_buf_en",    166},
    {"reg_ckrefbuf_cml_i",    167},
    {"reg_ckrefbuf_cml_r",    168},
    {"reg_rsvd",    169},
    {"dummy",    170},
    {"bist_mode_lbrxf",    171},
    {"bist_mode_dmy",    172},
    {"bist_mode_gtxf1",    173},
    {"bist_mode_grxf1",    174},
    {"bist_mode_tgtxf_x4_0",    175},
    {"bist_mode_tgrxf_x4_0",    176},
    {"bist_mode_gtxf0_x2_0",    177},
    {"bist_mode_grxf0_x2_0",    178},
    {"drf_bist_mode_lbrxf",    179},
    {"drf_bist_mode_dmy",    180},
    {"drf_bist_mode_gtxf1",    181},
    {"drf_bist_mode_grxf1",    182},
    {"drf_bist_mode_tgtxf_x4_0",    183},
    {"drf_bist_mode_tgrxf_x4_0",    184},
    {"drf_bist_mode_gtxf0_x2_0",    185},
    {"drf_bist_mode_grxf0_x2_0",    186},
    {"bist_rstn",    187},
    {"drf_test_resume_lbrxf",    188},
    {"drf_test_resume_dmy",    189},
    {"drf_test_resume_gtxf1",    190},
    {"drf_test_resume_grxf1",    191},
    {"drf_test_resume_tgtxf_x4_0",    192},
    {"drf_test_resume_tgrxf_x4_0",    193},
    {"drf_test_resume_gtxf0_x2_0",    194},
    {"drf_test_resume_grxf0_x2_0",    195},
    {"cfg_bist_dis_grxf0",    196},
    {"grxf0_done",    197},
    {"grxf0_drf_done",    198},
    {"grxf0_fail_7_0",    199},
    {"grxf0_drf_fail_7_0",    200},
    {"cfg_bist_dis_gtxf0",    201},
    {"gtxf0_done",    202},
    {"gtxf0_drf_done",    203},
    {"gtxf0_fail_7_0",    204},
    {"gtxf0_drf_fail_7_0",    205},
    {"cfg_bist_dis_tgrxf",    206},
    {"tgrxf_done",    207},
    {"tgrxf_drf_done",    208},
    {"tgrxf_fail_5_0",    209},
    {"tgrxf_drf_fail_5_0",    210},
    {"cfg_bist_dis_tgtxf",    211},
    {"tgtxf_done",    212},
    {"tgtxf_drf_done",    213},
    {"tgtxf_fail_5_0",    214},
    {"tgtxf_drf_fail_5_0",    215},
    {"cfg_bist_dis_grxf1",    216},
    {"grxf1_done",    217},
    {"grxf1_drf_done",    218},
    {"grxf1_fail_1_0",    219},
    {"grxf1_drf_fail_1_0",    220},
    {"cfg_bist_dis_gtxf1",    221},
    {"gtxf1_done",    222},
    {"gtxf1_drf_done",    223},
    {"gtxf1_fail",    224},
    {"gtxf1_drf_fail",    225},
    {"cfg_bist_dis_dmy",    226},
    {"dmy_done",    227},
    {"dmy_drf_done",    228},
    {"dmy_fail",    229},
    {"mac_stk_filter",    230},
    {"dmy_drf_fail",    231},
    {"cfg_bist_dis_lbrxf",    232},
    {"lbrxf_done",    233},
    {"lbrxf_drf_done",    234},
    {"lbrxf_fail_5_0",    235},
    {"lbrxf_drf_fail_5_0",    236},
    {"lbrxf_drf_pause_pg08",    237},
    {"dmy_drf_pause_pg08",    238},
    {"gtxf1_drf_pause_pg08",    239},
    {"grxf1_drf_pause_pg08",    240},
    {"tgtxf_drf_pause_pg07_04",    241},
    {"tgtxf_drf_pause_pg02",    242},
    {"tgrxf_drf_pause_pg07_04",    243},
    {"tgrxf_drf_pause_pg02",    244},
    {"gtxf0_drf_pause_pg02_00",    245},
    {"grxf_drf_pause0_pg02_00",    246},
    {"cfg_gtxf0_ls",    247},
    {"cfg_grxf0_ls",    248},
    {"cfg_gtxf0_rmeb_7_0",    249},
    {"cfg_gtxf0_rmea_7_0",    250},
    {"cfg_grxf0_rmeb_7_0",    251},
    {"cfg_grxf0_rmea_7_0",    252},
    {"cfg_grxf0_rma_7",    253},
    {"cfg_grxf0_rma_6",    254},
    {"cfg_grxf0_rma_5",    255},
    {"cfg_grxf0_rma_4",    256},
    {"cfg_grxf0_rma_3",    257},
    {"cfg_grxf0_rma_2",    258},
    {"cfg_grxf0_rma_1",    259},
    {"cfg_grxf0_rma_0",    260},
    {"cfg_grxf0_rmb_7",    261},
    {"cfg_grxf0_rmb_6",    262},
    {"cfg_grxf0_rmb_5",    263},
    {"cfg_grxf0_rmb_4",    264},
    {"cfg_grxf0_rmb_3",    265},
    {"cfg_grxf0_rmb_2",    266},
    {"cfg_grxf0_rmb_1",    267},
    {"cfg_grxf0_rmb_0",    268},
    {"cfg_gtxf0_rma_7",    269},
    {"cfg_gtxf0_rma_6",    270},
    {"cfg_gtxf0_rma_5",    271},
    {"cfg_gtxf0_rma_4",    272},
    {"cfg_gtxf0_rma_3",    273},
    {"cfg_gtxf0_rma_2",    274},
    {"cfg_gtxf0_rma_1",    275},
    {"cfg_gtxf0_rma_0",    276},
    {"cfg_gtxf0_rmb_7",    277},
    {"cfg_gtxf0_rmb_6",    278},
    {"cfg_gtxf0_rmb_5",    279},
    {"cfg_gtxf0_rmb_4",    280},
    {"cfg_gtxf0_rmb_3",    281},
    {"cfg_gtxf0_rmb_2",    282},
    {"cfg_gtxf0_rmb_1",    283},
    {"cfg_gtxf0_rmb_0",    284},
    {"cfg_tgtxf_ls",    285},
    {"cfg_tgrxf_ls",    286},
    {"cfg_tgtxf_rmeb_5_0",    287},
    {"cfg_tgtxf_rmea_5_0",    288},
    {"cfg_tgrxf_rmeb_5_0",    289},
    {"cfg_tgrxf_rmea_5_0",    290},
    {"cfg_tgrxf_rma_5",    291},
    {"cfg_tgrxf_rma_4",    292},
    {"cfg_tgrxf_rma_3",    293},
    {"cfg_tgrxf_rma_2",    294},
    {"cfg_tgrxf_rma_1",    295},
    {"cfg_tgrxf_rma_0",    296},
    {"cfg_tgrxf_rmb_5",    297},
    {"cfg_tgrxf_rmb_4",    298},
    {"cfg_tgrxf_rmb_3",    299},
    {"cfg_tgrxf_rmb_2",    300},
    {"cfg_tgrxf_rmb_1",    301},
    {"cfg_tgrxf_rmb_0",    302},
    {"cfg_tgtxf_rma_5",    303},
    {"cfg_tgtxf_rma_4",    304},
    {"cfg_tgtxf_rma_3",    305},
    {"cfg_tgtxf_rma_2",    306},
    {"cfg_tgtxf_rma_1",    307},
    {"cfg_tgtxf_rma_0",    308},
    {"cfg_tgtxf_rmb_5",    309},
    {"cfg_tgtxf_rmb_4",    310},
    {"cfg_tgtxf_rmb_3",    311},
    {"cfg_tgtxf_rmb_2",    312},
    {"cfg_tgtxf_rmb_1",    313},
    {"cfg_tgtxf_rmb_0",    314},
    {"cfg_gtxf1_ls",    315},
    {"cfg_grxf1_ls",    316},
    {"cfg_gtxf1_rmeb",    317},
    {"cfg_gtxf1_rmea",    318},
    {"cfg_grxf1_rmeb",    319},
    {"cfg_grxf1_rmea",    320},
    {"cfg_grxf1_rma_1",    321},
    {"cfg_grxf1_rma_0",    322},
    {"cfg_grxf1_rmb_1",    323},
    {"cfg_grxf1_rmb_0",    324},
    {"cfg_gtxf1_rma",    325},
    {"cfg_gtxf1_rmb",    326},
    {"cfg_dmy_ls",    327},
    {"cfg_dmy_rmeb",    328},
    {"cfg_dmy_rmea",    329},
    {"cfg_dmy_rma",    330},
    {"cfg_dmy_rmb",    331},
    {"cfg_lbrxf_ls",    332},
    {"cfg_lbrxf_rmeb_5_0",    333},
    {"cfg_lbrxf_rmea_5_0",    334},
    {"cfg_lbrxf_rma_5",    335},
    {"cfg_lbrxf_rma_4",    336},
    {"cfg_lbrxf_rma_3",    337},
    {"cfg_lbrxf_rma_2",    338},
    {"cfg_lbrxf_rma_1",    339},
    {"cfg_lbrxf_rma_0",    340},
    {"cfg_lbrxf_rmb_5",    341},
    {"cfg_lbrxf_rmb_4",    342},
    {"cfg_lbrxf_rmb_3",    343},
    {"cfg_lbrxf_rmb_2",    344},
    {"cfg_lbrxf_rmb_1",    345},
    {"cfg_lbrxf_rmb_0",    346},
    {"bist_mode_piso",    347},
    {"bist_mode_tkid",    348},
    {"bist_mode_l3mem_hit",    349},
    {"bist_mode_acl_dropact",    350},
    {"bist_mode_acl_tcam_x7_4",    351},
    {"bist_mode_repqll",    352},
    {"bist_mode_repq",    353},
    {"bist_mode_oilmem",    354},
    {"bist_mode_otgmem",    355},
    {"bist_mode_nxhmem",    356},
    {"bist_mode_mactcam",    357},
    {"bist_mode_camact",    358},
    {"bist_mode_l3tcam",    359},
    {"bist_mode_l3mem",    360},
    {"bist_mode_bcam",    361},
    {"bist_mode_mst",    362},
    {"bist_mode_mctab",    363},
    {"bist_mode_lut",    364},
    {"bist_mode_hsb",    365},
    {"bist_mode_vlan",    366},
    {"bist_mode_ivc_act",    367},
    {"bist_mode_ivc",    368},
    {"bist_mode_acl_act",    369},
    {"bist_mode_acl_met",    370},
    {"bist_mode_acl_log",    371},
    {"bist_mode_acl_tcam_x3_0",    372},
    {"bist_mode_trunk",    373},
    {"drf_bist_mode_piso",    374},
    {"drf_bist_mode_tkid",    375},
    {"drf_bist_mode_l3mem_hit",    376},
    {"drf_bist_mode_acl_dropact",    377},
    {"drf_bist_mode_acl_tcam_x7_4",    378},
    {"drf_bist_mode_repqll",    379},
    {"drf_bist_mode_repq",    380},
    {"drf_bist_mode_oilmem",    381},
    {"drf_bist_mode_otgmem",    382},
    {"drf_bist_mode_nxhmem",    383},
    {"drf_bist_mode_mactcam",    384},
    {"drf_bist_mode_camact",    385},
    {"drf_bist_mode_l3tcam",    386},
    {"drf_bist_mode_l3mem",    387},
    {"drf_bist_mode_bcam",    388},
    {"drf_bist_mode_mst",    389},
    {"drf_bist_mode_mctab",    390},
    {"drf_bist_mode_lut",    391},
    {"drf_bist_mode_hsb",    392},
    {"drf_bist_mode_vlan",    393},
    {"drf_bist_mode_ivc_act",    394},
    {"drf_bist_mode_ivc",    395},
    {"drf_bist_mode_acl_act",    396},
    {"drf_bist_mode_acl_met",    397},
    {"drf_bist_mode_acl_log",    398},
    {"drf_bist_mode_acl_tcam_x3_0",    399},
    {"drf_bist_mode_trunk",    400},
    {"piso_drf_bist_resume",    401},
    {"tkid_drf_bist_resume",    402},
    {"l3mem_hit_drf_bist_resume",    403},
    {"acl_dropact_drf_bist_resume",    404},
    {"acl_tcam_drf_bist_resume_x7_4",    405},
    {"repqll_drf_bist_resume",    406},
    {"repq_drf_bist_resume",    407},
    {"oil_drf_bist_resume",    408},
    {"otg_drf_bist_resume",    409},
    {"nxh_drf_bist_resume",    410},
    {"mactcam_drf_bist_resume",    411},
    {"camact_drf_bist_resume",    412},
    {"l3tcam_drf_bist_resume",    413},
    {"l3mem_drf_bist_resume",    414},
    {"bcam_drf_bist_resume",    415},
    {"mst_drf_bist_resume",    416},
    {"mctab_drf_bist_resume",    417},
    {"lut_drf_bist_resume",    418},
    {"hsb_drf_bist_resume",    419},
    {"vlan_drf_bist_resume",    420},
    {"ivc_act_drf_bist_resume",    421},
    {"ivc_tcam_drf_bist_resume",    422},
    {"acl_act_drf_bist_resume",    423},
    {"acl_met_drf_bist_resume",    424},
    {"acl_log_drf_bist_resume",    425},
    {"acl_tcam_drf_bist_resume_x3_0",    426},
    {"trunk_drf_bist_resume",    427},
    {"cfg_hsb_rme_x3_0",    428},
    {"cfg_ivc_act_rme",    429},
    {"cfg_acl_dropact_rme_x15_0",    430},
    {"cfg_acl_act_rme_x10_0",    431},
    {"cfg_acl_met_rme_x15_0",    432},
    {"cfg_acl_log_rme_x15_0",    433},
    {"cfg_trunk_rmeb",    434},
    {"cfg_trunk_rmea",    435},
    {"cfg_piso_rme",    436},
    {"cfg_tkid_rme",    437},
    {"cfg_l3mem_hit_rme_x1_0",    438},
    {"cfg_lutb_rme_x7_0",    439},
    {"cfg_luta_rme_x7_0",    440},
    {"cfg_mcb_rme",    441},
    {"cfg_mca_rme",    442},
    {"cfg_mst_rme",    443},
    {"cfg_vlan_rme",    444},
    {"cfg_repqll_rmeb",    445},
    {"cfg_repqll_rmea",    446},
    {"cfg_repq_rme_x5_0",    447},
    {"cfg_oil_rme",    448},
    {"cfg_otg_rme",    449},
    {"cfg_nxh_rme",    450},
    {"cfg_camact_rme_x7_0",    451},
    {"cfg_l3mem_rme_x11_0",    452},
    {"cfg_acl_act_rm_7",    453},
    {"cfg_acl_act_rm_6",    454},
    {"cfg_acl_act_rm_5",    455},
    {"cfg_acl_act_rm_4",    456},
    {"cfg_acl_act_rm_3",    457},
    {"cfg_acl_act_rm_2",    458},
    {"cfg_acl_act_rm_1",    459},
    {"cfg_acl_act_rm_0",    460},
    {"cfg_acl_drop_rm_4",    461},
    {"cfg_acl_drop_rm_3",    462},
    {"cfg_acl_drop_rm_2",    463},
    {"cfg_acl_drop_rm_1",    464},
    {"cfg_acl_drop_rm_0",    465},
    {"cfg_acl_act_rm_10",    466},
    {"cfg_acl_act_rm_9",    467},
    {"cfg_acl_act_rm_8",    468},
    {"cfg_acl_drop_rm_12",    469},
    {"cfg_acl_drop_rm_11",    470},
    {"cfg_acl_drop_rm_10",    471},
    {"cfg_acl_drop_rm_9",    472},
    {"cfg_acl_drop_rm_8",    473},
    {"cfg_acl_drop_rm_7",    474},
    {"cfg_acl_drop_rm_6",    475},
    {"cfg_acl_drop_rm_5",    476},
    {"cfg_hsb_rm_3",    477},
    {"cfg_hsb_rm_2",    478},
    {"cfg_hsb_rm_1",    479},
    {"cfg_hsb_rm_0",    480},
    {"cfg_ivc_act_rm",    481},
    {"cfg_acl_drop_rm_15",    482},
    {"cfg_acl_drop_rm_14",    483},
    {"cfg_acl_drop_rm_13",    484},
    {"cfg_acl_met_rm_7",    485},
    {"cfg_acl_met_rm_6",    486},
    {"cfg_acl_met_rm_5",    487},
    {"cfg_acl_met_rm_4",    488},
    {"cfg_acl_met_rm_3",    489},
    {"cfg_acl_met_rm_2",    490},
    {"cfg_acl_met_rm_1",    491},
    {"cfg_acl_met_rm_0",    492},
    {"cfg_acl_met_rm_15",    493},
    {"cfg_acl_met_rm_14",    494},
    {"cfg_acl_met_rm_13",    495},
    {"cfg_acl_met_rm_12",    496},
    {"cfg_acl_met_rm_11",    497},
    {"cfg_acl_met_rm_10",    498},
    {"cfg_acl_met_rm_9",    499},
    {"cfg_acl_met_rm_8",    500},
    {"cfg_acl_log_rm_7",    501},
    {"cfg_acl_log_rm_6",    502},
    {"cfg_acl_log_rm_5",    503},
    {"cfg_acl_log_rm_4",    504},
    {"cfg_acl_log_rm_3",    505},
    {"cfg_acl_log_rm_2",    506},
    {"cfg_acl_log_rm_1",    507},
    {"cfg_acl_log_rm_0",    508},
    {"cfg_acl_log_rm_15",    509},
    {"cfg_acl_log_rm_14",    510},
    {"cfg_acl_log_rm_13",    511},
    {"cfg_acl_log_rm_12",    512},
    {"cfg_acl_log_rm_11",    513},
    {"cfg_acl_log_rm_10",    514},
    {"cfg_acl_log_rm_9",    515},
    {"cfg_acl_log_rm_8",    516},
    {"cfg_luta_rm_7",    517},
    {"cfg_luta_rm_6",    518},
    {"cfg_luta_rm_5",    519},
    {"cfg_luta_rm_4",    520},
    {"cfg_luta_rm_3",    521},
    {"cfg_luta_rm_2",    522},
    {"cfg_luta_rm_1",    523},
    {"cfg_luta_rm_0",    524},
    {"cfg_lutb_rm_7",    525},
    {"cfg_lutb_rm_6",    526},
    {"cfg_lutb_rm_5",    527},
    {"cfg_lutb_rm_4",    528},
    {"cfg_lutb_rm_3",    529},
    {"cfg_lutb_rm_2",    530},
    {"cfg_lutb_rm_1",    531},
    {"cfg_lutb_rm_0",    532},
    {"cfg_piso_rm",    533},
    {"cfg_tkid_rm",    534},
    {"cfg_l3mem_hit_rm_1",    535},
    {"cfg_l3mem_hit_rm_0",    536},
    {"cfg_mctaba_rm",    537},
    {"cfg_mctabb_rm",    538},
    {"cfg_mst_rm",    539},
    {"cfg_vlan_rm",    540},
    {"cfg_l3mem_rm_7",    541},
    {"cfg_l3mem_rm_6",    542},
    {"cfg_l3mem_rm_5",    543},
    {"cfg_l3mem_rm_4",    544},
    {"cfg_l3mem_rm_3",    545},
    {"cfg_l3mem_rm_2",    546},
    {"cfg_l3mem_rm_1",    547},
    {"cfg_l3mem_rm_0",    548},
    {"cfg_oil_rm",    549},
    {"cfg_otg_rm",    550},
    {"cfg_nxh_rm",    551},
    {"cfg_l3mem_rm_11",    552},
    {"cfg_l3mem_rm_10",    553},
    {"cfg_l3mem_rm_9",    554},
    {"cfg_l3mem_rm_8",    555},
    {"cfg_l3camact_rm_7",    556},
    {"cfg_l3camact_rm_6",    557},
    {"cfg_l3camact_rm_5",    558},
    {"cfg_l3camact_rm_4",    559},
    {"cfg_l3camact_rm_3",    560},
    {"cfg_l3camact_rm_2",    561},
    {"cfg_l3camact_rm_1",    562},
    {"cfg_l3camact_rm_0",    563},
    {"cfg_repqll_rmb",    564},
    {"cfg_repqll_rma",    565},
    {"cfg_repq_rm_5",    566},
    {"cfg_repq_rm_4",    567},
    {"cfg_repq_rm_3",    568},
    {"cfg_repq_rm_2",    569},
    {"cfg_repq_rm_1",    570},
    {"cfg_repq_rm_0",    571},
    {"cfg_trunk_rmb",    572},
    {"cfg_trunk_rma",    573},
    {"cfg_tcam_mds_bist1_3",    574},
    {"cfg_tcam_mds_bist1_2",    575},
    {"cfg_tcam_mds_bist1_1",    576},
    {"cfg_tcam_mds_bist1_0",    577},
    {"cfg_tcam_mds_bist0_5",    578},
    {"cfg_tcam_mds_bist0_4",    579},
    {"cfg_tcam_mds_bist0_3",    580},
    {"cfg_tcam_mds_bist0_2",    581},
    {"cfg_tcam_mds_bist0_1",    582},
    {"cfg_tcam_mds_bist0_0",    583},
    {"cfg_tcam_mds_bist3_1",    584},
    {"cfg_tcam_mds_bist3_0",    585},
    {"cfg_tcam_mds_bist2_5",    586},
    {"cfg_tcam_mds_bist2_4",    587},
    {"cfg_tcam_mds_bist2_3",    588},
    {"cfg_tcam_mds_bist2_2",    589},
    {"cfg_tcam_mds_bist2_1",    590},
    {"cfg_tcam_mds_bist2_0",    591},
    {"cfg_tcam_mds_bist1_5",    592},
    {"cfg_tcam_mds_bist1_4",    593},
    {"cfg_tcam_mds_bist4_5",    594},
    {"cfg_tcam_mds_bist4_4",    595},
    {"cfg_tcam_mds_bist4_3",    596},
    {"cfg_tcam_mds_bist4_2",    597},
    {"cfg_tcam_mds_bist4_1",    598},
    {"cfg_tcam_mds_bist4_0",    599},
    {"cfg_tcam_mds_bist3_5",    600},
    {"cfg_tcam_mds_bist3_4",    601},
    {"cfg_tcam_mds_bist3_3",    602},
    {"cfg_tcam_mds_bist3_2",    603},
    {"cfg_tcam_mds_bist6_3",    604},
    {"cfg_tcam_mds_bist6_2",    605},
    {"cfg_tcam_mds_bist6_1",    606},
    {"cfg_tcam_mds_bist6_0",    607},
    {"cfg_tcam_mds_bist5_5",    608},
    {"cfg_tcam_mds_bist5_4",    609},
    {"cfg_tcam_mds_bist5_3",    610},
    {"cfg_tcam_mds_bist5_2",    611},
    {"cfg_tcam_mds_bist5_1",    612},
    {"cfg_tcam_mds_bist5_0",    613},
    {"cfg_tcam_mds_bist7_5",    614},
    {"cfg_tcam_mds_bist7_4",    615},
    {"cfg_tcam_mds_bist7_3",    616},
    {"cfg_tcam_mds_bist7_2",    617},
    {"cfg_tcam_mds_bist7_1",    618},
    {"cfg_tcam_mds_bist7_0",    619},
    {"cfg_tcam_mds_bist6_5",    620},
    {"cfg_tcam_mds_bist6_4",    621},
    {"cfg_l3tcam_mds",    622},
    {"cfg_mactcam_mds",    623},
    {"cfg_bcam_mds",    624},
    {"cfg_ivc_tcam_mds",    625},
    {"cfg_tcam_rds_bist1_1",    626},
    {"cfg_tcam_rds_bist1_0",    627},
    {"cfg_tcam_rds_bist0_5",    628},
    {"cfg_tcam_rds_bist0_4",    629},
    {"cfg_tcam_rds_bist0_3",    630},
    {"cfg_tcam_rds_bist0_2",    631},
    {"cfg_tcam_rds_bist0_1",    632},
    {"cfg_tcam_rds_bist0_0",    633},
    {"cfg_tcam_rds_bist2_3",    634},
    {"cfg_tcam_rds_bist2_2",    635},
    {"cfg_tcam_rds_bist2_1",    636},
    {"cfg_tcam_rds_bist2_0",    637},
    {"cfg_tcam_rds_bist1_5",    638},
    {"cfg_tcam_rds_bist1_4",    639},
    {"cfg_tcam_rds_bist1_3",    640},
    {"cfg_tcam_rds_bist1_2",    641},
    {"cfg_tcam_rds_bist3_5",    642},
    {"cfg_tcam_rds_bist3_4",    643},
    {"cfg_tcam_rds_bist3_3",    644},
    {"cfg_tcam_rds_bist3_2",    645},
    {"cfg_tcam_rds_bist3_1",    646},
    {"cfg_tcam_rds_bist3_0",    647},
    {"cfg_tcam_rds_bist2_5",    648},
    {"cfg_tcam_rds_bist2_4",    649},
    {"cfg_tcam_rds_bist5_1",    650},
    {"cfg_tcam_rds_bist5_0",    651},
    {"cfg_tcam_rds_bist4_5",    652},
    {"cfg_tcam_rds_bist4_4",    653},
    {"cfg_tcam_rds_bist4_3",    654},
    {"cfg_tcam_rds_bist4_2",    655},
    {"cfg_tcam_rds_bist4_1",    656},
    {"cfg_tcam_rds_bist4_0",    657},
    {"cfg_tcam_rds_bist6_3",    658},
    {"cfg_tcam_rds_bist6_2",    659},
    {"cfg_tcam_rds_bist6_1",    660},
    {"cfg_tcam_rds_bist6_0",    661},
    {"cfg_tcam_rds_bist5_5",    662},
    {"cfg_tcam_rds_bist5_4",    663},
    {"cfg_tcam_rds_bist5_3",    664},
    {"cfg_tcam_rds_bist5_2",    665},
    {"cfg_tcam_rds_bist7_5",    666},
    {"cfg_tcam_rds_bist7_4",    667},
    {"cfg_tcam_rds_bist7_3",    668},
    {"cfg_tcam_rds_bist7_2",    669},
    {"cfg_tcam_rds_bist7_1",    670},
    {"cfg_tcam_rds_bist7_0",    671},
    {"cfg_tcam_rds_bist6_5",    672},
    {"cfg_tcam_rds_bist6_4",    673},
    {"cfg_mactcam_rds",    674},
    {"cfg_bcam_rds",    675},
    {"cfg_ivc_tcam_rds",    676},
    {"cfg_l3tcam_rds",    677},
    {"piso_bist_done",    678},
    {"tkid_bist_done",    679},
    {"l3mem_hit_bist_done",    680},
    {"acl_dropact_bist_done",    681},
    {"acl_tcam_bist_done_x7_4",    682},
    {"repqll_bist_done",    683},
    {"repq_bist_done",    684},
    {"oil_bist_done",    685},
    {"otg_bist_done",    686},
    {"nxh_bist_done",    687},
    {"mactcam_bist_done",    688},
    {"camact_bist_done",    689},
    {"l3tcam_bist_done",    690},
    {"l3mem_bist_done",    691},
    {"bcam_bist_done",    692},
    {"mst_bist_done",    693},
    {"mctab_bist_done",    694},
    {"lut_bist_done",    695},
    {"hsb_bist_done",    696},
    {"vlan_bist_done",    697},
    {"ivc_act_bist_done",    698},
    {"ivc_tcam_bist_done",    699},
    {"acl_act_bist_done",    700},
    {"acl_met_bist_done",    701},
    {"acl_log_bist_done",    702},
    {"acl_tcam3_bist_done",    703},
    {"acl_tcam2_bist_done",    704},
    {"acl_tcam1_bist_done",    705},
    {"acl_tcam0_bist_done",    706},
    {"trunk_bist_done",    707},
    {"piso_drf_bist_pause",    708},
    {"tkid_drf_bist_pause",    709},
    {"l3mem_hit_drf_bist_pause",    710},
    {"acl_dropact_drf_bist_pause",    711},
    {"acl_tcam_drf_bist_pause_x7_4",    712},
    {"repqll_drf_bist_pause",    713},
    {"repq_drf_bist_pause",    714},
    {"oil_drf_bist_pause",    715},
    {"otg_drf_bist_pause",    716},
    {"nxh_drf_bist_pause",    717},
    {"mactcam_drf_bist_pause",    718},
    {"camact_drf_bist_pause",    719},
    {"l3tcam_drf_bist_pause",    720},
    {"l3mem_drf_bist_pause",    721},
    {"bcam_drf_bist_pause",    722},
    {"mst_drf_bist_pause",    723},
    {"mctab_drf_bist_pause",    724},
    {"lut_drf_bist_pause",    725},
    {"hsb_drf_bist_pause",    726},
    {"vlan_drf_bist_pause",    727},
    {"ivc_act_drf_bist_pause",    728},
    {"ivc_tcam_drf_bist_pause",    729},
    {"acl_act_drf_bist_pause",    730},
    {"acl_met_drf_bist_pause",    731},
    {"acl_log_drf_bist_pause",    732},
    {"acl_tcam3_drf_bist_pause",    733},
    {"acl_tcam2_drf_bist_pause",    734},
    {"acl_tcam1_drf_bist_pause",    735},
    {"acl_tcam0_drf_bist_pause",    736},
    {"trunk_drf_bist_pause",    737},
    {"ivc_tcam_bist_fail_x_3_0",    738},
    {"ivc_act_bist_fail",    739},
    {"acl_dropact_bist_fail_x_15_0",    740},
    {"acl_act_bist_fail_x_10_0",    741},
    {"acl_log_bist_fail_x_15_0",    742},
    {"acl_met_bist_fail_x_15_0",    743},
    {"acl_tcam3_bist_fail_x_7_0",    744},
    {"acl_tcam2_bist_fail_x_7_0",    745},
    {"acl_tcam1_bist_fail_x_7_0",    746},
    {"acl_tcam0_bist_fail_x_7_0",    747},
    {"acl_tcam3_bist_fail_x_11_8",    748},
    {"acl_tcam2_bist_fail_x_11_8",    749},
    {"acl_tcam1_bist_fail_x_11_8",    750},
    {"acl_tcam0_bist_fail_x_11_8",    751},
    {"bcam_bist_fail",    752},
    {"mctab_bist_fail",    753},
    {"lut_bist_fail_x_7_0",    754},
    {"hsb_bist_fail_x_3_0",    755},
    {"mst_bist_fail",    756},
    {"vlan_bist_fail",    757},
    {"oil_bist_fail",    758},
    {"otg_bist_fail",    759},
    {"nxh_bist_fail",    760},
    {"mactcam_bist_fail",    761},
    {"camact_bist_fail_x7_0",    762},
    {"l3tcam_bist_fail_x7_0",    763},
    {"l3mem_bist_fail_x11_0",    764},
    {"trunk_bist_fail",    765},
    {"piso_bist_fail",    766},
    {"tkid_bist_fail",    767},
    {"l3mem_hit_bist_fail",    768},
    {"repqll_bist_fail",    769},
    {"repq_bist_fail_x5_0",    770},
    {"piso_drf_bist_done",    771},
    {"tkid_drf_bist_done",    772},
    {"l3mem_hit_drf_bist_done",    773},
    {"acl_dropact_drf_bist_done",    774},
    {"acl_tcam_drf_bist_done_x7_4",    775},
    {"repqll_drf_bist_done",    776},
    {"repq_drf_bist_done",    777},
    {"oil_drf_bist_done",    778},
    {"otg_drf_bist_done",    779},
    {"nxh_drf_bist_done",    780},
    {"mactcam_drf_bist_done",    781},
    {"camact_drf_bist_done",    782},
    {"l3tcam_drf_bist_done",    783},
    {"l3mem_drf_bist_done",    784},
    {"bcam_drf_bist_done",    785},
    {"mst_drf_bist_done",    786},
    {"mctab_drf_bist_done",    787},
    {"lut_drf_bist_done",    788},
    {"hsb_drf_bist_done",    789},
    {"vlan_drf_bist_done",    790},
    {"ivc_act_drf_bist_done",    791},
    {"ivc_tcam_drf_bist_done",    792},
    {"acl_act_drf_bist_done",    793},
    {"acl_met_drf_bist_done",    794},
    {"acl_log_drf_bist_done",    795},
    {"acl_tcam3_drf_bist_done",    796},
    {"acl_tcam2_drf_bist_done",    797},
    {"acl_tcam1_drf_bist_done",    798},
    {"acl_tcam0_drf_bist_done",    799},
    {"trunk_drf_bist_done",    800},
    {"ivc_tcam_drf_bist_fail_x_3_0",    801},
    {"ivc_act_drf_bist_fail",    802},
    {"acl_dropact_drf_bist_fail_x_15_0",    803},
    {"acl_act_drf_bist_fail_x_10_0",    804},
    {"acl_log_drf_bist_fail_x_15_0",    805},
    {"acl_met_drf_bist_fail_x_15_0",    806},
    {"acl_tcam3_drf_bist_fail_x_7_0",    807},
    {"acl_tcam2_drf_bist_fail_x_7_0",    808},
    {"acl_tcam1_drf_bist_fail_x_7_0",    809},
    {"acl_tcam0_drf_bist_fail_x_7_0",    810},
    {"acl_tcam3_drf_bist_fail_x_11_8",    811},
    {"acl_tcam2_drf_bist_fail_x_11_8",    812},
    {"acl_tcam1_drf_bist_fail_x_11_8",    813},
    {"acl_tcam0_drf_bist_fail_x_11_8",    814},
    {"bcam_drf_bist_fail",    815},
    {"mctab_drf_bist_fail",    816},
    {"lut_drf_bist_fail_x_7_0",    817},
    {"hsb_drf_bist_fail_x_3_0",    818},
    {"mst_drf_bist_fail",    819},
    {"vlan_drf_bist_fail",    820},
    {"oil_drf_bist_fail",    821},
    {"otg_drf_bist_fail",    822},
    {"nxh_drf_bist_fail",    823},
    {"mactcam_drf_bist_fail",    824},
    {"camact_drf_bist_fail_x7_0",    825},
    {"l3tcam_drf_bist_fail_x7_0",    826},
    {"l3mem_drf_bist_fail_x11_0",    827},
    {"trunk_drf_bist_fail",    828},
    {"piso_drf_bist_fail",    829},
    {"tkid_drf_bist_fail",    830},
    {"l3mem_hit_drf_bist_fail",    831},
    {"repqll_drf_bist_fail",    832},
    {"repq_drf_bist_fail_x5_0",    833},
    {"bist_ale_ls_mode",    834},
    {"cfg_bisr_mode",    835},
    {"bist_mode_rmkpri",    836},
    {"bist_mode_l2smac",    837},
    {"bist_mode_l2msg",    838},
    {"bist_mode_mib",    839},
    {"bist_mode_spi",    840},
    {"bist_mode_evcact",    841},
    {"bist_mode_untag",    842},
    {"bist_mode_l2mac",    843},
    {"bist_mode_dsc",    844},
    {"bist_mode_evc",    845},
    {"drf_bist_mode_rmkpri",    846},
    {"drf_bist_mode_l2smac",    847},
    {"drf_bist_mode_l2msg",    848},
    {"drf_bist_mode_mib",    849},
    {"drf_bist_mode_spi",    850},
    {"drf_bist_mode_evcact",    851},
    {"drf_bist_mode_untag",    852},
    {"drf_bist_mode_l2mac",    853},
    {"drf_bist_mode_dsc",    854},
    {"drf_bist_mode_evc",    855},
    {"drf_test_resume_rmkpri",    856},
    {"drf_test_resume_l2smac",    857},
    {"drf_test_resume_l2msg",    858},
    {"drf_test_resume_mib",    859},
    {"drf_test_resume_spi",    860},
    {"drf_test_resume_evcact",    861},
    {"drf_test_resume_untag",    862},
    {"drf_test_resume_l2mac",    863},
    {"drf_test_resume_dsc",    864},
    {"drf_test_resume_hsb",    865},
    {"drf_test_resume_evc",    866},
    {"bist_done_rmkpri",    867},
    {"bist_done_l2smac",    868},
    {"bist_done_l2msg",    869},
    {"bist_done_mib",    870},
    {"bist_done_spi",    871},
    {"bist_done_evcact",    872},
    {"bist_done_untag",    873},
    {"bist_done_l2mac",    874},
    {"bist_done_dsc",    875},
    {"bist_done_hsb",    876},
    {"bist_done_evc",    877},
    {"drf_bist_done_rmkpri",    878},
    {"drf_bist_done_l2smac",    879},
    {"drf_bist_done_l2msg",    880},
    {"drf_bist_done_mib",    881},
    {"drf_bist_done_spi",    882},
    {"drf_bist_done_evcact",    883},
    {"drf_bist_done_untag",    884},
    {"drf_bist_done_l2mac",    885},
    {"drf_bist_done_dsc",    886},
    {"drf_bist_done_hsb",    887},
    {"drf_bist_done_evc",    888},
    {"bist_fail_rmkpri",    889},
    {"bist_fail_l2smac",    890},
    {"bist_fail_l2msg",    891},
    {"bist_fail_mib",    892},
    {"bist_fail_spi",    893},
    {"bist_fail_evcact",    894},
    {"bist_fail_untag",    895},
    {"bist_fail_l2mac",    896},
    {"bist_fail_dsc",    897},
    {"bist_fail_hsb",    898},
    {"bist_fail_evc",    899},
    {"drf_bist_fail_rmkpri",    900},
    {"drf_bist_fail_l2smac",    901},
    {"drf_bist_fail_l2msg",    902},
    {"drf_bist_fail_mib",    903},
    {"drf_bist_fail_spi",    904},
    {"drf_bist_fail_evcact",    905},
    {"drf_bist_fail_untag",    906},
    {"drf_bist_fail_l2mac",    907},
    {"drf_bist_fail_dsc",    908},
    {"drf_bist_fail_hsb",    909},
    {"drf_bist_fail_evc",    910},
    {"drf_start_pause_rmkpri",    911},
    {"drf_start_pause_l2smac",    912},
    {"drf_start_pause_l2msg",    913},
    {"drf_start_pause_mib",    914},
    {"drf_start_pause_spi",    915},
    {"drf_start_pause_evcact",    916},
    {"drf_start_pause_untag",    917},
    {"drf_start_pause_l2mac",    918},
    {"drf_start_pause_dsc",    919},
    {"drf_start_pause_hsb",    920},
    {"drf_start_pause_evc",    921},
    {"all_bist_done",    922},
    {"all_drf_bist_done",    923},
    {"any_bist_fail",    924},
    {"any_drf_bist_fail",    925},
    {"all_chip_bist_done",    926},
    {"all_chip_drf_bist_done",    927},
    {"any_chip_bist_fail",    928},
    {"any_chip_drf_bist_fail",    929},
    {"all_soc_bist_done",    930},
    {"all_soc_drf_bist_done",    931},
    {"any_soc_bist_fail",    932},
    {"any_soc_drf_bist_fail",    933},
    {"cfg_bisr_serial",    934},
    {"sram_ls",    935},
    {"pkb_bist_rstb_3_0",    936},
    {"pkb_drf_bist_mode_3_0",    937},
    {"pkb_bist_mode_3_0",    938},
    {"ll_bist_rstb",    939},
    {"ll_drf_bist_mode",    940},
    {"ll_bist_mode",    941},
    {"drop_fifo_bist_rstb",    942},
    {"drop_fifo_drf_bist_mode",    943},
    {"drop_fifo_bist_mode",    944},
    {"rsc_fifo_bist_rstb",    945},
    {"rsc_fifo_drf_bist_mode",    946},
    {"rsc_fifo_bist_mode",    947},
    {"cbuf_bist_rstb",    948},
    {"cbuf_drf_bist_mode",    949},
    {"cbuf_bist_mode",    950},
    {"pkb_drf_test_resume_3_0",    951},
    {"ll_drf_test_resume",    952},
    {"drop_fifo_drf_test_resume",    953},
    {"rsc_fifo_drf_test_resume",    954},
    {"cbuf_drf_test_resume",    955},
    {"ll_bist_fail_1_0",    956},
    {"ll_bist_done",    957},
    {"drop_fifo_bist_fail",    958},
    {"drop_fifo_bist_done",    959},
    {"rsc_fifo_bist_fail_1_0",    960},
    {"rsc_fifo_bist_done",    961},
    {"cbuf_bist_fail_9_0",    962},
    {"cbuf_bist_done",    963},
    {"pkb_bisr_fail",    964},
    {"pkb_bisr_done",    965},
    {"pkb_bist_fail_23_0",    966},
    {"pkb_bist_done_3_0",    967},
    {"ll_drf_bist_fail_1_0",    968},
    {"ll_drf_bist_done",    969},
    {"drop_fifo_drf_bist_fail",    970},
    {"drop_fifo_drf_bist_done",    971},
    {"rsc_fifo_drf_bist_fail_1_0",    972},
    {"rsc_fifo_drf_bist_done",    973},
    {"cbuf_drf_bist_fail_9_0",    974},
    {"cbuf_drf_bist_done",    975},
    {"pkb_drf_bisr_fail",    976},
    {"pkb_drf_bisr_done",    977},
    {"pkb_drf_bist_fail_23_0",    978},
    {"pkb_drf_bist_done_3_0",    979},
    {"pkb_drf_start_pause_3_0",    980},
    {"ll_drf_start_pause",    981},
    {"drop_fifo_drf_start_pause",    982},
    {"rsc_fifo_drf_start_pause",    983},
    {"cbuf_drf_start_pause",    984},
    {"pkb_sram_rme",    985},
    {"pkb_sram_rm_3_0",    986},
    {"ll_sram_rme",    987},
    {"ll_sram_rm_3_0",    988},
    {"drop_fifo_sram_rme",    989},
    {"drop_fifo_sram_rm_3_0",    990},
    {"rsc_fifo_sram_rme",    991},
    {"rsc_fifo_sram_rm_3_0",    992},
    {"cbuf_sram_rme",    993},
    {"cbuf_sram_rm_3_0",    994},
    {"pkb_second_run_en",    995},
    {"pkb_hold_remap",    996},
    {"bypass_pg_vld_3_0",    997},
    {"bypass_pg_ad1_11_0",    998},
    {"bypass_pg_ad0_11_0",    999},
    {"bypass_pg_ad3_11_0",    1000},
    {"bypass_pg_ad2_11_0",    1001},
    {"bhsa_bist_rstb",    1002},
    {"bhsa_drf_bist_mode",    1003},
    {"bhsa_bist_mode",    1004},
    {"ehsa_bist_rstb",    1005},
    {"ehsa_drf_bist_mode",    1006},
    {"ehsa_bist_mode",    1007},
    {"ehsa_ll_bist_rstb",    1008},
    {"ehsa_ll_drf_bist_mode",    1009},
    {"ehsa_ll_bist_mode",    1010},
    {"cp_bist_rstb",    1011},
    {"cp_drf_bist_mode",    1012},
    {"cp_bist_mode",    1013},
    {"dpc_bist_rstb",    1014},
    {"dpc_drf_bist_mode",    1015},
    {"dpc_bist_mode",    1016},
    {"txq_bist_rstb",    1017},
    {"txq_drf_bist_mode_3_0",    1018},
    {"txq_bist_mode_3_0",    1019},
    {"bhsa_test_resume",    1020},
    {"ehsa_test_resume",    1021},
    {"ehsa_ll_drf_test_resume",    1022},
    {"cp_drf_test_resume",    1023},
    {"dpc_drf_test_resume",    1024},
    {"txq_drf_test_resume_3_0",    1025},
    {"bhsa_bist_fail",    1026},
    {"bhsa_bist_done",    1027},
    {"ehsa_bist_fail",    1028},
    {"ehsa_bist_done",    1029},
    {"ehsa_ll_bist_fail",    1030},
    {"ehsa_ll_bist_done",    1031},
    {"cp_bist_fail",    1032},
    {"cp_bist_done",    1033},
    {"dpc_bist_fail",    1034},
    {"dpc_bist_done",    1035},
    {"txq_bist_done_3_0",    1036},
    {"txq_bist_fail_28_0",    1037},
    {"bhsa_drf_bist_fail",    1038},
    {"bhsa_drf_bist_done",    1039},
    {"ehsa_drf_bist_fail",    1040},
    {"ehsa_drf_bist_done",    1041},
    {"ehsa_ll_drf_bist_fail",    1042},
    {"ehsa_ll_drf_bist_done",    1043},
    {"cp_drf_bist_fail",    1044},
    {"cp_drf_bist_done",    1045},
    {"dpc_drf_bist_fail",    1046},
    {"dpc_drf_bist_done",    1047},
    {"txq_drf_bist_done_3_0",    1048},
    {"txq_drf_bist_fail_28_0",    1049},
    {"bhsa_drf_start_pause",    1050},
    {"ehsa_drf_start_pause",    1051},
    {"ehsa_ll_drf_start_pause",    1052},
    {"cp_drf_start_pause",    1053},
    {"dpc_drf_start_pause",    1054},
    {"txq_drf_start_pause_3_0",    1055},
    {"bhsa_sram_rme",    1056},
    {"bhsa_sram_rm_3_0",    1057},
    {"ehsa_sram_rme",    1058},
    {"ehsa_sram_rm_3_0",    1059},
    {"ehsa_ll_sram_rme",    1060},
    {"ehsa_ll_sram_rm_3_0",    1061},
    {"cp_sram_rme",    1062},
    {"cp_sram_rm_3_0",    1063},
    {"dpc_sram_rme",    1064},
    {"dpc_sram_rm_3_0",    1065},
    {"txq_sram_rme",    1066},
    {"txq_sram_rm_3_0",    1067},
    {"soc_rme",    1068},
    {"soc_rm_3_0",    1069},
    {"soc_ls",    1070},
    {"cpu1_dvs_7",    1071},
    {"cpu1_dvs_6",    1072},
    {"cpu1_dvs_5",    1073},
    {"cpu1_dvs_4",    1074},
    {"cpu1_dvs_3",    1075},
    {"cpu1_dvs_2",    1076},
    {"cpu1_dvs_1",    1077},
    {"cpu1_dvs_0",    1078},
    {"cpu1_dvs_15",    1079},
    {"cpu1_dvs_14",    1080},
    {"cpu1_dvs_13",    1081},
    {"cpu1_dvs_12",    1082},
    {"cpu1_dvs_11",    1083},
    {"cpu1_dvs_10",    1084},
    {"cpu1_dvs_9",    1085},
    {"cpu1_dvs_8",    1086},
    {"cpu1_dvs_19",    1087},
    {"cpu1_dvs_18",    1088},
    {"cpu1_dvs_17",    1089},
    {"cpu1_dvs_16",    1090},
    {"cpu1_dvs",    1091},
    {"sramctrl_ram_dvs",    1092},
    {"sramctrl_ram_dvse",    1093},
    {"sramctrl_rom_dvs",    1094},
    {"bist_mode",    1095},
    {"bist_mode_ocp",    1096},
    {"drf_bist_mode",    1097},
    {"drf_bist_mode_ocp",    1098},
    {"drf_test_resume",    1099},
    {"drf_test_resume_ocp",    1100},
    {"cpu1_drf_bist0_start_pause",    1101},
    {"cpu1_drf_bist1_start_pause",    1102},
    {"sram_drf_start_pause_0",    1103},
    {"cpu1_bist0_done",    1104},
    {"cpu1_bist1_done",    1105},
    {"cpu1_drf_bist0_done",    1106},
    {"cpu1_drf_bist1_done",    1107},
    {"sram_bist_done_0",    1108},
    {"sram_drf_bist_done_0",    1109},
    {"sram_rom_bist_done",    1110},
    {"flsh_bist_rstn",    1111},
    {"usbhost_drf_bist_mode",    1112},
    {"usbhost_drf_test_resume",    1113},
    {"usbhost_bist_mode",    1114},
    {"usbhost_bist_rstn",    1115},
    {"cpu1_bist1_fail_8",    1116},
    {"cpu1_bist1_fail_7",    1117},
    {"cpu1_bist1_fail_6",    1118},
    {"cpu1_bist1_fail_5",    1119},
    {"cpu1_bist1_fail_4",    1120},
    {"cpu1_bist1_fail_3",    1121},
    {"cpu1_bist1_fail_2",    1122},
    {"cpu1_bist1_fail_1",    1123},
    {"cpu1_bist1_fail_0",    1124},
    {"cpu1_bist0_fail_10",    1125},
    {"cpu1_bist0_fail_9",    1126},
    {"cpu1_bist0_fail_8",    1127},
    {"cpu1_bist0_fail_7",    1128},
    {"cpu1_bist0_fail_6",    1129},
    {"cpu1_bist0_fail_5",    1130},
    {"cpu1_bist0_fail_4",    1131},
    {"cpu1_bist0_fail_3",    1132},
    {"cpu1_bist0_fail_2",    1133},
    {"cpu1_bist0_fail_1",    1134},
    {"cpu1_bist0_fail_0",    1135},
    {"cpu1_drf_bist1_fail_8",    1136},
    {"cpu1_drf_bist1_fail_7",    1137},
    {"cpu1_drf_bist1_fail_6",    1138},
    {"cpu1_drf_bist1_fail_5",    1139},
    {"cpu1_drf_bist1_fail_4",    1140},
    {"cpu1_drf_bist1_fail_3",    1141},
    {"cpu1_drf_bist1_fail_2",    1142},
    {"cpu1_drf_bist1_fail_1",    1143},
    {"cpu1_drf_bist1_fail_0",    1144},
    {"cpu1_drf_bist0_fail_10",    1145},
    {"cpu1_drf_bist0_fail_9",    1146},
    {"cpu1_drf_bist0_fail_8",    1147},
    {"cpu1_drf_bist0_fail_7",    1148},
    {"cpu1_drf_bist0_fail_6",    1149},
    {"cpu1_drf_bist0_fail_5",    1150},
    {"cpu1_drf_bist0_fail_4",    1151},
    {"cpu1_drf_bist0_fail_3",    1152},
    {"cpu1_drf_bist0_fail_2",    1153},
    {"cpu1_drf_bist0_fail_1",    1154},
    {"cpu1_drf_bist0_fail_0",    1155},
    {"sram_bist_fail_0_0",    1156},
    {"sram_bist_fail_0_1",    1157},
    {"sram_drf_bist_fail_0_0",    1158},
    {"sram_drf_bist_fail_0_1",    1159},
    {"sram_rom_bist_fail_0",    1160},
    {"sram_rom_bist_fail_1",    1161},
    {"flsh_drf_bist_fail",    1162},
    {"flsh_drf_start_pause",    1163},
    {"flsh_drf_bist_done",    1164},
    {"flsh_bist_fail",    1165},
    {"flsh_bist_done",    1166},
    {"usbhost_drf_bist_fail",    1167},
    {"usbhost_drf_start_pause",    1168},
    {"usbhost_drf_bist_done",    1169},
    {"usbhost_bist_fail",    1170},
    {"usbhost_bist_done",    1171},
    {"rom_misr_dataout_0",    1172},
    {"rom_mbisr_dataout_0",    1173},
    {"spi_so_ref",    1174},
    {"reg_if_sel",    1175},
    {"cfg_sda_dly",    1176},
    {"i2c_data_endian_sel",    1177},
    {"spi_timeout_set",    1178},
    {"spi_timeout_flag",    1179},
    {"i2c_timeout_set",    1180},
    {"i2c_timeout_flag",    1181},
    {"mem_addr",    1182},
    {"sda_out_sel",    1183},
    {"gpio8_scl_sel",    1184},
    {"rwop",    1185},
    {"i2c_fail",    1186},
    {"i2c_trig",    1187},
    {"i2c_reset",    1188},
    {"drive_ack_delay",    1189},
    {"check_ack_delay",    1190},
    {"i2c_rd_mode",    1191},
    {"dev_addr",    1192},
    {"data_width",    1193},
    {"mem_addr_width",    1194},
    {"scl_freq",    1195},
    {"data3",    1196},
    {"data2",    1197},
    {"data1",    1198},
    {"data0",    1199},
    {"data7",    1200},
    {"data6",    1201},
    {"data5",    1202},
    {"data4",    1203},
    {"data11",    1204},
    {"data10",    1205},
    {"data9",    1206},
    {"data8",    1207},
    {"data15",    1208},
    {"data14",    1209},
    {"data13",    1210},
    {"data12",    1211},
    {"cfg_sck_i_dly_2",    1212},
    {"cfg_sck_i_dly_1",    1213},
    {"cfg_wait_scl_mode_2",    1214},
    {"cfg_wait_scl_mode_1",    1215},
    {"cfg_data_hold_time_2",    1216},
    {"cfg_data_hold_time_1",    1217},
    {"i2c_open_drn_scl_mst2",    1218},
    {"i2c_open_drn_scl_mst1",    1219},
    {"i2c_open_drn_sda_7_0",    1220},
    {"gpio16_sda7_sel",    1221},
    {"gpio15_sda6_sel",    1222},
    {"gpio14_sda5_sel",    1223},
    {"gpio13_sda4_sel",    1224},
    {"gpio12_sda3_sel",    1225},
    {"gpio11_sda2_sel",    1226},
    {"gpio10_sda1_sel",    1227},
    {"gpio9_sda0_sel",    1228},
    {"gpio17_scl_sel",    1229},
    {"addr_width",    1230},
    {"spi_clk_div",    1231},
    {"gpio_spi_sel",    1232},
    {"csb_out_sel",    1233},
    {"gpio6_csb1_sel",    1234},
    {"gpio7_csb0_sel",    1235},
    {"spi_cmd",    1236},
    {"spi_cmd_type",    1237},
    {"spi_trig",    1238},
    {"spi_rx_dly",    1239},
    {"spi_clk_dly",    1240},
    {"spi_tx_dly",    1241},
    {"spi_cpha",    1242},
    {"spi_cpol",    1243},
    {"spi_tslch",    1244},
    {"spi_tchsh",    1245},
    {"spi_addr",    1246},
    {"data",    1247},
    {"p0_intf",    1248},
    {"ptp_ext_en",    1249},
    {"gpio20_1588out_sel",    1250},
    {"gpio19_ledsync_sel",    1251},
    {"gpio18_usbled_sel",    1252},
    {"slv_spi_cs_sel_gpio",    1253},
    {"slv_spi_sdo_sel_gpio",    1254},
    {"jtag_tdo_sel_gpio",    1255},
    {"jtag_tdi_sel_gpio",    1256},
    {"jtag_tms_sel_gpio",    1257},
    {"jtag_tck_sel_gpio",    1258},
    {"jtag_trst_sel_gpio",    1259},
    {"jtag_sel",    1260},
    {"cfg_mdx_dealy",    1261},
    {"led_stack_ftg_ignore",    1262},
    {"led_stack",    1263},
    {"ledic_page_access",    1264},
    {"ledic_restart",    1265},
    {"led_active",    1266},
    {"led_signal_invert",    1267},
    {"blink_time_sel",    1268},
    {"led_clk_sel",    1269},
    {"led_load_en",    1270},
    {"sys_led_mode",    1271},
    {"sys_led_en",    1272},
    {"stp2_pwr_on_led",    1273},
    {"stp1_pwr_on_led",    1274},
    {"pwr_on_blink_sel",    1275},
    {"led_mod",    1276},
    {"led_num_sel",    1277},
    {"set3_led3_sel",    1278},
    {"set3_led2_sel",    1279},
    {"set3_led1_sel",    1280},
    {"set3_led0_sel",    1281},
    {"set2_led3_sel",    1282},
    {"set2_led2_sel",    1283},
    {"set2_led1_sel",    1284},
    {"set2_led0_sel",    1285},
    {"set1_led3_sel",    1286},
    {"set1_led2_sel",    1287},
    {"set1_led1_sel",    1288},
    {"set1_led0_sel",    1289},
    {"set0_led3_sel",    1290},
    {"set0_led2_sel",    1291},
    {"set0_led1_sel",    1292},
    {"set0_led0_sel",    1293},
    {"led_copr_set_psel",    1294},
    {"led_fib_set_psel",    1295},
    {"led_copr_pmask",    1296},
    {"led_fib_pmask",    1297},
    {"led_combo_pmask",    1298},
    {"sw_led_load",    1299},
    {"sw_ctrl_led_en",    1300},
    {"sw_fib_led3_mode",    1301},
    {"sw_fib_led2_mode",    1302},
    {"sw_fib_led1_mode",    1303},
    {"sw_fib_led0_mode",    1304},
    {"sw_copr_led3_mode",    1305},
    {"sw_copr_led2_mode",    1306},
    {"sw_copr_led1_mode",    1307},
    {"sw_copr_led0_mode",    1308},
    {"reg",    1309},
    {"phyaddr",    1310},
    {"cmd",    1311},
    {"lv1_thr_10g",    1312},
    {"lv2_thr_10g",    1313},
    {"lv3_thr_10g",    1314},
    {"lv1_thr_5g",    1315},
    {"lv2_thr_5g",    1316},
    {"lv3_thr_5g",    1317},
    {"lv1_thr_2p5g",    1318},
    {"lv2_thr_2p5g",    1319},
    {"lv3_thr_2p5g",    1320},
    {"lv1_thr_1g",    1321},
    {"lv2_thr_1g",    1322},
    {"lv3_thr_1g",    1323},
    {"lv1_thr_500m",    1324},
    {"lv2_thr_500m",    1325},
    {"lv3_thr_500m",    1326},
    {"lv1_thr_100m",    1327},
    {"lv2_thr_100m",    1328},
    {"lv3_thr_100m",    1329},
    {"lv1_thr_10m",    1330},
    {"lv2_thr_10m",    1331},
    {"lv3_thr_10m",    1332},
    {"dv_speedup_led",    1333},
    {"p_load_cntr_idx",    1334},
    {"p_load_cntr",    1335},
    {"dv_speedup_gpio",    1336},
    {"ext_gpio_mdx2_ready",    1337},
    {"ext_gpio_mdx3_ready",    1338},
    {"ext_gpio_en",    1339},
    {"ext_gpio_mdio_prembl",    1340},
    {"ext_gpio_mdc_period",    1341},
    {"ext_gpio_mdx2_access_mode",    1342},
    {"ext_gpio_mdx3_access_mode",    1343},
    {"ext_gpio_mdx2_en",    1344},
    {"ext_gpio_mdx3_en",    1345},
    {"ext_gpio_mdx2_trig",    1346},
    {"ext_gpio_mdx3_trig",    1347},
    {"ext_gpio_31_0_dir",    1348},
    {"ext_gpio_63_32_dir",    1349},
    {"ext_gpio_73_64_dir",    1350},
    {"ext_gpio_31_0_data",    1351},
    {"ext_gpio_63_32_data",    1352},
    {"ext_gpio_73_64_data",    1353},
    {"gpio_rcmd_fail",    1354},
    {"gpio_data",    1355},
    {"gpio_reg",    1356},
    {"gpio_phyadrr",    1357},
    {"gpio_rwop",    1358},
    {"gpio_cmd",    1359},
    {"imr_ext_cpu",    1360},
    {"imr_port_link_sts_chg_28_0",    1361},
    {"imr_rsvd",    1362},
    {"imr_serdes_link_fault_p27",    1363},
    {"imr_serdes_link_fault_p26",    1364},
    {"imr_serdes_link_fault_p25",    1365},
    {"imr_serdes_link_fault_p24",    1366},
    {"imr_serdes_link_fault_p23",    1367},
    {"imr_serdes_link_fault_p22",    1368},
    {"imr_serdes_link_fault_p21",    1369},
    {"imr_serdes_link_fault_p20",    1370},
    {"imr_serdes_link_fault_p19",    1371},
    {"imr_serdes_link_fault_p18",    1372},
    {"imr_serdes_link_fault_p17",    1373},
    {"imr_serdes_link_fault_p16",    1374},
    {"imr_serdes_link_fault_p15",    1375},
    {"imr_serdes_link_fault_p14",    1376},
    {"imr_serdes_link_fault_p13",    1377},
    {"imr_serdes_link_fault_p12",    1378},
    {"imr_serdes_link_fault_p11",    1379},
    {"imr_serdes_link_fault_p10",    1380},
    {"imr_serdes_link_fault_p9",    1381},
    {"imr_serdes_link_fault_p8",    1382},
    {"imr_serdes_link_fault_p7",    1383},
    {"imr_serdes_link_fault_p6",    1384},
    {"imr_serdes_link_fault_p5",    1385},
    {"imr_serdes_link_fault_p4",    1386},
    {"imr_serdes_link_fault_p3",    1387},
    {"imr_serdes_link_fault_p2",    1388},
    {"imr_serdes_link_fault_p1",    1389},
    {"imr_serdes_link_fault_p0",    1390},
    {"imr_serdes_rx_sym_err11",    1391},
    {"imr_serdes_rx_sym_err10",    1392},
    {"imr_serdes_rx_sym_err9",    1393},
    {"imr_serdes_rx_sym_err8",    1394},
    {"imr_serdes_rx_sym_err7",    1395},
    {"imr_serdes_rx_sym_err6",    1396},
    {"imr_serdes_rx_sym_err5",    1397},
    {"imr_serdes_rx_sym_err4",    1398},
    {"imr_serdes_rx_sym_err3",    1399},
    {"imr_serdes_rx_sym_err2",    1400},
    {"imr_serdes_rx_sym_err1",    1401},
    {"imr_serdes_rx_sym_err0",    1402},
    {"imr_oam_dygasp",    1403},
    {"imr_ext_gpio_31_0",    1404},
    {"imr_ext_gpio_36_32",    1405},
    {"imr_rlfd_port_27_0",    1406},
    {"imr_tm_low",    1407},
    {"imr_tm_high",    1408},
    {"imr_auto_rec",    1409},
    {"imr_smi_check_reg_4_0",    1410},
    {"imr_sds_upd_physts27_0",    1411},
    {"imr_rout_l2_ntfy_buf",    1412},
    {"imr_rout_pbuf",    1413},
    {"isr_glb_sds_rx_sym_err",    1414},
    {"isr_glb_rout_l2_ntfy_buf",    1415},
    {"isr_glb_rout_pbuf",    1416},
    {"isr_rlfd_glb",    1417},
    {"isr_glb_sds_upd_physts",    1418},
    {"isr_glb_auto_rec",    1419},
    {"isr_glb_smi_check",    1420},
    {"isr_glb_termal_detect",    1421},
    {"isr_glb_ext_gpio",    1422},
    {"isr_glb_oam_dygasp",    1423},
    {"isr_glb_serdes_link_fault_p",    1424},
    {"isr_glb_link_chg",    1425},
    {"sw_int_pulse_interval",    1426},
    {"sw_int_mode",    1427},
    {"isr_port_link_sts_chg_28_0",    1428},
    {"isr_rsvd",    1429},
    {"isr_serdes89_link_fault_p27",    1430},
    {"isr_serdes89_link_fault_p26",    1431},
    {"isr_serdes89_link_fault_p25",    1432},
    {"isr_serdes89_link_fault_p24",    1433},
    {"isr_serdes89_link_fault_p23",    1434},
    {"isr_serdes89_link_fault_p22",    1435},
    {"isr_serdes89_link_fault_p21",    1436},
    {"isr_serdes89_link_fault_p20",    1437},
    {"isr_serdes89_link_fault_p19",    1438},
    {"isr_serdes89_link_fault_p18",    1439},
    {"isr_serdes89_link_fault_p17",    1440},
    {"isr_serdes89_link_fault_p16",    1441},
    {"isr_serdes89_link_fault_p15",    1442},
    {"isr_serdes89_link_fault_p14",    1443},
    {"isr_serdes89_link_fault_p13",    1444},
    {"isr_serdes89_link_fault_p12",    1445},
    {"isr_serdes89_link_fault_p11",    1446},
    {"isr_serdes89_link_fault_p10",    1447},
    {"isr_serdes89_link_fault_p9",    1448},
    {"isr_serdes89_link_fault_p8",    1449},
    {"isr_serdes89_link_fault_p7",    1450},
    {"isr_serdes89_link_fault_p6",    1451},
    {"isr_serdes89_link_fault_p5",    1452},
    {"isr_serdes89_link_fault_p4",    1453},
    {"isr_serdes89_link_fault_p3",    1454},
    {"isr_serdes89_link_fault_p2",    1455},
    {"isr_serdes89_link_fault_p1",    1456},
    {"isr_serdes89_link_fault_p0",    1457},
    {"isr_serdes11_rx_sym_err",    1458},
    {"isr_serdes10_rx_sym_err",    1459},
    {"isr_serdes9_rx_sym_err",    1460},
    {"isr_serdes8_rx_sym_err",    1461},
    {"isr_serdes7_rx_sym_err",    1462},
    {"isr_serdes6_rx_sym_err",    1463},
    {"isr_serdes5_rx_sym_err",    1464},
    {"isr_serdes4_rx_sym_err",    1465},
    {"isr_serdes3_rx_sym_err",    1466},
    {"isr_serdes2_rx_sym_err",    1467},
    {"isr_serdes1_rx_sym_err",    1468},
    {"isr_serdes0_rx_sym_err",    1469},
    {"isr_oam_dygasp",    1470},
    {"isr_ext_gpio31_0",    1471},
    {"isr_ext_gpio36_32",    1472},
    {"ext_gpio15_int_mode",    1473},
    {"ext_gpio14_int_mode",    1474},
    {"ext_gpio13_int_mode",    1475},
    {"ext_gpio12_int_mode",    1476},
    {"ext_gpio11_int_mode",    1477},
    {"ext_gpio10_int_mode",    1478},
    {"ext_gpio9_int_mode",    1479},
    {"ext_gpio8_int_mode",    1480},
    {"ext_gpio7_int_mode",    1481},
    {"ext_gpio6_int_mode",    1482},
    {"ext_gpio5_int_mode",    1483},
    {"ext_gpio4_int_mode",    1484},
    {"ext_gpio3_int_mode",    1485},
    {"ext_gpio2_int_mode",    1486},
    {"ext_gpio1_int_mode",    1487},
    {"ext_gpio0_int_mode",    1488},
    {"ext_gpio31_int_mode",    1489},
    {"ext_gpio30_int_mode",    1490},
    {"ext_gpio29_int_mode",    1491},
    {"ext_gpio28_int_mode",    1492},
    {"ext_gpio27_int_mode",    1493},
    {"ext_gpio26_int_mode",    1494},
    {"ext_gpio25_int_mode",    1495},
    {"ext_gpio24_int_mode",    1496},
    {"ext_gpio23_int_mode",    1497},
    {"ext_gpio22_int_mode",    1498},
    {"ext_gpio21_int_mode",    1499},
    {"ext_gpio20_int_mode",    1500},
    {"ext_gpio19_int_mode",    1501},
    {"ext_gpio18_int_mode",    1502},
    {"ext_gpio17_int_mode",    1503},
    {"ext_gpio16_int_mode",    1504},
    {"ext_gpio36_int_mode",    1505},
    {"ext_gpio35_int_mode",    1506},
    {"ext_gpio34_int_mode",    1507},
    {"ext_gpio33_int_mode",    1508},
    {"ext_gpio32_int_mode",    1509},
    {"isr_rlfd_port_27_0",    1510},
    {"isr_tm_low",    1511},
    {"isr_tm_high",    1512},
    {"isr_auto_rec",    1513},
    {"isr_smi_check_4_0",    1514},
    {"isr_sds_upd_physts27_0",    1515},
    {"isr_rout_l2_ntfy_buf",    1516},
    {"isr_rout_pbuf",    1517},
    {"efuse_access_en",    1518},
    {"efuse_ctrl_done",    1519},
    {"efuse_access_busy",    1520},
    {"efuse_cmd",    1521},
    {"efuse_addr",    1522},
    {"efuse_rwop",    1523},
    {"efuse_wdata",    1524},
    {"efuse_rdata",    1525},
    {"calib_step_finish",    1526},
    {"amp_calib_fail",    1527},
    {"r_calib_fail",    1528},
    {"amp_efuse_trig",    1529},
    {"r_efuse_trig",    1530},
    {"rc_efuse_trig",    1531},
    {"adc_efuse_trig",    1532},
    {"amp_calib_trig",    1533},
    {"r_calib_trig",    1534},
    {"rc_calib_trig",    1535},
    {"calib_mode_sel",    1536},
    {"center_port_sel",    1537},
    {"group1_mask",    1538},
    {"group0_mask",    1539},
    {"group1_calib_port",    1540},
    {"group0_calib_port",    1541},
    {"amp_fail_sram_reg",    1542},
    {"r_fail_sram_reg",    1543},
    {"cfg_tapbin_ofs",    1544},
    {"cfg_ampk_all_ch_en",    1545},
    {"che_calib_fail",    1546},
    {"amp_sram_bit",    1547},
    {"r_sram_bit",    1548},
    {"speed_en",    1549},
    {"dss_rst_n",    1550},
    {"ro_sel",    1551},
    {"wire_sel",    1552},
    {"data_in",    1553},
    {"ready",    1554},
    {"wsort_go",    1555},
    {"count_out",    1556},
    {"spd_sel",    1557},
    {"dbgo",    1558},
    {"tm_lowcmp_en",    1559},
    {"tm_low_thr",    1560},
    {"tm_highcmp_en",    1561},
    {"tm_high_thr",    1562},
    {"pwron_dly",    1563},
    {"sample_dly",    1564},
    {"compare_dly",    1565},
    {"reverse_cmp_out",    1566},
    {"tm_enable",    1567},
    {"sbg_2_0",    1568},
    {"sos_2_0",    1569},
    {"sinl_1_0",    1570},
    {"en_chop",    1571},
    {"sw2_sw3_reverse",    1572},
    {"chop_swcnt_4_0",    1573},
    {"thermal_dummy",    1574},
    {"data_sampled",    1575},
    {"data_valid",    1576},
    {"temp_out",    1577},
    {"temp_base_code",    1578},
    {"temp_out_open",    1579},
    {"temp_max",    1580},
    {"temp_min",    1581},
    {"gpion_io_drv",    1582},
    {"gpion_io_slew",    1583},
    {"m2_mdx_ck_smt",    1584},
    {"m2_mdx_ck_drv",    1585},
    {"m2_mdx_ck_slew",    1586},
    {"m2_mdx_io_smt",    1587},
    {"m2_mdx_io_drv",    1588},
    {"m2_mdx_io_slew",    1589},
    {"m1_mdx_ck_smt",    1590},
    {"m1_mdx_ck_drv",    1591},
    {"m1_mdx_ck_slew",    1592},
    {"m1_mdx_io_smt",    1593},
    {"m1_mdx_io_drv",    1594},
    {"m1_mdx_io_slew",    1595},
    {"m0_mdx_ck_smt",    1596},
    {"m0_mdx_ck_drv",    1597},
    {"m0_mdx_ck_slew",    1598},
    {"m0_mdx_io_smt",    1599},
    {"m0_mdx_io_drv",    1600},
    {"m0_mdx_io_slew",    1601},
    {"m3_mdx_ck_drv",    1602},
    {"m3_mdx_ck_slew",    1603},
    {"m3_mdx_io_drv",    1604},
    {"m3_mdx_io_slew",    1605},
    {"spi_mst_rst_drv",    1606},
    {"spi_mst_rst_slew",    1607},
    {"spi_mst_cs1_drv",    1608},
    {"spi_mst_cs1_slew",    1609},
    {"spi_mst_cs0_drv",    1610},
    {"spi_mst_cs0_slew",    1611},
    {"spi_mst_io3_drv",    1612},
    {"spi_mst_io3_slew",    1613},
    {"spi_mst_io2_drv",    1614},
    {"spi_mst_io2_slew",    1615},
    {"spi_mst_io1_drv",    1616},
    {"spi_mst_io1_slew",    1617},
    {"spi_mst_io0_drv",    1618},
    {"spi_mst_io0_slew",    1619},
    {"spi_mst_ck_drv",    1620},
    {"spi_mst_ck_slew",    1621},
    {"led_ck_drv",    1622},
    {"led_ck_slew",    1623},
    {"led_da_drv",    1624},
    {"led_da_slew",    1625},
    {"slv_spi_csn_drv",    1626},
    {"slv_spi_csn_slew",    1627},
    {"slv_spi_sdo_drv",    1628},
    {"slv_spi_sdo_slew",    1629},
    {"i2c_sda_drv",    1630},
    {"i2c_sda_slew",    1631},
    {"i2c_sck_drv",    1632},
    {"i2c_sck_slew",    1633},
    {"uart0_rts_drv",    1634},
    {"uart0_rts_slew",    1635},
    {"uart0_cts_drv",    1636},
    {"uart0_cts_slew",    1637},
    {"uart0_txd_drv",    1638},
    {"uart0_txd_slew",    1639},
    {"uart0_rxd_drv",    1640},
    {"uart0_rxd_slew",    1641},
    {"jtag_trstn_drv",    1642},
    {"jtag_trstn_slew",    1643},
    {"jtag_tck_drv",    1644},
    {"jtag_tck_slew",    1645},
    {"jtag_tms_drv",    1646},
    {"jtag_tms_slew",    1647},
    {"jtag_tdi_drv",    1648},
    {"jtag_tdi_slew",    1649},
    {"jtag_tdo_drv",    1650},
    {"jtag_tdo_slew",    1651},
    {"rstout_drv",    1652},
    {"rstout_slew",    1653},
    {"int_io_drv",    1654},
    {"int_io_slew",    1655},
    {"reset_io_drv",    1656},
    {"reset_io_slew",    1657},
    {"gpion_io_smt",    1658},
    {"m3_mdx_ck_smt",    1659},
    {"m3_mdx_io_smt",    1660},
    {"spi_mst_rst_smt",    1661},
    {"spi_mst_cs1_smt",    1662},
    {"spi_mst_cs0_smt",    1663},
    {"spi_mst_io3_smt",    1664},
    {"spi_mst_io2_smt",    1665},
    {"spi_mst_io1_smt",    1666},
    {"spi_mst_io0_smt",    1667},
    {"spi_mst_ck_smt",    1668},
    {"led_ck_smt",    1669},
    {"led_da_smt",    1670},
    {"slv_spi_csn_smt",    1671},
    {"slv_spi_sdo_smt",    1672},
    {"i2c_sda_smt",    1673},
    {"i2c_sck_smt",    1674},
    {"uart0_rts_smt",    1675},
    {"uart0_cts_smt",    1676},
    {"uart0_rxd_smt",    1677},
    {"uart0_txd_smt",    1678},
    {"jtag_trstn_smt",    1679},
    {"jtag_tck_smt",    1680},
    {"jtag_tms_smt",    1681},
    {"jtag_tdi_smt",    1682},
    {"jtag_tdo_smt",    1683},
    {"rstout_smt",    1684},
    {"int_io_smt",    1685},
    {"reset_io_smt",    1686},
    {"ft_scan_submode",    1687},
    {"ft_scan_mode",    1688},
    {"cpu_testmode",    1689},
    {"sel_ejtag_lbist",    1690},
    {"soc_extclk_mode",    1691},
    {"ocl_pon200urst_n",    1692},
    {"soc_byp_mem_ini",    1693},
    {"soc_byp_200us",    1694},
    {"soc_spdup",    1695},
    {"bo_24_0",    1696},
    {"strp_31_0",    1697},
    {"dbg_shift",    1698},
    {"dbg_en",    1699},
    {"dbg_blk_sel0",    1700},
    {"dbg_bit_sel0",    1701},
    {"dbg_blk_sel1",    1702},
    {"dbg_bit_sel1",    1703},
    {"dbg_blk_sel2",    1704},
    {"dbg_bit_sel2",    1705},
    {"dbg_blk_sel3",    1706},
    {"dbg_bit_sel3",    1707},
    {"dbg_sig_sel0",    1708},
    {"dbg_sig_sel1",    1709},
    {"dbg_sig_sel2",    1710},
    {"dbg_sig_sel3",    1711},
    {"dbg_out",    1712},
    {"cfg_vol_prb_sel",    1713},
    {"dss_sel",    1714},
    {"addr",    1715},
    {"rx_run_out",    1716},
    {"rx_done",    1717},
    {"tx_all_done",    1718},
    {"tx_done",    1719},
    {"rx_truncate_len",    1720},
    {"rx_truncate_en",    1721},
    {"tx_en",    1722},
    {"rx_en",    1723},
    {"tx_high_fetch",    1724},
    {"tx_low_fetch",    1725},
    {"tx_high_busy",    1726},
    {"tx_low_busy",    1727},
    {"trap_pkt_tag",    1728},
    {"fwd_pkt_tag",    1729},
    {"trap_pkt_fmt",    1730},
    {"fwd_pkt_fmt",    1731},
    {"pkt_vlan_fmt",    1732},
    {"size",    1733},
    {"cntr",    1734},
    {"msk",    1735},
    {"nic_debug_sel_0",    1736},
    {"nic_debug_sel_1",    1737},
    {"bist_done",    1738},
    {"bist_fail",    1739},
    {"drf_bist_done",    1740},
    {"drf_bist_fail",    1741},
    {"drf_bist_pause",    1742},
    {"bist_disable",    1743},
    {"bist_rme_a",    1744},
    {"bist_rm_a",    1745},
    {"bist_rme_b",    1746},
    {"bist_rm_b",    1747},
    {"switch_ipv4",    1748},
    {"switch_ipv6_3",    1749},
    {"switch_ipv6_2",    1750},
    {"switch_ipv6_1",    1751},
    {"switch_ipv6_0",    1752},
    {"udp_dport",    1753},
    {"capwap_trap_target",    1754},
    {"cpu_sel",    1755},
    {"ip_cmp",    1756},
    {"capwap",    1757},
    {"ip4_chksum_err_act",    1758},
    {"l2_crc_err_act",    1759},
    {"garp_act",    1760},
    {"exec",    1761},
    {"tbl",    1762},
    {"sram_if",    1763},
    {"method",    1764},
    {"start_addr",    1765},
    {"vid",    1766},
    {"mac_h",    1767},
    {"mac_l",    1768},
    {"hit",    1769},
    {"full",    1770},
    {"hit_addr",    1771},
    {"smac_31_0",    1772},
    {"mac_48pass1_drop_en",    1773},
    {"original_crs",    1774},
    {"original_col",    1775},
    {"defer_pkt_cont_sel",    1776},
    {"max_retx_sel",    1777},
    {"late_coli_drop_en",    1778},
    {"iol_max_retry_en",    1779},
    {"bkoff_spdup",    1780},
    {"bkoff_sel",    1781},
    {"half_48pass1_en",    1782},
    {"bkpres_mthd_sel",    1783},
    {"defer_ipg_sel",    1784},
    {"precollat_sel",    1785},
    {"late_coli_thr",    1786},
    {"bkpres_en",    1787},
    {"half_to_full_pause",    1788},
    {"ref_rx_congest",    1789},
    {"chg_dup_thr",    1790},
    {"full_det_en",    1791},
    {"mac_chg_dup",    1792},
    {"col_cur_cnt",    1793},
    {"sck_freq_sel",    1794},
    {"eeepom_valid",    1795},
    {"eeprom_valid_fail",    1796},
    {"eeprom_compl",    1797},
    {"noeeprom",    1798},
    {"mac_seg_end_pos",    1799},
    {"mac_seg_start_pos",    1800},
    {"serdes_seg_end_pos",    1801},
    {"serdes_seg_start_pos",    1802},
    {"phy_seg_end_pos",    1803},
    {"phy_seg_start_pos",    1804},
    {"group_mac_seg_end_pos",    1805},
    {"group_mac_seg_start_pos",    1806},
    {"smi_glb_rst",    1807},
    {"smi3_polling_park_sel",    1808},
    {"smi2_polling_park_sel",    1809},
    {"smi1_polling_park_sel",    1810},
    {"smi0_polling_park_sel",    1811},
    {"smi3_poll_sel",    1812},
    {"smi2_poll_sel",    1813},
    {"smi1_poll_sel",    1814},
    {"smi0_poll_sel",    1815},
    {"smi3_intf_sel",    1816},
    {"smi2_intf_sel",    1817},
    {"smi1_intf_sel",    1818},
    {"smi0_intf_sel",    1819},
    {"smi3_freq_sel",    1820},
    {"smi2_freq_sel",    1821},
    {"smi1_freq_sel",    1822},
    {"smi0_freq_sel",    1823},
    {"smi3_preamble_sel",    1824},
    {"smi2_preamble_sel",    1825},
    {"smi1_preamble_sel",    1826},
    {"smi0_preamble_sel",    1827},
    {"smi3_broadcast_set_en",    1828},
    {"smi2_broadcast_set_en",    1829},
    {"smi1_broadcast_set_en",    1830},
    {"smi0_broadcast_set_en",    1831},
    {"mac_p27_type",    1832},
    {"mac_p26_type",    1833},
    {"mac_p25_type",    1834},
    {"mac_p24_type",    1835},
    {"mac_p23_p20_type",    1836},
    {"mac_p19_p16_type",    1837},
    {"mac_p15_p12_type",    1838},
    {"mac_p11_p8_type",    1839},
    {"mac_p7_p4_type",    1840},
    {"mac_p3_p0_type",    1841},
    {"smi_port15_polling_sel",    1842},
    {"smi_port14_polling_sel",    1843},
    {"smi_port13_polling_sel",    1844},
    {"smi_port12_polling_sel",    1845},
    {"smi_port11_polling_sel",    1846},
    {"smi_port10_polling_sel",    1847},
    {"smi_port9_polling_sel",    1848},
    {"smi_port8_polling_sel",    1849},
    {"smi_port7_polling_sel",    1850},
    {"smi_port6_polling_sel",    1851},
    {"smi_port5_polling_sel",    1852},
    {"smi_port4_polling_sel",    1853},
    {"smi_port3_polling_sel",    1854},
    {"smi_port2_polling_sel",    1855},
    {"smi_port1_polling_sel",    1856},
    {"smi_port0_polling_sel",    1857},
    {"smi_port27_polling_sel",    1858},
    {"smi_port26_polling_sel",    1859},
    {"smi_port25_polling_sel",    1860},
    {"smi_port24_polling_sel",    1861},
    {"smi_port23_polling_sel",    1862},
    {"smi_port22_polling_sel",    1863},
    {"smi_port21_polling_sel",    1864},
    {"smi_port20_polling_sel",    1865},
    {"smi_port19_polling_sel",    1866},
    {"smi_port18_polling_sel",    1867},
    {"smi_port17_polling_sel",    1868},
    {"smi_port16_polling_sel",    1869},
    {"smi_prvte_polling27_0",    1870},
    {"mdio_free_cnt_sel",    1871},
    {"mdio_free_cnt_en",    1872},
    {"intdev0_polling_10gphy",    1873},
    {"intreg0_polling_10gphy",    1874},
    {"force_byp_link",    1875},
    {"media_sel",    1876},
    {"eee_en_10g",    1877},
    {"eee_en_5g",    1878},
    {"eee_en_2p5g",    1879},
    {"eee_en_1000m",    1880},
    {"eee_en_500m",    1881},
    {"eee_en_100m",    1882},
    {"mac_force_fc_en",    1883},
    {"rx_pause_en",    1884},
    {"tx_pause_en",    1885},
    {"dup_sel",    1886},
    {"force_link_en",    1887},
    {"mac_force_en",    1888},
    {"smi_poll_mask_27_0",    1889},
    {"chk1_mode",    1890},
    {"chk1_page",    1891},
    {"chk1_reg",    1892},
    {"chk1_mode_10g",    1893},
    {"check1_mmd_reg",    1894},
    {"check1_mmd_devad",    1895},
    {"chk1_pmsk",    1896},
    {"chk1_dmsk",    1897},
    {"chk1_data",    1898},
    {"chk1_dmsk_10g",    1899},
    {"chk1_data_10g",    1900},
    {"chk1_result",    1901},
    {"chk2_mode",    1902},
    {"chk2_page",    1903},
    {"chk2_reg",    1904},
    {"chk2_mode_10g",    1905},
    {"check2_mmd_reg",    1906},
    {"check2_mmd_devad",    1907},
    {"chk2_pmsk",    1908},
    {"chk2_dmsk",    1909},
    {"chk2_data",    1910},
    {"chk2_dmsk_10g",    1911},
    {"chk2_data_10g",    1912},
    {"chk2_result",    1913},
    {"chk3_mode",    1914},
    {"chk3_page",    1915},
    {"chk3_reg",    1916},
    {"chk3_mode_10g",    1917},
    {"check3_mmd_reg",    1918},
    {"check3_mmd_devad",    1919},
    {"chk3_pmsk",    1920},
    {"chk3_dmsk",    1921},
    {"chk3_data",    1922},
    {"chk3_dmsk_10g",    1923},
    {"chk3_data_10g",    1924},
    {"chk3_result",    1925},
    {"chk4_mode",    1926},
    {"chk4_page",    1927},
    {"chk4_reg",    1928},
    {"chk4_mode_10g",    1929},
    {"check4_mmd_reg",    1930},
    {"check4_mmd_devad",    1931},
    {"chk4_pmsk",    1932},
    {"chk4_dmsk",    1933},
    {"chk4_data",    1934},
    {"chk4_dmsk_10g",    1935},
    {"chk4_data_10g",    1936},
    {"chk4_result",    1937},
    {"chk5_mode",    1938},
    {"chk5_page",    1939},
    {"chk5_reg",    1940},
    {"chk5_mode_10g",    1941},
    {"check5_mmd_reg",    1942},
    {"check5_mmd_devad",    1943},
    {"chk5_pmsk",    1944},
    {"chk5_dmsk",    1945},
    {"chk5_data",    1946},
    {"chk5_dmsk_10g",    1947},
    {"chk5_data_10g",    1948},
    {"chk5_result",    1949},
    {"link_dn_tmr_en",    1950},
    {"link_dn_tmr",    1951},
    {"bypass_ablty_lock",    1952},
    {"tx_idle_tmr",    1953},
    {"linkup_delay_10g_5g",    1954},
    {"linkup_delay_2p5g_1000m_100m",    1955},
    {"linkup_delay_10m",    1956},
    {"link_sts_28_0",    1957},
    {"media_sts_28_0",    1958},
    {"spd_sts_28_0",    1959},
    {"dup_sts_28_0",    1960},
    {"tx_pause_sts_28_0",    1961},
    {"rx_pause_sts_28_0",    1962},
    {"eee_ablty_28_0",    1963},
    {"mstr_slv_sts_27_0",    1964},
    {"mstr_slv_fault_sts_27_0",    1965},
    {"link_sts_27_0",    1966},
    {"media_sts_27_0",    1967},
    {"spd_sts_27_0",    1968},
    {"dup_sts_27_0",    1969},
    {"tx_pause_sts_27_0",    1970},
    {"rx_pause_sts_27_0",    1971},
    {"eee_ablty_27_0",    1972},
    {"phy_brdcast",    1973},
    {"phy_mask",    1974},
    {"fail",    1975},
    {"reg_addr_4_0",    1976},
    {"park_page_4_0",    1977},
    {"main_page_11_0",    1978},
    {"type",    1979},
    {"indata_15_0",    1980},
    {"data_15_0",    1981},
    {"mmd_devad_4_0",    1982},
    {"mmd_reg_15_0",    1983},
    {"port5_addr",    1984},
    {"port4_addr",    1985},
    {"port3_addr",    1986},
    {"port2_addr",    1987},
    {"port1_addr",    1988},
    {"port0_addr",    1989},
    {"port11_addr",    1990},
    {"port10_addr",    1991},
    {"port9_addr",    1992},
    {"port8_addr",    1993},
    {"port7_addr",    1994},
    {"port6_addr",    1995},
    {"port17_addr",    1996},
    {"port16_addr",    1997},
    {"port15_addr",    1998},
    {"port14_addr",    1999},
    {"port13_addr",    2000},
    {"port12_addr",    2001},
    {"port23_addr",    2002},
    {"port22_addr",    2003},
    {"port21_addr",    2004},
    {"port20_addr",    2005},
    {"port19_addr",    2006},
    {"port18_addr",    2007},
    {"port27_addr",    2008},
    {"port26_addr",    2009},
    {"port25_addr",    2010},
    {"port24_addr",    2011},
    {"sds_adj_rst",    2012},
    {"p27_sds_mode_sel",    2013},
    {"p26_sds_mode_sel",    2014},
    {"p25_sds_mode_sel",    2015},
    {"p24_sds_mode_sel",    2016},
    {"p20_sds_mode_sel",    2017},
    {"p16_sds_mode_sel",    2018},
    {"p8_sds_mode_sel",    2019},
    {"p0_sds_mode_sel",    2020},
    {"p27_sds_mode_adj",    2021},
    {"p26_sds_mode_adj",    2022},
    {"p25_sds_mode_adj",    2023},
    {"p24_sds_mode_adj",    2024},
    {"p20_sds_mode_adj",    2025},
    {"p16_sds_mode_adj",    2026},
    {"p8_sds_mode_adj",    2027},
    {"p0_sds_mode_adj",    2028},
    {"smi3_mdc_en",    2029},
    {"smi2_mdc_en",    2030},
    {"smi1_mdc_en",    2031},
    {"smi0_mdc_en",    2032},
    {"sds_mdx_dly_cfg",    2033},
    {"smi3_dly_cfg",    2034},
    {"smi2_dly_cfg",    2035},
    {"smi1_dly_cfg",    2036},
    {"smi0_dly_cfg",    2037},
    {"bonding_define_en",    2038},
    {"dummy_bonding_12_23",    2039},
    {"en_dram",    2040},
    {"chip_mode_3_0",    2041},
    {"preamble_sfd_10g_sel",    2042},
    {"ipg_10g_4n_byte_comps_en",    2043},
    {"fwd_pause_en",    2044},
    {"fwd_invld_mac_ctrl_en",    2045},
    {"fwd_unkn_opcode_en",    2046},
    {"limit_pause_en",    2047},
    {"crc_cpu_rc_en",    2048},
    {"ipg_1g_100m_10m_comps_en",    2049},
    {"ipg_1g_100m_10m_sel",    2050},
    {"ipg_2p5g_comps_en",    2051},
    {"ipg_2p5g_sel",    2052},
    {"ipg_10g_comps_en",    2053},
    {"ipg_10g_sel",    2054},
    {"iol_len_err_en",    2055},
    {"iol_max_len_en",    2056},
    {"limit_ipg_cfg_1g_2p5g",    2057},
    {"limit_ipg_cfg_10m_100m",    2058},
    {"tg_linkfault_tx_en_7_0",    2059},
    {"cfg_rx_rxdv_cnt",    2060},
    {"padding_und_size_en",    2061},
    {"rx_chk_crc_en",    2062},
    {"pass_all_mode_en",    2063},
    {"byp_tx_crc",    2064},
    {"padding_sel",    2065},
    {"intf_p28_sel",    2066},
    {"cpu_port",    2067},
    {"cpu_tag_id",    2068},
    {"sw_mac_addr_47_32",    2069},
    {"sw_mac_addr_31_0",    2070},
    {"max_len_tag_inc",    2071},
    {"max_len_100m_10m_sel",    2072},
    {"max_len_1g_2p5g_5g_10g_sel",    2073},
    {"cpu_port_tx_max_len",    2074},
    {"ph_rstb_125m_reg",    2075},
    {"phsft_cnt_125m",    2076},
    {"phsft_b_125m",    2077},
    {"phsft_a_125m",    2078},
    {"dll_mode_125m",    2079},
    {"pn_poly_deg_125m",    2080},
    {"phase_lim_sel_125m",    2081},
    {"ssc_mode_125m",    2082},
    {"ssc_en_125m",    2083},
    {"phase_lim_en_125m",    2084},
    {"ssc_type_125m",    2085},
    {"ph_gcode_125m",    2086},
    {"pn_poly_sel_125m",    2087},
    {"rdm_seed_125m",    2088},
    {"ssc_upldn0_125m",    2089},
    {"ssc_testmode_125m",    2090},
    {"ssc_offset_125m",    2091},
    {"ssc_step_125m",    2092},
    {"ssc_period_125m",    2093},
    {"ph_ofs_125m",    2094},
    {"ph_ofs_tog_125m",    2095},
    {"phsft_prd_125m",    2096},
    {"phsft_updn_125m",    2097},
    {"ssc_ph_cfg_125m",    2098},
    {"ofs_gry0_125m",    2099},
    {"ofs_busy_125m",    2100},
    {"ofs_total_r_125m",    2101},
    {"dbg_out_125m",    2102},
    {"mdc_freq",    2103},
    {"mdx_gpio_sel",    2104},
    {"rcmd_fail",    2105},
    {"rlfd_sel",    2106},
    {"rlfd_en",    2107},
    {"rlfd_sts",    2108},
    {"rlfd_dev_2p5g_10gphy",    2109},
    {"rlfd_reg_2p5g_10gphy",    2110},
    {"rlfd_bit_2p5g_10gphy",    2111},
    {"unidir_win_dly",    2112},
    {"fib_unidir_only_cputx_en",    2113},
    {"fib_unidir_en",    2114},
    {"intdev1_polling_10gphy",    2115},
    {"intreg1_polling_10gphy",    2116},
    {"reg0_bit_2p5g_10gphy",    2117},
    {"reg0_dev_2p5g_10gphy",    2118},
    {"reg0_reg_2p5g_10gphy",    2119},
    {"reg9_bit_2p5g_10gphy",    2120},
    {"reg9_dev_2p5g_10gphy",    2121},
    {"reg9_reg_2p5g_10gphy",    2122},
    {"reg10_bit_2p5g_10gphy",    2123},
    {"reg10_dev_2p5g_10gphy",    2124},
    {"reg10_reg_2p5g_10gphy",    2125},
    {"s0_frc_reg4_fib100",    2126},
    {"s4_frc_reg4_fib100",    2127},
    {"s10_frc_reg4_fib100",    2128},
    {"sds3_0_phy_mode",    2129},
    {"sds3_frc_ld",    2130},
    {"sds2_frc_ld",    2131},
    {"sds1_frc_ld",    2132},
    {"sds0_frc_ld",    2133},
    {"sds9_4_phy_mode",    2134},
    {"sds9_frc_ld",    2135},
    {"sds8_frc_ld",    2136},
    {"sds7_frc_ld",    2137},
    {"sds6_frc_ld",    2138},
    {"sds5_frc_ld",    2139},
    {"sds4_frc_ld",    2140},
    {"sds11_frc_ld",    2141},
    {"sds10_frc_ld",    2142},
    {"sds3_fec_mode",    2143},
    {"sds3_mode_sel",    2144},
    {"sds2_fec_mode",    2145},
    {"sds2_mode_sel",    2146},
    {"sds1_fec_mode",    2147},
    {"sds1_mode_sel",    2148},
    {"sds0_fec_mode",    2149},
    {"sds0_mode_sel",    2150},
    {"sds7_fec_mode",    2151},
    {"sds7_mode_sel",    2152},
    {"sds6_fec_mode",    2153},
    {"sds6_mode_sel",    2154},
    {"sds5_fec_mode",    2155},
    {"sds5_mode_sel",    2156},
    {"sds4_fec_mode",    2157},
    {"sds4_mode_sel",    2158},
    {"sds9_fec_mode",    2159},
    {"sds9_mode_sel",    2160},
    {"sds8_fec_mode",    2161},
    {"sds8_mode_sel",    2162},
    {"sds11_fec_mode",    2163},
    {"sds11_mode_sel",    2164},
    {"sds10_fec_mode",    2165},
    {"sds10_mode_sel",    2166},
    {"sds_regad",    2167},
    {"sds_page",    2168},
    {"sds_index",    2169},
    {"sds_rwop",    2170},
    {"sds_cmd",    2171},
    {"sds_data",    2172},
    {"sds_rtk_oui",    2173},
    {"sds_model_no",    2174},
    {"sds_revision_no",    2175},
    {"link_ok_tgxr_s0",    2176},
    {"sds_sdet_out_s0",    2177},
    {"fib100_det_s0",    2178},
    {"fib100_sdet_s0",    2179},
    {"fib_iso_s0",    2180},
    {"rx_sym_err_all_s0",    2181},
    {"rx_sym_err_tgxr_s0",    2182},
    {"intp_tgx_s0",    2183},
    {"intp_tgr_s0",    2184},
    {"iso_on_s0",    2185},
    {"load_sys_par_s0",    2186},
    {"unidir_tx_able_s0",    2187},
    {"sds_tx_disable_s0",    2188},
    {"sds_rx_disable_s0",    2189},
    {"bcst_on_s0",    2190},
    {"intp_src_tgx_s0",    2191},
    {"intp_src_tgr_s0",    2192},
    {"tx_swap_tgx_s0",    2193},
    {"rx_swap_tgx_s0",    2194},
    {"link_ok_tgxr_s4",    2195},
    {"sds_sdet_out_s4",    2196},
    {"fib100_det_s4",    2197},
    {"fib100_sdet_s4",    2198},
    {"fib_iso_s4",    2199},
    {"rx_sym_err_all_s4",    2200},
    {"rx_sym_err_tgxr_s4",    2201},
    {"intp_tgx_s4",    2202},
    {"intp_tgr_s4",    2203},
    {"iso_on_s4",    2204},
    {"load_sys_par_s4",    2205},
    {"unidir_tx_able_s4",    2206},
    {"sds_tx_disable_s4",    2207},
    {"sds_rx_disable_s4",    2208},
    {"bcst_on_s4",    2209},
    {"intp_src_tgx_s4",    2210},
    {"intp_src_tgr_s4",    2211},
    {"tx_swap_tgx_s4",    2212},
    {"rx_swap_tgx_s4",    2213},
    {"sds_sdet_out_s10",    2214},
    {"fib100_det_s10",    2215},
    {"fib100_sdet_s10",    2216},
    {"fib_iso_s10",    2217},
    {"rx_sym_err_all_s10",    2218},
    {"iso_on_s10",    2219},
    {"load_sys_par_s10",    2220},
    {"unidir_tx_able_s10",    2221},
    {"sds_tx_disable_s10",    2222},
    {"sds_rx_disable_s10",    2223},
    {"bcst_on_s10",    2224},
    {"bcst_idx_ws0",    2225},
    {"lpi_gmii_sel_ws0",    2226},
    {"cmd_stop_gli_clk_ws0",    2227},
    {"sts_upd_tx_ws0",    2228},
    {"bcst_idx_ws2",    2229},
    {"lpi_gmii_sel_ws2",    2230},
    {"cmd_stop_gli_clk_ws2",    2231},
    {"sts_upd_tx_ws2",    2232},
    {"lpi_gmii_sel_ws5",    2233},
    {"cmd_stop_gli_clk_ws5",    2234},
    {"sts_upd_tx_ws5",    2235},
    {"sds_link_ok_sum_ws0",    2236},
    {"sds_link_ok_ws0",    2237},
    {"sts_upd_rx_ws0",    2238},
    {"sds_link_ok_sum_ws2",    2239},
    {"sds_link_ok_ws2",    2240},
    {"sts_upd_rx_ws2",    2241},
    {"sds_link_ok_sum_ws5",    2242},
    {"sds_link_ok_ws5",    2243},
    {"sts_upd_rx_ws5",    2244},
    {"rg2x_cen",    2245},
    {"rg1x_cen",    2246},
    {"rtt_dig_cen_l",    2247},
    {"en_rtt2_l",    2248},
    {"en_rtt1_l",    2249},
    {"rg0x_cen",    2250},
    {"s3_usxgmii_submode",    2251},
    {"s2_usxgmii_submode",    2252},
    {"s9_usxgmii_submode",    2253},
    {"s8_usxgmii_submode",    2254},
    {"s7_usxgmii_submode",    2255},
    {"s6_usxgmii_submode",    2256},
    {"s5_usxgmii_submode",    2257},
    {"s4_usxgmii_submode",    2258},
    {"low_q_thr",    2259},
    {"high_q",    2260},
    {"tx_lpi_minipg_gelite",    2261},
    {"tx_lpi_minipg_fe",    2262},
    {"tx_lpi_minipg_10g",    2263},
    {"tx_lpi_minipg_ge",    2264},
    {"tx_lpi_minipg_5g",    2265},
    {"tx_lpi_minipg_2p5g",    2266},
    {"multiwake_ports",    2267},
    {"multiwake_intlv",    2268},
    {"multiwake_time_unit",    2269},
    {"multiwake_en",    2270},
    {"link_up_delay",    2271},
    {"en_fc_efct",    2272},
    {"ref_rxlpi",    2273},
    {"tx_wake_sel",    2274},
    {"low_q_tx_delay_fe",    2275},
    {"tx_wake_timer_fe",    2276},
    {"low_q_tx_delay_gelite",    2277},
    {"tx_pause_wake_timer_gelite",    2278},
    {"tx_wake_timer_gelite",    2279},
    {"low_q_tx_delay_ge",    2280},
    {"tx_pause_wake_timer_ge",    2281},
    {"tx_wake_timer_ge",    2282},
    {"low_q_tx_delay_2p5g",    2283},
    {"tx_pause_wake_timer_2p5g",    2284},
    {"tx_wake_timer_2p5g",    2285},
    {"low_q_tx_delay_5g",    2286},
    {"tx_pause_wake_timer_5g",    2287},
    {"tx_wake_timer_5g",    2288},
    {"low_q_tx_delay_10g",    2289},
    {"tx_pause_wake_timer_10g",    2290},
    {"tx_wake_timer_10g",    2291},
    {"eee_tx_en",    2292},
    {"eee_rx_en",    2293},
    {"wait_rx_inactive_gelite",    2294},
    {"wait_rx_inactive_timer_gelite",    2295},
    {"wait_rx_inactive_ge",    2296},
    {"wait_rx_inactive_timer_ge",    2297},
    {"wait_rx_inactive_2p5g",    2298},
    {"wait_rx_inactive_timer_2p5g",    2299},
    {"wait_rx_inactive_5g",    2300},
    {"wait_rx_inactive_timer_5g",    2301},
    {"wait_rx_inactive_10g",    2302},
    {"wait_rx_inactive_timer_10g",    2303},
    {"eee_eeep_rx_sts",    2304},
    {"eee_eeep_tx_sts",    2305},
    {"eeep_1000m_en",    2306},
    {"eeep_500m_en",    2307},
    {"eeep_100m_en",    2308},
    {"eeep_tx_en",    2309},
    {"eeep_rx_en",    2310},
    {"eeep_slave_en",    2311},
    {"timer_unit_giga",    2312},
    {"timer_unit_500m",    2313},
    {"timer_unit_100m",    2314},
    {"tx_rate_thr_100m",    2315},
    {"tx_rate_timer_100m",    2316},
    {"tx_rate_en_100m",    2317},
    {"tx_rate_thr_500m",    2318},
    {"tx_rate_timer_500m",    2319},
    {"tx_rate_en_500m",    2320},
    {"tx_rate_thr_giga",    2321},
    {"tx_rate_timer_giga",    2322},
    {"tx_rate_en_giga",    2323},
    {"tx_wake_timer_giga",    2324},
    {"tx_wake_timer_500m",    2325},
    {"tx_wake_timer_100m",    2326},
    {"rx_rate_thr_100m",    2327},
    {"rx_rate_timer_100m",    2328},
    {"rx_rate_thr_500m",    2329},
    {"rx_rate_timer_500m",    2330},
    {"rx_rate_thr_giga",    2331},
    {"rx_rate_timer_giga",    2332},
    {"rx_sleep_step_max",    2333},
    {"rx_wake_timer_100m",    2334},
    {"rx_min_sleep_timer_100m",    2335},
    {"rx_sleep_timer_100m",    2336},
    {"rx_pause_on_timer_100m",    2337},
    {"rx_wake_timer_500m_master",    2338},
    {"rx_min_sleep_timer_500m",    2339},
    {"rx_sleep_timer_500m",    2340},
    {"rx_pause_on_timer_500m",    2341},
    {"rx_wake_timer_500m_slave",    2342},
    {"rx_wake_timer_giga_master",    2343},
    {"rx_min_sleep_timer_giga",    2344},
    {"rx_sleep_timer_giga",    2345},
    {"rx_pause_on_timer_giga",    2346},
    {"rx_wake_timer_giga_slave",    2347},
    {"rx_idle_timer_giga",    2348},
    {"rx_idle_timer_500m",    2349},
    {"rx_idle_timer_100m",    2350},
    {"tx_idle_timer_giga",    2351},
    {"tx_idle_timer_500m",    2352},
    {"tx_idle_timer_100m",    2353},
    {"allport_mask",    2354},
    {"mac_gatclk_en",    2355},
    {"ale_gatclk_en",    2356},
    {"pkt_encap_gatclk_en",    2357},
    {"pkt_prs_gatclk_en",    2358},
    {"egr_ctrl_gatclk_en",    2359},
    {"igr_ctrl_gatclk_en",    2360},
    {"lnkdn_clk_gate_flag",    2361},
    {"sysclk_gate_mxdly",    2362},
    {"soc_sleep",    2363},
    {"otpid",    2364},
    {"itpid",    2365},
    {"etpid",    2366},
    {"itpid_cmp_msk",    2367},
    {"otpid_cmp_msk",    2368},
    {"etpid_cmp",    2369},
    {"otag_untag_accept",    2370},
    {"otag_accept",    2371},
    {"itag_untag_accept",    2372},
    {"itag_accept",    2373},
    {"mc_svl_fid",    2374},
    {"uc_svl_fid",    2375},
    {"stp_leak_en",    2376},
    {"leak_en",    2377},
    {"ocfi_act",    2378},
    {"icfi_act",    2379},
    {"opvid",    2380},
    {"opvid_fmt",    2381},
    {"ipvid",    2382},
    {"ipvid_fmt",    2383},
    {"dbl_tag",    2384},
    {"otag",    2385},
    {"itag",    2386},
    {"untag",    2387},
    {"arp_rep_act",    2388},
    {"arp_req_act",    2389},
    {"dhcp6_act",    2390},
    {"dhcp_act",    2391},
    {"mld_act",    2392},
    {"igmp_act",    2393},
    {"igr_fltr_act",    2394},
    {"egr_fltr_en",    2395},
    {"egr_otag_sts",    2396},
    {"egr_itag_sts",    2397},
    {"egr_otag_keep",    2398},
    {"egr_itag_keep",    2399},
    {"igr_otag_keep",    2400},
    {"igr_itag_keep",    2401},
    {"otpid_idx",    2402},
    {"otpid_keep",    2403},
    {"itpid_idx",    2404},
    {"itpid_keep",    2405},
    {"router_smac_sel",    2406},
    {"smac_47_32",    2407},
    {"l2_lrn_en",    2408},
    {"l2_new_sa_act",    2409},
    {"ip4_uc_rt_en",    2410},
    {"ip6_uc_rt_en",    2411},
    {"ip4_mc_bdg_mode",    2412},
    {"ip6_mc_bdg_mode",    2413},
    {"ip4_mc_rt_en",    2414},
    {"ip6_mc_rt_en",    2415},
    {"ip4_urpf_chk_en",    2416},
    {"ip4_urpf_dflt_route_en",    2417},
    {"ip4_urpf_chk_mode",    2418},
    {"ip4_urpf_fail_act",    2419},
    {"ip6_urpf_chk_en",    2420},
    {"ip6_urpf_dflt_route_en",    2421},
    {"ip6_urpf_chk_mode",    2422},
    {"ip6_urpf_fail_act",    2423},
    {"ip4_mc_act_224_0_0",    2424},
    {"ip4_mc_act_224_0_1",    2425},
    {"ip4_mc_act_239_0_0",    2426},
    {"ip6_mc_act_0_x",    2427},
    {"ip6_act_0_x_x",    2428},
    {"ip6_act_db8_x_x",    2429},
    {"ip6_nd_act",    2430},
    {"l2_mc_bdg_lu_mis_act",    2431},
    {"ip4_mc_l2bdg_lu_mis_act",    2432},
    {"ip6_mc_l2bdg_lu_mis_act",    2433},
    {"l2_unkn_mc_fld_pmsk",    2434},
    {"ip4_unkn_mc_fld_pmsk",    2435},
    {"ip6_unkn_mc_fld_pmsk",    2436},
    {"frame_type",    2437},
    {"frame_type_value",    2438},
    {"vlan_type",    2439},
    {"pri_as",    2440},
    {"pri",    2441},
    {"vid_as",    2442},
    {"upper",    2443},
    {"lower",    2444},
    {"mode",    2445},
    {"pri_tag_act",    2446},
    {"vid_sel",    2447},
    {"cnvt_en",    2448},
    {"vid_range_set_idx",    2449},
    {"ivc_en",    2450},
    {"ip_vlan_en",    2451},
    {"mac_vlan_en",    2452},
    {"otag_lu_mis_drop",    2453},
    {"itag_lu_mis_drop",    2454},
    {"evc_en",    2455},
    {"rma_0f_act",    2456},
    {"rma_0e_act",    2457},
    {"rma_0d_act",    2458},
    {"rma_0c_act",    2459},
    {"rma_0b_act",    2460},
    {"rma_0a_act",    2461},
    {"rma_09_act",    2462},
    {"rma_08_act",    2463},
    {"rma_07_act",    2464},
    {"rma_06_act",    2465},
    {"rma_05_act",    2466},
    {"rma_04_act",    2467},
    {"rma_03_act",    2468},
    {"rma_02_act",    2469},
    {"rma_01_act",    2470},
    {"rma_1f_act",    2471},
    {"rma_1e_act",    2472},
    {"rma_1d_act",    2473},
    {"rma_1c_act",    2474},
    {"rma_1b_act",    2475},
    {"rma_1a_act",    2476},
    {"rma_19_act",    2477},
    {"rma_18_act",    2478},
    {"rma_17_act",    2479},
    {"rma_16_act",    2480},
    {"rma_15_act",    2481},
    {"rma_14_act",    2482},
    {"rma_13_act",    2483},
    {"rma_12_act",    2484},
    {"rma_11_act",    2485},
    {"rma_10_act",    2486},
    {"rma_2f_act",    2487},
    {"rma_2e_act",    2488},
    {"rma_2d_act",    2489},
    {"rma_2c_act",    2490},
    {"rma_2b_act",    2491},
    {"rma_2a_act",    2492},
    {"rma_29_act",    2493},
    {"rma_28_act",    2494},
    {"rma_27_act",    2495},
    {"rma_26_act",    2496},
    {"rma_25_act",    2497},
    {"rma_24_act",    2498},
    {"rma_23_act",    2499},
    {"rma_22_act",    2500},
    {"rma_21_act",    2501},
    {"rma_20_act",    2502},
    {"mirror_act",    2503},
    {"lrn",    2504},
    {"ptp_lrn",    2505},
    {"lldp_lrn",    2506},
    {"eapol_lrn",    2507},
    {"act",    2508},
    {"udp_act",    2509},
    {"eth2_act",    2510},
    {"pmsk",    2511},
    {"addr_max_hi",    2512},
    {"addr_max_lo",    2513},
    {"addr_min_hi",    2514},
    {"addr_min_lo",    2515},
    {"ether_type",    2516},
    {"bypass_vlan",    2517},
    {"bypass_stp",    2518},
    {"en",    2519},
    {"trk_valid",    2520},
    {"trk_id",    2521},
    {"trk_ppm_28_0",    2522},
    {"l3_hash_msk",    2523},
    {"l2_hash_msk",    2524},
    {"link_down_avoid",    2525},
    {"congst_avoid",    2526},
    {"local_first",    2527},
    {"stk_hash_cal",    2528},
    {"trk_stand_alone_mode",    2529},
    {"sep_port_sel",    2530},
    {"shift_bits_flow_label",    2531},
    {"shift_bits_proto",    2532},
    {"shift_bits_l4dport",    2533},
    {"shift_bits_l4sport",    2534},
    {"shift_bits_dip",    2535},
    {"shift_bits_sip",    2536},
    {"shift_bits_vlan",    2537},
    {"shift_bits_dmac",    2538},
    {"shift_bits_smac",    2539},
    {"shift_bits_spp",    2540},
    {"trk_local_tbl_refresh",    2541},
    {"num_tx_candi",    2542},
    {"l2_hash_msk_idx",    2543},
    {"ip4_hash_msk_idx",    2544},
    {"ip6_hash_msk_idx",    2545},
    {"sep_dlf_bcast_en",    2546},
    {"sep_kwn_mc_en",    2547},
    {"trk_port7",    2548},
    {"trk_port6",    2549},
    {"trk_port5",    2550},
    {"trk_port4",    2551},
    {"trk_port3",    2552},
    {"trk_port2",    2553},
    {"trk_port1",    2554},
    {"trk_port0",    2555},
    {"stk_trk_ppm",    2556},
    {"is_trk_mbr",    2557},
    {"msti_mode",    2558},
    {"restrict_route",    2559},
    {"vb_iso_mbr",    2560},
    {"vid_upper",    2561},
    {"vid_lower",    2562},
    {"valid",    2563},
    {"vb_iso_egr_bypass",    2564},
    {"l2_stt_mv_ref",    2565},
    {"lutcam_en",    2566},
    {"stk_auto_lrn",    2567},
    {"hash_full_act",    2568},
    {"link_down_p_invld",    2569},
    {"mc_bc_sa_act",    2570},
    {"zero_sa_act",    2571},
    {"zero_sa_lrn",    2572},
    {"l2_hash_algo_blk1",    2573},
    {"l2_hash_algo_blk0",    2574},
    {"keep_age_out_entry_valid",    2575},
    {"sus_age_max",    2576},
    {"fast_age_out",    2577},
    {"age_unit",    2578},
    {"age_en",    2579},
    {"salrn",    2580},
    {"new_sa_fwd",    2581},
    {"forbid_act",    2582},
    {"portmask",    2583},
    {"constrt_num",    2584},
    {"lrn_cnt",    2585},
    {"fvid",    2586},
    {"port_id",    2587},
    {"below_zero_flag",    2588},
    {"sts",    2589},
    {"fvid_cmp",    2590},
    {"agg_vid_cmp",    2591},
    {"port_cmp",    2592},
    {"entry_type",    2593},
    {"agg_vid",    2594},
    {"replacing_port_id",    2595},
    {"src_fltr_en",    2596},
    {"src",    2597},
    {"cnt",    2598},
    {"ntfy_type",    2599},
    {"hashfull_ntfy_en",    2600},
    {"ld_flush_ntfy_en",    2601},
    {"tagsts_ntfy_en",    2602},
    {"sus_ntfy_en",    2603},
    {"dasablk_ntfy_en",    2604},
    {"sttc_ntfy_en",    2605},
    {"dyn_ntfy_en",    2606},
    {"bp_thr",    2607},
    {"fifo_empty",    2608},
    {"ntfy_en",    2609},
    {"min_len",    2610},
    {"max_event",    2611},
    {"timeout",    2612},
    {"dmac_hi",    2613},
    {"dmac_lo",    2614},
    {"smac_hi",    2615},
    {"smac_lo",    2616},
    {"itagif",    2617},
    {"rst",    2618},
    {"num",    2619},
    {"on",    2620},
    {"off",    2621},
    {"remote_back_press",    2622},
    {"state",    2623},
    {"base_addr",    2624},
    {"cur_addr",    2625},
    {"ntfy_done",    2626},
    {"ntfy_buf_run_out",    2627},
    {"local_ntfy_buf_run_out",    2628},
    {"cfg_l2msg_tmrout_spdup",    2629},
    {"cfg_l2msg_tmrout_en",    2630},
    {"cfg_l2msg_tmrout_sel",    2631},
    {"cfg_l2msg_cnt_sel",    2632},
    {"cfg_frc_rx_ready_f",    2633},
    {"cfg_frc_tx_ready_f",    2634},
    {"cfg_rdma_cnt_sel",    2635},
    {"dis_port_mask",    2636},
    {"inc_bypass_pkt",    2637},
    {"inc_ifg",    2638},
    {"arp_vlan_constrt",    2639},
    {"dhcp_vlan_constrt",    2640},
    {"admit_rip",    2641},
    {"admit_dhcp",    2642},
    {"admit_arpreq",    2643},
    {"admit_rma",    2644},
    {"admit_bpdu",    2645},
    {"admit_rtkpkt",    2646},
    {"admit_igmp",    2647},
    {"tick",    2648},
    {"tkn",    2649},
    {"rate",    2650},
    {"burst",    2651},
    {"flag",    2652},
    {"bw_en",    2653},
    {"high_on",    2654},
    {"high_off",    2655},
    {"assured_dis_encap_feed_back",    2656},
    {"encap_cpu_tag_feed_back",    2657},
    {"rate_mode_cpu",    2658},
    {"p25_in_sxg_mode",    2659},
    {"p24_in_sxg_mode",    2660},
    {"stric_wfq_jumbo",    2661},
    {"spd_up_refill",    2662},
    {"amp_factor",    2663},
    {"srtcm_smart_tkn",    2664},
    {"lb_exceed",    2665},
    {"cnt_meter_idx",    2666},
    {"unit",    2667},
    {"cntr_clr",    2668},
    {"green_cntr",    2669},
    {"yellow_cntr",    2670},
    {"red_cntr",    2671},
    {"total_cntr",    2672},
    {"jumbo_frame_cnt",    2673},
    {"precise_drop_all_en",    2674},
    {"guar_page_en",    2675},
    {"allow_page_cnt",    2676},
    {"thr",    2677},
    {"drop_all",    2678},
    {"pkt_len",    2679},
    {"sys_used_page_thr",    2680},
    {"idx",    2681},
    {"ref_rxcngst",    2682},
    {"hol_prvnt_en",    2683},
    {"bc_en",    2684},
    {"l2_mc_en",    2685},
    {"ip_mc_en",    2686},
    {"unkn_uc_en",    2687},
    {"force_drop_en",    2688},
    {"glb_page_cnt",    2689},
    {"p_page_cnt",    2690},
    {"glb_page_peakcnt",    2691},
    {"glb_page_curcnt",    2692},
    {"p_page_peakcnt",    2693},
    {"q_page_peakcnt",    2694},
    {"q_page_cnt",    2695},
    {"q_pkt_peakcnt",    2696},
    {"q_pkt_cnt",    2697},
    {"lb_page_peakcnt",    2698},
    {"lb_page_cnt",    2699},
    {"lb_pkt_peakcnt",    2700},
    {"lb_pkt_cnt",    2701},
    {"weight",    2702},
    {"q_id",    2703},
    {"hsm_peakcnt",    2704},
    {"hsm_cnt",    2705},
    {"hsa_peakcnt",    2706},
    {"hsa_cnt",    2707},
    {"sw_sync_remote_p_fc",    2708},
    {"nrm_port_ete_fc_en",    2709},
    {"cascade_portmask",    2710},
    {"dmac_47_32",    2711},
    {"dmac_31_0",    2712},
    {"drop_type_sel",    2713},
    {"max",    2714},
    {"min",    2715},
    {"port_idx_grp",    2716},
    {"color_idx_grp",    2717},
    {"drop_cntr_grp",    2718},
    {"drain_out_thr_h",    2719},
    {"drain_out_thr",    2720},
    {"cngst_tmr_h",    2721},
    {"cngst_sust_tmr_lmt_h",    2722},
    {"cngst_tmr",    2723},
    {"cngst_sust_tmr_lmt",    2724},
    {"port_pri_remap_en",    2725},
    {"proto_vlan_pri_remap_en",    2726},
    {"mac_ip_vlan_pri_remap_en",    2727},
    {"dscp_invld_en",    2728},
    {"dscp_invld_val",    2729},
    {"port_pri_remap_tbl_sel",    2730},
    {"intpri_port",    2731},
    {"intpri_cfi0_ipri",    2732},
    {"intpri_cfi1_ipri",    2733},
    {"intpri_dei0_opri",    2734},
    {"intpri_dei1_opri",    2735},
    {"intpri_dscp",    2736},
    {"pri_sel_tb_idx",    2737},
    {"wt_rout",    2738},
    {"wt_proto_vlan",    2739},
    {"wt_mac_vlan",    2740},
    {"wt_otag",    2741},
    {"wt_itag",    2742},
    {"wt_dscp",    2743},
    {"wt_vacl",    2744},
    {"wt_port",    2745},
    {"dp_cfi0_ipri",    2746},
    {"dp_cfi1_ipri",    2747},
    {"dp_dei0_ipri",    2748},
    {"dp_dei1_ipri",    2749},
    {"dp_dscp",    2750},
    {"qid",    2751},
    {"cpu2cpu_talk",    2752},
    {"oampdu",    2753},
    {"l3_ipuc_rpf",    2754},
    {"inn_outer_cfi_eql_1",    2755},
    {"ivc",    2756},
    {"igr_vlan_fltr",    2757},
    {"l2_uc_mc_bridge_lu_miss",    2758},
    {"ip4_ip6_bridge_lu_miss",    2759},
    {"ptp",    2760},
    {"rma_usr_def_0",    2761},
    {"rma_usr_def_1",    2762},
    {"rma_usr_def_2",    2763},
    {"rma_usr_def_3",    2764},
    {"rma_bpdu",    2765},
    {"rma_lacp",    2766},
    {"rma_lldp",    2767},
    {"rma_eapol",    2768},
    {"rma_xx",    2769},
    {"router_mac_if",    2770},
    {"l3_ipuc_non_ip_pkt",    2771},
    {"ip4_ip6_hdr_err",    2772},
    {"routing_ip_chk",    2773},
    {"l3_routing_dip_dmac_mismatch",    2774},
    {"ip6_uc_mc_hop_by_hop",    2775},
    {"ip6_uc_mc_routing_hdr",    2776},
    {"ip4_ip_opt",    2777},
    {"ip4_ip6_mc_routing_lu_miss",    2778},
    {"l3_ipuc_null_route",    2779},
    {"l3_ipuc_pbr_null_route",    2780},
    {"l3_uc_host_route",    2781},
    {"l3_uc_net_route",    2782},
    {"l3_mc_bridge_entry",    2783},
    {"l3_mc_route_entry",    2784},
    {"l3_ipmc_rpf",    2785},
    {"routing_excpt_nh_age_out_act",    2786},
    {"ip4_ip6_icmp_redrt",    2787},
    {"ipuc_mtu",    2788},
    {"ipmc_mtu",    2789},
    {"ipuc_ttl",    2790},
    {"ipmc_ttl",    2791},
    {"igmp_mld",    2792},
    {"dhcp_dhcp6",    2793},
    {"arp_req_rep",    2794},
    {"neighbor_discover",    2795},
    {"ip4_ip6_reserve_addr",    2796},
    {"rldp_rlpp",    2797},
    {"l2_ntfy",    2798},
    {"normal_fwd",    2799},
    {"mac_cst",    2800},
    {"new_sa",    2801},
    {"pmv_forbid",    2802},
    {"l2_sttc_pmv",    2803},
    {"l2_dyn_pmv",    2804},
    {"hash_full",    2805},
    {"invalid_sa",    2806},
    {"atk_type",    2807},
    {"acl_hit",    2808},
    {"mir_hit",    2809},
    {"l2_err_pkt",    2810},
    {"l3_err_pkt",    2811},
    {"strict_en",    2812},
    {"sched_type",    2813},
    {"force_all_port_second_egr_drop",    2814},
    {"sflow",    2815},
    {"ipri_rmk_src",    2816},
    {"opri_rmk_src",    2817},
    {"dei_rmk_src",    2818},
    {"dscp_rmk_src",    2819},
    {"ipri_dflt_cfg",    2820},
    {"opri_dflt_cfg",    2821},
    {"dei_rmk_tag_sel",    2822},
    {"dei_rmk_en",    2823},
    {"dscp_rmk_en",    2824},
    {"opri_rmk_en",    2825},
    {"ipri_rmk_en",    2826},
    {"ipri",    2827},
    {"opri",    2828},
    {"dei",    2829},
    {"dscp",    2830},
    {"class_non_b_redirect_qid",    2831},
    {"class_non_a_redirect_qid",    2832},
    {"class_non_b_rmk_pri",    2833},
    {"class_non_a_rmk_pri",    2834},
    {"class_b_qid",    2835},
    {"class_a_qid",    2836},
    {"class_b_pri",    2837},
    {"class_a_pri",    2838},
    {"nonip_act",    2839},
    {"urpf_base_sel",    2840},
    {"nh_age_out_act",    2841},
    {"ip_hdr_err_act",    2842},
    {"ip6_hdr_err_act",    2843},
    {"mc_hash_alg_sel_1",    2844},
    {"mc_hash_alg_sel_0",    2845},
    {"uc_hash_alg_sel_1",    2846},
    {"uc_hash_alg_sel_0",    2847},
    {"lu_force_mode_hash_key_sel",    2848},
    {"lu_mode_sel",    2849},
    {"pkt_to_cpu_target",    2850},
    {"ttl_fail_act",    2851},
    {"mtu_fail_act",    2852},
    {"hdr_opt_act",    2853},
    {"dmac_mc_act",    2854},
    {"dmac_bc_act",    2855},
    {"zero_sip_act",    2856},
    {"bad_dip_act",    2857},
    {"bad_sip_act",    2858},
    {"glb_en",    2859},
    {"hl_fail_act",    2860},
    {"hdr_route_act",    2861},
    {"hbh_err_act",    2862},
    {"hbh_act",    2863},
    {"dmac_mismatch_act",    2864},
    {"lu_mis_act",    2865},
    {"src_vlan_fltr_en",    2866},
    {"mtu_val",    2867},
    {"urpf_fail_act",    2868},
    {"urpf_chk_mode",    2869},
    {"urpf_dflt_route_en",    2870},
    {"urpf_chk_en",    2871},
    {"reset",    2872},
    {"cntr_latch",    2873},
    {"l3_entry_cntr_mode",    2874},
    {"l3_entry_idx",    2875},
    {"val_hi",    2876},
    {"val_lo",    2877},
    {"to",    2878},
    {"from",    2879},
    {"len",    2880},
    {"round",    2881},
    {"ipmc_type",    2882},
    {"ip3",    2883},
    {"ip2",    2884},
    {"ip1",    2885},
    {"ip",    2886},
    {"exec_tcam",    2887},
    {"result_tcam",    2888},
    {"entry_idx_tcam",    2889},
    {"rst_mib_val",    2890},
    {"rst_glb_mib",    2891},
    {"rst_port_flag",    2892},
    {"rst_port_mib",    2893},
    {"tx_stack_cnt_hdr",    2894},
    {"rx_stack_cnt_hdr",    2895},
    {"tx_cnt_tag",    2896},
    {"rx_cnt_tag",    2897},
    {"cnt_set1_len_max",    2898},
    {"cnt_set1_len_min",    2899},
    {"cnt_set0_len_max",    2900},
    {"cnt_set0_len_min",    2901},
    {"dot1dtplearnedentrydiscards",    2902},
    {"ifinoctets_h",    2903},
    {"ifinoctets_l",    2904},
    {"ifoutoctets_h",    2905},
    {"ifoutoctets_l",    2906},
    {"ifinucastpkts_h",    2907},
    {"ifinucastpkts_l",    2908},
    {"ifinmulticastpkts_h",    2909},
    {"ifinmulticastpkts_l",    2910},
    {"ifinbroadcastpkts_h",    2911},
    {"ifinbroadcastpkts_l",    2912},
    {"ifoutucastpkts_h",    2913},
    {"ifoutucastpkts_l",    2914},
    {"ifoutmulticastpkts_h",    2915},
    {"ifoutmulticastpkts_l",    2916},
    {"ifoutbroadcastpkts_h",    2917},
    {"ifoutbroadcastpkts_l",    2918},
    {"ifoutdiscards",    2919},
    {"dot1dtpportindiscards",    2920},
    {"dot3statssinglecollisionframes",    2921},
    {"dot3statsmultiplecollisionframes",    2922},
    {"dot3statsdeferredtransmissions",    2923},
    {"dot3statslatecollisions",    2924},
    {"dot3statsexcessivecollisions",    2925},
    {"dot3statssymbolerrors",    2926},
    {"dot3controlinunknownopcodes",    2927},
    {"dot3inpauseframes",    2928},
    {"dot3outpauseframes",    2929},
    {"etherstatsdropevents",    2930},
    {"tx_etherstatsbroadcastpkts",    2931},
    {"tx_etherstatsmulticastpkts",    2932},
    {"tx_etherstatscrcalignerrors",    2933},
    {"rx_etherstatscrcalignerrors",    2934},
    {"tx_etherstatsundersizepkts",    2935},
    {"rx_etherstatsundersizepkts",    2936},
    {"tx_etherstatsoversizepkts",    2937},
    {"rx_etherstatsoversizepkts",    2938},
    {"tx_etherstatsfragments",    2939},
    {"rx_etherstatsfragments",    2940},
    {"tx_etherstatsjabbers",    2941},
    {"rx_etherstatsjabbers",    2942},
    {"tx_etherstatscollisions",    2943},
    {"tx_etherstatspkts64octets",    2944},
    {"rx_etherstatspkts64octets",    2945},
    {"tx_etherstatspkts65to127octets",    2946},
    {"rx_etherstatspkts65to127octets",    2947},
    {"tx_etherstatspkts128to255octets",    2948},
    {"rx_etherstatspkts128to255octets",    2949},
    {"tx_etherstatspkts256to511octets",    2950},
    {"rx_etherstatspkts256to511octets",    2951},
    {"tx_etherstatspkts512to1023octets",    2952},
    {"rx_etherstatspkts512to1023octets",    2953},
    {"tx_etherstatspkts1024to1518octets",    2954},
    {"rx_etherstatspkts1024to1518octets",    2955},
    {"rx_etherstatsundersizedroppktsrt",    2956},
    {"tx_etherstatspkts1519tomaxoctetsrt",    2957},
    {"rx_etherstatspkts1519tomaxoctetsrt",    2958},
    {"tx_etherstatspktsovermaxoctetsrt",    2959},
    {"rx_etherstatspktsovermaxoctetsrt",    2960},
    {"tx_etherstatspktsflexibleoctetsset1rt",    2961},
    {"rx_etherstatspktsflexibleoctetsset1rt",    2962},
    {"tx_etherstatspktsflexibleoctetscrcset1rt",    2963},
    {"rx_etherstatspktsflexibleoctetscrcset1rt",    2964},
    {"tx_etherstatspktsflexibleoctetsset0rt",    2965},
    {"rx_etherstatspktsflexibleoctetsset0rt",    2966},
    {"tx_etherstatspktsflexibleoctetscrset0crt",    2967},
    {"rx_etherstatspktsflexibleoctetscrset0crt",    2968},
    {"lengthfielderrorrt",    2969},
    {"falsecarriertimesrt",    2970},
    {"undersizeoctetsrt",    2971},
    {"framingerrorsrt",    2972},
    {"parsererrorsrt",    2973},
    {"rxmacdiscardsrt",    2974},
    {"rxmacipgshortdroprt",    2975},
    {"rst_flag",    2976},
    {"rst_port_idx",    2977},
    {"egrqueuedroppktrt",    2978},
    {"reason",    2979},
    {"mtp_port",    2980},
    {"mtp_is_trk",    2981},
    {"traffic_sel",    2982},
    {"mtp_tx_iso",    2983},
    {"mir_mode",    2984},
    {"mir_rx_tx_sel",    2985},
    {"mtp_self_flter",    2986},
    {"mir_op",    2987},
    {"mir_type",    2988},
    {"spm_28_0",    2989},
    {"dpm_28_0",    2990},
    {"sample_rate",    2991},
    {"mir_qid",    2992},
    {"mir_qid_en",    2993},
    {"rspan_tag_tpid",    2994},
    {"rspan_tag_pri",    2995},
    {"rspan_tag_cfi",    2996},
    {"rspan_tag_vid",    2997},
    {"rspan_tx_tag_add",    2998},
    {"rspan_rx_tag_rm",    2999},
    {"smpl_sel",    3000},
    {"egr_rate",    3001},
    {"igr_rate",    3002},
    {"lookup_en",    3003},
    {"phase",    3004},
    {"tmplte_field",    3005},
    {"grp_id",    3006},
    {"logic_id",    3007},
    {"blk_tmplte2",    3008},
    {"blk_tmplte1",    3009},
    {"mv_to",    3010},
    {"mv_from",    3011},
    {"mv",    3012},
    {"mv_len",    3013},
    {"clr_to",    3014},
    {"clr_from",    3015},
    {"clr",    3016},
    {"rule_indication",    3017},
    {"glb_indication",    3018},
    {"dp_sel",    3019},
    {"arp_mac_ctrl",    3020},
    {"v_tmplte0_iotag_fmt",    3021},
    {"v_tmplte1_iotag_fmt",    3022},
    {"v_tmplte2_iotag_fmt",    3023},
    {"v_tmplte3_iotag_fmt",    3024},
    {"v_tmplte4_iotag_fmt",    3025},
    {"v_tmplte5_iotag_fmt",    3026},
    {"v_tmplte6_iotag_fmt",    3027},
    {"v_tmplte7_iotag_fmt",    3028},
    {"v_tmplte8_iotag_fmt",    3029},
    {"v_tmplte9_iotag_fmt",    3030},
    {"v_tmplte0_iotag_sel",    3031},
    {"v_tmplte1_iotag_sel",    3032},
    {"v_tmplte2_iotag_sel",    3033},
    {"v_tmplte4_iotag_sel",    3034},
    {"i_tmplte0_iotag_sel",    3035},
    {"i_tmplte1_iotag_sel",    3036},
    {"i_tmplte2_iotag_sel",    3037},
    {"i_tmplte4_iotag_sel",    3038},
    {"lb_limit",    3039},
    {"lb_en",    3040},
    {"ip_upper",    3041},
    {"ip_lower",    3042},
    {"invalid_len",    3043},
    {"tcp_frag_off_min",    3044},
    {"syn_rst",    3045},
    {"syn_fin",    3046},
    {"xmas",    3047},
    {"null_scan",    3048},
    {"syn_sport_less_1024",    3049},
    {"tcp_hdr_len_min",    3050},
    {"smurf",    3051},
    {"icmpv6_ping_max",    3052},
    {"icmpv4_ping_max",    3053},
    {"icmp_frag_pkt",    3054},
    {"ipv6_frag_len_min",    3055},
    {"pod",    3056},
    {"tcp_blat",    3057},
    {"udp_blat",    3058},
    {"land",    3059},
    {"da_equal_sa",    3060},
    {"frag_len_min",    3061},
    {"pkt_len_max",    3062},
    {"hdr_len_min",    3063},
    {"netmask",    3064},
    {"arp_invld",    3065},
    {"ipv4_invld",    3066},
    {"tcp_hdr_min",    3067},
    {"mac_swap",    3068},
    {"dis_act",    3069},
    {"par_act",    3070},
    {"mux_act",    3071},
    {"dying_gasp_pktcnt",    3072},
    {"dying_gasp_trig",    3073},
    {"tbp_val",    3074},
    {"port_oam_dying_gasp_en",    3075},
    {"dygasp_polarity",    3076},
    {"rldp_rlpp_trap",    3077},
    {"drop_my_unit",    3078},
    {"stk_port_sel",    3079},
    {"my_unit_id",    3080},
    {"master_unit_id",    3081},
    {"unit_port_map",    3082},
    {"non_unicast_block_pm",    3083},
    {"cascade_slave_mode",    3084},
    {"cascade_master_id",    3085},
    {"one_hop_redir_pm",    3086},
    {"stk_port_debug",    3087},
    {"offset",    3088},
    {"fmt",    3089},
    {"pppoe_parse_en",    3090},
    {"rfc1042_oui_ignore",    3091},
    {"page_cnt",    3092},
    {"lst_dsc",    3093},
    {"fst_dsc",    3094},
    {"lbhdr_vld",    3095},
    {"sthdr_vld",    3096},
    {"sthdr_0_3",    3097},
    {"sthdr_4_7",    3098},
    {"sthdr_8_11",    3099},
    {"sthdr_12_15",    3100},
    {"sthdr_16",    3101},
    {"fs11_data",    3102},
    {"fs10_data",    3103},
    {"fs9_data",    3104},
    {"fs8_data",    3105},
    {"fs7_data",    3106},
    {"fs6_data",    3107},
    {"fs5_data",    3108},
    {"fs4_data",    3109},
    {"fs3_data",    3110},
    {"fs2_data",    3111},
    {"fs1_data",    3112},
    {"fs0_data",    3113},
    {"fs_valid",    3114},
    {"flow_label",    3115},
    {"igr_err",    3116},
    {"udp_ptp",    3117},
    {"l2_ptp",    3118},
    {"dsap_ssap",    3119},
    {"arp_opcode",    3120},
    {"target_mac_47_16",    3121},
    {"target_mac_15_0",    3122},
    {"sender_mac_47_32",    3123},
    {"sender_mac_31_0",    3124},
    {"dport",    3125},
    {"sport",    3126},
    {"tcp_flag",    3127},
    {"ip_ttl",    3128},
    {"ip_tos",    3129},
    {"ip_protocol",    3130},
    {"ip_ver",    3131},
    {"ip_flag",    3132},
    {"ip_offset",    3133},
    {"dip",    3134},
    {"sip",    3135},
    {"otag_content",    3136},
    {"itag_content",    3137},
    {"typelen",    3138},
    {"ip_length",    3139},
    {"smac_47_16",    3140},
    {"smac_15_0",    3141},
    {"ipv4_hdrlen",    3142},
    {"tcp_sn_eq_0",    3143},
    {"ipv6_hop",    3144},
    {"ipv6_rout",    3145},
    {"ipv6_frag",    3146},
    {"ipv6_dest",    3147},
    {"ipv6_auth",    3148},
    {"ipv4_chksum_ok",    3149},
    {"ipv6_ext_long",    3150},
    {"ipv6_pkt",    3151},
    {"ipv4_pkt",    3152},
    {"rtag_type",    3153},
    {"rtag_exist",    3154},
    {"etag_exist",    3155},
    {"ctag_exist",    3156},
    {"otag_exist",    3157},
    {"itag_exist",    3158},
    {"oam_pdu",    3159},
    {"llc_other",    3160},
    {"pppoe_pkt",    3161},
    {"rfc_1042",    3162},
    {"spa",    3163},
    {"l4_hdr_chk",    3164},
    {"dmac_15_0",    3165},
    {"ctag_if",    3166},
    {"dmac_47_16",    3167},
    {"sth_vld",    3168},
    {"sphy",    3169},
    {"dp",    3170},
    {"proto_storm_drop",    3171},
    {"byp_igr_bwctrl",    3172},
    {"st_ctag_if",    3173},
    {"st_sa_lrn",    3174},
    {"dp_info",    3175},
    {"dp_fmt",    3176},
    {"fwd_type",    3177},
    {"sp_info",    3178},
    {"rma_act",    3179},
    {"rma_lrn",    3180},
    {"rma_byp_stp",    3181},
    {"ivc_mode",    3182},
    {"ivc_hit",    3183},
    {"ivc_act",    3184},
    {"int_pri_route",    3185},
    {"int_pri",    3186},
    {"org_otag_if",    3187},
    {"org_itag",    3188},
    {"org_itag_if",    3189},
    {"capwap_trap",    3190},
    {"eav_class_a",    3191},
    {"eav_class_b",    3192},
    {"atk_act",    3193},
    {"atk_hit",    3194},
    {"grap_act",    3195},
    {"rma_byp_new_sa_drop",    3196},
    {"rma_pkt",    3197},
    {"acl_act_19_0",    3198},
    {"org_otag",    3199},
    {"acl_act_51_20",    3200},
    {"fwd_base",    3201},
    {"ivc_drop",    3202},
    {"acl_idx",    3203},
    {"igr_ovid",    3204},
    {"fwd_vid",    3205},
    {"msti",    3206},
    {"vlan_group_mask",    3207},
    {"iacl_meter_drop",    3208},
    {"vlan_cfi_act",    3209},
    {"vlan_aft_drop",    3210},
    {"igr_ivid",    3211},
    {"rma_eapol_pkt",    3212},
    {"err_pkt",    3213},
    {"rma_byp_vlan_fltr",    3214},
    {"iacl_metadata",    3215},
    {"iacl_byp_act",    3216},
    {"oam_dis_lrn",    3217},
    {"oam_act",    3218},
    {"igr_stp_status",    3219},
    {"rx_port_in_vlan",    3220},
    {"ucast_hkey",    3221},
    {"mcast_hkey",    3222},
    {"vlan_prof",    3223},
    {"mcmis_act",    3224},
    {"ip_rsv_act",    3225},
    {"rip_if",    3226},
    {"dhcp_if",    3227},
    {"rtag_if",    3228},
    {"rma_rsn",    3229},
    {"rma_usr_pkt",    3230},
    {"rma_lldp_pkt",    3231},
    {"igr_vlan_mbr",    3232},
    {"route_act_31_0",    3233},
    {"route_act_61_32",    3234},
    {"nd_pkt_if",    3235},
    {"st_rt_if",    3236},
    {"lut_hash_addr1",    3237},
    {"lut_hash_addr0",    3238},
    {"spcl_act",    3239},
    {"acl_act_20_0",    3240},
    {"acl_act_51_21",    3241},
    {"l2_sa_hit",    3242},
    {"l2_sa_entry",    3243},
    {"l2_da_hit",    3244},
    {"l2_da_entry",    3245},
    {"mac_limit_vlan_act",    3246},
    {"mac_limit_act",    3247},
    {"l3_da_idx",    3248},
    {"hash_type",    3249},
    {"da_type",    3250},
    {"new_sa_act",    3251},
    {"sttc_pm_act",    3252},
    {"is_mcast_sa",    3253},
    {"igr_vlan_fltr_act",    3254},
    {"dpm",    3255},
    {"nexthop_if",    3256},
    {"nexthop_ageout",    3257},
    {"ctag_flag",    3258},
    {"org_spa",    3259},
    {"forbid_pm_act",    3260},
    {"dyn_pm_act",    3261},
    {"src_port_fltr_en",    3262},
    {"l2_hash_full_act",    3263},
    {"uc_to_stk",    3264},
    {"port_mv",    3265},
    {"route_act_41_32",    3266},
    {"trk_hit_idx",    3267},
    {"trk_uc",    3268},
    {"hol_prvnt",    3269},
    {"ipv6_mld",    3270},
    {"ipv4_igmp",    3271},
    {"rfc1042",    3272},
    {"arp_pkt",    3273},
    {"rtk_pkt",    3274},
    {"rldp_rlpp_pkt",    3275},
    {"eth",    3276},
    {"rma_bpdu_pkt",    3277},
    {"da_bcast",    3278},
    {"da_mcast",    3279},
    {"sa_zero",    3280},
    {"l2_sa_block",    3281},
    {"vlan_sp_fltr_act",    3282},
    {"trk_hash_1",    3283},
    {"unkn_trk_hash_0",    3284},
    {"unkn_trk_hash_1",    3285},
    {"hash_uc",    3286},
    {"hash_idx",    3287},
    {"acl_cpu_fmt",    3288},
    {"acl_redi",    3289},
    {"ivc_iacl_itag_status_as",    3290},
    {"ivc_iacl_otag_status_as",    3291},
    {"ivc_iacl_ipri_as",    3292},
    {"ivc_iacl_opri_as",    3293},
    {"ivc_itpid_as",    3294},
    {"ivc_otpid_as",    3295},
    {"egr_itag_status",    3296},
    {"egr_otag_status",    3297},
    {"egr_ipri",    3298},
    {"egr_opri",    3299},
    {"int_icfi",    3300},
    {"int_ocfi",    3301},
    {"egr_itpid_idx",    3302},
    {"egr_otpid_idx",    3303},
    {"trk_hash_0",    3304},
    {"eacl_ovid_as",    3305},
    {"n_1_ovid_as",    3306},
    {"eacl_itag_as",    3307},
    {"eacl_otag_as",    3308},
    {"eacl_ipri_as",    3309},
    {"eacl_opri_as",    3310},
    {"eacl_itpid_as",    3311},
    {"eacl_otpid_as",    3312},
    {"eacl_mir_act",    3313},
    {"eacl_mir_hit",    3314},
    {"eacl_pri_as",    3315},
    {"eacl_qid",    3316},
    {"acl_rmk_val",    3317},
    {"eacl_rmk_hit",    3318},
    {"eacl_ivid_as",    3319},
    {"n_1_ivid_as",    3320},
    {"iacl_qid",    3321},
    {"acl_trap_hit",    3322},
    {"iacl_mir_hit",    3323},
    {"iacl_mir_act",    3324},
    {"mcrt_rpf_asst",    3325},
    {"mcrt_oil_idx",    3326},
    {"orig_fwd_vid",    3327},
    {"l2_da_block",    3328},
    {"eacl_meter_drop",    3329},
    {"storm_lkmis",    3330},
    {"trk_mc_hit",    3331},
    {"acl_redir_copy",    3332},
    {"eacl_disable",    3333},
    {"iacl_drop",    3334},
    {"iacl_drop_act",    3335},
    {"iacl_redir_zero",    3336},
    {"iacl_trap",    3337},
    {"iacl_copy",    3338},
    {"iacl_trap_master",    3339},
    {"eacl_drop",    3340},
    {"eacl_drop_act",    3341},
    {"eacl_redir_zero",    3342},
    {"eacl_trap",    3343},
    {"eacl_copy",    3344},
    {"eacl_trap_master",    3345},
    {"ivc_trap",    3346},
    {"ivc_trap_master",    3347},
    {"ivc_copy",    3348},
    {"ivc_byp_igr_vlan_fltr",    3349},
    {"mir_id",    3350},
    {"trk_hash",    3351},
    {"st_da_hit",    3352},
    {"meta_data",    3353},
    {"acl_lb_act",    3354},
    {"lb_ttl",    3355},
    {"lb_pkt",    3356},
    {"stk_if",    3357},
    {"sp_fltr_en",    3358},
    {"force_pmove",    3359},
    {"ip_rsvd_invert",    3360},
    {"ctx_dpm_27_0",    3361},
    {"ctx_unit_id",    3362},
    {"ctx_dpm_type",    3363},
    {"ctx_dpm_55_28",    3364},
    {"ctx_acl_act",    3365},
    {"ctx_cngst_drop",    3366},
    {"ctx_dg",    3367},
    {"ctx_bp_fltr_egr",    3368},
    {"ctx_bp_stp_egr",    3369},
    {"ctx_bp_vlan_egr",    3370},
    {"ctx_tag_as",    3371},
    {"ctx_l3_act",    3372},
    {"ctx_ori_tag",    3373},
    {"ctx_qid",    3374},
    {"ctx_as_qid",    3375},
    {"ctx_fwd_vid_en",    3376},
    {"ctx_sp_fltr",    3377},
    {"crx_data_31_0",    3378},
    {"crx_data_63_32",    3379},
    {"st_pmsk",    3380},
    {"l3_uc_kn",    3381},
    {"crx_data_79_64",    3382},
    {"ip_route_en",    3383},
    {"l3_ttl_dec",    3384},
    {"l3_da_rep",    3385},
    {"l3_sa_rep",    3386},
    {"l3_sa_idx",    3387},
    {"rt_event",    3388},
    {"ipmc_en",    3389},
    {"ipmc_pkt",    3390},
    {"replicate_ttl_dec",    3391},
    {"replicate_type",    3392},
    {"ipmc_qid",    3393},
    {"replicate_none",    3394},
    {"replicate_fst_cp",    3395},
    {"replicate_lst_cp",    3396},
    {"pppoe_if",    3397},
    {"stk_spa_trk_id",    3398},
    {"stk_spa_is_trk",    3399},
    {"stk_spa",    3400},
    {"stk_sunit",    3401},
    {"org_itag_content",    3402},
    {"etag_if",    3403},
    {"org_otpid_idx",    3404},
    {"org_itpid_idx",    3405},
    {"org_otag_content",    3406},
    {"ttl_dec",    3407},
    {"l2_hash_full",    3408},
    {"routed_pkt",    3409},
    {"cpu_fmt_en",    3410},
    {"cpu_fmt",    3411},
    {"l3_sa_if",    3412},
    {"l3_da_if",    3413},
    {"oam_swap_mac",    3414},
    {"rvid_base",    3415},
    {"ale_itag_content",    3416},
    {"eacl_itag_status_as",    3417},
    {"eacl_otag_status_as",    3418},
    {"iacl_itag_status_as",    3419},
    {"iacl_otag_status_as",    3420},
    {"ale_itag_status",    3421},
    {"ale_otag_status",    3422},
    {"iacl_otpid_as",    3423},
    {"iacl_itpid_as",    3424},
    {"ale_otag_content",    3425},
    {"is_eav_a",    3426},
    {"is_eav_b",    3427},
    {"int_dscp_hit",    3428},
    {"int_dscp",    3429},
    {"iacl_opri_as",    3430},
    {"iacl_ipri_as",    3431},
    {"cpu_tagsts_as",    3432},
    {"l2_org_port",    3433},
    {"l2_org_trk_if",    3434},
    {"ctx_fwd_type",    3435},
    {"sa_lrn",    3436},
    {"l2_mac_cst",    3437},
    {"ctx_dpm_0_27",    3438},
    {"ctx_dpm_28_55",    3439},
    {"ctx_spn",    3440},
    {"ctx_spn_is_trk",    3441},
    {"ctx_sp_fltr_en",    3442},
    {"nor_cpu_sel",    3443},
    {"txqid_cpu",    3444},
    {"da_hit",    3445},
    {"stk_mir",    3446},
    {"mir2_info",    3447},
    {"mir1_info",    3448},
    {"mir0_info",    3449},
    {"mir_normal_fwd",    3450},
    {"dy_gasp",    3451},
    {"dpc",    3452},
    {"stk_cpu_fwd",    3453},
    {"miring_port_3",    3454},
    {"miring_port_2",    3455},
    {"miring_port_1",    3456},
    {"miring_port_0",    3457},
    {"mir3_info",    3458},
    {"sflow_smpl_port",    3459},
    {"sflow_info",    3460},
    {"sflow_nor_fwd",    3461},
    {"stk_nor_fwd",    3462},
    {"dpm_lb",    3463},
    {"txqid_normal_31_0",    3464},
    {"txqid_normal_63_32",    3465},
    {"txqid_stk_port",    3466},
    {"txqid_normal_71_64",    3467},
    {"drop_rsn",    3468},
    {"latch",    3469},
    {"cnt_rst",    3470},
    {"con",    3471},
    {"grp_tx_cmd",    3472},
    {"spg_mode",    3473},
    {"dbg_acc_pkb_en",    3474},
    {"grp_tx_port",    3475},
    {"tx_done_port",    3476},
    {"ipg_len",    3477},
    {"pkt_cnt_high",    3478},
    {"pkt_cnt_low",    3479},
    {"pkt_cnt_dbg_high",    3480},
    {"pkt_cnt_dbg_low",    3481},
    {"bad_crc_en_0",    3482},
    {"stream_da_mod_0",    3483},
    {"stream_sa_mod_0",    3484},
    {"stream_len_type_0",    3485},
    {"stream_content_offset_0",    3486},
    {"stream_content_mod_0",    3487},
    {"stream_pkt_cnt_0",    3488},
    {"stream_len_rng_start_0",    3489},
    {"stream_len_rng_end_0",    3490},
    {"stream_da_repeat_cnt_0",    3491},
    {"stream_sa_repeat_cnt_0",    3492},
    {"stream_repeat_content_0",    3493},
    {"bad_crc_en_1",    3494},
    {"stream_da_mod_1",    3495},
    {"stream_sa_mod_1",    3496},
    {"stream_len_type_1",    3497},
    {"stream_content_offset_1",    3498},
    {"stream_content_mod_1",    3499},
    {"stream_pkt_cnt_1",    3500},
    {"stream_len_rng_start_1",    3501},
    {"stream_len_rng_end_1",    3502},
    {"stream_da_repeat_cnt_1",    3503},
    {"stream_sa_repeat_cnt_1",    3504},
    {"stream_repeat_content_1",    3505},
    {"pb_index",    3506},
    {"access_data",    3507},
    {"pb_trig",    3508},
    {"pb_type",    3509},
    {"pb_cell_index",    3510},
    {"pb_byte_index",    3511},
    {"port0_s1_index",    3512},
    {"port0_s0_index",    3513},
    {"pkt_index_2n_1",    3514},
    {"pkt_index_2n",    3515},
    {"rxport_dsc_sts",    3516},
    {"rxport_dsc_err",    3517},
    {"sw_q_rst_sys_thr",    3518},
    {"sw_q_rst_p_thr",    3519},
    {"ld_tx_dsc_sts",    3520},
    {"ld_tx_dsc_err",    3521},
    {"tx_dsc_chk_tmr",    3522},
    {"rxfifo_overflow_sts",    3523},
    {"rxfifo_overflow_err",    3524},
    {"rxfifo_rdempty_sts",    3525},
    {"rxfifo_rdempty_err",    3526},
    {"txfifo_overflow_sts",    3527},
    {"txfifo_overflow_err",    3528},
    {"txfifo_rdempty_sts",    3529},
    {"txfifo_rdempty_err",    3530},
    {"pingpong_plus_sts",    3531},
    {"pingpong_plus_err",    3532},
    {"token_sts",    3533},
    {"token_err",    3534},
    {"sw_q_rst_cnt",    3535},
    {"en_token_err_trig",    3536},
    {"en_rxport_dsc_err_trig",    3537},
    {"en_sys_dsc_err_trig",    3538},
    {"en_pingpong_err_trig",    3539},
    {"en_ld_tx_dsc_err_trig",    3540},
    {"en_fifo_err_trig",    3541},
    {"glb_token_sts",    3542},
    {"glb_rxport_dsc_sts",    3543},
    {"glb_sys_dsc_sts",    3544},
    {"glb_pingpong_sts",    3545},
    {"glb_ld_tx_dsc_sts",    3546},
    {"glb_fifo_sts",    3547},
    {"glb_token_err",    3548},
    {"glb_rx_p_dsc_err",    3549},
    {"glb_sys_dsc_err",    3550},
    {"glb_pingpong_err",    3551},
    {"glb_ld_tx_dsc_err",    3552},
    {"glb_fifo_err",    3553},
    {"txerr_cnt",    3554},
    {"efuse_ejtag_disable",    3555},
    {"key_src_sel_efuse",    3556},
    {"efuse_key_blk_sel",    3557},
    {"spi_mb_rme",    3558},
    {"spi_mb_rm",    3559},
    {"mib_mb_rme",    3560},
    {"mib_mb_rm",    3561},
    {"encap_tcam_mds",    3562},
    {"encap_tcam_rds",    3563},
    {"encap_ut_rme",    3564},
    {"encap_ut_rm",    3565},
    {"encap_mac_rme",    3566},
    {"encap_mac_rm",    3567},
    {"encap_act_rme",    3568},
    {"encap_act_rm",    3569},
    {"encap_rmkopri_rme",    3570},
    {"encap_rmkopri_rm",    3571},
    {"encap_rmkipri_rme",    3572},
    {"encap_rmkipri_rm",    3573},
    {"encap_smac_rme",    3574},
    {"encap_smac_rm",    3575},
    {"par_ptr_rmeb",    3576},
    {"par_ptr_rmb",    3577},
    {"par_ptr_rmea",    3578},
    {"par_ptr_rma",    3579},
    {"par_rmea5",    3580},
    {"par_rma5",    3581},
    {"par_rmea4",    3582},
    {"par_rma4",    3583},
    {"par_rmea3",    3584},
    {"par_rma3",    3585},
    {"par_rmea2",    3586},
    {"par_rma2",    3587},
    {"par_rmea1",    3588},
    {"par_rma1",    3589},
    {"par_rmea0",    3590},
    {"par_rma0",    3591},
    {"par_rmeb5",    3592},
    {"par_rmb5",    3593},
    {"par_rmeb4",    3594},
    {"par_rmb4",    3595},
    {"par_rmeb3",    3596},
    {"par_rmb3",    3597},
    {"par_rmeb2",    3598},
    {"par_rmb2",    3599},
    {"par_rmeb1",    3600},
    {"par_rmb1",    3601},
    {"par_rmeb0",    3602},
    {"par_rmb0",    3603},
    {"p29_par_dp_cnt",    3604},
    {"p29_ing_dp_cnt",    3605},
    {"p30_par_dp_cnt",    3606},
    {"p30_ing_dp_cnt",    3607},
    {"",    3608}
};

static diag_table_reg_name_value_pair_t longan_diag_table_array[] =
{
    {"untag",    0},
    {"vlan",    1},
    {"vlan_egr_cnvt",    2},
    {"vlan_igr_cnvt",    3},
    {"vlan_ip_based",    4},
    {"vlan_mac_based",    5},
    {"lag",    6},
    {"src_trk_map",    7},
    {"msti",    8},
    {"port_iso_ctrl",    9},
    {"l2_cam_mc",    10},
    {"l2_cam_uc",    11},
    {"l2_mc",    12},
    {"l2_uc",    13},
    {"mc_portmask",    14},
    {"meter",    15},
    {"remark",    16},
    {"l3_egr_intf",    17},
    {"l3_egr_intf_list",    18},
    {"l3_egr_intf_mac",    19},
    {"l3_host_route_ip6mc",    20},
    {"l3_host_route_ip6uc",    21},
    {"l3_host_route_ipmc",    22},
    {"l3_host_route_ipuc",    23},
    {"l3_nexthop",    24},
    {"l3_prefix_route_ip6mc",    25},
    {"l3_prefix_route_ip6uc",    26},
    {"l3_prefix_route_ipmc",    27},
    {"l3_prefix_route_ipuc",    28},
    {"l3_router_mac",    29},
    {"iacl",    30},
    {"log",    31},
    {"vacl",    32},
    {"hsb",    33},
    {"hsa",    34},
    {"",    35}
};

static diag_table_reg_name_value_pair_t longan_diag_table_field_array[] =
{

    {"untag_pmsk",    0},

    {"vlan_mbr",    0},
    {"vlan_msti",    1},
    {"vlan_l2_hkey_ucast",    2},
    {"vlan_l2_hkey_mcast",    3},
    {"vlan_vlan_profile",    4},
    {"vlan_group_mask",    5},

    {"vlan_egr_cnvt_valid",    0},
    {"vlan_egr_cnvt_port_type",    1},
    {"vlan_egr_cnvt_port_id",    2},
    {"vlan_egr_cnvt_int_otag_if",    3},
    {"vlan_egr_cnvt_int_opri",    4},
    {"vlan_egr_cnvt_int_ovid",    5},
    {"vlan_egr_cnvt_int_itag_if",    6},
    {"vlan_egr_cnvt_int_ipri",    7},
    {"vlan_egr_cnvt_int_ivid",    8},
    {"vlan_egr_cnvt_int_vid_rng_chk",    9},
    {"vlan_egr_cnvt_bmsk_port_type",    10},
    {"vlan_egr_cnvt_bmsk_port_id",    11},
    {"vlan_egr_cnvt_bmsk_int_otag_if",    12},
    {"vlan_egr_cnvt_bmsk_int_opri",    13},
    {"vlan_egr_cnvt_bmsk_int_ovid",    14},
    {"vlan_egr_cnvt_bmsk_int_itag_if",    15},
    {"vlan_egr_cnvt_bmsk_int_ipri",    16},
    {"vlan_egr_cnvt_bmsk_int_ivid",    17},
    {"vlan_egr_cnvt_bmsk_int_vid_rng_chk",    18},
    {"vlan_egr_cnvt_otpid_assign",    19},
    {"vlan_egr_cnvt_otpid_idx",    20},
    {"vlan_egr_cnvt_otag_sts_assign",    21},
    {"vlan_egr_cnvt_otag_sts",    22},
    {"vlan_egr_cnvt_opri_assign",    23},
    {"vlan_egr_cnvt_opri",    24},
    {"vlan_egr_cnvt_ovid_assign",    25},
    {"vlan_egr_cnvt_ovid",    26},
    {"vlan_egr_cnvt_itpid_assign",    27},
    {"vlan_egr_cnvt_itpid_idx",    28},
    {"vlan_egr_cnvt_itag_sts_assign",    29},
    {"vlan_egr_cnvt_itag_sts",    30},
    {"vlan_egr_cnvt_ipri_assign",    31},
    {"vlan_egr_cnvt_ipri",    32},
    {"vlan_egr_cnvt_ivid_assign",    33},
    {"vlan_egr_cnvt_ivid",    34},

    {"vlan_igr_cnvt_valid",    0},
    {"vlan_igr_cnvt_port_type",    1},
    {"vlan_igr_cnvt_port_id",    2},
    {"vlan_igr_cnvt_ori_otag_if",    3},
    {"vlan_igr_cnvt_ori_opri",    4},
    {"vlan_igr_cnvt_ori_ovid",    5},
    {"vlan_igr_cnvt_ori_itag_if",    6},
    {"vlan_igr_cnvt_ori_ipri",    7},
    {"vlan_igr_cnvt_ori_ivid",    8},
    {"vlan_igr_cnvt_ori_vid_rng_chk",    9},
    {"vlan_igr_cnvt_bmsk_port_type",    10},
    {"vlan_igr_cnvt_bmsk_port_id",    11},
    {"vlan_igr_cnvt_bmsk_ori_otag_if",    12},
    {"vlan_igr_cnvt_bmsk_ori_opri",    13},
    {"vlan_igr_cnvt_bmsk_ori_ovid",    14},
    {"vlan_igr_cnvt_bmsk_ori_itag_if",    15},
    {"vlan_igr_cnvt_bmsk_ori_ipri",    16},
    {"vlan_igr_cnvt_bmsk_ori_ivid",    17},
    {"vlan_igr_cnvt_bmsk_ori_vid_rng_chk",    18},
    {"vlan_igr_cnvt_otpid_assign",    19},
    {"vlan_igr_cnvt_otpid_idx",    20},
    {"vlan_igr_cnvt_otag_sts_assign",    21},
    {"vlan_igr_cnvt_otag_sts",    22},
    {"vlan_igr_cnvt_opri_assign",    23},
    {"vlan_igr_cnvt_opri",    24},
    {"vlan_igr_cnvt_ovid_assign",    25},
    {"vlan_igr_cnvt_ovid",    26},
    {"vlan_igr_cnvt_itpid_assign",    27},
    {"vlan_igr_cnvt_itpid_idx",    28},
    {"vlan_igr_cnvt_itag_sts_assign",    29},
    {"vlan_igr_cnvt_itag_sts",    30},
    {"vlan_igr_cnvt_ipri_assign",    31},
    {"vlan_igr_cnvt_ipri",    32},
    {"vlan_igr_cnvt_ivid_assign",    33},
    {"vlan_igr_cnvt_ivid",    34},

    {"vlan_ip_based_valid",    0},
    {"vlan_ip_based_port_type",    1},
    {"vlan_ip_based_port_id",    2},
    {"vlan_ip_based_ovid_valid",    3},
    {"vlan_ip_based_ivid_valid",    4},
    {"vlan_ip_based_sip",    5},
    {"vlan_ip_based_bmsk_port_type",    6},
    {"vlan_ip_based_bmsk_port_id",    7},
    {"vlan_ip_based_bmsk_ovid_valid",    8},
    {"vlan_ip_based_bmsk_ivid_valid",    9},
    {"vlan_ip_based_bmsk_sip",    10},
    {"vlan_ip_based_fwd_act",    11},
    {"vlan_ip_based_ignore_igr_fltr",    12},
    {"vlan_ip_based_vlan_type",    13},
    {"vlan_ip_based_tpid_assign",    14},
    {"vlan_ip_based_tpid_idx",    15},
    {"vlan_ip_based_tag_sts_assign",    16},
    {"vlan_ip_based_tag_sts",    17},
    {"vlan_ip_based_pri_assign",    18},
    {"vlan_ip_based_pri",    19},
    {"vlan_ip_based_vid_assign",    20},
    {"vlan_ip_based_vid",    21},

    {"vlan_mac_based_valid",    0},
    {"vlan_mac_based_port_type",    1},
    {"vlan_mac_based_port_id",    2},
    {"vlan_mac_based_ovid_valid",    3},
    {"vlan_mac_based_ivid_valid",    4},
    {"vlan_mac_based_smac",    5},
    {"vlan_mac_based_bmsk_port_type",    6},
    {"vlan_mac_based_bmsk_port_id",    7},
    {"vlan_mac_based_bmsk_ovid_valid",    8},
    {"vlan_mac_based_bmsk_ivid_valid",    9},
    {"vlan_mac_based_bmsk_smac",    10},
    {"vlan_mac_based_fwd_act",    11},
    {"vlan_mac_based_ignore_igr_fltr",    12},
    {"vlan_mac_based_vlan_type",    13},
    {"vlan_mac_based_tpid_assign",    14},
    {"vlan_mac_based_tpid_idx",    15},
    {"vlan_mac_based_tag_sts_assign",    16},
    {"vlan_mac_based_tag_sts",    17},
    {"vlan_mac_based_pri_assign",    18},
    {"vlan_mac_based_pri",    19},
    {"vlan_mac_based_vid_assign",    20},
    {"vlan_mac_based_vid",    21},

    {"lag_num_tx_candi",    0},
    {"lag_l2_hash_msk_idx",    1},
    {"lag_ip4_hash_msk_idx",    2},
    {"lag_ip6_hash_msk_idx",    3},
    {"lag_sep_dlf_bcast_en",    4},
    {"lag_sep_kwn_mc_en",    5},
    {"lag_trk_unit7",    6},
    {"lag_trk_port7",    7},
    {"lag_trk_unit6",    8},
    {"lag_trk_port6",    9},
    {"lag_trk_unit5",    10},
    {"lag_trk_port5",    11},
    {"lag_trk_unit4",    12},
    {"lag_trk_port4",    13},
    {"lag_trk_unit3",    14},
    {"lag_trk_port3",    15},
    {"lag_trk_unit2",    16},
    {"lag_trk_port2",    17},
    {"lag_trk_unit1",    18},
    {"lag_trk_port1",    19},
    {"lag_trk_unit0",    20},
    {"lag_trk_port0",    21},

    {"src_trk_map_trk_valid",    0},
    {"src_trk_map_trk_id",    1},

    {"msti_state_port28",    0},
    {"msti_state_port27",    1},
    {"msti_state_port26",    2},
    {"msti_state_port25",    3},
    {"msti_state_port24",    4},
    {"msti_state_port23",    5},
    {"msti_state_port22",    6},
    {"msti_state_port21",    7},
    {"msti_state_port20",    8},
    {"msti_state_port19",    9},
    {"msti_state_port18",    10},
    {"msti_state_port17",    11},
    {"msti_state_port16",    12},
    {"msti_state_port15",    13},
    {"msti_state_port14",    14},
    {"msti_state_port13",    15},
    {"msti_state_port12",    16},
    {"msti_state_port11",    17},
    {"msti_state_port10",    18},
    {"msti_state_port9",    19},
    {"msti_state_port8",    20},
    {"msti_state_port7",    21},
    {"msti_state_port6",    22},
    {"msti_state_port5",    23},
    {"msti_state_port4",    24},
    {"msti_state_port3",    25},
    {"msti_state_port2",    26},
    {"msti_state_port1",    27},
    {"msti_state_port0",    28},

    {"port_iso_ctrl_p_iso_mbr_0",    0},

    {"l2_cam_mc_mac",    0},
    {"l2_cam_mc_fid_rvid",    1},
    {"l2_cam_mc_valid",    2},
    {"l2_cam_mc_mc_pmsk_idx",    3},
    {"l2_cam_mc_next_hop",    4},
    {"l2_cam_mc_mac_idx",    5},

    {"l2_cam_uc_mac",    0},
    {"l2_cam_uc_fid_rvid",    1},
    {"l2_cam_uc_valid",    2},
    {"l2_cam_uc_is_trk",    3},
    {"l2_cam_uc_spa",    4},
    {"l2_cam_uc_age",    5},
    {"l2_cam_uc_sa_blk",    6},
    {"l2_cam_uc_da_blk",    7},
    {"l2_cam_uc_static",    8},
    {"l2_cam_uc_suspend",    9},
    {"l2_cam_uc_next_hop",    10},
    {"l2_cam_uc_vid",    11},

    {"l2_mc_mac",    0},
    {"l2_mc_fid_rvid",    1},
    {"l2_mc_valid",    2},
    {"l2_mc_mc_pmsk_idx",    3},
    {"l2_mc_next_hop",    4},
    {"l2_mc_mac_idx",    5},

    {"l2_uc_mac",    0},
    {"l2_uc_fid_rvid",    1},
    {"l2_uc_valid",    2},
    {"l2_uc_is_trk",    3},
    {"l2_uc_spa",    4},
    {"l2_uc_age",    5},
    {"l2_uc_sa_blk",    6},
    {"l2_uc_da_blk",    7},
    {"l2_uc_static",    8},
    {"l2_uc_suspend",    9},
    {"l2_uc_next_hop",    10},
    {"l2_uc_vid",    11},

    {"mc_portmask_portmask",    0},

    {"meter_type",    0},
    {"meter_mode",    1},
    {"meter_color_aware",    2},
    {"meter_lb0_rate",    3},
    {"meter_lb1_rate",    4},
    {"meter_lb0_bs",    5},
    {"meter_lb1_bs",    6},
    {"meter_rst",    7},

    {"remark_ipri_dflt_pri",    0},
    {"remark_opri_dflt_pri",    1},
    {"remark_ipri_dflt_src",    2},
    {"remark_opri_dflt_src",    3},

    {"l3_egr_intf_dst_vid",    0},
    {"l3_egr_intf_smac_idx",    1},
    {"l3_egr_intf_ip_mtu_idx",    2},
    {"l3_egr_intf_ip6_mtu_idx",    3},
    {"l3_egr_intf_ipmc_ttl_scope",    4},
    {"l3_egr_intf_ip6mc_hl_scope",    5},
    {"l3_egr_intf_ip_icmp_redirect_act",    6},
    {"l3_egr_intf_ip6_icmp_redirect_act",    7},
    {"l3_egr_intf_ip_pbr_icmp_redirect_act",    8},
    {"l3_egr_intf_ip6_pbr_icmp_redirect_act",    9},

    {"l3_egr_intf_list_oil_next",    0},
    {"l3_egr_intf_list_eol",    1},
    {"l3_egr_intf_list_ttl_dec",    2},
    {"l3_egr_intf_list_ttl_chk",    3},
    {"l3_egr_intf_list_sa_replace",    4},
    {"l3_egr_intf_list_l3_egr_intf_bssid_idx",    5},
    {"l3_egr_intf_list_mc_pmsk_idx",    6},

    {"l3_egr_intf_mac_mac",    0},

    {"l3_host_route_ip6mc_valid",    0},
    {"l3_host_route_ip6mc_entry_type",    1},
    {"l3_host_route_ip6mc_ipmc_type",    2},
    {"l3_host_route_ip6mc_sip",    3},
    {"l3_host_route_ip6mc_gip",    4},
    {"l3_host_route_ip6mc_hit",    5},
    {"l3_host_route_ip6mc_ttl_min",    6},
    {"l3_host_route_ip6mc_mtu_max_idx",    7},
    {"l3_host_route_ip6mc_stack_fwd_pmsk",    8},
    {"l3_host_route_ip6mc_vid_cmp",    9},
    {"l3_host_route_ip6mc_vid",    10},
    {"l3_host_route_ip6mc_qos_as",    11},
    {"l3_host_route_ip6mc_qos_pri",    12},
    {"l3_host_route_ip6mc_l2_en",    13},
    {"l3_host_route_ip6mc_l2_act",    14},
    {"l3_host_route_ip6mc_l2_mc_pmsk_idx",    15},
    {"l3_host_route_ip6mc_l3_en",    16},
    {"l3_host_route_ip6mc_l3_act",    17},
    {"l3_host_route_ip6mc_rpf_chk_en",    18},
    {"l3_host_route_ip6mc_rpf_fail_act",    19},
    {"l3_host_route_ip6mc_oil_idx_valid",    20},
    {"l3_host_route_ip6mc_oil_idx",    21},

    {"l3_host_route_ip6uc_valid",    0},
    {"l3_host_route_ip6uc_entry_type",    1},
    {"l3_host_route_ip6uc_hit",    2},
    {"l3_host_route_ip6uc_dst_null_intf",    3},
    {"l3_host_route_ip6uc_action",    4},
    {"l3_host_route_ip6uc_nh_idx",    5},
    {"l3_host_route_ip6uc_ttl_dec",    6},
    {"l3_host_route_ip6uc_ttl_chk",    7},
    {"l3_host_route_ip6uc_qos_as",    8},
    {"l3_host_route_ip6uc_qos_pri",    9},
    {"l3_host_route_ip6uc_ip",    10},

    {"l3_host_route_ipmc_valid",    0},
    {"l3_host_route_ipmc_entry_type",    1},
    {"l3_host_route_ipmc_ipmc_type",    2},
    {"l3_host_route_ipmc_sip",    3},
    {"l3_host_route_ipmc_gip",    4},
    {"l3_host_route_ipmc_hit",    5},
    {"l3_host_route_ipmc_ttl_min",    6},
    {"l3_host_route_ipmc_mtu_max_idx",    7},
    {"l3_host_route_ipmc_stack_fwd_pmsk",    8},
    {"l3_host_route_ipmc_vid_cmp",    9},
    {"l3_host_route_ipmc_vid",    10},
    {"l3_host_route_ipmc_qos_as",    11},
    {"l3_host_route_ipmc_qos_pri",    12},
    {"l3_host_route_ipmc_l2_en",    13},
    {"l3_host_route_ipmc_l2_act",    14},
    {"l3_host_route_ipmc_l2_mc_pmsk_idx",    15},
    {"l3_host_route_ipmc_l3_en",    16},
    {"l3_host_route_ipmc_l3_act",    17},
    {"l3_host_route_ipmc_rpf_chk_en",    18},
    {"l3_host_route_ipmc_rpf_fail_act",    19},
    {"l3_host_route_ipmc_oil_idx_valid",    20},
    {"l3_host_route_ipmc_oil_idx",    21},

    {"l3_host_route_ipuc_valid",    0},
    {"l3_host_route_ipuc_entry_type",    1},
    {"l3_host_route_ipuc_hit",    2},
    {"l3_host_route_ipuc_dst_null_intf",    3},
    {"l3_host_route_ipuc_action",    4},
    {"l3_host_route_ipuc_nh_idx",    5},
    {"l3_host_route_ipuc_ttl_dec",    6},
    {"l3_host_route_ipuc_ttl_chk",    7},
    {"l3_host_route_ipuc_qos_as",    8},
    {"l3_host_route_ipuc_qos_pri",    9},
    {"l3_host_route_ipuc_ip",    10},

    {"l3_nexthop_dmac_idx",    0},
    {"l3_nexthop_l3_egr_intf_idx",    1},

    {"l3_prefix_route_ip6mc_valid",    0},
    {"l3_prefix_route_ip6mc_entry_type",    1},
    {"l3_prefix_route_ip6mc_ipmc_type",    2},
    {"l3_prefix_route_ip6mc_round",    3},
    {"l3_prefix_route_ip6mc_vid",    4},
    {"l3_prefix_route_ip6mc_sip",    5},
    {"l3_prefix_route_ip6mc_gip",    6},
    {"l3_prefix_route_ip6mc_bmsk_entry_type",    7},
    {"l3_prefix_route_ip6mc_bmsk_ipmc_type",    8},
    {"l3_prefix_route_ip6mc_bmsk_round",    9},
    {"l3_prefix_route_ip6mc_bmsk_vid",    10},
    {"l3_prefix_route_ip6mc_bmsk_sip",    11},
    {"l3_prefix_route_ip6mc_bmsk_gip",    12},
    {"l3_prefix_route_ip6mc_hit",    13},
    {"l3_prefix_route_ip6mc_ttl_min",    14},
    {"l3_prefix_route_ip6mc_mtu_max_idx",    15},
    {"l3_prefix_route_ip6mc_stack_fwd_pmsk",    16},
    {"l3_prefix_route_ip6mc_vid_cmp",    17},
    {"l3_prefix_route_ip6mc_rpf_vid",    18},
    {"l3_prefix_route_ip6mc_l2_en",    19},
    {"l3_prefix_route_ip6mc_l2_act",    20},
    {"l3_prefix_route_ip6mc_l2_mc_pmsk_idx",    21},
    {"l3_prefix_route_ip6mc_l3_en",    22},
    {"l3_prefix_route_ip6mc_l3_act",    23},
    {"l3_prefix_route_ip6mc_rpf_chk_en",    24},
    {"l3_prefix_route_ip6mc_rpf_fail_act",    25},
    {"l3_prefix_route_ip6mc_oil_idx_valid",    26},
    {"l3_prefix_route_ip6mc_oil_idx",    27},
    {"l3_prefix_route_ip6mc_qos_as",    28},
    {"l3_prefix_route_ip6mc_qos_pri",    29},

    {"l3_prefix_route_ip6uc_valid",    0},
    {"l3_prefix_route_ip6uc_entry_type",    1},
    {"l3_prefix_route_ip6uc_ip",    2},
    {"l3_prefix_route_ip6uc_bmsk_entry_type",    3},
    {"l3_prefix_route_ip6uc_bmsk_ip",    4},
    {"l3_prefix_route_ip6uc_hit",    5},
    {"l3_prefix_route_ip6uc_host_route",    6},
    {"l3_prefix_route_ip6uc_dflt_route",    7},
    {"l3_prefix_route_ip6uc_action",    8},
    {"l3_prefix_route_ip6uc_nh_idx",    9},
    {"l3_prefix_route_ip6uc_ttl_dec",    10},
    {"l3_prefix_route_ip6uc_ttl_chk",    11},
    {"l3_prefix_route_ip6uc_dst_null_intf",    12},
    {"l3_prefix_route_ip6uc_qos_as",    13},
    {"l3_prefix_route_ip6uc_qos_pri",    14},

    {"l3_prefix_route_ipmc_valid",    0},
    {"l3_prefix_route_ipmc_entry_type",    1},
    {"l3_prefix_route_ipmc_ipmc_type",    2},
    {"l3_prefix_route_ipmc_round",    3},
    {"l3_prefix_route_ipmc_vid",    4},
    {"l3_prefix_route_ipmc_sip",    5},
    {"l3_prefix_route_ipmc_gip",    6},
    {"l3_prefix_route_ipmc_bmsk_entry_type",    7},
    {"l3_prefix_route_ipmc_bmsk_ipmc_type",    8},
    {"l3_prefix_route_ipmc_bmsk_round",    9},
    {"l3_prefix_route_ipmc_bmsk_vid",    10},
    {"l3_prefix_route_ipmc_bmsk_sip",    11},
    {"l3_prefix_route_ipmc_bmsk_gip",    12},
    {"l3_prefix_route_ipmc_hit",    13},
    {"l3_prefix_route_ipmc_ttl_min",    14},
    {"l3_prefix_route_ipmc_mtu_max_idx",    15},
    {"l3_prefix_route_ipmc_stack_fwd_pmsk",    16},
    {"l3_prefix_route_ipmc_vid_cmp",    17},
    {"l3_prefix_route_ipmc_rpf_vid",    18},
    {"l3_prefix_route_ipmc_l2_en",    19},
    {"l3_prefix_route_ipmc_l2_act",    20},
    {"l3_prefix_route_ipmc_l2_mc_pmsk_idx",    21},
    {"l3_prefix_route_ipmc_l3_en",    22},
    {"l3_prefix_route_ipmc_l3_act",    23},
    {"l3_prefix_route_ipmc_rpf_chk_en",    24},
    {"l3_prefix_route_ipmc_rpf_fail_act",    25},
    {"l3_prefix_route_ipmc_oil_idx_valid",    26},
    {"l3_prefix_route_ipmc_oil_idx",    27},
    {"l3_prefix_route_ipmc_qos_as",    28},
    {"l3_prefix_route_ipmc_qos_pri",    29},

    {"l3_prefix_route_ipuc_valid",    0},
    {"l3_prefix_route_ipuc_entry_type",    1},
    {"l3_prefix_route_ipuc_ip",    2},
    {"l3_prefix_route_ipuc_bmsk_entry_type",    3},
    {"l3_prefix_route_ipuc_bmsk_ip",    4},
    {"l3_prefix_route_ipuc_hit",    5},
    {"l3_prefix_route_ipuc_host_route",    6},
    {"l3_prefix_route_ipuc_dflt_route",    7},
    {"l3_prefix_route_ipuc_action",    8},
    {"l3_prefix_route_ipuc_nh_idx",    9},
    {"l3_prefix_route_ipuc_ttl_dec",    10},
    {"l3_prefix_route_ipuc_ttl_chk",    11},
    {"l3_prefix_route_ipuc_dst_null_intf",    12},
    {"l3_prefix_route_ipuc_qos_as",    13},
    {"l3_prefix_route_ipuc_qos_pri",    14},

    {"l3_router_mac_valid",    0},
    {"l3_router_mac_port_type",    1},
    {"l3_router_mac_port_id",    2},
    {"l3_router_mac_l3_intf",    3},
    {"l3_router_mac_intf_id",    4},
    {"l3_router_mac_mac",    5},
    {"l3_router_mac_bmsk_reserved",    6},
    {"l3_router_mac_bmsk_port_type",    7},
    {"l3_router_mac_bmsk_port_id",    8},
    {"l3_router_mac_bmsk_l3_intf",    9},
    {"l3_router_mac_bmsk_intf_id",    10},
    {"l3_router_mac_bmsk_mac",    11},
    {"l3_router_mac_action",    12},

    {"iacl_field_11",    0},
    {"iacl_field_10",    1},
    {"iacl_field_9",    2},
    {"iacl_field_8",    3},
    {"iacl_field_7",    4},
    {"iacl_field_6",    5},
    {"iacl_field_5",    6},
    {"iacl_field_4",    7},
    {"iacl_field_3",    8},
    {"iacl_field_2",    9},
    {"iacl_field_1",    10},
    {"iacl_field_0",    11},
    {"iacl_stacking_port",    12},
    {"iacl_slp",    13},
    {"iacl_mgnt_vlan",    14},
    {"iacl_dev_dmac",    15},
    {"iacl_not_first_frag",    16},
    {"iacl_frame_type_l4",    17},
    {"iacl_frame_type",    18},
    {"iacl_outer_untag_pritag",    19},
    {"iacl_inner_untag_pritag",    20},
    {"iacl_outer_tag_pritag",    21},
    {"iacl_inner_tag_pritag",    22},
    {"iacl_frame_type_l2",    23},
    {"iacl_igr_nml_port",    24},
    {"iacl_tid",    25},
    {"iacl_bmsk_field_11",    26},
    {"iacl_bmsk_field_10",    27},
    {"iacl_bmsk_field_9",    28},
    {"iacl_bmsk_field_8",    29},
    {"iacl_bmsk_field_7",    30},
    {"iacl_bmsk_field_6",    31},
    {"iacl_bmsk_field_5",    32},
    {"iacl_bmsk_field_4",    33},
    {"iacl_bmsk_field_3",    34},
    {"iacl_bmsk_field_2",    35},
    {"iacl_bmsk_field_1",    36},
    {"iacl_bmsk_field_0",    37},
    {"iacl_bmsk_stacking_port",    38},
    {"iacl_bmsk_slp",    39},
    {"iacl_bmsk_mgnt_vlan",    40},
    {"iacl_bmsk_dev_dmac",    41},
    {"iacl_bmsk_not_first_frag",    42},
    {"iacl_bmsk_frame_type_l4",    43},
    {"iacl_bmsk_frame_type",    44},
    {"iacl_bmsk_outer_untag_pritag",    45},
    {"iacl_bmsk_inner_untag_pritag",    46},
    {"iacl_bmsk_outer_tag_pritag",    47},
    {"iacl_bmsk_inner_tag_pritag",    48},
    {"iacl_bmsk_frame_type_l2",    49},
    {"iacl_bmsk_igr_nml_port",    50},
    {"iacl_bmsk_tid",    51},
    {"iacl_valid",    52},
    {"iacl_not",    53},
    {"iacl_and1",    54},
    {"iacl_and2",    55},
    {"iacl_act_msk_invert_ip_rsvd_flag",    56},
    {"iacl_act_msk_red_remark",    57},
    {"iacl_act_msk_yellow_remark",    58},
    {"iacl_act_msk_remark",    59},
    {"iacl_act_msk_cpuqid",    60},
    {"iacl_act_msk_metadata",    61},
    {"iacl_act_msk_bypass",    62},
    {"iacl_act_msk_priority",    63},
    {"iacl_act_msk_tag_status",    64},
    {"iacl_act_msk_opri",    65},
    {"iacl_act_msk_ovlan",    66},
    {"iacl_act_msk_ipri",    67},
    {"iacl_act_msk_ivlan",    68},
    {"iacl_act_msk_meter",    69},
    {"iacl_act_msk_mirror",    70},
    {"iacl_act_msk_log",    71},
    {"iacl_act_msk_fwd",    72},
    {"iacl_act_msk_red_drop",    73},
    {"iacl_act_msk_yellow_drop",    74},
    {"iacl_act_msk_drop",    75},
    {"iacl_drop_act",    76},
    {"iacl_yellow_drop_act",    77},
    {"iacl_red_drop_act",    78},
    {"iacl_fwd_act",    79},
    {"iacl_fwd_cpu_pkt_fmt",    80},
    {"iacl_fwd_sel",    81},
    {"iacl_fwd_port_info",    82},
    {"iacl_log_act",    83},
    {"iacl_meter_index",    84},
    {"iacl_ivlan_vid_act",    85},
    {"iacl_ivlan_vid",    86},
    {"iacl_ivlan_tpid_act",    87},
    {"iacl_ivlan_tpid_idx",    88},
    {"iacl_ivlan_pri_act",    89},
    {"iacl_ivlan_pri",    90},
    {"iacl_ovlan_vid_act",    91},
    {"iacl_ovlan_vid",    92},
    {"iacl_ovlan_tpid_act",    93},
    {"iacl_ovlan_tpid_idx",    94},
    {"iacl_ovlan_pri_act",    95},
    {"iacl_ovlan_pri",    96},
    {"iacl_mirror_act",    97},
    {"iacl_mirror_index",    98},
    {"iacl_tag_status_inner",    99},
    {"iacl_tag_status_outer",    100},
    {"iacl_pri_data",    101},
    {"iacl_qid_data",    102},
    {"iacl_bypass_data",    103},
    {"iacl_meta_data",    104},
    {"iacl_remark_act",    105},
    {"iacl_remark_value",    106},
    {"iacl_yellow_remark_act",    107},
    {"iacl_yellow_remark_value",    108},
    {"iacl_red_remark_act",    109},
    {"iacl_red_remark_value",    110},

    {"log_counter",    0},

    {"vacl_field_11",    0},
    {"vacl_field_10",    1},
    {"vacl_field_9",    2},
    {"vacl_field_8",    3},
    {"vacl_field_7",    4},
    {"vacl_field_6",    5},
    {"vacl_field_5",    6},
    {"vacl_field_4",    7},
    {"vacl_field_3",    8},
    {"vacl_field_2",    9},
    {"vacl_field_1",    10},
    {"vacl_field_0",    11},
    {"vacl_stacking_port",    12},
    {"vacl_slp",    13},
    {"vacl_mgnt_vlan",    14},
    {"vacl_content_too_deep",    15},
    {"vacl_not_first_frag",    16},
    {"vacl_frame_type_l4",    17},
    {"vacl_frame_type",    18},
    {"vacl_outer_untag_pritag",    19},
    {"vacl_inner_untag_pritag",    20},
    {"vacl_outer_tag_pritag",    21},
    {"vacl_inner_tag_pritag",    22},
    {"vacl_frame_type_l2",    23},
    {"vacl_igr_nml_port",    24},
    {"vacl_tid",    25},
    {"vacl_bmsk_field_11",    26},
    {"vacl_bmsk_field_10",    27},
    {"vacl_bmsk_field_9",    28},
    {"vacl_bmsk_field_8",    29},
    {"vacl_bmsk_field_7",    30},
    {"vacl_bmsk_field_6",    31},
    {"vacl_bmsk_field_5",    32},
    {"vacl_bmsk_field_4",    33},
    {"vacl_bmsk_field_3",    34},
    {"vacl_bmsk_field_2",    35},
    {"vacl_bmsk_field_1",    36},
    {"vacl_bmsk_field_0",    37},
    {"vacl_bmsk_stacking_port",    38},
    {"vacl_bmsk_slp",    39},
    {"vacl_bmsk_mgnt_vlan",    40},
    {"vacl_bmsk_content_too_deep",    41},
    {"vacl_bmsk_not_first_frag",    42},
    {"vacl_bmsk_frame_type_l4",    43},
    {"vacl_bmsk_frame_type",    44},
    {"vacl_bmsk_outer_untag_pritag",    45},
    {"vacl_bmsk_inner_untag_pritag",    46},
    {"vacl_bmsk_outer_tag_pritag",    47},
    {"vacl_bmsk_inner_tag_pritag",    48},
    {"vacl_bmsk_frame_type_l2",    49},
    {"vacl_bmsk_igr_nml_port",    50},
    {"vacl_bmsk_tid",    51},
    {"vacl_valid",    52},
    {"vacl_not",    53},
    {"vacl_and1",    54},
    {"vacl_and2",    55},
    {"vacl_act_msk_invert_ip_rsvd_flag",    56},
    {"vacl_act_msk_red_remark",    57},
    {"vacl_act_msk_yellow_remark",    58},
    {"vacl_act_msk_remark",    59},
    {"vacl_act_msk_qid",    60},
    {"vacl_act_msk_metadata",    61},
    {"vacl_act_msk_bypass",    62},
    {"vacl_act_msk_priority",    63},
    {"vacl_act_msk_tag_status",    64},
    {"vacl_act_msk_opri",    65},
    {"vacl_act_msk_ovlan",    66},
    {"vacl_act_msk_ipri",    67},
    {"vacl_act_msk_ivlan",    68},
    {"vacl_act_msk_meter",    69},
    {"vacl_act_msk_mirror",    70},
    {"vacl_act_msk_log",    71},
    {"vacl_act_msk_fwd",    72},
    {"vacl_act_msk_red_drop",    73},
    {"vacl_act_msk_yellow_drop",    74},
    {"vacl_act_msk_drop",    75},
    {"vacl_drop_act",    76},
    {"vacl_yellow_drop_act",    77},
    {"vacl_red_drop_act",    78},
    {"vacl_fwd_act",    79},
    {"vacl_fwd_cpu_pkt_fmt",    80},
    {"vacl_fwd_sa_lrn",    81},
    {"vacl_fwd_sel",    82},
    {"vacl_fwd_port_info",    83},
    {"vacl_log_act",    84},
    {"vacl_meter_index",    85},
    {"vacl_ivlan_vid_act",    86},
    {"vacl_ivlan_vid",    87},
    {"vacl_ivlan_pri_act",    88},
    {"vacl_ivlan_pri",    89},
    {"vacl_ovlan_vid_act",    90},
    {"vacl_ovlan_vid",    91},
    {"vacl_ovlan_pri_act",    92},
    {"vacl_ovlan_pri",    93},
    {"vacl_mirror_act",    94},
    {"vacl_mirror_index",    95},
    {"vacl_tag_status_inner",    96},
    {"vacl_tag_status_outer",    97},
    {"vacl_internal_pri",    98},
    {"vacl_qid_data",    99},
    {"vacl_bypass_data",    100},
    {"vacl_meta_data",    101},
    {"vacl_remark_act",    102},
    {"vacl_remark_value",    103},
    {"vacl_yellow_remark_act",    104},
    {"vacl_yellow_remark_value",    105},
    {"vacl_red_remark_act",    106},
    {"vacl_red_remark_value",    107},

    {"hsb_page_cnt",    0},
    {"hsb_lst_dsc",    1},
    {"hsb_fst_dsc",    2},
    {"hsb_lbhdr_vld",    3},
    {"hsb_sthdr_vld",    4},
    {"hsb_sthdr_0_3",    5},
    {"hsb_sthdr_4_7",    6},
    {"hsb_sthdr_8_11",    7},
    {"hsb_sthdr_12_15",    8},
    {"hsb_sthdr_16",    9},
    {"hsb_fs11_data",    10},
    {"hsb_fs10_data",    11},
    {"hsb_fs9_data",    12},
    {"hsb_fs8_data",    13},
    {"hsb_fs7_data",    14},
    {"hsb_fs6_data",    15},
    {"hsb_fs5_data",    16},
    {"hsb_fs4_data",    17},
    {"hsb_fs3_data",    18},
    {"hsb_fs2_data",    19},
    {"hsb_fs1_data",    20},
    {"hsb_fs0_data",    21},
    {"hsb_fs_valid",    22},
    {"hsb_ipv6_flow_label",    23},
    {"hsb_ingr_err",    24},
    {"hsb_udp_ptp",    25},
    {"hsb_l2_ptp",    26},
    {"hsb_dsap_ssap",    27},
    {"hsb_arp_opcode",    28},
    {"hsb_tgt_mac_47_16",    29},
    {"hsb_tgt_mac_15_0",    30},
    {"hsb_sender_mac_47_32",    31},
    {"hsb_sender_mac_31_0",    32},
    {"hsb_dport",    33},
    {"hsb_sport",    34},
    {"hsb_tcp_flag",    35},
    {"hsb_ip_ttl",    36},
    {"hsb_ip_tos",    37},
    {"hsb_ip_protocol",    38},
    {"hsb_ip_ver",    39},
    {"hsb_ip_flag",    40},
    {"hsb_ip_offset",    41},
    {"hsb_dip",    42},
    {"hsb_sip",    43},
    {"hsb_otag_content",    44},
    {"hsb_itag_content",    45},
    {"hsb_typelen",    46},
    {"hsb_ip_length",    47},
    {"hsb_smac_47_16",    48},
    {"hsb_smac_15_0",    49},
    {"hsb_dmac_47_32",    50},
    {"hsb_dmac_31_0",    51},
    {"hsb_otpid_idx",    52},
    {"hsb_itpid_idx",    53},
    {"hsb_ipv4_hdrlen",    54},
    {"hsb_tcp_sn_eq_0",    55},
    {"hsb_ipv6_hop",    56},
    {"hsb_ipv6_rout",    57},
    {"hsb_ipv6_frag",    58},
    {"hsb_ipv6_dest",    59},
    {"hsb_ipv6_auth",    60},
    {"hsb_ipv4_chksum_ok",    61},
    {"hsb_ipv6_ext_long",    62},
    {"hsb_ipv6_pkt",    63},
    {"hsb_ipv4_pkt",    64},
    {"hsb_rtag_type",    65},
    {"hsb_rtag_exist",    66},
    {"hsb_etag_exist",    67},
    {"hsb_ctag_exist",    68},
    {"hsb_otag_exist",    69},
    {"hsb_itag_exist",    70},
    {"hsb_oam_pdu",    71},
    {"hsb_llc_other",    72},
    {"hsb_pppoe_pkt",    73},
    {"hsb_rfc1042",    74},
    {"hsb_spa",    75},
    {"hsb_l2_err_pkt",    76},
    {"hsb_l4_hdr_chk",    77},
    {"hsb_pkt_len",    78},

    {"hsa_drop_rsn",    0},
    {"hsa_fst_dsc",    1},
    {"hsa_txqid_stk_port",    2},
    {"hsa_txqid_normal_71_64",    3},
    {"hsa_txqid_normal_63_32",    4},
    {"hsa_txqid_normal_31_0",    5},
    {"hsa_dpm_lb",    6},
    {"hsa_dpm",    7},
    {"hsa_replicate_lst_cp",    8},
    {"hsa_replicate_fst_cp",    9},
    {"hsa_replicate_none",    10},
    {"hsa_replicate_type",    11},
    {"hsa_sflow_smpl_port",    12},
    {"hsa_sflow_info",    13},
    {"hsa_sflow_nor_fwd",    14},
    {"hsa_stk_nor_fwd",    15},
    {"hsa_stk_cpu_fwd",    16},
    {"hsa_miring_port_3",    17},
    {"hsa_miring_port_2",    18},
    {"hsa_miring_port_1",    19},
    {"hsa_miring_port_0",    20},
    {"hsa_mir3_info",    21},
    {"hsa_mir2_info",    22},
    {"hsa_mir1_info",    23},
    {"hsa_mir0_info",    24},
    {"hsa_mir_normal_fwd",    25},
    {"hsa_dy_gasp",    26},
    {"hsa_dpc",    27},
    {"hsa_page_cnt",    28},
    {"hsa_pkt_len",    29},
    {"hsa_lst_dsc",    30},
    {"hsa_ipmc_qid",    31},
    {"hsa_ipmc_pkt",    32},
    {"hsa_nor_cpu_sel",    33},
    {"hsa_txqid_cpu",    34},
    {"hsa_lb_pkt",    35},
    {"hsa_ip_rsvd_invert",    36},
    {"hsa_da_hit",    37},
    {"hsa_stk_mir",    38},
    {"hsa_lb_ttl",    39},
    {"hsa_meta_data",    40},
    {"hsa_ctx_l3_act",    41},
    {"hsa_ctx_acl_act",    42},
    {"hsa_ctx_cngst_drop",    43},
    {"hsa_ctx_bp_fltr_egr",    44},
    {"hsa_ctx_bp_stp_egr",    45},
    {"hsa_ctx_bp_vlan_egr",    46},
    {"hsa_ctx_qid",    47},
    {"hsa_ctx_as_qid",    48},
    {"hsa_src_fltr_en",    49},
    {"hsa_ctx_fwd_vid_en",    50},
    {"hsa_ctx_spn",    51},
    {"hsa_ctx_spn_is_trk",    52},
    {"hsa_ctx_sp_fltr_en",    53},
    {"hsa_ctx_dpm_28_55",    54},
    {"hsa_ctx_dpm_0_27",    55},
    {"hsa_ctx_unit_id",    56},
    {"hsa_ctx_fwd_type",    57},
    {"hsa_dp_info",    58},
    {"hsa_dp_fmt",    59},
    {"hsa_fwd_type",    60},
    {"hsa_sa_lrn",    61},
    {"hsa_vb_iso_mbr",    62},
    {"hsa_trk_hash",    63},
    {"hsa_new_sa",    64},
    {"hsa_l2_mac_cst",    65},
    {"hsa_pmv_forbid",    66},
    {"hsa_l2_dyn_pmv",    67},
    {"hsa_l2_sttc_pmv",    68},
    {"hsa_l2_org_port",    69},
    {"hsa_l2_org_trk_if",    70},
    {"hsa_atk_type",    71},
    {"hsa_acl_idx",    72},
    {"hsa_acl_hit",    73},
    {"hsa_is_eav_a",    74},
    {"hsa_is_eav_b",    75},
    {"hsa_reason",    76},
    {"hsa_int_dscp_hit",    77},
    {"hsa_int_dscp",    78},
    {"hsa_int_pri",    79},
    {"hsa_eacl_opri_as",    80},
    {"hsa_eacl_ipri_as",    81},
    {"hsa_iacl_opri_as",    82},
    {"hsa_iacl_ipri_as",    83},
    {"hsa_cpu_tagsts_as",    84},
    {"hsa_eacl_itag_status_as",    85},
    {"hsa_eacl_otag_status_as",    86},
    {"hsa_iacl_itag_status_as",    87},
    {"hsa_iacl_otag_status_as",    88},
    {"hsa_ale_itag_status",    89},
    {"hsa_ale_otag_status",    90},
    {"hsa_iacl_otpid_as",    91},
    {"hsa_iacl_itpid_as",    92},
    {"hsa_eacl_otpid_as",    93},
    {"hsa_eacl_itpid_as",    94},
    {"hsa_otpid_idx",    95},
    {"hsa_itpid_idx",    96},
    {"hsa_ale_otag_content",    97},
    {"hsa_ale_itag_content",    98},
    {"hsa_eacl_ivid_as",    99},
    {"hsa_eacl_ovid_as",    100},
    {"hsa_n_1_ovid_as",    101},
    {"hsa_n_1_ivid_as",    102},
    {"hsa_ttl_dec",    103},
    {"hsa_l2_hash_full",    104},
    {"hsa_invalid_sa",    105},
    {"hsa_routed_pkt",    106},
    {"hsa_cpu_fmt_en",    107},
    {"hsa_cpu_fmt",    108},
    {"hsa_l3_sa_idx",    109},
    {"hsa_l3_da_idx",    110},
    {"hsa_l3_sa_if",    111},
    {"hsa_l3_da_if",    112},
    {"hsa_oam_swap_mac",    113},
    {"hsa_dp",    114},
    {"hsa_rvid_base",    115},
    {"hsa_fwd_vid",    116},
    {"hsa_org_otpid_idx",    117},
    {"hsa_org_itpid_idx",    118},
    {"hsa_org_otag_content",    119},
    {"hsa_org_itag_content",    120},
    {"hsa_etag_if",    121},
    {"hsa_ctag_if",    122},
    {"hsa_org_otag_if",    123},
    {"hsa_org_itag_if",    124},
    {"hsa_pppoe_if",    125},
    {"hsa_llc_other",    126},
    {"hsa_rfc1042",    127},
    {"hsa_stk_spa_trk_id",    128},
    {"hsa_stk_spa_is_trk",    129},
    {"hsa_stk_spa",    130},
    {"hsa_stk_sunit",    131},
    {"hsa_sphy",    132},
    {"hsa_l2_err_pkt",    133},
    {"hsa_l3_err_pkt",    134},
    {"hsa_ipv6_pkt",    135},
    {"hsa_ipv4_pkt",    136},

    {"",    0}
};
#endif



