#include <common.h>
#include <asm/addrspace.h>
#include <asm/io.h>
#include <asm/mipsregs.h>
#include <asm/otto_pll.h>
#include <rtk_reg.h>

#define RTL8380_MAC_ADDR_CTRL_ADDR  (0xBB00A9EC)
#define RTL8380_PORT_ISO_CTRL_ADDR  (0xBB004100)
#define RTL8380_N_NONCPU_PORTS  28
#define RTL8380_CPU_PORT  28


phys_size_t initdram(int board_type __attribute__((unused))) {
#define DCR (MEM32_READ(0xb8001004))
	const unsigned char BNKCNTv[] = {1, 2, 3};
	const unsigned char BUSWIDv[] = {0, 1, 2};
	const unsigned char ROWCNTv[] = {11, 12, 13, 14, 15, 16};
	const unsigned char COLCNTv[] = {8, 9, 10, 11, 12};	
	return 1 << (BNKCNTv[(DCR >> 28) & 0x3] +
			BUSWIDv[(DCR >> 24) & 0x3] +
			ROWCNTv[(DCR >> 20) & 0xF] +
			COLCNTv[(DCR >> 16) & 0xF]);
}

int checkboard (void) {
	printf("Board: RTL838x CPU:%dMHz LXB:%dMHz MEM:%dMHz\n",
	       board_CPU_freq_mhz(), board_LX_freq_mhz(), board_DRAM_freq_mhz());
	return 0;
}

void RTL838x_set_mac(void) {
	char *addr_str, *end;
	unsigned char addr[6];
	int i;
	unsigned int data;
	if ((addr_str = getenv("ethaddr")) != NULL) {
		for (i = 0; i < 6; i++) {
			addr[i] =
			    addr_str ? simple_strtoul(addr_str, &end, 16) : 0;
			if (addr_str) {
				addr_str = (*end) ? end + 1 : end;
			}
		}
		data = addr[5] | (addr[4] << 8) | (addr[3] << 16) | (addr[2] << 24);
		MEM32_WRITE(RTL8380_MAC_ADDR_CTRL_ADDR + 4, data);
		data = addr[1] | (addr[0] << 8);
		MEM32_WRITE(RTL8380_MAC_ADDR_CTRL_ADDR, data);
	}
}

void RTL838x_isolate_ports(void)
{
	int i;

	for (i = 0; i < RTL8380_N_NONCPU_PORTS; i++) {
		MEM32_WRITE(RTL8380_PORT_ISO_CTRL_ADDR + 4 * i, 1 << RTL8380_CPU_PORT);
	}
}

