#include "bspchip.h"
#include <common.h>
#include <uboot/cmd/uboot_cmd.h>
#include <rtk_reg.h>
#include <tlt/leds.h>
#include <tlt/mnf_info.h>

#include <private/drv/rtl8231/rtl8231_rtl8380.h>
#include <private/drv/swcore/swcore_rtl8380.h>

#define LED_GLB_CTRL	  0xBB00A000
#define LED_P_EN_CTRL	  0xBB00A008
#define LED_P_EN_CTRL	  0xBB00A008
#define LED0_SW_P_EN_CTRL 0xBB00A010
#define LED1_SW_P_EN_CTRL 0xBB00A014
#define LED_SW_P_CTRL	  0xBB00A01C
#define LED_MODE_SEL	  0xBB001004

#define LED_PER_GROUP 28

#define ANIMATION_TIME_STEP 4000
#define BTN_PRESS_TIME_STEP 1000
#define BLINK_TIME_STEP	    100
#define INIT_Y_TIME	    500
#define INIT_G_TIME	    500

#ifdef SWM2_PLATFORM
// yellow leds
static const int8_t yleds[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1,
				/* poe */
				0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
				0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
				/* gpio-exp */
				0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0 };

// yellow leds
static const int8_t gleds[] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				1, 1, 1, 1,
				/* poe */
				1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0,
				1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0,
				/* gpio-exp */
				0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 };

// mixed/standard leds
static const int8_t leds[] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
			       0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			       1, 1, 1, 1,
			       /* poe */
			       0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
			       0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
			       /* gpio-exp */
			       0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			       0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0 };

static const int8_t leds_anim[] = { 0,	1,  101, 103, 2,  3,  97, 99, 4,  5,  93, 95, 6,  7,
				    89, 91, 8,	 9,   85, 87, 10, 11, 81, 83, 12, 13, 77, 79,
				    14, 15, 73,	 75,  16, 17, 69, 71, 18, 19, 65, 67, 20, 21,
				    61, 63, 22,	 23,  57, 59, 52, 53, -1, -1, 54, 55, -1, -1 };

static const int8_t *aleds[3] = { yleds, gleds, leds }; // yellow, green and normal colors
#endif

#ifdef TSW2_PLATFORM
#include <drv/i2c/i2c.h>
#include <uboot/cmd/uboot_cmd.h>

#define GPIO_AB_CTRL	0xB8003500
#define GPIO_AB_DIR	0xB8003508
#define GPIO_AB_DATA	0xB800350C
#define SFP_TX_DIS_MASK ((0x1 << 25) | (0x1 << 18)) //PORTA[1], PORTB[2]

#define PCA9535_OUT0 0x02
#define PCA9535_OUT1 0x03
#define PCA9535_CFG0 0x06
#define PCA9535_CFG1 0x07

#define TSW2X3_PCA9535_SCL  4
#define TSW2X3_PCA9535_SDA  5
#define TSW2X3_PCA9535_ADDR 0x24

#define TSW2X3_SFP_TX_DIS1 (1 << 6)
#define TSW2X3_SFP_TX_DIS2 (1 << 4)

static const int8_t leds[] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
			       0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 };

static const int8_t leds_anim[] = { 8,	9,  36, 37, 10, 11, 38, 39, 12, 13,
				    40, 41, 14, 15, 42, 43, 26, -1, 24, -1 };

static const int8_t *aleds[3] = { leds, leds, leds };
#endif

#define NLEDS sizeof(leds)

static uint8_t cur_leds_on[NLEDS] = { 0 };

static int leds_count = 0, anim_count, anim_state;
static uint8_t leds_state;
static uint8_t col_idx		   = 0;
static uint32_t nextTimerVal	   = 1;
static uint32_t init_col_timer_val = 0;
static int flashing_active;
static int failsafe_active;
static char anim_index;

static ulong btn_first_press = 0;
static ulong btn_press_diff  = 0;
static int btn_press_blink   = 0;

#ifndef EXT_SR_LEDS_OFF
#define EXT_SR_LEDS_OFF sizeof(leds)
#endif

#ifndef EXT_GP_LEDS_OFF
#define EXT_GP_LEDS_OFF sizeof(leds)
#endif

#ifdef CONFIG_SDK_RTL8231

static int ext_dev = 0;

#define RTL838X_DMY_REG5 (0x0144)

/* RTL8231 registers for LED control */
#define RTL8231_LED_FUNC0	   0x0000
#define RTL8231_LED_FUNC1	   0x0001
#define RTL8231_READY_MASK	   0x03f0
#define RTL8231_READY_VALUE	   0x0370
#define RTL8231_GPIO_PIN_SEL(gpio) ((0x0002) + ((gpio) >> 4))
#define RTL8231_GPIO_DIR(gpio)	   ((0x0005) + ((gpio) >> 4))
#define RTL8231_GPIO_DATA(gpio)	   ((0x001C) + ((gpio) >> 4))

#ifdef CONFIG_SDK_RTL8380
#define EXT_GPIO_INDRT_ACCESS (0xA09C)
#endif

#ifdef CONFIG_SDK_RTL8390
#define EXT_GPIO_INDRT_ACCESS (0x0224)
#endif

#define USEC_TIMEOUT 5000

#define RTL8231_SMI_BUS_ID_MAX 0x1F

#define RTL8231_MDC_WAIT_COMPLETE(unit, REG, MASK)                                                           \
	do {                                                                                                 \
		uint32 t = 0;                                                                                \
		uint32 regVal;                                                                               \
		do {                                                                                         \
			udelay(1); /* check the register every N microsecond */                              \
			t += 1;                                                                              \
			loc_mem32_read(REG, &regVal);                                                        \
			if (0 == (regVal & MASK)) {                                                          \
				break;                                                                       \
			}                                                                                    \
		} while (t <= 5000);                                                                         \
		if (t > 5000) {                                                                              \
			printf("%s:%d timeout\n", __func__, __LINE__);                                       \
			return RT_ERR_BUSYWAIT_TIMEOUT;                                                      \
		}                                                                                            \
	} while (0)

static inline void loc_mem32_write(u32 addr, u32 val)
{
	WRITE_MEM32((SWCORE_BASE_ADDR + addr), val);
}

static inline void loc_mem32_read(u32 addr, u32 *val)
{
	*val = READ_MEM32((SWCORE_BASE_ADDR + addr));
}

int32 loc_r8380_rtl8231_mdc_read(uint32 unit, uint32 phy_id, uint32 page, uint32 reg_addr, uint32 *pData)
{
	uint32 temp = 0;

	/* Input parameters:
     * If RWOP = 0(read), then INDATA[15:0] = {Reserved & PORT_ID[4:0]}
     * If RWOP = 1(write), then INDATA[15:0] = DATA[15:0]
     */
	temp |= ((phy_id << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_PHY_ADDR_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_PHY_ADDR_MASK);

	/* Select register number to access */
	temp |= ((reg_addr << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_REG_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_REG_MASK);

	/* Read/Write operation
     * 0b0: read
     * 0b1: write
     */
	temp |= ((0 << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_RWOP_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_RWOP_MASK);

	/* Request MAC to access PHY MII register
     * 0b0: complete access
     * 0b1: execute access
     * Note: When MAC completes access, it will clear this bit.
     */
	temp |= ((1 << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_CMD_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_CMD_MASK);

	/* write register to active the read operation */

	loc_mem32_write(RTL8380_EXT_GPIO_INDRT_ACCESS_ADDR, temp);

	/* busy waiting until reg.bit[0] = 0b0 (MAC completes access) */
	RTL8231_MDC_WAIT_COMPLETE(unit, RTL8380_EXT_GPIO_INDRT_ACCESS_ADDR, 0x1);

	/* get the read operation result to temp */
	loc_mem32_read(RTL8380_EXT_GPIO_INDRT_ACCESS_ADDR, &temp);

	/* fill the DATA[15:0] from temp to pData */
	(*pData) = (temp & RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_DATA_MASK) >>
		   RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_DATA_OFFSET;

	/*printf("%s:%d 0x%x <= 0x%x(0x%x)\n", __func__, __LINE__, *pData, RTL8380_EXT_GPIO_INDRT_ACCESS_ADDR,*/
	/*reg_addr);*/

	return RT_ERR_OK;
}

int32 loc_r8380_rtl8231_mdc_write(uint32 unit, uint32 phy_id, uint32 page, uint32 reg_addr, uint32 data)
{
	uint32 temp = 0;

	/* Input parameters:
     * If RWOP = 0(read), then INDATA[15:0] = {Reserved & PORT_ID[4:0]}
     * If RWOP = 1(write), then INDATA[15:0] = DATA[15:0]
     */
	temp |= ((phy_id << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_PHY_ADDR_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_PHY_ADDR_MASK);

	/* Select register number to access */
	temp |= ((reg_addr << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_REG_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_REG_MASK);

	/* Read/Write operation
     * 0b0: read
     * 0b1: write
     */
	temp |= ((1 << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_RWOP_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_RWOP_MASK);

	/* Input parameters:
     * If RWOP = 0(read), then GPIO_DATA[15:0] = input data[15:0]
     * If RWOP = 1(write), then GPIO_DATA [15:0] = output data[15:0]
     */
	temp |= ((data << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_DATA_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_DATA_MASK);

	/* Request MAC to access PHY MII register
     * 0b0: complete access
     * 0b1: execute access
     * Note: When MAC completes access, it will clear this bit.
     */
	temp |= ((1 << RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_CMD_OFFSET) &
		 RTL8380_EXT_GPIO_INDRT_ACCESS_GPIO_CMD_MASK);

	/* write register to active the read operation */
	loc_mem32_write(RTL8380_EXT_GPIO_INDRT_ACCESS_ADDR, temp);
	/*printf("%s:%d 0x%x(0x%x) => 0x%x(0x%x)\n", __func__, __LINE__, temp, data,*/
	/*RTL8380_EXT_GPIO_INDRT_ACCESS_ADDR, reg_addr);*/

	/* busy waiting until reg.bit[0] = 0b0 (MAC completes access) */
	RTL8231_MDC_WAIT_COMPLETE(unit, RTL8380_EXT_GPIO_INDRT_ACCESS_ADDR, 0x1);

	return RT_ERR_OK;
}

u32 rtl8231_read(u32 reg)
{
	u32 data;
	int ret;

	ret = loc_r8380_rtl8231_mdc_read(RTK_UNIT, ext_dev, 0, reg, &data);
	if (ret)
		printf("Failed to read 0x%x register\n", reg);
	return data;
}

int rtl8231_write(u32 reg, u32 data)
{
	int ret;
	ret = loc_r8380_rtl8231_mdc_write(RTK_UNIT, ext_dev, 0, reg, data);
	if (ret)
		printf("Failed to write to 0x%x register\n", reg);
	return ret;
}

/* Set Direction of the RTL8231 pin:
 * dir 1: input
 * dir 0: output
 */
static int rtl8231_try_pin_dir(u32 gpio, u32 dir)
{
	u32 v;
	int pin_sel_addr = RTL8231_GPIO_PIN_SEL(gpio);
	int pin_dir_addr = RTL8231_GPIO_DIR(gpio);
	int dpin	 = gpio % 16;

	if (gpio > 31) {
		dpin += 5;
		pin_dir_addr = pin_sel_addr;
	}

	v = rtl8231_read(pin_dir_addr);
	if (v & 0x80000000) {
		printf("Error reading RTL8231\n");
		return -1;
	}

	if (!(v & (1 << dpin))) {
		return 0;
	}

	printf("Setting dir %d for pin %d\n", dir, gpio);

	v = (v & ~(1 << dpin)) | (dir << dpin);
	rtl8231_write(pin_dir_addr, v);

	rtl8231_write(RTL8231_LED_FUNC0_ADDR, 2);
	return 0;
}

int rtl8231_pin_set(u32 gpio, u32 data)
{
	u32 v = rtl8231_read(RTL8231_GPIO_DATA(gpio));
	if (v & 0x80000000) {
		printf("Error reading RTL8231\n");
		return -1;
	}
	v = (v & ~(1 << (gpio % 16))) | (data << (gpio % 16));
	rtl8231_write(RTL8231_GPIO_DATA(gpio), v);

	return 0;
}

int rtl8231_init(void)
{
	uint32 mode;
	int32 ret = RT_ERR_FAILED;

#ifdef CONFIG_SDK_RTL8380
	/* Enable RTL8380 Indirect access RTL8231 mode */
	loc_mem32_read(RTL8380_EXTRA_GPIO_CTRL_ADDR, &mode);
	mode |= 0x1UL;
	loc_mem32_write(RTL8380_EXTRA_GPIO_CTRL_ADDR, mode);

	loc_mem32_read(RTL8380_DMY_REG5_ADDR, &mode);
	mode &= ~0x3UL;
	mode |= 0x1UL;
	loc_mem32_write(RTL8380_DMY_REG5_ADDR, mode);
#endif

#ifdef CONFIG_SDK_RTL8390
	// RTL8390: Enable external gpio in global led control register
	loc_mem32_read(RTL839X_LED_GLB_CTRL, &mode);
	mode &= ~(0x7 << 18);
	mode |= (0x4 << 18);
	loc_mem32_write(RTL839X_LED_GLB_CTRL, mode);
#endif
	/*Add GPIO output driver current */
	loc_mem32_read(RTL8380_IO_DRIVING_ABILITY_CTRL_ADDR, &mode);
	mode |= (RTL8380_IO_DRIVING_ABILITY_CTRL_GPIO_IO_DRV_MASK);
	loc_mem32_write(RTL8380_IO_DRIVING_ABILITY_CTRL_ADDR, mode);

	uint32 pData = 0;
	for (ext_dev = 0; ext_dev < 32; ext_dev++) {
		ret = loc_r8380_rtl8231_mdc_read(RTK_UNIT, ext_dev, 0, 0, &pData);
		if (ret != RT_ERR_OK || pData & 0x8000) {
			/*printf("ext-gpio not found at (%d).\n", ext_dev);*/
			continue;
		}
		printf("Found ext-gpio at %d.\n", ext_dev);
		goto found;
	}

	ext_dev = 0;
	printf("ext-gpio was not found\n");
found:

	/* Select GPIO functionality and force input direction for pins 0-36 */
	rtl8231_write(RTL8231_GPIO_PIN_SEL(0), 0xffff);
	rtl8231_write(RTL8231_GPIO_DIR(0), 0xffff);
	rtl8231_write(RTL8231_GPIO_PIN_SEL(16), 0xffff);
	rtl8231_write(RTL8231_GPIO_DIR(16), 0xffff);
	rtl8231_write(RTL8231_GPIO_PIN_SEL(32), 0x03ff);
	rtl8231_write(RTL8231_LED_FUNC0_ADDR, 2);

	return 0;
}
#endif //CONFIG_SDK_RTL8231

static void led_set_1(uint8_t *mask)
{
	uint32_t regData, regAddr, msk, maskOn;
	int offset;

	for (int i = 0; i < EXT_SR_LEDS_OFF; i++) {
		if (!aleds[col_idx][i] || !!mask[i] == !!cur_leds_on[i])
			continue;

		if (i < LED_PER_GROUP) {
			msk    = 0x07;
			maskOn = 0x05;
			offset = i;
		} else {
			msk    = 0x38;
			maskOn = 0x28;
			offset = i - LED_PER_GROUP;
		}
		regAddr = LED_SW_P_CTRL + offset * 4;
#ifdef OPPOSED_LEDS
		regData = 0;
#else
		regData = READ_MEM32(regAddr);
#endif
		regData &= ~msk;
		if (mask[i]) {
			regData |= maskOn;
		}
		WRITE_MEM32(regAddr, regData);
		cur_leds_on[i] = mask[i];
	}
}

static void set_ext_sr_led(uint8_t *mask)
{
#ifdef EXT_SR_LEDS
	uint32_t regData;
	uint8_t sr_mask[EXT_SR_BIT_LEN] = { 0 };
	for (int i = 0; i < EXT_SR_BIT_LEN; i++) {
		/*sr_mask[i] = mask[EXT_SR_LEDS_OFF + i] & leds[EXT_SR_LEDS_OFF + i];*/
		sr_mask[i] = mask[EXT_SR_LEDS_OFF + i] & aleds[col_idx][EXT_SR_LEDS_OFF + i];

		cur_leds_on[EXT_SR_LEDS_OFF + i] = sr_mask[i];
	}

	for (int i = EXT_SR_BIT_LEN; i >= 0; i--) {
		regData = READ_MEM32(GPIO_PABCD_DAT);
		if (sr_mask[i]) {
			WRITE_MEM32(GPIO_PABCD_DAT, (regData | (1 << EXT_SR_DATA)));
		} else {
			WRITE_MEM32(GPIO_PABCD_DAT, (regData & ~(1 << EXT_SR_DATA)));
		}

		regData = READ_MEM32(GPIO_PABCD_DAT);
		WRITE_MEM32(GPIO_PABCD_DAT, (regData | (1 << EXT_SR_CLK)));
		udelay(EXT_SR_TIME_UNIT);
		regData = READ_MEM32(GPIO_PABCD_DAT);
		WRITE_MEM32(GPIO_PABCD_DAT, (regData & ~(1 << EXT_SR_CLK)));
	}
#else
	(void)mask;
#endif
}

static void set_ext_gp_led(uint8_t *mask)
{
#ifdef CONFIG_SDK_RTL8231
	for (int i = EXT_GP_LEDS_OFF; i < NLEDS; i++) {
		if ((cur_leds_on[i] && !aleds[col_idx][i]) || aleds[col_idx][i] ||
		    !!mask[i] != !!cur_leds_on[i]) {
			/* inverted for some reason */
			if (rtl8231_try_pin_dir(i - EXT_GP_LEDS_OFF + 1, 0)) {
				printf("Failed to set pin (%d) dir\n", i - EXT_GP_LEDS_OFF + 1);
				continue;
			}

			if (rtl8231_pin_set(i - EXT_GP_LEDS_OFF + 1, !mask[i])) {
				printf("Failed to set pin (%d) value\n", i - EXT_GP_LEDS_OFF + 1);
				continue;
			}

			cur_leds_on[i] = mask[i];
		}
	}
#else
	(void)mask;
#endif
}

static void led_set(uint8_t *mask)
{
	uint8_t mask_in[NLEDS]	   = { 0 };
	uint8_t mask_ext_sr[NLEDS] = { 0 };
	uint8_t mask_ext_gp[NLEDS] = { 0 };

	uint32_t cur_col_timer_val = get_timer(0);
	if (col_idx == 0 && cur_col_timer_val - init_col_timer_val > INIT_Y_TIME) {
		col_idx = 1;
	} else if (col_idx == 1 && cur_col_timer_val - init_col_timer_val > INIT_Y_TIME + INIT_G_TIME) {
		col_idx = 2;
	}

	for (int ix = 0; ix < NLEDS; ix++)
		if (ix < EXT_SR_LEDS_OFF)
			mask_in[ix] = mask[ix];
		else if (ix < EXT_GP_LEDS_OFF) {
			mask_ext_sr[ix] = mask[ix];
		} else {
			mask_ext_gp[ix] = mask[ix] & aleds[col_idx][ix];
		}

	led_set_1(mask_in);
	set_ext_sr_led(mask_ext_sr);
	set_ext_gp_led(mask_ext_gp);
}

void tlt_gpio_init(void)
{
	uint32_t regData;

#ifdef CONFIG_SDK_RTL8231
	rtl8231_init();
#endif // CONFIG_SDK_RTL8231

#ifdef TSW2_PLATFORM
	char name[16];
	mnf_get_field("name", name);
	if (!strncmp(name, "TSW202", 6) || !strncmp(name, "TSW212", 6)) {
		// SFP TX_DIS as gpio
		regData = READ_MEM32(GPIO_AB_CTRL);
		WRITE_MEM32(GPIO_AB_CTRL, (regData & ~SFP_TX_DIS_MASK));
		// SFP TX_DIS as output
		regData = READ_MEM32(GPIO_AB_DIR);
		WRITE_MEM32(GPIO_AB_DIR, (regData | SFP_TX_DIS_MASK));
		// SFP TX_DIS output low
		regData = READ_MEM32(GPIO_AB_DATA);
		WRITE_MEM32(GPIO_AB_DATA, (regData & ~SFP_TX_DIS_MASK));
	}
#endif // TSW2_PLATFORM

#ifdef EXT_SR_LEDS
	// shiftreg CLK
	regData = READ_MEM32(GPIO_PABCD_CNR);
	WRITE_MEM32(GPIO_PABCD_CNR, (regData & ~(1 << EXT_SR_CLK)));
	regData = READ_MEM32(GPIO_PABCD_DIR);
	WRITE_MEM32(GPIO_PABCD_DIR, (regData | (1 << EXT_SR_CLK)));

	// shiftreg DATA
	regData = READ_MEM32(GPIO_PABCD_CNR);
	WRITE_MEM32(GPIO_PABCD_CNR, (regData & ~(1 << EXT_SR_DATA)));
	regData = READ_MEM32(GPIO_PABCD_DIR);
	WRITE_MEM32(GPIO_PABCD_DIR, (regData | (1 << EXT_SR_DATA)));
#endif
	// RST BUTTON as gpio
	regData = READ_MEM32(GPIO_PABCD_CNR);
	WRITE_MEM32(GPIO_PABCD_CNR, (regData & ~(1 << CONFIG_RST_BTN_SHIFT)));
	// RST BUTTON as input
	regData = READ_MEM32(GPIO_PABCD_DIR);
	WRITE_MEM32(GPIO_PABCD_DIR, (regData & ~(1 << CONFIG_RST_BTN_SHIFT)));

	// Enable serial interface of Ethernet LED-s
	regData = READ_MEM32(LED_MODE_SEL);
	regData &= ~0x3;
	WRITE_MEM32(LED_MODE_SEL, regData);

	//Two leds per port
	regData = READ_MEM32(LED_GLB_CTRL);
	regData &= ~0x3F;
	regData |= 0x1B;
	WRITE_MEM32(LED_GLB_CTRL, regData);

	// Enable software control of Ethernet LED-s
	WRITE_MEM32(LED_P_EN_CTRL, LED_ENABLED_MASK);
	WRITE_MEM32(LED0_SW_P_EN_CTRL, LED0_ENABLED_MASK);
	WRITE_MEM32(LED1_SW_P_EN_CTRL, LED1_ENABLED_MASK);
	anim_count = sizeof(leds_anim) / ANIM_SHIFT - 1;
	for (int i = 0; i < NLEDS; i++) {
		if (leds[i])
			leds_count++;
	}

	init_col_timer_val = get_timer(0);
}

void tlt_net_init(void)
{
#ifdef TSW2_PLATFORM
	char name[16];
	mnf_get_field("name", name);
	if (!strncmp(name, "TSW213", 6) || !strncmp(name, "TSW223", 6)) {
		uint8 data;
		uboot_sdk_init(UBOOT_SDK_INIT_PHASE_RTK);

		rtk_i2c_sw_init(0, 0, TSW2X3_PCA9535_SCL, 0, TSW2X3_PCA9535_SDA, "8", TSW2X3_PCA9535_ADDR, 2,
				0, 0);

		// SFP TX_DIS1 as output
		drv_i2c_read(0, 0, PCA9535_CFG0, &data);
		data &= ~TSW2X3_SFP_TX_DIS1;
		drv_i2c_write(0, 0, PCA9535_CFG0, &data);
		// SFP TX_DIS1 output low
		drv_i2c_read(0, 0, PCA9535_OUT0, &data);
		data &= ~TSW2X3_SFP_TX_DIS1;
		drv_i2c_write(0, 0, PCA9535_OUT0, &data);
		// SFP TX_DIS2 as output
		drv_i2c_read(0, 0, PCA9535_CFG1, &data);
		data &= ~TSW2X3_SFP_TX_DIS2;
		drv_i2c_write(0, 0, PCA9535_CFG1, &data);
		// SFP TX_DIS2 output low
		drv_i2c_read(0, 0, PCA9535_OUT1, &data);
		data &= ~TSW2X3_SFP_TX_DIS2;
		drv_i2c_write(0, 0, PCA9535_OUT1, &data);
	}
#endif // TSW2_PLATFORM
}

void tlt_leds_invert(void)
{
	uint8_t mask_arr[NLEDS];

	leds_state = !leds_state;

	memset(mask_arr, leds_state, NLEDS);
	led_set(mask_arr);
}

void tlt_leds_on(void)
{
	leds_state = 1;
	uint8_t mask_arr[NLEDS];
	memset(mask_arr, 1, NLEDS);

	led_set(mask_arr);
}

void tlt_leds_off(void)
{
	leds_state		= 0;
	uint8_t mask_arr[NLEDS] = { 0 };
	led_set(mask_arr);
}

int tlt_get_rst_btn_status(void)
{
	int ret = ((READ_MEM32(GPIO_PABCD_DAT) >> CONFIG_RST_BTN_SHIFT) & 1);
	/* Disable 'button press blinking' state if it was already enaled and if button is
	 * no longer pressed. This helps to identify if button was released before
	 * 5 second mark */
	if (btn_press_diff && ret) {
		btn_press_blink = 0;
	}

	return ret;
}

void tlt_btn_press_blink_set(int val)
{
	btn_press_blink = !!val;
}

/* Returns time interval in which reset button was continiously been pressed */
int tlt_leds_check_btn_blink(void)
{
	/* 'Button press blinking' state is not enabled or button is not pressed */
	if (tlt_get_rst_btn_status() || !btn_press_blink)
		return btn_press_diff;

	ulong currentTick = get_timer(0);
	if (btn_first_press) {
		btn_first_press = currentTick;
		tlt_leds_on();
		leds_state = 1;
		return 0;
	}

	ulong diff = (currentTick - btn_first_press) / 1000; // difference in seconds
	if (diff & 0x1 && leds_state) {
		tlt_leds_off();
		leds_state = 0;
	} else if (!(diff & 0x1) && !leds_state) {
		tlt_leds_on();
		leds_state = 1;
	}

	btn_press_diff = diff;

	return diff;
}

static void sr_led_animation(void)
{
	uint8_t mask[NLEDS] = { 0 };
	if (leds_count == 0)
		return;
	if (leds_state) {
		tlt_leds_off();
		anim_state = 0;
		anim_index = 0;
	}

	for (int i = 0; i < ANIM_SHIFT; i++) {
		if (leds_anim[anim_index * ANIM_SHIFT + i] >= 0) {
			mask[leds_anim[anim_index * ANIM_SHIFT + i]] = 1;
		}
	}

	led_set(mask);

	if (!anim_state) {
		anim_index++;
		if (anim_index == anim_count) {
			anim_state = 1;
		}
	} else {
		anim_index--;
		if (!anim_index) {
			anim_state = 0;
		}
	}
}

void tlt_leds_check_anim(void)
{
	uint32_t currentTick = get_timer(0);

	if (leds_count == 0)
		return;

	if (nextTimerVal == 0) {
		nextTimerVal = currentTick + (ANIMATION_TIME_STEP / leds_count);
	}

	if (flashing_active && nextTimerVal <= currentTick) {
		sr_led_animation();
		nextTimerVal = currentTick + (ANIMATION_TIME_STEP / leds_count);
	}
}

void tlt_leds_check_blink(void)
{
	uint32_t currentTick = get_timer(0);

	if (leds_count == 0)
		return;

	if (nextTimerVal == 0) {
		nextTimerVal = currentTick + BLINK_TIME_STEP;
	}

	if (failsafe_active && nextTimerVal <= currentTick) {
		if (leds_state) {
			tlt_leds_off();
		} else {
			tlt_leds_on();
		}

		nextTimerVal = currentTick + BLINK_TIME_STEP;
	}
}

void tlt_leds_set_flashing_state(int state)
{
	flashing_active = !!state;
	if (flashing_active) {
		tlt_leds_off();
		leds_state = 0;
	}
	failsafe_active = 0;
}

void tlt_leds_set_failsafe_state(int state)
{
	failsafe_active = !!state;
	flashing_active = 0;
}

int tlt_leds_get_flashing_state(void)
{
	return flashing_active;
}

int tlt_leds_get_failsafe_state(void)
{
	return failsafe_active;
}
