#include <spi_nand/spi_nand_ctrl.h>
#include <spi_nand/spi_nand_common.h>
#include <util.h>
#ifdef CONFIG_SPI_NAND_FLASH_INIT_FIRST
    #include <spi_nand/spi_nand_util.h>
#endif
#if defined(CONFIG_UNDER_UBOOT) && !defined(CONFIG_SPI_NAND_FLASH_INIT_FIRST)
    #include <spi_nand/spi_nand_blr_util.h>
    #include <spi_nand/spi_nand_symb_func.h>
#endif

/***********************************************
  *  XTX's ID Definition
  ***********************************************/
#define MID_XTX      (0x0B)
#define DID_XT26G01B (0xF1)
#define DID_XT26G02B (0xF2)
#define DID_XT26G01C (0x11)
#define DID_XT26G02C (0x12)

// policy decision
    //input: #define NSU_PROHIBIT_QIO, or NSU_PROHIBIT_DIO  (in project/info.in)
    //       #define NSU_XTX_USING_QIO, NSU_XTX_USING_DIO, NSU_XTX_USING_SIO  (in project/info.in)
    //       #define NSU_DRIVER_IN_ROM, IS_RECYCLE_SECTION_EXIST (in template/info.in)
    //       #define NSU_USING_SYMBOL_TABLE_FUNCTION (in project/info.in)

    //output: #define __DEVICE_REASSIGN, __DEVICE_USING_SIO, __DEVICE_USING_DIO, and __DEVICE_USING_QIO
    //        #define __SECTION_INIT_PHASE, __SECTION_INIT_PHASE_DATA
    //        #define __SECTION_RUNTIME, __SECTION_RUNTIME_DATA

#ifdef NSU_DRIVER_IN_ROM
    #define __SECTION_INIT_PHASE      SECTION_SPI_NAND
    #define __SECTION_INIT_PHASE_DATA SECTION_SPI_NAND_DATA
    #define __SECTION_RUNTIME         SECTION_SPI_NAND
    #define __SECTION_RUNTIME_DATA    SECTION_SPI_NAND_DATA
    #if defined(NSU_PROHIBIT_QIO) || defined(NSU_PROHIBIT_DIO)
        #error 'lplr should not run at ...'
    #endif
    #ifdef IS_RECYCLE_SECTION_EXIST
        #error 'lplr should not have recycle section ...'
    #endif
    #define __DEVICE_USING_SIO 1
    #define __DEVICE_USING_DIO 0
    #define __DEVICE_USING_QIO 0
#else
    #ifdef NSU_USING_SYMBOL_TABLE_FUNCTION
        #define __DEVICE_REASSIGN 1
    #endif
    #ifdef IS_RECYCLE_SECTION_EXIST
        #define __SECTION_INIT_PHASE        SECTION_RECYCLE
        #define __SECTION_INIT_PHASE_DATA   SECTION_RECYCLE_DATA
        #define __SECTION_RUNTIME           SECTION_UNS_TEXT
        #define __SECTION_RUNTIME_DATA      SECTION_UNS_RO
    #else
        #define __SECTION_INIT_PHASE
        #define __SECTION_INIT_PHASE_DATA
        #define __SECTION_RUNTIME
        #define __SECTION_RUNTIME_DATA
    #endif

    #ifdef NSU_XTX_USING_QIO
        #if defined(NSU_PROHIBIT_QIO) && defined(NSU_PROHIBIT_DIO)
            #define __DEVICE_USING_SIO 1
            #define __DEVICE_USING_DIO 0
            #define __DEVICE_USING_QIO 0
        #elif defined(NSU_PROHIBIT_QIO)
            #define __DEVICE_USING_SIO 0
            #define __DEVICE_USING_DIO 1
            #define __DEVICE_USING_QIO 0
        #else
            #define __DEVICE_USING_SIO 0
            #define __DEVICE_USING_DIO 0
            #define __DEVICE_USING_QIO 1
        #endif
    #elif defined(NSU_XTX_USING_DIO)
        #if defined(NSU_PROHIBIT_DIO)
            #define __DEVICE_USING_SIO 1
            #define __DEVICE_USING_DIO 0
            #define __DEVICE_USING_QIO 0
        #else
            #define __DEVICE_USING_SIO 0
            #define __DEVICE_USING_DIO 1
            #define __DEVICE_USING_QIO 0
        #endif
    #else
        #define __DEVICE_USING_SIO 1
        #define __DEVICE_USING_DIO 0
        #define __DEVICE_USING_QIO 0
    #endif
#endif

#ifdef CONFIG_SPI_NAND_FLASH_INIT_FIRST
#if __DEVICE_USING_QIO
__SECTION_INIT_PHASE_DATA
spi_nand_cmd_info_t xtx_qio_cmd_info = {
    .w_cmd = PROGRAM_LOAD_X4_OP,
    .w_addr_io = SIO_WIDTH,
    .w_data_io = QIO_WIDTH,
    .r_cmd = FAST_READ_QIO_OP,
    .r_addr_io = QIO_WIDTH,
    .r_data_io = QIO_WIDTH,
    .r_dummy_cycles  = 8,
};
#endif

__SECTION_RUNTIME void
xtx_ecc_encode(u32_t ecc_ability, void *dma_addr, void *fake_ptr_cs) { return; }

__SECTION_RUNTIME s32_t
_xtx_ecc_decode(u32_t ecc_ability, void *dma_addr, void *fake_ptr_cs)
{
    const u32_t cs = ((u32_t)fake_ptr_cs) & 0xF;
    u32_t ecst = nsu_get_feature_reg(cs, 0xC0);
    return ecst;
}

__SECTION_RUNTIME s32_t
xtx_ecc_decode_8bit(u32_t ecc_ability, void *dma_addr, void *fake_ptr_cs)
{
    u32_t ecst = _xtx_ecc_decode(ecc_ability, dma_addr, fake_ptr_cs);
    u32_t res;

    ecst = (ecst>>4)&0xf;
    if (0xf==ecst) {       // error and no correted
        res = ECC_CTRL_ERR;
    } else if (0<ecst && 8>=ecst) { // error and corrected
        res = ecst;
    } else {             // no error
        res = 0;
    }

    return res;
}

__SECTION_RUNTIME s32_t
xtx_ecc_decode_8bit_1B(u32_t ecc_ability, void *dma_addr, void *fake_ptr_cs)
{
    u32_t ecst = _xtx_ecc_decode(ecc_ability, dma_addr, fake_ptr_cs);
    u32_t res;

    ecst = (ecst>>2)&0xf;
    if (0x8==ecst) {       // error and no correted
        res = ECC_CTRL_ERR;
    } else if (0<ecst && 7>=ecst) { // error and corrected
        res = ecst;
    } else if (0xc==ecst) {
        res = 8;
    } else {             // no error
        res = 0;
    }

    return res;
}

__SECTION_INIT_PHASE_DATA
spi_nand_flash_info_t xtx_chip_info[] = {
    {
        .man_id              = MID_XTX,
        .dev_id              = DID_XT26G01B,
        ._num_block          = SNAF_MODEL_NUM_BLK_1024,
        ._num_page_per_block = SNAF_MODEL_NUM_PAGE_64,
        ._page_size          = SNAF_MODEL_PAGE_SIZE_2048B,
        ._spare_size         = SNAF_MODEL_SPARE_SIZE_64B,
        ._oob_size           = SNAF_MODEL_OOB_SIZE(24),
        ._ecc_ability        = ECC_USE_ODE,
    #if __DEVICE_REASSIGN
        ._ecc_encode         = VZERO,
        ._ecc_decode         = VZERO,
        ._reset              = VZERO,
        ._cmd_info           = VZERO,
        ._model_info         = VZERO,
    #else
        ._ecc_encode         = xtx_ecc_encode,
        ._ecc_decode         = xtx_ecc_decode_8bit_1B,
        ._reset              = nsu_reset_spi_nand_chip,
        ._model_info         = &snaf_ode_general_model,
        #if __DEVICE_USING_QIO
        ._cmd_info           = &xtx_qio_cmd_info,
        #elif __DEVICE_USING_DIO
        ._cmd_info           = &nsc_dio_cmd_info,
        #else
        ._cmd_info           = &nsc_sio_cmd_info,
        #endif
    #endif
    },{
        .man_id              = MID_XTX,
        .dev_id              = DID_XT26G02B,
        ._num_block          = SNAF_MODEL_NUM_BLK_2048,
        ._num_page_per_block = SNAF_MODEL_NUM_PAGE_64,
        ._page_size          = SNAF_MODEL_PAGE_SIZE_2048B,
        ._spare_size         = SNAF_MODEL_SPARE_SIZE_64B,
        ._oob_size           = SNAF_MODEL_OOB_SIZE(24),
        ._ecc_ability        = ECC_MODEL_6T,
    #if __DEVICE_REASSIGN
        ._ecc_encode         = VZERO,
        ._ecc_decode         = VZERO,
        ._reset              = VZERO,
        ._cmd_info           = VZERO,
        ._model_info         = VZERO,
    #else
        ._ecc_encode         = ecc_encode_bch,
        ._ecc_decode         = ecc_decode_bch,
        ._reset              = nsu_reset_spi_nand_chip,
        ._model_info         = &snaf_rom_general_model,
        #if __DEVICE_USING_QIO
        ._cmd_info           = &xtx_qio_cmd_info,
        #elif __DEVICE_USING_DIO
        ._cmd_info           = &nsc_dio_cmd_info,
        #else
        ._cmd_info           = &nsc_sio_cmd_info,
        #endif
    #endif
    },{
        .man_id              = MID_XTX,
        .dev_id              = DID_XT26G01C,
        ._num_block          = SNAF_MODEL_NUM_BLK_1024,
        ._num_page_per_block = SNAF_MODEL_NUM_PAGE_64,
        ._page_size          = SNAF_MODEL_PAGE_SIZE_2048B,
        ._spare_size         = SNAF_MODEL_SPARE_SIZE_64B, // another 64B for internal ECC
        ._oob_size           = SNAF_MODEL_OOB_SIZE(62),
        ._ecc_ability        = ECC_USE_ODE,
    #if __DEVICE_REASSIGN
        ._ecc_encode         = VZERO,
        ._ecc_decode         = VZERO,
        ._reset              = VZERO,
        ._cmd_info           = VZERO,
        ._model_info         = VZERO,
    #else
        ._ecc_encode         = xtx_ecc_encode,
        ._ecc_decode         = xtx_ecc_decode_8bit,
        ._reset              = nsu_reset_spi_nand_chip,
        ._model_info         = &snaf_ode_general_model,
        #if __DEVICE_USING_QIO
        ._cmd_info           = &xtx_qio_cmd_info,
        #elif __DEVICE_USING_DIO
        ._cmd_info           = &nsc_dio_cmd_info,
        #else
        ._cmd_info           = &nsc_sio_cmd_info,
        #endif
    #endif
    },{
        .man_id              = MID_XTX,
        .dev_id              = DID_XT26G02C,
        ._num_block          = SNAF_MODEL_NUM_BLK_2048,
        ._num_page_per_block = SNAF_MODEL_NUM_PAGE_64,
        ._page_size          = SNAF_MODEL_PAGE_SIZE_2048B,
        ._spare_size         = SNAF_MODEL_SPARE_SIZE_64B, // another 64B for internal ECC
        ._oob_size           = SNAF_MODEL_OOB_SIZE(62),
        ._ecc_ability        = ECC_USE_ODE,
    #if __DEVICE_REASSIGN
        ._ecc_encode         = VZERO,
        ._ecc_decode         = VZERO,
        ._reset              = VZERO,
        ._cmd_info           = VZERO,
        ._model_info         = VZERO,
    #else
        ._ecc_encode         = xtx_ecc_encode,
        ._ecc_decode         = xtx_ecc_decode_8bit,
        ._reset              = nsu_reset_spi_nand_chip,
        ._model_info         = &snaf_ode_general_model,
        #if __DEVICE_USING_QIO
        ._cmd_info           = &xtx_qio_cmd_info,
        #elif __DEVICE_USING_DIO
        ._cmd_info           = &nsc_dio_cmd_info,
        #else
        ._cmd_info           = &nsc_sio_cmd_info,
        #endif
    #endif
    }
};
#endif // CONFIG_SPI_NAND_FLASH_INIT_FIRST

#if __DEVICE_USING_QIO
__SECTION_INIT_PHASE void
xtx_quad_enable(u32_t cs)
{
    u32_t feature_addr=0xB0;
    u32_t value = 1;
    value |= nsu_get_feature_reg(cs, feature_addr);
    nsu_set_feature_reg(cs, feature_addr, value);
}
#endif

__SECTION_INIT_PHASE void
xtx_enable_on_die_ecc(u32_t cs, u32_t fa)
{
    u32_t feature_addr=fa;
    u32_t value = nsu_get_feature_reg(cs, feature_addr);
    value &= ~(1<<4);
    nsu_set_feature_reg(cs, feature_addr,value);
}

__SECTION_INIT_PHASE void
xtx_disable_on_die_ecc(u32_t cs, u32_t fa)
{
    u32_t feature_addr=fa;
    u32_t value = nsu_get_feature_reg(cs, feature_addr);
    value &= ~(1<<4);
    nsu_set_feature_reg(cs, feature_addr,value);
}

__SECTION_INIT_PHASE u32_t
xtx_read_id(u32_t cs)
{
    u32_t dummy = 0x00;
    u32_t w_io_len = IO_WIDTH_LEN(SIO_WIDTH,CMR_LEN(2));
    u32_t r_io_len = IO_WIDTH_LEN(SIO_WIDTH,CMR_LEN(2));

    u32_t ret = nsu_read_spi_nand_id(cs, dummy, w_io_len, r_io_len);
    return ((ret>>16)&0xFFFF);
}


#ifdef CONFIG_SPI_NAND_FLASH_INIT_FIRST
__SECTION_INIT_PHASE spi_nand_flash_info_t *
probe_xtx_spi_nand_chip(void)
{
    nsu_reset_spi_nand_chip(0);
    u32_t rdid = xtx_read_id(0);

    if(MID_XTX != (rdid>>8)) return VZERO;

    u16_t did8  = rdid&0xFF;
    u32_t i;
    for(i=0 ; i<ELEMENT_OF_SNAF_INFO(xtx_chip_info) ; i++){
        if(xtx_chip_info[i].dev_id == did8)
        {
            u32_t ecc_conf_addr = 0xB0;
            #if __DEVICE_REASSIGN
                #if __DEVICE_USING_QIO
                xtx_chip_info[i]._cmd_info = &xtx_qio_cmd_info;
                #elif __DEVICE_USING_DIO
                xtx_chip_info[i]._cmd_info = _nsu_dio_cmd_info_ptr;
                #else
                xtx_chip_info[i]._cmd_info = _nsu_cmd_info_ptr;
                #endif
                xtx_chip_info[i]._model_info= &nsu_model_info;
                xtx_chip_info[i]._reset     = _nsu_reset_ptr;
                if (DID_XT26G02B == xtx_chip_info[i].dev_id) { ecc_conf_addr = 0x90; }
                if(ECC_USE_ODE==xtx_chip_info[i]._ecc_ability) {
                    nsu_model_info._page_read_ecc  = _nsu_page_read_with_ode_ptr;
                    nsu_model_info._page_write_ecc = _nsu_page_write_with_ode_ptr;
                    xtx_chip_info[i]._ecc_encode = xtx_ecc_encode;
                    if (DID_XT26G01B == xtx_chip_info[i].dev_id) {
                        xtx_chip_info[i]._ecc_decode = xtx_ecc_decode_8bit_1B;
                    } else {
                        xtx_chip_info[i]._ecc_decode = xtx_ecc_decode_8bit;
                    }
                } else {
                    xtx_chip_info[i]._ecc_encode = _nsu_ecc_encode_ptr;
                    xtx_chip_info[i]._ecc_decode = _nsu_ecc_decode_ptr;
                }
            #endif
            if(ECC_USE_ODE==xtx_chip_info[i]._ecc_ability) {
                xtx_enable_on_die_ecc(0, ecc_conf_addr);
            } else {
                xtx_disable_on_die_ecc(0, ecc_conf_addr);
            }

            #if __DEVICE_USING_QIO
            xtx_quad_enable(0);
            #endif

            nsu_block_unprotect(0);

            return &xtx_chip_info[i];
        }
    }
    return VZERO;
}
REG_SPI_NAND_PROBE_FUNC(probe_xtx_spi_nand_chip);
#endif   // CONFIG_SPI_NAND_FLASH_INIT_FIRST
#ifdef CONFIG_SPI_NAND_FLASH_INIT_REST
int
xtx_init_rest(void)
{
    u32_t cs=1;
    u32_t ecc_conf_addr = 0xB0;
    // check ID, cs0 and cs1 should be identical
    u32_t rdid = xtx_read_id(cs);
    if(((rdid>>8)!=MID_XTX) || ((rdid&0xFF)!=_spi_nand_info->dev_id))
      { return 0; }

    // reset
    nsu_reset_spi_nand_chip(cs);

    if (DID_XT26G02B == _spi_nand_info->dev_id) { ecc_conf_addr = 0x90; }

    if(ECC_USE_ODE==_spi_nand_info->_ecc_ability){
        xtx_enable_on_die_ecc(0, ecc_conf_addr);
    } else {
        xtx_disable_on_die_ecc(0, ecc_conf_addr);
    }

    #if __DEVICE_USING_QIO
    xtx_quad_enable(cs);
    #endif
    nsu_block_unprotect(cs);

    return 1;
}
REG_SPI_NAND_INIT_REST_FUNC(xtx_init_rest);
#endif // CONFIG_SPI_NAND_FLASH_INIT_REST


