#!/usr/bin/env bash
set -euo pipefail
SCRIPT_PWD="$(cd "$(dirname "${BASH_SOURCE[0]}")" >/dev/null && pwd)"

BOOTLOADERS=(
"mips|tsw2|swm2"
)

for BOOTLOADER in "${BOOTLOADERS[@]}"; do
	export TMPL_ARCH="${BOOTLOADER%%|*}"
	export TMPL_BOOTLOADER="${BOOTLOADER##*|}"

	perl -p -e 's/\$\{\@([A-Z0-9_]+)\@\}/defined $ENV{$1} ? $ENV{$1} : $&/eg' < "${SCRIPT_PWD}/bootloader_ci_template.yml" > "${SCRIPT_PWD}/${TMPL_BOOTLOADER}.yml"
done
