#!/bin/ash

. /lib/functions.sh
. /usr/share/libubox/jshn.sh

ucidef_add_port_security_capabilities() {
	local guest_vlan=$1
	local fallback_vlan=$2
	local isolation_method="$3"
	json_add_object "port_security"
	json_add_boolean guest_vlan $guest_vlan
	json_add_boolean fallback_vlan $fallback_vlan
	json_add_string isolation_method "$isolation_method"
	json_close_object

}

ucidef_set_sfp_ports() {
	local lan_list
	lan_list=$(ls -1 -v -d /sys/class/net/port* /sys/class/net/sfp* | xargs -n1 basename | xargs)
	json_add_array "sfp_ports"
	for lan in $lan_list; do
		[[ "$(ethtool -m $lan 2>&1)" != *"Not supported"* ]] && json_add_string "" "$lan"
	done
	json_close_array
}

ucidef_set_port() {
	local network=$1; shift

	[ -z "$network" ] && return

	json_select_object network
	json_select_object "$network"

	while [ -n "$1" ]; do
		local opt=$1; shift
		local val=$1; shift

		[ -n "$opt" ] && [ -n "$val" ] || break

		[ "$opt" = "device" ] && [ "$val" != "${val/ //}" ] && {
			json_select_array "ports"
			json_add_object ""
			for e in $val; do
				local k="${e%%:*}"
				local v="${e##*:}"

				[ -n "$k" ] && [ -n "$v" ] || continue

				if [ "$v" -eq "$val" ] 2>/dev/null; then
					json_add_int "$k" "$v"
				elif [ "$v" = "true" ]; then
					json_add_boolean "$k" 1
				elif [ "$v" = "false" ]; then
					json_add_boolean "$k" 0
				else
					json_add_string "$k" "$v"
				fi
			done
			json_close_object
			json_close_array
		} || {
			json_add_string "$opt" "$val"
		}
	done

	if ! json_is_a protocol string; then
		case "$network" in
			lan | mgmt) json_add_string protocol static ;;
			wan) json_add_string protocol dhcp ;;
			*) json_add_string protocol none ;;
		esac
	fi

	json_select ..
	json_select ..
}

ucidef_set_hwinfo() {
	local args=" $* "
	local options='
	ethernet
	sfp_port
	sfp_switch
	poe
	switch
	ios
	'

	json_select_object hwinfo

	for opt in $options; do
		if [[ "$args" =~ " $(echo "$opt" | tr -d '\011\012\015\040') " ]]; then
			json_add_boolean "$opt" 1
		else
			json_add_boolean "$opt" 0
		fi
	done

	json_select ..
}

ucidef_set_release_version() {
	json_add_string release_version "$1"
}
