#
# Copyright (C) 2023 Teltonika-Networks
#

# export Kconfig option to CPPFLAGS
# 1 -> Kconfig option name
# 2 -> define option name (optional)
define export_feature
TARGET_CPPFLAGS+=$(if $(value $1),-D$(if $(2),$(2),$(subst CONFIG_,,$(1))))
endef

# export TLT_PLATFORM_<device_name> variable
# device name is taken from device shortname and converted into all-capital letters
# additionally double `x` letters are removed (tsw2xx becomes tsw2)
# note: this variable is deprecated
TLT_DEV_NAME:=$(call toupper,$(subst xx,,$(call device_shortname)))
export TLT_PLATFORM_$(TLT_DEV_NAME):=y

# export TLT_PLATFORM_NAME variable
# it is based off the same variable used by TLT_PLATFORM_<device_name>
# note: this variable is deprecated
export TLT_PLATFORM_NAME:=$(TLT_DEV_NAME)

TARGET_CFLAGS += -D$(TLT_PLATFORM_NAME)_PLATFORM
TARGET_CPPFLAGS += -D$(TLT_PLATFORM_NAME)_PLATFORM

$(eval $(call export_feature,CONFIG_SWITCH_DEVICE))
$(eval $(call export_feature,CONFIG_IO_SUPPORT))
