#
# Copyright (C) 2025 Teltonika-Networks
#

# Ethernet common
HW_ETH_SPEED_100:=10/100 Mbps
HW_ETH_SPEED_1000:=10/100/1000 Mbps
HW_ETH_SPEED_2500:=100/1000/2500 Mbps
HW_ETH_RJ45_PORTS:=x RJ45 ports
HW_ETH_RJ45_PORT:=x RJ45 port
HW_ETH_ETH_PORT:=x ETH port
HW_ETH_ETH_PORTS:=x ETH ports
HW_ETH_SFP_PORT:=x SFP port
HW_ETH_SFP_PORTS:=x SFP ports

# Physical interfaces
HW_INTERFACE_RESET:=Reboot/Reset
HW_INTERFACE_POWER_2PIN:=1 x 2-pin power connector
HW_INTERFACE_POWER_4PIN:=1 x 4-pin power connector
HW_INTERFACE_POWER_16PIN:=1 x 16-pin terminal block

# Physical specifications
HW_PHYSICAL_HOUSING_AL:=Aluminium housing
HW_PHYSICAL_HOUSING_AL_PL:=Aluminium housing, plastic panels
HW_PHYSICAL_HOUSING_AND_PANELS_AL:=Anodized aluminum housing and panels
HW_PHYSICAL_HOUSING_STEEL:=Full steel housing
HW_PHYSICAL_HOUSING_UV_PLASTIC:=UV stabilized plastic
HW_PHYSICAL_MOUNTING:=DIN rail, flat surface placement
HW_PHYSICAL_MOUNTING_KIT:=DIN rail, wall mount, flat surface (all require additional kit)
HW_PHYSICAL_MOUNTING_KIT_INTEGRATED_DIN := Integrated DIN rail bracket; wall mount and flat surface (additional kit needed)
HW_PHYSICAL_MOUNTING_RACK:=Rack mounting kit

# Operating environment
HW_OPERATING_TEMP:=-40 °C to 75 °C
HW_OPERATING_HUMIDITY:=5% to 95% non-condensing
HW_OPERATING_PROTECTION_IP30:=IP30
HW_OPERATING_PROTECTION_IP55:=IP55

# RAM parameters
HW_RAM_TYPE_DDR2:=DDR2
HW_RAM_TYPE_DDR3:=DDR3
HW_RAM_TYPE_DDR4:=DDR4
HW_RAM_SIZE_64M:=64 MB
HW_RAM_SIZE_128M:=128 MB
HW_RAM_SIZE_256M:=256 MB
HW_RAM_SIZE_512M:=512 MB
HW_RAM_SIZE_1G:=1 GB

# Poe standards
HW_POE_STD_80203AF:=802.3af PoE Class 1
HW_POE_STD_80203AT:=802.03at

# Flash parameters
HW_FLASH_SIZE_16M:=16 MB
HW_FLASH_SIZE_32M:=32 MB
HW_FLASH_SIZE_128M:=128 MB
HW_FLASH_SIZE_256M:=256 MB
HW_FLASH_SIZE_512M:=512 MB
HW_FLASH_SIZE_8G:=8 GB
HW_FLASH_TYPE_NOR:=NOR Flash
HW_FLASH_TYPE_SPI:=SPI Flash
HW_FLASH_TYPE_NOR_SERIAL:=serial NOR flash
HW_FLASH_TYPE_NAND_SERIAL:=serial NAND flash
HW_FLASH_TYPE_SERIAL:=serial flash
HW_FLASH_TYPE_EMMC:=eMMC Flash

# Power connector
HW_POWER_CONNECTOR_16PIN:=2-pin in 16-pin industrial terminal block
HW_POWER_CONNECTOR_2PIN:=2-pin industrial DC power socket
HW_POWER_CONNECTOR_3PIN:=3-pin industrial DC power socket
HW_POWER_CONNECTOR_4PIN:=4-pin industrial DC power socket
HW_POWER_CONNECTOR_3TERMINAL:=3-pos plugable terminal block

# Ethernet standards
HW_ETH_STANDARD:=802.3i, 802.3u, 802.3ab, 802.3x, 802.3z

# Emissions & imunity
HW_IMUNITY_EMISION_CS:=EN 61000-4-6:2014
HW_IMUNITY_EMISION_DIP:=EN 61000-4-11:2020
HW_IMUNITY_EMISION_EFT:=EN 61000-4-4:2012
HW_IMUNITY_EMISION_SURGE:=EN 61000-4-5:2014 + A1:2017
HW_IMUNITY_EMISION_ESD:=EN 61000-4-2:2009
HW_IMUNITY_EMISION_RI:=EN IEC 61000-4-3:2020

# Emissions & immunity - standards
HW_EI_STANDARDS_EN_55032:=EN 55032:2015 + A11:2020 + A1:2020
HW_EI_STANDARDS_EN_55035:=EN 55035:2017 + A11:2020
HW_EI_STANDARDS_EN_IEC_61000-3-2:=EN IEC 61000-3-2:2019 + A1:2021
HW_EI_STANDARDS_EN_61000-3-3:=EN 61000-3-3:2013 + A1:2019 + A2:2021
HW_EI_STANDARDS_EN_301_489-1_V2.2.3:=EN 301 489-1 V2.2.3
HW_EI_STANDARDS_EN_301_489-17_V3.2.4:=EN 301 489-17 V3.2.4
HW_EI_STANDARDS_EN_301_489-52_V1.2.1:=EN 301 489-52 V1.2.1
HW_EI_STANDARDS_EN_IEC_61000-3-2:=EN IEC 61000-3-2:2019

# Safety standards
HW_SAFETY_EN_IEC_62368-1:=EN IEC 62368-1:2020 + A11:2020
HW_SAFETY_EN_IEC_62311:=EN IEC 62311:2020
HW_SAFETY_EN_5066:=EN 50665:2017
HW_SAFETY_AS/NZS_62368:=AS/NZS 62368.1:2022
HW_SAFETY_IEC_62368-1:=IEC 62368-1:2018
HW_SAFETY_IEC_60068-2-6:=IEC 60068-2-6:2007 Environmental testing - Part 2-6
HW_SAFETY_IEC_60068-2-27:=IEC 60068-2-27:2008 Environmental testing - Part 2-27
HW_SAFETY_IEC_60068-2-31:=IEC 60068-2-31:2008 Environmental testing - Part 2-31

# RF standards
HW_RF_EN_300_328_V2.2.2:=EN 300 328 V2.2.2
HW_RF_EN_301_511_V12.5.1:=EN 301 511 V12.5.1
HW_RF_EN_301_908-1_V15.2.1:=EN 301 908-1 V15.2.1
HW_RF_EN_301_908-2_V13.1.1:=EN 301 908-2 V13.1.1
HW_RF_EN_301_908-13-V13.1.1:=EN 301 908-13 V13.1.1
HW_RF_EN_301_908-1_V15.1.1:=EN 301 908-1 V15.1.1
HW_RF_EN_301_908-13_V13.2.1:=EN 301 908-13 V13.2.1

# PoE (passive) power options
HW_POWER_POE_PASSIVE_30V:= Possibility to power up through ETH1 ports, not compatible with IEEE802.3af, 802.3at and 802.3bt standards, Mode B, 9 - 30 VDC
