# Firmware Building And Installation

## Prerequisites

	Make sure you're running a supported Linux distribution.
	We recommend using Ubuntu 20.04 LTS (http://www.ubuntu.com/download/desktop).
	You might succeed with other distributions.

	It is recommended to use Docker environment to build RUTOS firmware which
	is accessible from "TSW2_R_GPL_00.01.07.1/scripts/dockerbuild".

## Building with Docker environment

	1. Install Docker (https://docs.docker.com/engine/install/ubuntu).

	2. Extract the GPL archive to an empty folder

		$ mkdir TSW2_R_GPL_00.01.07.1
		$ tar -xzf ~/Downloads/TSW2_R_GPL_00.01.07.1.tar.gz -C TSW2_R_GPL_00.01.07.1

	3. Update feeds

		$ cd TSW2_R_GPL_00.01.07.1
		$ ./scripts/dockerbuild ./scripts/feeds update -a

	4. Build the image

		$ ./scripts/dockerbuild make

	5. Sign the image with local keys (optional):

		This step is only necessary if the firmware needs to be flashed
		from the bootloader.

		$ ./scripts/dockerbuild make sign

## Building with Host OS

	1. Install NodeJS v20 (or newer) and NPM v10.5 (or newer).

		Please follow NodeJS and NPM installation guides for your distribution.

		Third-party helpers such as "nvm" (https://github.com/nvm-sh/nvm) or "n" (https://github.com/tj/n) can be used to manage multiple NodeJS and NPM versions on the system.

	2. Install required packages

		$ sudo apt update
		$ sudo apt install build-essential ccache ecj fastjar file flex g++ gawk \
			gettext git java-propose-classpath java-wrappers jq libelf-dev \
			libffi-dev libncurses5-dev libncursesw5-dev libssl-dev libsqlite3-dev \
			libtool python3 python3-dev python3-distutils python3-setuptools rsync \
			subversion swig time u-boot-tools unzip wget xsltproc zlib1g-dev bison \
			libzstd-dev ninja-build

	3. Extract the GPL archive to an empty folder

		$ mkdir TSW2_R_GPL_00.01.07.1
		$ tar -xzf ~/Downloads/TSW2_R_GPL_00.01.07.1.tar.gz -C TSW2_R_GPL_00.01.07.1

	4. Update feeds

		$ cd TSW2_R_GPL_00.01.07.1
		$ ./scripts/feeds update -a

	5. Build the image

		$ make

	6. Sign the image with local keys (optional):

		This step is only necessary if the firmware needs to be flashed
		from the bootloader.

		$ make sign

## Installation

	After successful build you will get the firmware file in
		"TSW2_R_GPL_00.01.07.1/bin/targets/realtek/generic/tltFws".

	Update the new firmware via the web interface on your device.

# Profinet image configuration

	You can build image with Profinet enabled config.

	To set-up Profinet image you should remove the .config file and run menuconfig:

		$ rm .config
		$ make menuconfig

	Then, navigate to "Target Images" and select "Build Image with PROFINET support"

	After that, you can exit menuconfig, save the configuration, and build the image as stated in the previous steps.

	Note: if you're using dockerbuild, then run menuconfig through it as well:

		$ ./scripts/dockerbuild make menuconfig
