# SPDX-License-Identifier: GPL-2.0-only

include devices/tsw1xx_family.mk
include devices/tsw2xx_family.mk
include devices/swm2xx_family.mk

define Device/teltonika_tsw2xx
  DEVICE_MODEL := TSW2XX
  DEVICE_BOOT_NAME := tsw2xx
  DEVICE_DTS := rtl8380_teltonika_tsw2xx
  DEVICE_FEATURES := ledman-lite ios

  SOC := rtl8380
  IMAGE_SIZE := 15168k

  SUPPORTED_DEVICES := teltonika,tsw2XX

  INCLUDED_DEVICES := \
    TEMPLATE_teltonika_tsw200 \
    TEMPLATE_teltonika_tsw202 \
    TEMPLATE_teltonika_tsw210 \
    TEMPLATE_teltonika_tsw212 \
    TEMPLATE_teltonika_tsw213
endef

define Device/teltonika_tsw1xx
  DEVICE_MODEL := TSW1XX
  DEVICE_BOOT_NAME := tsw1xx
  DEVICE_DTS :=

  SUPPORTED_DEVICES := teltonika,tsw1XX

  INCLUDED_DEVICES := \
    TEMPLATE_teltonika_tsf010 \
    TEMPLATE_teltonika_tsw010 \
    TEMPLATE_teltonika_tsw030 \
    TEMPLATE_teltonika_tsw040 \
    TEMPLATE_teltonika_tsw100 \
    TEMPLATE_teltonika_tsw101 \
    TEMPLATE_teltonika_tsw110 \
    TEMPLATE_teltonika_tsw114 \
    TEMPLATE_teltonika_tsw304
endef

define Device/teltonika_swm2xx
  DEVICE_MODEL := SWM2XX
  DEVICE_BOOT_NAME := swm2xx
  DEVICE_DTS := rtl8382_teltonika_swm2xx

  DEVICE_INITIAL_FIRMWARE_SUPPORT := 1.2

  SOC := rtl8382
  UBOOT_SIZE := 786432
  IMAGE_SIZE := 14912k

  DEVICE_FEATURES := fan
  #DEVICE_FEATURES += tpm

  INCLUDED_DEVICES := \
    TEMPLATE_teltonika_swm280 \
    TEMPLATE_teltonika_swm281 \
    TEMPLATE_teltonika_swm282
endef
TARGET_DEVICES += teltonika_swm2xx
