include $(INCLUDE_DIR)/hardware.mk

define Device/teltonika_tsw2xx_common
	HARDWARE/Ethernet/Port := 8 $(HW_ETH_ETH_PORTS)
	HARDWARE/Ethernet/Speed := $(HW_ETH_SPEED_1000)
	HARDWARE/Ethernet/Standard := $(HW_ETH_STANDARD)
	HARDWARE/Fibre/Port := 2 $(HW_ETH_SFP_PORTS)
	HARDWARE/System_Characteristics/CPU := Realtek, single core, 500MHz, MIPS-4KEc
	HARDWARE/System_Characteristics/RAM := $(HW_RAM_SIZE_128M), $(HW_RAM_TYPE_DDR3)
	HARDWARE/System_Characteristics/Flash_Storage := $(HW_FLASH_SIZE_16M), $(HW_FLASH_TYPE_SERIAL)
	TECHNICAL/Power/Connector := $(HW_POWER_CONNECTOR_2PIN)
	TECHNICAL/Power/Input_Voltage_Range := 7–57 VDC
	TECHNICAL/Physical_Interfaces/Ethernet := 8 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_1000)
	TECHNICAL/Physical_Interfaces/Fibre := 2 $(HW_ETH_SFP_PORT)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 1 x Aux LED, 16 x ETH status LEDs, 2 x SFP status LEDs
	TECHNICAL/Physical_Interfaces/Power := $(HW_INTERFACE_POWER_2PIN)
	TECHNICAL/Physical_Interfaces/Reset := $(HW_INTERFACE_RESET)
	TECHNICAL/Physical_Specification/Casing_Material := $(HW_PHYSICAL_HOUSING_AND_PANELS_AL)
	TECHNICAL/Physical_Specification/Mounting_Options := $(HW_PHYSICAL_MOUNTING_KIT)
	TECHNICAL/Physical_Specification/Dimensions := 132 x 44.2 x 122.2 mm
	TECHNICAL/Operating_Environment/Operating_Temperature := $(HW_OPERATING_TEMP)
	TECHNICAL/Operating_Environment/Operating_Humidity := $(HW_OPERATING_HUMIDITY)
	TECHNICAL/Operating_Environment/Ingress_Protection_Rating := $(HW_OPERATING_PROTECTION_IP30)
	REGULATORY/EMC_Emissions_&_Immunity/Standards := $(HW_EI_STANDARDS_EN_55032); $(HW_EI_STANDARDS_EN_55035); \
		$(HW_EI_STANDARDS_EN_IEC_61000-3-2); $(HW_EI_STANDARDS_EN_61000-3-3)
	REGULATORY/EMC_Emissions_&_Immunity/ESD := $(HW_IMUNITY_EMISION_ESD)
	REGULATORY/EMC_Emissions_&_Immunity/Radiated_Immunity := $(HW_IMUNITY_EMISION_RI)
	REGULATORY/EMC_Emissions_&_Immunity/EFT := $(HW_IMUNITY_EMISION_EFT)
	REGULATORY/EMC_Emissions_&_Immunity/Surge_Immunity_(AC_Mains_Power_Port) := $(HW_IMUNITY_EMISION_SURGE)
	REGULATORY/EMC_Emissions_&_Immunity/CS := $(HW_IMUNITY_EMISION_CS)
	REGULATORY/EMC_Emissions_&_Immunity/DIP := $(HW_IMUNITY_EMISION_DIP)
	REGULATORY/Safety/Standards := CE: $(HW_SAFETY_EN_IEC_62368-1); RCM: $(HW_SAFETY_AS/NZS_62368); CB: $(HW_SAFETY_IEC_62368-1)
endef

define Device/template_tsw2xx
	$(Device/teltonika_tsw2xx)

	DEVICE_FEATURES := ledman-lite ethernet sfp_port sfp_switch switch
endef

define Device/TEMPLATE_teltonika_tsw200
	$(Device/teltonika_tsw2xx_common)
	$(Device/teltonika_tsw2xx)
	DEVICE_MODEL := TSW200

	DEVICE_FEATURES :=

	HARDWARE/System_Characteristics/CPU :=
	HARDWARE/System_Characteristics/RAM :=
	HARDWARE/System_Characteristics/Flash_Storage :=
	TECHNICAL/PoE_Out/PoE_Ports := Port 1 - 8
	TECHNICAL/PoE_Out/PoE_Standards := 802.3af and 802.3at Alternative A (From batch 42); 802.3af and 802.3at Alternative B (From batch 1-41)
	TECHNICAL/PoE_Out/PoE_Max_Power_per_Port_(at_PSE) := 30 W
	TECHNICAL/PoE_Out/Total_PoE_Power_Budget_(at_PSE) := 240 W
	TECHNICAL/Physical_Specification/Dimensions := 132 x 44.2 x 95.1 mm
	TECHNICAL/Power/PoE\-out_Input_Voltage_Range := 44–57 VDC
	TECHNICAL/Power/Power_Consumption := Idle: 1.81 W / Max: 5.5 W / PoE Max: 245.5 W
	TECHNICAL/Physical_Specification/Weight := 517 g
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, CITC, ANRT, FCC, IC, CB
	REGULATORY/Safety/Standards := $(HW_SAFETY_IEC_62368-1) $(HW_SAFETY_EN_IEC_62368-1)
endef

define Device/TEMPLATE_teltonika_tsw202
	$(Device/teltonika_tsw2xx_common)
	$(Device/teltonika_tsw2xx)
	DEVICE_MODEL := TSW202

	DEVICE_FEATURES += poe

	TECHNICAL/PoE_Out/PoE_Ports := Port 1 - 8
	TECHNICAL/PoE_Out/PoE_Standards := 802.3af and 802.3at Alternative A (From batch 42); 802.3af and 802.3at Alternative B (From batch 1-41)
	TECHNICAL/PoE_Out/PoE_Max_Power_per_Port_(at_PSE) := 30 W
	TECHNICAL/PoE_Out/Total_PoE_Power_Budget_(at_PSE) := 240 W
	TECHNICAL/Power/PoE\-out_Input_Voltage_Range := 44–57 VDC
	TECHNICAL/Power/Power_Consumption := Idle < 3 W, Max 8 W, PoE Max 248 W
	TECHNICAL/PoE_Out/Maximum_Ethernet_cable_length := 100 m
	TECHNICAL/Physical_Specification/Weight := 610 g
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, RCM, ANRT, FCC, IC, CB, NBTC, PROFINET, CITC, RoHS, REACH, WEEE, SDPPI (POSTEL), JATE, Kenya, ICASA, Giteki, UL Safety
endef

define Device/TEMPLATE_teltonika_tsw210
	$(Device/teltonika_tsw2xx_common)
	$(Device/teltonika_tsw2xx)
	DEVICE_MODEL := TSW210

	DEVICE_FEATURES :=

	HARDWARE/System_Characteristics/CPU :=
	HARDWARE/System_Characteristics/RAM :=
	HARDWARE/System_Characteristics/Flash_Storage :=
	TECHNICAL/Physical_Specification/Dimensions := 132 x 44.2 x 95.1 mm
	TECHNICAL/Power/Power_Consumption := Idle: ~1.03 W / Max: 3.71 W
	TECHNICAL/Physical_Specification/Weight := 500 g
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, CITC, ANRT, FCC, IC, RCM, CB, EAC, Kenya, NOM, UL/CSA, Japan, SDPPI (POSTEL)
	REGULATORY/Safety/Standards := $(HW_SAFETY_IEC_62368-1) $(HW_SAFETY_EN_IEC_62368-1)
	REGULATORY/Safety_(Hazardous_Locations)/Standards := UL 62368-1; CAN/CSA C22.2 No. 62368-1-19;
endef

define Device/TEMPLATE_teltonika_tsw212
	$(Device/teltonika_tsw2xx_common)
	$(Device/teltonika_tsw2xx)
	DEVICE_MODEL := TSW212

	TECHNICAL/Power/Power_Consumption := Idle < 2.5 W, Max: 6 
	TECHNICAL/Physical_Specification/Weight := 615 g
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, RCM, ANRT, FCC, IC, CB, WEEE, RoHS, REACH, SDPPI (POSTEL), JATE, Kenya, ICASA, Giteki, NBCT, ICASA, PROFINET, UL Safety
endef

define Device/TEMPLATE_teltonika_tsw213
	$(Device/teltonika_tsw2xx_common)
	$(Device/teltonika_tsw2xx)
	DEVICE_MODEL := TSW213

	DEVICE_FEATURES += ios

	TECHNICAL/Power/Power_Consumption := Idle < 2.5 W, Max: 6 
	TECHNICAL/Physical_Specification/Weight := 615 g
	REGULATORY/Regulatory_&_Type_Approvals/Regulatory := CE, UKCA, RCM, ANRT, FCC, IC, CB, WEEE, RoHS, REACH, SDPPI (POSTEL), JATE, Kenya, ICASA, Giteki, NBCT, ICASA, PROFINET, UL Safety
endef
