include $(INCLUDE_DIR)/hardware.mk

define Device/teltonika_swm2xx_common
	HARDWARE/Ethernet/Port := 28 $(HW_ETH_ETH_PORTS)
	HARDWARE/Ethernet/Speed := $(HW_ETH_SPEED_1000)
	HARDWARE/Ethernet/Standard := $(HW_ETH_STANDARD)
	HARDWARE/Fibre/Port := 4 $(HW_ETH_SFP_PORTS)
	HARDWARE/System_Characteristics/CPU := Realtek, single core, 500MHz, MIPS-4KEc
	HARDWARE/System_Characteristics/RAM := $(HW_RAM_SIZE_128M), $(HW_RAM_TYPE_DDR3)
	HARDWARE/System_Characteristics/Flash_Storage := $(HW_FLASH_SIZE_16M), $(HW_FLASH_TYPE_SERIAL)
	TECHNICAL/Power/Connector := C14 connector
	TECHNICAL/Power/Input_Voltage_Range := 100 - 230 VAC
	TECHNICAL/Physical_Interfaces/Ethernet := 28 $(HW_ETH_RJ45_PORTS), $(HW_ETH_SPEED_1000)
	TECHNICAL/Physical_Interfaces/Fibre := 1 $(HW_ETH_SFP_PORT)
	TECHNICAL/Physical_Interfaces/Status_Leds := 1 x Power LED, 48 x ETH status LEDs, 4 x SFP status LEDs
	TECHNICAL/Physical_Interfaces/Power := C14 connector (Power)
	TECHNICAL/Physical_Interfaces/Reset := $(HW_INTERFACE_RESET)
	TECHNICAL/Physical_Specification/Casing_Material := $(HW_PHYSICAL_HOUSING_AL)
	TECHNICAL/Physical_Specification/Mounting_Options := U1 Rack
	TECHNICAL/Physical_Specification/Dimensions := 483 x 44 x 234mm
	TECHNICAL/Operating_Environment/Operating_Temperature := 0 °C to 50 °C
	TECHNICAL/Operating_Environment/Operating_Humidity := 10% to 90% non-condensing
	TECHNICAL/Operating_Environment/Ingress_Protection_Rating := $(HW_OPERATING_PROTECTION_IP30)
endef

define Device/template_swm2xx
	$(Device/teltonika_swm2xx)

	DEVICE_FEATURES := fan ethernet sfp_port sfp_switch switch
endef

define Device/TEMPLATE_teltonika_swm280
	$(Device/teltonika_swm2xx_common)
	$(Device/template_swm2xx)
	DEVICE_MODEL := SWM280

	DEVICE_FEATURES += poe

	TECHNICAL/Power/Power_Consumption := Idle <7.5 W, Max 8 W, PoE Max 325 W
	TECHNICAL/Physical_Specification/Weight := 1770g
	TECHNICAL/PoE_Out/PoE_Ports := Port 1 - 12
	TECHNICAL/PoE_Out/PoE_Standards := 12 x 802.3af/at compliant PSE ports, Alternative A (PoE Max Power per Port -30W), 1-12 ETH Ports
	TECHNICAL/PoE_Out/PoE_Max_Power_per_Port_(at_PSE) := 30 W
	TECHNICAL/PoE_Out/Total_PoE_Power_Budget_(at_PSE) := 300 W
	TECHNICAL/PoE_Out/Maximum_Ethernet_cable_length := 100 m
endef
TARGET_DEVICES += TEMPLATE_teltonika_swm280

define Device/TEMPLATE_teltonika_swm281
	$(Device/teltonika_swm2xx_common)
	$(Device/template_swm2xx)
	DEVICE_MODEL := SWM281

	TECHNICAL/Power/Power_Consumption := Idle <5.5 W, Max 8 W, PoE Max 20 W
	TECHNICAL/Physical_Specification/Weight := 1430g
endef
TARGET_DEVICES += TEMPLATE_teltonika_swm281

define Device/TEMPLATE_teltonika_swm282
	$(Device/teltonika_swm2xx_common)
	$(Device/template_swm2xx)
	DEVICE_MODEL := SWM282

	DEVICE_FEATURES += poe

	TECHNICAL/Power/Power_Consumption := Idle <9 W, Max 8 W, PoE Max 330 W
	TECHNICAL/Physical_Specification/Weight := 1770g
	TECHNICAL/PoE_Out/PoE_Ports := Port 1 - 24
	TECHNICAL/PoE_Out/PoE_Standards := 24 x 802.3af/at compliant PSE ports, Alternative A (PoE Max Power per Port -30W), 1-24 ETH Ports
	TECHNICAL/PoE_Out/PoE_Max_Power_per_Port_(at_PSE) := 30 W
	TECHNICAL/PoE_Out/Total_PoE_Power_Budget_(at_PSE) := 300 W
	TECHNICAL/PoE_Out/Maximum_Ethernet_cable_length := 100 m
endef
TARGET_DEVICES += TEMPLATE_teltonika_swm282
