#ifndef I2C_RTL9300_H
#define I2C_RTL9300_H

#include <linux/i2c.h>

#define RTL9300_I2C_CTRL1			0x00
#define RTL9300_I2C_CTRL1_MEM_ADDR		8
#define RTL9300_I2C_CTRL1_SDA_OUT_SEL		4
#define RTL9300_I2C_CTRL1_GPIO8_SCL_SEL		3
#define RTL9300_I2C_CTRL1_RWOP			2
#define RTL9300_I2C_CTRL1_I2C_FAIL		1
#define RTL9300_I2C_CTRL1_I2C_TRIG		0

#define RTL9300_I2C_CTRL2			0x04
#define RTL9300_I2C_CTRL2_DRIVE_ACK_DELAY	20
#define RTL9300_I2C_CTRL2_CHECK_ACK_DELAY	16
#define RTL9300_I2C_CTRL2_READ_MODE		15
#define RTL9300_I2C_CTRL2_DEV_ADDR		8
#define RTL9300_I2C_CTRL2_DATA_WIDTH		4
#define RTL9300_I2C_CTRL2_MADDR_WIDTH		2
#define RTL9300_I2C_CTRL2_SCL_FREQ		0

#define RTL9300_I2C_DATA_WORD0			0x08

#define RTL9300_I2C_MST_GLB_CTRL		0x18

#define RTL9310_I2C_MST_IF_CTRL			0x00

#define RTL9310_I2C_MST_IF_SEL			0x04
#define RTL9310_I2C_MST_IF_SEL_GPIO_SCL_SEL	12

#define RTL9310_I2C_CTRL			0x08
#define RTL9310_I2C_CTRL_SCL_FREQ		30
#define RTL9310_I2C_CTRL_CHECK_ACK_DELAY	26
#define RTL9310_I2C_CTRL_DRIVE_ACK_DELAY	22
#define RTL9310_I2C_CTRL_SDA_OUT_SEL		18
#define RTL9310_I2C_CTRL_DEV_ADDR		11
#define RTL9310_I2C_CTRL_MADDR_WIDTH		9
#define RTL9310_I2C_CTRL_DATA_WIDTH		5
#define RTL9310_I2C_CTRL_READ_MODE		4
#define RTL9310_I2C_CTRL_RWOP			2
#define RTL9310_I2C_CTRL_I2C_FAIL		1
#define RTL9310_I2C_CTRL_I2C_TRIG		0

#define RTL9310_I2C_MEMADDR			0x0c

#define RTL9310_I2C_DATA			0x10

#define RTL9300_I2C_STD_FREQ		0
#define RTL9300_I2C_FAST_FREQ		1

struct rtl9300_i2c {
	void __iomem *base;
	u32 mst2_offset;
	struct device *dev;
	struct i2c_adapter adap;
	u8 bus_freq;
	u8 sda_num;			// SDA channel number
	u8 scl_num;			// SCL channel, mapping to master 1 or 2
};

#endif
