#!/usr/bin/env bash
export LANG=C
export LC_ALL=C
TOPDIR="$(cd "$(dirname "${BASH_SOURCE[0]}")/.." >/dev/null && pwd)"

get_config_val() {
	local file=$1
	local key=$2

	sed --quiet --regexp-extended --expression="s/^${key}=\"?([^\"]*)\"?/\1/p" "$file"
}

if [ -s "${TOPDIR}/gpl_version" ]; then
	profinet="$(get_config_val "${TOPDIR}/.config" CONFIG_BUILD_PROFINET)"
	read -r gpl_version < "${TOPDIR}/gpl_version"
	[ -n "$profinet" ] && gpl_version="${gpl_version%%_*}_PROFINET_${gpl_version#*_}"
	printf "%s" "${gpl_version}"
	exit 0
fi

exit 1