#ifndef UBUS_SERVER_H
#define UBUS_SERVER_H

#include <ev.h>
#include <linux/mrp_bridge.h>

#include <errno.h>
#include <net/if.h>
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>

#include "utils.h"
#include "print.h"

//#include "state_machine.h"

typedef enum {
	UBUS_ALARM_MANAGER_ROLE_OK	= 0x0000,
	UBUS_ALARM_MANAGER_ROLE_FAIL	= 0x8000,
	UBUS_ALARM_RING_CLOSED		= 0x0001,
	UBUS_ALARM_RING_OPEN		= 0x8001,
	UBUS_ALARM_MULTIPLE_MANAGERS_OK = 0x0003,
	UBUS_ALARM_MULTIPLE_MANAGERS	= 0x8003,
	UBUS_ALARM_DOMAIN_MISMATCH_OK	= 0x0004,
	UBUS_ALARM_DOMAIN_MISMATCH	= 0x8004,
} ring_alarm_t;

struct mrp_params {
	uint32_t ring_topo_conf_interval;
	uint32_t ring_topo_conf_max;
	uint32_t ring_test_conf_short;
	uint32_t ring_test_conf_interval;
	uint32_t ring_test_conf_max;
	uint32_t ring_test_conf_ext_max;
	uint32_t ring_link_conf_interval_up;
	uint32_t ring_link_conf_interval_down;
	uint32_t ring_link_conf_max;
};

int ubus_init();
void ubus_cleanup();
int ubus_notify_alarm(ring_alarm_t alarm, int ring_nr);

#endif // UBUS_SERVER_H
