# Media Redundancy Protocol

MRP is Layer 2 protocol based on ring topology and is designed to react deterministically on a single failure of a switch in the ring. 
MRP protocol is defined in IEC 62439-2 standard. MRP ring consists of nodes that are usully network devices ( switches, routers ). These nodes has ring role assigned to them. One of the role is Media Redundancy Manager (MRM). The function of a Manager is to observe and control ring topology in order to react to network failure. The MRM does that by sending MRM_Test frames on one ring port over the ring and receiving them from the ring over the other ring port, and vice versa in the other direction. The other nodes in the ring have the role of Media Redundancy Clients (MRC). An receives reconfiguration frames from MRM and can detect signal link changes on its ring ports. Theres also other roles defined in the standard, but for TSWOS only MRM and MRC will be manageble.

### Media Redundancy Manager

One ring port of the MRM shall be connected to a ring port of a MRC. The other port of that MRC shall be connected to a ring port of another MRC or to the second ring port of the MRM, thus forming a ring topology as show in the image below (Img. 1)


```plantuml
@startuml
skinparam linetype ortho

together {
    node "TSW202" <<Device>> as "dev1" {
        node "Manager" as "mrp1" {

        }
    }

    node "TSW202" <<Device>> as "dev2" {
        node "Client" as "mrp2" {

        }
    }

}
    node "TSW202" <<Device>> as "dev3" {
        node "Client" as "mrp3" {

        }
    }

dev2 -left- dev3
dev1 -up- dev2
dev1 -up- dev3

@enduml
```

As mentioned MRM sends MRP_Test frames at a confugured time period in both directions of the ring. It sets one ring port to FORWARDING state and other to BLOCKING state when MRM gets its own MRP_Test frames. Setting both rings ports to FORWARDING when it does not get the MRP_Test frames. Only one MRM can be initialized in the ring.

You can set TSW device to role MRM by selecting MRM from Role drop-down list

#### MRM State Machine

```plantuml
@startuml
[*] -> Power_On
Power_On -> AC_STAT1
AC_STAT1 -> AC_STAT1
AC_STAT1 -> PRM_UP
PRM_UP -> AC_STAT1
PRM_UP -> PRM_UP
PRM_UP -> CHK_RC
CHK_RO -> CHK_RC
CHK_RO -> CHK_RO
CHK_RC -> CHK_RO
CHK_RC -> CHK_RC
CHK_RC -> PRM_UP
@enduml
```

**Power_On**

Initialization - This state is very short and mrp_server does not state it. Usualy resources are alocated right after you create MRP objected

**AC_STATE1**

Startup state. MRP object waits for interface LINK_UP event on the primery ring port.

**PRM_UP (Primery Ring Port with Link Up)**

State in witch primery ring port has active link. In this state MRM starts to send MRP_Test packets froms its primery port.

**CHK_RO (Check Ring, Ring Open State)**

State has both ring ports with active link. In this state MRM send MRP_Test packets from both ring ports but MRM did not received them for a determined time.

**CHK_RC (Check Ring, Ring Closed State)**

State has both ring ports with active link. In this state MRM send MRP_Test packets from both ring ports and received them.

### Media Redundancy Client

MRC device forward MRP_Test frames received on one ring port to the other ring port and vise versa. If the MRC detects a failure or recovery of a ring port link, the MRC can notify the change by sending MRP_LinkChange frames through both of its ring ports. Each MRC also forward MRP_LinkChange, MRP_TopologyChange frames. MRC will clear its FDB if requested by MRP_TopologyChange frame.

MRC role can be set on TSW device by selectic role to MRC from Role drop-down list.

#### MRC State Machine

```plantuml
@startuml
[*] -> Power_On
Power_On -> AC_STAT1
AC_STAT1 -> AC_STAT1
AC_STAT1 -> DE_IDLE
DE_IDLE -> DE_IDLE
DE_IDLE -> AC_STAT1
DE_IDLE -> PT
PT -> PT
PT -> DE
PT -> PT_IDLE
DE -> DE
DE -> PT
DE -> DE_IDLE
DE -> AC_STAT1
PT_IDLE -> DE
PT_IDLE -> PT_IDLE
@enduml
```

**Power_On**

Initialization - This state is very short and mrp_server does not state it. Usualy resources are alocated right after you create MRP objected

**AC_STAT1**

Startup state. MRP object waits for interface LINK_UP event on one of the ring ports

**DE_IDLE (Data echange idle state)**

On this state one of the ring ports is active and its state is FORWARDING

**PT (Pass Through)**

Temporary state while signaling link change

**DE (Data echange)**

Temporary state while signaling link change

**PT_IDLE (Pass Through Idle state)**

This state shall be reached if both ring ports have a link and their port states are set to FORWARDING

### Frame structures

#### MRP PDU

| 2 bytes | 12 - 20 bytes | 20 bytes | ? | 2 bytes |
|---------|---------------|----------|---|---------|
| MRP_Version | MRP_Type      | MRP_Common| MRP_Option | MRP_End |

#### MRP_Type
##### MRP_Test frame
| 1 bytes | 1 bytes | 2 bytes | 6 bytes | 2 bytes | 2 bytes | 2 bytes | 4 bytes |
|---------|---------|---------|---------|---------|---------|---------|---------|
| Lenght  | Type  0x2 | MRP_Prio | MRP_SA | MRP_PortRole | MRP_RingState | MRP_Transition | MRP_TimeStamp |
##### MRP_Topology frame

| 1 byte | 1 byte | 2 bytes  | 6 bytes | 2 bytes      |
|--------|--------|----------|---------|--------------|
| Lenght | Type 0x3 | MRP_Prio | MRP_SA  | MRP_Interval |

##### MRP_LinkDown

| 1 byte | 1 byte | 6 bytes | 2 bytes      | 2 bytes      | 2 bytes     |
|--------|--------|---------|--------------|--------------|-------------|
| Lenght | Type 0x4 | MRP_SA  | MRP_PortRole | MRP_Interval | MRP_Blocked |

##### MRP_LinkUp

| 1 byte | 1 byte | 6 bytes | 2 bytes      | 2 bytes      | 2 bytes     |
|--------|--------|---------|--------------|--------------|-------------|
| Lenght | Type 0x5 | MRP_SA  | MRP_PortRole | MRP_Interval | MRP_Blocked |

#### Some Field Explanations
##### MRP_Version

Version of MRP protocol always 1 didn't change from 2010 standart

##### MRP_SequenceID

Indentifies duplication of generate MRP frames in the ring. Every request demands unique sequence number.

##### MRP_Prio

This is for MRA Automanager role. It is used in Voting process. So it is irelevent for now.

##### MRP_SA

MAC address of sending switch

##### MRP_PortRole

Specifies from what port packet was generated. 0x1 - Primery ring port 0x2 - Secondary ring port

##### MRP_RingState

Specifies state of the ring. 0x0 - ring is open, 0x1 - ring is closed

##### MRP_Interval

Interval for next topology change event in miliseconds

##### MRP_Transition

Number of transitions between ring open state and ring closed state. Used for monitoring purposes.

##### MRP_TimeStamp

Timestamp from local counter. Used to determine time of how much it took to MRP_Test frame to travel.

##### MRP_Blocked

0x0 - The MRC is not able to receive and forward MRP_Test
frames, MRP_LinkChange frames and
MRP_TopologyChange frames at a ring port whose port
state is BLOCKED

0x1 - The MRC is able to receive and forward MRP_Test frames,
MRP_LinkChange frames and MRP_TopologyChange
frames at a ring port whose port state is BLOCKED

### Configuration

**Config:** _mrp_

**Config Section:** _global_

**Additional text for usability:** section name is global

| Option label | Option hint                | Placeholder | Option validation | Option name in config | Default values | Required |
|--------------|----------------------------|-------------|-------------------|-----------------------|----------------|----------|
| Enabled      | Enable/Disable MRP service | -           | 0 or 1            | enabled               | 0              | yes      |


**Config:** _mrp_

**Config Section:** _mrp_

**Additional text for usability:** section name is unique ID number

| Option label        | Option hint                                              | Placeholder | Option validation                                         | Option name in config | Default values | Required |
|---------------------|----------------------------------------------------------|-------------|-----------------------------------------------------------|-----------------------|----------------|----------|
| Ring Number         | The ID of MRP instance                                   | 1           | Numbers from 1 to 255                                     | ring_nr               | 1              | yes      |
| Ring Role           | Ring role of MRP instance                                | -           | mrm or mrc                                                | ring_role             | mrc            | yes      |
| Primery Ring Port   | Primery ring port for MRP instance                       | -           | device available ports can’t select already reserved port | pport                 | port1          | yes      |
| Secondary Ring Port | Secondary ring port for MRP instance                     | -           | device available ports can’t select already reserved port | sport                 | port2          | yes      |
| Bridge              | Brindge interface for MRP instance                       | -           | device available bridge interfaces                        | bridge                | br0            | yes      |
| Ring Recovery Time  | The time period in witch MRP restores network on failure | 500         | 10,30,200 or 500                                          | ring_recv             | 500            | yes      |

**NOTE** Bridge option will not be visible in WebUI as value will alway be br0. Also only one MRP instance is configurable in WebUI.

### Ubus interface

##### object name: mrp
##### object methods: addmrp, getmrp, delmrp, getprm

#### method addmrp

arguments

| Option name | Type    | Optional | Posible values                                  | Comment                             |
|-------------|---------|----------|-------------------------------------------------|-------------------------------------|
| ring_nr     | Integer | No       | 1 to 255                                        |                                     |
| bridge      | String  | No       | br0 br1 br2 br3 …                               | Must be existing bridge interface   |
| pport       | String  | No       | port1 port2 port3 port4 port5 port6 port7 port8 | Must be existing ethernet interface |
| sport       | String  | No       | port1 port2 port3 port4 port5 port6 port7 port8 | Must be existing ethernet interface |
| ring_role        | String  | No       | mrm or mrc                                      |                                     |
| ring_recv   | Integer | No       | 10,30,200 or 500                                |                                     |
| domain      | Array   | Yes      | 16 elements of uint8 values                     |                                     |
| domain_name | String  | Yes      | Max 240 ASCII characters                        |                                     |
| TOPchgT     | Integer | Yes      | -                                               |                                     |
| TOPNRmax    | Integer | Yes      | -                                               |                                     |
| TSTshortT   | Integer | Yes      | -                                               |                                     |
| TSTdefaultT | Integer | Yes      | -                                               |                                     |
| TSTNRmax    | Integer | Yes      | -                                               |                                     |
| TSTExtNRma  | Integer | Yes      | -                                               |                                     |
| LNKdownT    | Integer | Yes      | -                                               |                                     |
| LNKupT      | Integer | Yes      | -                                               |                                     |
| LNKNRmax    | Integer | Yes      | -                                               |                                     |

**NOTE** MRP parameters are optional and override default ring recovery profiles. If you decide to override paramaters you need to pass all of them then.

reponse

| Option name | Type | Optional | Posible values | Comment |
|-------------|------|----------|----------------|---------|
| success     | bool | No       | true or false  |         |

#### method getmrp

argumets

| Option name | Type    | Optional | Posible values                                  | Comment                             |
|-------------|---------|----------|-------------------------------------------------|-------------------------------------|
| ring_nr     | Integer | No       | 1 to 255                                        |                                     |
| bridge      | String  | No       | br0 br1 br2 br3 …                               | Must be existing bridge interface   |

response

| Option name | Type    | Optional | Posible values                                  | Comment                             |
|-------------|---------|----------|-------------------------------------------------|-------------------------------------|
| ring_nr     | Integer | No       | 1 to 255                                        |                                     |
| bridge      | String  | No       | br0 br1 br2 br3 …                               | Must be existing bridge interface   |
| pport       | String  | No       | port1 port2 port3 port4 port5 port6 port7 port8 | Must be existing ethernet interface |
| sport       | String  | No       | port1 port2 port3 port4 port5 port6 port7 port8 | Must be existing ethernet interface |
| ring_role        | String  | No       | mrm or mrc                                      |                                     |
| ring_recv   | Integer | No       | 10,30,200 or 500                                |                                     |
| domain      | Array   | Yes      | 16 elements of uint8 values                     |                                     |
| domain_name | String  | Yes      | Max 240 ASCII characters                        |                                     |
| mra_support | bool    | -        | -                                                   | Not important for now               |
| prio        | Integer | -        | -                                                   | Not important for now               |
| ring_state  | String  | Yes      | AC_STAT1 PRM_UP CHK_RO CHK_RC DE_IDLE PT DE PT_IDLE |                                     |
| pport_state | String  | Yes      | disabled blocked forwarding                         |                                     |
| sport_state | String  | Yes      | disabled blocked forwarding                         |                                     |

#### method getprm

argumets

| Option name | Type    | Optional | Posible values                                  | Comment                             |
|-------------|---------|----------|-------------------------------------------------|-------------------------------------|
| ring_nr     | Integer | No       | 1 to 255                                        |                                     |
| bridge      | String  | No       | br0 br1 br2 br3 …                               | Must be existing bridge interface   |

response

| Option name | Type    | Optional | Posible values                                  | Comment                             |
|-------------|---------|----------|-------------------------------------------------|-------------------------------------|
| TOPchgT     | Integer | Yes      | -                                               |                                     |
| TOPNRmax    | Integer | Yes      | -                                               |                                     |
| TSTshortT   | Integer | Yes      | -                                               |                                     |
| TSTdefaultT | Integer | Yes      | -                                               |                                     |
| TSTNRmax    | Integer | Yes      | -                                               |                                     |
| TSTExtNRma  | Integer | Yes      | -                                               |                                     |
| LNKdownT    | Integer | Yes      | -                                               |                                     |
| LNKupT      | Integer | Yes      | -                                               |                                     |
| LNKNRmax    | Integer | Yes      | -                                               |                                     |

#### method delmrp

argumets

| Option name | Type    | Optional | Posible values                                  | Comment                             |
|-------------|---------|----------|-------------------------------------------------|-------------------------------------|
| ring_nr     | Integer | No       | 1 to 255                                        |                                     |
| bridge      | String  | No       | br0 br1 br2 br3 …                               | Must be existing bridge interface   |

response

| Option name | Type | Optional | Posible values | Comment |
|-------------|------|----------|----------------|---------|
| success     | bool | No       | true or false  |         |

#### event mrp_alarm

you can subscribe to mrp ubus object and listen for mrp alarms

message

| Option name | Type    | Optional | Posible values                                  | Comment                             |
|-------------|---------|----------|-------------------------------------------------|-------------------------------------|
| code     | Integer |No       |  16 byte unsigend integer value range   | in hex 0x8aab where a is ring number and b is alarm type   |
| type      | String  | No       |   "Manager Role Ok" "Manager Role Fail" "Multiple Managers Ok" "Multiple Managers" "Domain Mismatch OK" "Domain Mismatch" "Ring Closed" "Ring Open" "Unknown" | |

## CLI examples
``` sh
mrp -v list mrp

# 'mrp' @c12e38d9
#         "getmrp":{"ring_nr":"Integer","bridge":"String"}
#         "delmrp":{"ring_nr":"Integer","bridge":"String"}
#         "addmrp":{"ring_nr":"Integer","bridge":"String","pport":"String","sport":"String","ring_role":"String","ring_recv":"Integer","domain":"Array","domain_name":"String","TOPchgT":"Integer","TOPNRmax":"Integer","TSTshortT":"Integer","TSTdefaultT":"Integer","TSTNRmax":"Integer","TSTExtNRma":"Integer","LNKdownT":"Integer","LNKupT":"Integer","LNKNRmax":"Integer"}
#         "getprm":{"ring_nr":"Integer","bridge":"String"}

ubus call mrp getmrp '{"ring_nr":1, "bridge":"br0"}' # this will return MRP instance with id 1 from bridge br0
ubus call mrp getmrp # this will get all MRP instances

# Response:
# {
#         "mrp_instances": [
#                 {
#                         "ring_nr": 1,
#                         "bridge": "br0",
#                         "pport": "port1",
#                         "sport": "port2",
#                         "mra_support": 0,
#                         "ring_role": "mrc",
#                         "prio": 0,
#                         "ring_recv": 500,
#                         "domain_name": "",
#                         "domain": [
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true,
#                                 true
#                         ],
#                         "ring_state": "AC_STAT1",
#                         "pport_state": "blocked",
#                         "sport_state": "blocked"
#                 }
#         ]
# }

ubus call mrp getprm '{"ring_nr":1, "bridge":"br0"}' # this will return parameter set of the MRP instance with id 1 from bridge br0

# Response:
# {
#         "TOPchgT": 20000,
#         "TOPNRmax": 3,
#         "TSTshortT": 30000,
#         "TSTdefaultT": 50000,
#         "TSTNRmax": 5,
#         "TSTExtNRma": 15,
#         "LNKdownT": 100000,
#         "LNKupT": 100000,
#         "LNKNRmax": 4
# }

ubus call mrp delmrp '{"ring_nr":1, "bridge":"br0"}' # this will delete instance with id 1 from bridge br0
ubus call mrp addmrp '{"bridge":"br0","ring_nr":1,"pport":"port1","sport":"port2","role":"mrc","ring_recv":500
}' # this will add mrp instance

# Response:
# {
#         "success": true
# }

```

## Terms

**MRC** - Media Redundancy Client
**MRM** - Media Redundancy Manager
**FDB** - Filtering Database

## Reference

MRP 62439-2 Standart

PROFINET Media Redundancy Guideline for PROFINET Version 1.03

MRP support kernel patch by Horatiu Vultur - https://lore.kernel.org/all/40cacdda-8110-e7d7-92a3-dae7565fcc81@cumulusnetworks.com/T/