#include <common.h>
#include <command.h>
#include <tlt/mnf_info.h>


#define MNF_INFO_USABLE_SIZE MNF_INFO_SIZE / 10  
static char mnf_cache[MNF_INFO_USABLE_SIZE];
static char buf[256];


extern int mnf_flash_read(const mnf_field_t *field, char *result)
{
	int res;
	sprintf(buf,
				"sf probe 0;"
				"sf read 0x%X 0x%X 0x%X",
				(int)result,
				MNF_INFO_ADDRESS + field->offset,
				field->length);
	res = run_command(buf, 0);
	if (res < 0) return res;
	return 0;
}

extern int mnf_flash_write_init(void)
{
	int res;
	sprintf(buf,
				"sf probe 0;"
				"sf read 0x%X 0x%X 0x%X",
				(int)mnf_cache,
				MNF_INFO_ADDRESS,
				MNF_INFO_USABLE_SIZE);
	res = run_command(buf, 0);
	if (res < 0) return res;
	return 0;
}

extern int mnf_flash_write(const mnf_field_t *field, const char *buf)
{
	memcpy(mnf_cache + field->offset, buf, field->length);
	return 0;
}

extern int mnf_flash_write_finalize(void)
{
	int res;
	sprintf(buf,
				"sf probe 0;"
				"sf update 0x%X 0x%X 0x%X",
				(int)mnf_cache,
				MNF_INFO_ADDRESS,
				MNF_INFO_USABLE_SIZE);
	res = run_command(buf, 0);
	if (res < 0) return res;
	return 0;
}
